<?php
/**
 * Seventhqueen\Typer\Plugins\Component class
 *
 * @package typer
 */

namespace Seventhqueen\Typer\Plugins;

use Seventhqueen\Typer\Component_Interface;
use function add_action;
use function add_filter;
use function Seventhqueen\Typer\typer;

/**
 * Class Component
 * @package Seventhqueen\Typer\Plugins
 */
class Component implements Component_Interface {

	/**
	 * Gets the unique identifier for the theme component.
	 *
	 * @return string Component slug.
	 */
	public function get_slug() {
		return 'plugins';
	}

	/**
	 * Adds the action and filter hooks to integrate with WordPress.
	 */
	public function initialize() {
		// Front User Profile
		if ( function_exists( 'fup_is_profile_page' ) ) {
			new FUP();
		}

		if ( defined( 'STAX_VERSION' ) ) {
			new Stax();
		}
	}

}
