<div class="svq-onboard">
	<div class="onboard-slider-wrap">
		<div class="onboard-slider slider-form">
			<div class="swiper-wrapper">
				<?php foreach ( $items as $index => $item ) : ?>
					<div class="slider-item swiper-no-swiping swiper-slide <?php echo esc_attr( $item['link_to'] ) ?>">
						<?php if ( $item['image']['id'] || $item['title'] || $item['separator'] || $item['sub_title'] ) : ?>
							<div class="onboard-header text-center">
								<?php if ( $item['image']['id'] ) : ?>
									<div class="onboard-image">
										<?php echo wp_get_attachment_image( $item['image']['id'], 'large', false, [ 'class' => 'skip-lazy' ] ); ?>
									</div>
								<?php endif; ?>
								<?php if ( $item['title'] ) : ?>
									<div class="onboard-heading"><?php echo esc_html( $item['title'] ) ?></div>
								<?php endif; ?>
								<?php if ( $item['separator'] ) : ?>
									<hr class="svq-block-separator">
								<?php endif; ?>
								<?php if ( $item['sub_title'] ) : ?>
									<div
										class="onboard-subheading"><?php echo esc_html( $item['sub_title'] ) ?></div>
								<?php endif; ?>
							</div>
						<?php endif; ?>
						<?php if ( $item['link_to'] !== 'none' ) : ?>
							<div class="onboard-body">
								<?php
								if ( $item['link_to'] === 'register-box' ) {
									do_shortcode( '[svq-register-form]' );
								} else {
									apply_filters( 'typer_onboarding_render', $item );
								}
								?>
							</div>
						<?php endif; ?>

						<?php if ( $item['main_button'] || $item['skip_button'] ) : ?>
							<div class="onboard-action">
								<?php if ( $item['main_button'] ) : ?>
									<?php $main_btn_class = 'btn-onboard-' . $item['main_button_action']; ?>
									<button
										class="btn btn-dark button-ripple btn-next <?php echo esc_attr( $main_btn_class ) ?>">
										<?php echo esc_attr( $item['main_button_text'] ) ?>
										<span class="button_ripple"></span>
									</button>
								<?php endif; ?>
								<?php if ( $item['skip_button'] ) : ?>
									<button class="btn btn-link btn-onboard-skip">
										<?php esc_html_e( 'Skip', 'typer' ) ?>
									</button>
								<?php endif; ?>
							</div>
						<?php endif; ?>
					</div>
				<?php endforeach; ?>
			</div>
		</div>
	</div>
</div>
