<?php

namespace Seventhqueen\Typer;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class Gallery extends \Elementor\Widget_Base {

	public function get_name() {
		return 'typer-gallery';
	}

	public function get_title() {
		return esc_html__( 'Image Gallery (Typer)', 'typer' );
	}

	public function get_icon() {
		return 'eicon-photo-library';
	}

	public function get_categories() {
		return [ 'typer-elements' ];
	}

	public function get_keywords() {
		return [ 'gallery', 'typer' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'section_photo_gallery',
			[
				'label' => esc_html__( 'Image Gallery (max 6)', 'typer' ),
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'image',
			[
				'label'      => __( 'Add Image', 'typer' ),
				'type'       => \Elementor\Controls_Manager::MEDIA,
				'default'    => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'show_label' => false,
				'dynamic'    => [
					'active' => true,
				],
			]
		);

		$repeater->add_control(
			'caption',
			[
				'label'       => __( 'Caption', 'typer' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'default'     => '',
				'placeholder' => 'Image caption',
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'link_to',
			[
				'label'       => __( 'Link to', 'typer' ),
				'type'        => \Elementor\Controls_Manager::SELECT,
				'default'     => 'file',
				'options'     => [
					'file' => __( 'Media File', 'typer' ),
					'none' => __( 'None', 'typer' ),
				],
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'link',
			[
				'label'       => __( 'Link', 'typer' ),
				'type'        => \Elementor\Controls_Manager::URL,
				'condition'   => [
					'link_to' => 'custom',
				],
				'label_block' => true,
			]
		);

		$this->add_control(
			'image_list',
			[
				'label'       => __( 'Images', 'typer' ),
				'type'        => \Elementor\Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'default'     => [
					[
						'title' => esc_attr__( 'Image item', 'typer' ),
					],
				],
				'title_field' => ''

			]
		);

		$this->end_controls_section();

	}

	protected function get_image_link( $index ) {
		$settings = $this->get_settings();
		if ( $settings['links'] !== '' ) {
			$links = explode( "\n", $settings['links'] );
			if ( isset( $links[ $index - 1 ] ) ) {
				return $links[ $index - 1 ];
			}
		}

		return '#';
	}

	protected function render() {

		$settings = $this->get_settings();

		$items = $this->get_settings_for_display( 'image_list' );

		$count = count( (array) $settings['image_list'] );

		if ( $count > 5 ) {
			$count = 'more';
		}

		$classes   = [];
		$classes[] = 'svq-gallery--view-' . $count;

		$classes = implode( ' ', $classes );

		typer()->get_template_part( 'inc/Elementor/Widgets/templates/gallery/gallery', '', [
			'items'    => $items,
			'classes'  => $classes,
			'settings' => $settings
		] );
	}

}
