<?php

namespace Seventhqueen\Typer;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class CategoryGrid extends \Elementor\Widget_Base {

	public function get_name() {
		return 'typer-category-grid';
	}

	public function get_title() {
		return esc_html__( 'Category Grid (Typer)', 'typer' );
	}

	public function get_icon() {
		return 'eicon-gallery-grid';
	}

	public function get_categories() {
		return [ 'typer-elements' ];
	}

	public function get_keywords() {
		return [ 'categories', 'follow', 'typer' ];
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_category_query',
			[
				'label' => esc_html__( 'Query', 'typer' ),
			]
		);

		$this->add_control(
			'show_empty',
			[
				'label'        => __( 'Empty categories', 'typer' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __( 'Show', 'typer' ),
				'label_off'    => __( 'Hide', 'typer' ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			'show_subcategories',
			[
				'label'        => __( 'Subcategories', 'typer' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __( 'Show', 'typer' ),
				'label_off'    => __( 'Hide', 'typer' ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			'show_number',
			[
				'label'   => __( 'Number of categories', 'typer' ),
				'type'    => \Elementor\Controls_Manager::NUMBER,
				'min'     => 1,
				'max'     => 100,
				'step'    => 1,
				'default' => 9,
			]
		);

		$this->add_control(
			'offset',
			[
				'label'   => __( 'Offset', 'typer' ),
				'type'    => \Elementor\Controls_Manager::NUMBER,
				'min'     => 0,
				'max'     => 100,
				'step'    => 1,
				'default' => 0,
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section-style-general',
			[
				'label' => esc_html__( 'General', 'typer' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'box-shadow',
				'label'    => __( 'Box Shadow', 'typer' ),
				'selector' => '{{WRAPPER}} .svq-interest-tags .category-link .link-tag',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name'     => 'box-border',
				'label'    => __( 'Border', 'typer' ),
				'selector' => '{{WRAPPER}} .svq-interest-tags .category-link .link-tag',
			]
		);

		$this->add_responsive_control(
			'box-radius',
			[
				'label'      => __( 'Border radius', 'typer' ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'devices'    => [ 'desktop', 'tablet', 'mobile' ],
				'selectors'  => [
					'{{WRAPPER}} .svq-interest-tags .category-link .link-tag' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section-style-text',
			[
				'label' => esc_html__( 'Category Title', 'typer' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'category_title_typography',
				'label'    => __( 'Typography', 'typer' ),
				'selector' => '{{WRAPPER}} a .screen-reader-link',
			]
		);

		$this->start_controls_tabs(
			'style_category_title'
		);

		$this->start_controls_tab(
			'style_normal_title_tab',
			[
				'label' => __( 'Normal', 'typer' ),
			]
		);

		$this->add_control(
			'title_normal_color',
			[
				'label'     => __( 'Color', 'typer' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} a .screen-reader-link' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Text_Shadow::get_type(),
			[
				'name'     => 'title_shadow_normal',
				'label'    => __( 'Shadow', 'typer' ),
				'selector' => '{{WRAPPER}} a .screen-reader-link',
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'style_hover_title_tab',
			[
				'label' => __( 'Hover', 'typer' ),
			]
		);

		$this->add_control(
			'title_hover_color',
			[
				'label'     => __( 'Color', 'typer' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} a:hover .screen-reader-link' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Text_Shadow::get_type(),
			[
				'name'     => 'title_shadow_hover',
				'label'    => __( 'Shadow', 'typer' ),
				'selector' => '{{WRAPPER}} a:hover .screen-reader-link',
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();

		$this->start_controls_section(
			'section-style-overlay',
			[
				'label' => esc_html__( 'Overlay', 'typer' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->start_controls_tabs(
			'style_category_box'
		);

		$this->start_controls_tab(
			'style_normal_box_tab',
			[
				'label' => __( 'Normal', 'typer' ),
			]
		);

		$this->add_control(
			'box_normal_overlay_color',
			[
				'label'     => __( 'Overlay', 'typer' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .svq-interest-tags .category-link .link-tag:after, {{WRAPPER}} .svq-interest-tags .category-link .link-tag:before' => 'background: {{VALUE}}',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'style_hover_box_tab',
			[
				'label' => __( 'Hover', 'typer' ),
			]
		);

		$this->add_control(
			'box_hover_overlay_color',
			[
				'label'     => __( 'Overlay', 'typer' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .svq-interest-tags .category-link:hover .link-tag:after, {{WRAPPER}} .svq-interest-tags .category-link:hover .link-tag:before' => 'background: {{VALUE}}',
				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();

		$args = [
			'orderby'    => 'name',
			'hide_empty' => $settings['show_empty'] ? 0 : 1,
			'number'     => $settings['show_number'],
			'offset'     => $settings['offset']
		];

		if ( ! $settings['show_subcategories'] ) {
			$args['parent'] = 0;
		}

		$categories = get_categories( $args );

		typer()->get_template_part( 'inc/Elementor/Widgets/templates/category-grid/list', '', [
			'categories' => $categories,
			'settings'   => $settings
		] );
	}

	protected function _content_template() {
	}

}
