<?php

namespace Seventhqueen\Typer;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class ArticleSlider extends \Elementor\Widget_Base {

	public function get_style_depends() {
		return [ 'swiper' ];
	}

	public function get_script_depends() {
		return [ 'swiper' ];
	}

	public function get_name() {
		return 'typer-article-slider';
	}

	public function get_title() {
		return esc_html__( 'Article Slider (Typer)', 'typer' );
	}

	public function get_icon() {
		return 'eicon-post-slider';
	}

	public function get_categories() {
		return [ 'typer-elements' ];
	}

	public function get_keywords() {
		return [ 'slider', 'article', 'typer' ];
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_settings',
			[
				'label' => esc_html__( 'Settings', 'typer' ),
			]
		);

		$this->add_control(
			'slider_style',
			[
				'label'   => esc_html__( 'Slider type', 'typer' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => 'style_1',
				'options' => [
					'style_1' => esc_html__( 'Style 1', 'typer' ),
					'style_2' => esc_html__( 'Style 2', 'typer' ),
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_appearance',
			[
				'label' => esc_html__( 'Appearance', 'typer' ),
			]
		);

		$this->add_control(
			'title',
			[
				'label'       => esc_html__( 'Title', 'typer' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'default'     => __( 'Latest articles', 'typer' ),
				'placeholder' => __( 'Type your title here', 'typer' ),
				'condition'   => [
					'slider_style' => 'style_1'
				]
			]
		);

		$this->add_control(
			'group_by_category',
			[
				'label'        => esc_html__( 'Group by category', 'typer' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', 'typer' ),
				'label_off'    => esc_html__( 'No', 'typer' ),
				'return_value' => '1',
				'default'      => '0',
				'condition'    => [
					'slider_style' => 'style_1'
				],
			]
		);

		$this->add_control(
			'show_category_nav',
			[
				'label'        => __( 'Show category', 'typer' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __( 'Show', 'typer' ),
				'label_off'    => __( 'Hide', 'typer' ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			'show_breadcrumbs',
			[
				'label'        => __( 'Show breadcrumbs', 'typer' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __( 'Show', 'typer' ),
				'label_off'    => __( 'Hide', 'typer' ),
				'return_value' => 'yes',
				'default'      => 'yes',
				'condition'    => [
					'slider_style' => 'style_2'
				],
			]
		);

		$this->add_control(
			'show_excerpt',
			[
				'label'        => __( 'Show excerpt', 'typer' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __( 'Show', 'typer' ),
				'label_off'    => __( 'Hide', 'typer' ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			'show_entry_meta',
			[
				'label'        => __( 'Show meta', 'typer' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __( 'Show', 'typer' ),
				'label_off'    => __( 'Hide', 'typer' ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			'show_meta_avatar',
			[
				'label'        => __( 'Show meta avatar', 'typer' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __( 'Show', 'typer' ),
				'label_off'    => __( 'Hide', 'typer' ),
				'return_value' => 'yes',
				'default'      => 'yes',
				'condition'    => [
					'show_entry_meta!' => '',
					'slider_style'     => 'style_2'
				]
			]
		);

		$this->add_control(
			'show_meta_author',
			[
				'label'        => __( 'Show meta author', 'typer' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __( 'Show', 'typer' ),
				'label_off'    => __( 'Hide', 'typer' ),
				'return_value' => 'yes',
				'default'      => 'yes',
				'condition'    => [
					'show_entry_meta!' => '',
					'slider_style'     => 'style_2'
				]
			]
		);

		$this->add_control(
			'show_meta_date',
			[
				'label'        => __( 'Show meta date', 'typer' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __( 'Show', 'typer' ),
				'label_off'    => __( 'Hide', 'typer' ),
				'return_value' => 'yes',
				'default'      => 'yes',
				'condition'    => [
					'show_entry_meta!' => '',
					'slider_style'     => 'style_2'
				]
			]
		);

		$this->add_control(
			'show_button',
			[
				'label'        => __( 'Show button', 'typer' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __( 'Show', 'typer' ),
				'label_off'    => __( 'Hide', 'typer' ),
				'return_value' => 'yes',
				'default'      => 'yes',
				'condition'    => [
					'slider_style' => 'style_2'
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_query',
			[
				'label' => esc_html__( 'Query', 'typer' ),
			]
		);

		$categoryArray = [];
		$categories    = get_categories( 'orderby=name&hide_empty=0' );

		foreach ( $categories as $category ) {
			$categoryArray[ $category->term_id ] = $category->name;
		}

		$this->add_control(
			'query_categories',
			[
				'label'    => esc_html__( 'Categories', 'typer' ),
				'type'     => \Elementor\Controls_Manager::SELECT2,
				'options'  => $categoryArray,
				'multiple' => true,
			]
		);

		$tagsArray = [];
		$tags      = get_tags( array(
			'hide_empty' => false
		) );

		foreach ( $tags as $tag ) {
			$tagsArray[ $tag->term_id ] = $tag->name;
		}

		$this->add_control(
			'query_tags',
			[
				'label'    => esc_html__( 'Tags', 'typer' ),
				'type'     => \Elementor\Controls_Manager::SELECT2,
				'options'  => $tagsArray,
				'multiple' => true,
			]
		);

		$this->add_control(
			'query_total',
			[
				'label'       => esc_html__( 'Total posts', 'typer' ),
				'type'        => \Elementor\Controls_Manager::NUMBER,
				'default'     => 12,
				'placeholder' => esc_html__( 'Total posts', 'typer' ),
			]
		);

		$this->add_control(
			'query_offset',
			[
				'label'       => esc_html__( 'Offset', 'typer' ),
				'type'        => \Elementor\Controls_Manager::NUMBER,
				'default'     => 0,
				'placeholder' => esc_html__( 'Offset', 'typer' ),
			]
		);

		$this->add_control(
			'query_sort',
			[
				'label'   => esc_html__( 'Sort', 'typer' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => 'newest',
				'options' => [
					'newest' => esc_html__( 'Newest', 'typer' ),
					'oldest' => esc_html__( 'Oldest', 'typer' ),
					'random' => esc_html__( 'Random', 'typer' ),
				]
			]
		);

		$this->add_control(
			'sticky_posts',
			[
				'label'        => esc_html__( 'Include sticky posts', 'typer' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', 'typer' ),
				'label_off'    => esc_html__( 'No', 'typer' ),
				'return_value' => '1',
				'default'      => '0'
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section-style-color',
			[
				'label' => esc_html__( 'Colors', 'typer' ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name'      => 'box_shadow',
				'label'     => __( 'Box Shadow', 'typer' ),
				'selector'  => '{{WRAPPER}} .svq-article',
				'condition' => [
					'slider_style' => 'style_1'
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name'      => 'background',
				'label'     => __( 'Background', 'typer' ),
				'types'     => [ 'classic' ],
				'selector'  => '{{WRAPPER}} .svq-article',
				'condition' => [
					'slider_style' => 'style_1'
				],
			]
		);

		$this->add_control(
			'category-color',
			[
				'label'     => esc_html__( 'Category', 'typer' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'scheme'    => [
					'type'  => \Elementor\Scheme_Color::get_type(),
					'value' => \Elementor\Scheme_Color::COLOR_4,
				],
				'selectors' => [
					'{{WRAPPER}} .meta-category .meta-category__item a' => 'color: {{VALUE}}'
				],
			]
		);

		$this->add_control(
			'title-color',
			[
				'label'     => esc_html__( 'Title', 'typer' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'scheme'    => [
					'type'  => \Elementor\Scheme_Color::get_type(),
					'value' => \Elementor\Scheme_Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .heading-title .heading-title-link' => 'color: {{VALUE}}',
					'{{WRAPPER}} .entry-title'                       => 'color: {{VALUE}}'
				],
			]
		);

		$this->add_control(
			'excerpt-color',
			[
				'label'     => esc_html__( 'Excerpt', 'typer' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'scheme'    => [
					'type'  => \Elementor\Scheme_Color::get_type(),
					'value' => \Elementor\Scheme_Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .screen-reader-link' => 'color: {{VALUE}}'
				],
			]
		);

		$this->add_control(
			'breadcrumbs-color',
			[
				'label'     => esc_html__( 'Breadcrumbs', 'typer' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'scheme'    => [
					'type'  => \Elementor\Scheme_Color::get_type(),
					'value' => \Elementor\Scheme_Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .breadcrumb__link' => 'color: {{VALUE}}'
				],
				'condition' => [
					'slider_style' => 'style_2'
				],
			]
		);

		$this->add_control(
			'meta-color',
			[
				'label'     => esc_html__( 'Meta', 'typer' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'scheme'    => [
					'type'  => \Elementor\Scheme_Color::get_type(),
					'value' => \Elementor\Scheme_Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .entry-meta .entry-meta__content'                  => 'color: {{VALUE}}',
					'{{WRAPPER}} .entry-meta .entry-meta__content .author'          => 'color: {{VALUE}}',
					'{{WRAPPER}} .entry-meta .entry-meta__content a'                => 'color: {{VALUE}}',
					'{{WRAPPER}} .entry-meta .entry-meta__content .posted-on'       => 'color: {{VALUE}}',
					'{{WRAPPER}} .entry-meta .entry-meta__action a'                 => 'color: {{VALUE}}',
					'{{WRAPPER}} .entry-meta .entry-meta_content .entry-meta__text' => 'color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'media-style',
			[
				'label'     => esc_html__( 'Media', 'typer' ),
				'tab'       => \Elementor\Controls_Manager::TAB_STYLE,
				'condition' => [
					'slider_style' => 'style_2'
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name'      => 'media_box_shadow',
				'label'     => __( 'Box Shadow', 'typer' ),
				'selector'  => '{{WRAPPER}} .svq-media-image, {{WRAPPER}} .svq-gallery-slider, {{WRAPPER}} .svq-media-video',
				'condition' => [
					'slider_style' => 'style_2'
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'button-style-color',
			[
				'label'     => esc_html__( 'Button', 'typer' ),
				'tab'       => \Elementor\Controls_Manager::TAB_STYLE,
				'condition' => [
					'slider_style' => 'style_2'
				],
			]
		);

		$this->add_responsive_control(
			'btn-radius',
			[
				'label'      => __( 'Border radius', 'typer' ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'devices'    => [ 'desktop', 'tablet', 'mobile' ],
				'selectors'  => [
					'{{WRAPPER}} .btn-customize' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition'  => [
					'slider_style' => 'style_2'
				],
			]
		);

		$this->start_controls_tabs(
			'button-styles'
		);

		$this->start_controls_tab(
			'button-styles-normal',
			[
				'label' => __( 'Normal', 'typer' ),
			]
		);

		$this->add_control(
			'btn-bg-color-normal',
			[
				'label'     => esc_html__( 'Background color', 'typer' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'scheme'    => [
					'type'  => \Elementor\Scheme_Color::get_type(),
					'value' => \Elementor\Scheme_Color::COLOR_1,
				],
				'default'   => '#000000',
				'selectors' => [
					'{{WRAPPER}} .btn-customize' => 'background: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'btn-text-color-normal',
			[
				'label'     => esc_html__( 'Text color', 'typer' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'scheme'    => [
					'type'  => \Elementor\Scheme_Color::get_type(),
					'value' => \Elementor\Scheme_Color::COLOR_1,
				],
				'default'   => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .btn-customize' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name'     => 'border-normal',
				'label'    => __( 'Border', 'plugin-domain' ),
				'selector' => '{{WRAPPER}} .btn-customize',
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'button-styles-hover',
			[
				'label' => __( 'Hover', 'typer' ),
			]
		);

		$this->add_control(
			'btn-bg-color-hover',
			[
				'label'     => esc_html__( 'Background color', 'typer' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'scheme'    => [
					'type'  => \Elementor\Scheme_Color::get_type(),
					'value' => \Elementor\Scheme_Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .btn-customize:hover' => 'background: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'btn-text-color-hover',
			[
				'label'     => esc_html__( 'Text color', 'typer' ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'scheme'    => [
					'type'  => \Elementor\Scheme_Color::get_type(),
					'value' => \Elementor\Scheme_Color::COLOR_1,
				],
				'selectors' => [
					'{{WRAPPER}} .btn-customize:hover' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name'     => 'border-hover',
				'label'    => __( 'Border', 'plugin-domain' ),
				'selector' => '{{WRAPPER}} .btn-customize:hover',
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();

		/* Query args */
		$args = [
			'showposts'           => $settings['query_total'],
			'offset'              => $settings['query_offset'],
			'post_type'           => 'post',
			'ignore_sticky_posts' => $settings['sticky_posts'] ? 0 : 1,
			'post_status'         => [ 'publish' ]
		];

		if ( ! empty( $settings['query_categories'] ) ) {
			$args['category__in'] = $settings['query_categories'];
		}

		if ( ! empty( $settings['query_tags'] ) ) {
			$args['tag__in'] = $settings['query_tags'];
		}

		if ( $settings['query_sort'] === 'oldest' ) {
			$args['order'] = 'ASC';
		} elseif ( $settings['query_sort'] === 'random' ) {
			$args['orderby'] = 'rand';
			$args['order']   = 'ASC';
		}

		// The Query
		$query = new \WP_Query( $args );

		typer()->get_template_part( 'inc/Elementor/Widgets/templates/article-slider/' . $settings['slider_style'], '', [
			'query'    => $query,
			'settings' => $settings,
			'id'       => $this->get_id()
		] );

		/* Restore original Post Data */
		wp_reset_postdata();
	}

	protected function _content_template() {
	}

}
