<?php
/**
 * Handles Box Shadow control css output.
 *
 * @package Typer\Customizer
 *
 * @since 1.0.0
 */

namespace Seventhqueen\Typer\Customizer\Modules\Kirki_Extend\Output;

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Overrides Kirki CSS output.
 *
 * @since 1.0.0
 * @ignore
 * @access private
 *
 * @package Typer\Customizer
 */
class Box_Shadow extends \Seventhqueen\Typer\Customizer\Modules\Kirki_Extend\Base\Output {

	/**
	 * CSS output.
	 *
	 * @since 1.0.0
	 *
	 * @param array $output Defined single output.
	 * @param array $value Settings value.
	 */
	protected function apply_output( $output, $value ) {
		$output = wp_parse_args(
			$output, [
				'element'     => '',
				'property'    => 'box-shadow',
				'media_query' => 'global',
				'unit'        => '',
				'prefix'      => '',
				'suffix'      => '',
			]
		);

		$value = \Seventhqueen\Typer\Customizer\Control\Group\Box_Shadow::format_value( $value/*, $output['units']*/ );

		$this->styles[ $output['media_query'] ][ $output['element'] ][ $output['property'] ] = $output['prefix'] . $this->process_property_value( $output['property'], $value ) . $output['suffix'];
	}
}
