<?php
/**
 * Handles position control class.
 *
 * @package Typer\Customizer
 *
 * @since 1.0.0
 */

namespace Seventhqueen\Typer\Customizer\Control;

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Position control class.
 *
 * @since 1.0.0
 * @ignore
 * @access private
 *
 * @package Typer\Customizer
 */
class Position extends \Seventhqueen\Typer\Customizer\Base\Control {

	/**
	 * Control's type.
	 *
	 * @since 1.0.0
	 *
	 * @var string
	 */
	public $type = 'sq-control-position';

	/**
	 * An Underscore (JS) template for control wrapper.
	 *
	 * Use to create the control template.
	 *
	 * @since 1.0.0
	 */
	protected function control_template() {
		?>
		<#
		var left = '<?php echo is_rtl() ? 'right' : 'left'; ?>';
		var right = '<?php echo is_rtl() ? 'left' : 'right'; ?>';

		position = {
			'top-left':     { value: 'top left', icon: 'arrow-' + left + '-top' },
			'top':          { value: 'top center', icon: 'arrow-top' },
			'top-right':    { value: 'top right', icon: 'arrow-' + right + '-top' },
			'center-left':  { value: 'center left', icon: 'arrow-' + left },
			'center':       { value: 'center', icon: '' },
			'center-right': { value: 'center right', icon: 'arrow-' + right },
			'bottom-left':  { value: 'bottom left', icon: 'arrow-' + left + '-bottom' },
			'bottom':       { value: 'bottom center', icon: 'arrow-bottom' },
			'bottom-right': { value: 'bottom right', icon: 'arrow-' + right + '-bottom' }
		}
		#>
		<div class="typer-control typer-position-control">
			<div class="typer-position-control-buttons">
				<# _.each( position, function( position, key ) { #>
					<input class="typer-position-control-radio" {{{ data.inputAttrs }}} type="radio" value="{{ position.value }}" name="{{ data.id }}" id="{{ data.id }}-{{ key }}" {{{ data.link }}} <# if ( position.value === data.value ) { #> checked <# } #>>
					<label class="typer-position-control-button typer-position-control-{{ ( position.icon ) ? 'icon' : 'label' }}" for="{{ data.id }}-{{ key }}"><# if ( position.icon ) { #><img src="<?php echo esc_url( \Seventhqueen\Typer\Customizer\Utils::get_assets_url() ); ?>/img/{{ position.icon }}.svg" /><# } else { #>{{ position.label }}<# } #></label>
				<# } ) #>
			</div>
		</div>
		<?php
	}
}
