<?php
/**
 * Handles image control class.
 *
 * @package Typer\Customizer
 *
 * @since 1.0.0
 */

namespace Seventhqueen\Typer\Customizer\Control;

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Image control class.
 *
 * @since 1.0.0
 * @ignore
 * @access private
 *
 * @package Typer\Customizer
 */
class Image extends \Seventhqueen\Typer\Customizer\Base\Control {

	/**
	 * Control's type.
	 *
	 * @since 1.0.0
	 *
	 * @var string
	 */
	public $type = 'sq-control-image';

	/**
	 * An Underscore (JS) template for control wrapper.
	 *
	 * Use to create the control template.
	 *
	 * @since 1.0.0
	 */
	protected function control_template() {
		?>
		<div class="typer-control typer-image-upload-control {{ data.value ? 'has-image' : '' }}">
			<span class="typer-image-upload-control-remove"><img src="<?php echo esc_url( \Seventhqueen\Typer\Customizer\Utils::get_icon_url( 'x' ) ); ?>" alt="<?php esc_attr_e( 'Remove image icon', 'typer' ); ?>" /></span>
			<span class="typer-image-upload-control-icon"><img src="<?php echo esc_url( \Seventhqueen\Typer\Customizer\Utils::get_icon_url( 'upload' ) ); ?>" alt="<?php esc_attr_e( 'Upload image icon', 'typer' ); ?>" /></span>
			<span class="typer-image-upload-control-label"><?php esc_html_e( 'Click to Upload Image', 'typer' ); ?></span>
			<img class="typer-image-upload-control-preview" src="{{ data.value }}" />
			<input type="hidden" value="{{ data.value }}" {{{ data.link }}} />
		</div>
		<?php
	}
}
