<?php
/**
 * Handles box shadow control class.
 *
 * @package Typer\Customizer
 *
 * @since 1.0.0
 */

namespace Seventhqueen\Typer\Customizer\Control\Group;

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Box_Shadow control class.
 *
 * @since 1.0.0
 * @ignore
 * @access private
 *
 * @package Typer\Customizer
 */
class Box_Shadow extends \Seventhqueen\Typer\Customizer\Base\Group_Control {

	/**
	 * Control's type.
	 *
	 * @since 1.0.0
	 *
	 * @var string
	 */
	public $type = 'sq-control-box-shadow';

	/**
	 * Set the fields for this control.
	 *
	 * @since 1.0.0
	 */
	protected function set_fields() {
		$this->add_field( 'horizontal', [
			'type'       => 'sq-control-text',
			'inputType'  => 'number',
			'label'      => esc_html__( 'Horizontal', 'typer' ),
			'inputAttrs' => [ 'placeholder' => 0 ],
			'column'     => '3',
		] );

		$this->add_field( 'vertical', [
			'type'       => 'sq-control-text',
			'inputType'  => 'number',
			'label'      => esc_html__( 'Vertical', 'typer' ),
			'inputAttrs' => [ 'placeholder' => 0 ],
			'column'     => '3',
		] );

		$this->add_field( 'blur', [
			'type'       => 'sq-control-text',
			'inputType'  => 'number',
			'label'      => esc_html__( 'Blur', 'typer' ),
			'inputAttrs' => [ 'placeholder' => 0 ],
			'column'     => '3',
		] );

		$this->add_field( 'spread', [
			'type'       => 'sq-control-text',
			'inputType'  => 'number',
			'label'      => esc_html__( 'Spread', 'typer' ),
			'inputAttrs' => [ 'placeholder' => 0 ],
			'column'     => '3',
		] );

		$this->add_field( 'position', [
			'type'    => 'sq-control-choose',
			'column'  => '4',
			'label'   => esc_html__( 'Position', 'typer' ),
			'default' => '',
			'choices' => [
				'' => [
					'label' => esc_html__( 'Linear', 'typer' ),
				],
				'inset' => [
					'label' => esc_html__( 'Inset', 'typer' ),
				],
			],
		] );

		$this->add_field( 'color', [
			'type'   => 'sq-control-color',
			'label'  => esc_html__( 'Color', 'typer' ),
			'column' => '8',
		] );
	}

	/**
	 * Format theme mod array value into a valid box shadow value.
	 *
	 * @since 1.0.0
	 *
	 * @param array $value The field's value.
	 *
	 * @return string The formatted box shadow value.
	 */
	public static function format_value( $value ) {
		$value = array_merge(
			[
				'horizontal' => 0,
				'vertical'   => 0,
				'blur'       => 0,
				'spread'     => 0,
				'color'      => '#0000',
				'position'   => '',
				'unit'       => 'px',
			],
			$value
		);

		$value = sprintf(
			'%1$s%7$s %2$s%7$s %3$s%7$s %4$s%7$s %5$s %6$s',
			$value['horizontal'],
			$value['vertical'],
			$value['blur'],
			$value['spread'],
			$value['color'],
			$value['position'],
			$value['unit']
		);

		return $value;
	}
}
