<?php
/**
 * Handles full screen slider control class.
 *
 * @package Typer\Customizer
 *
 * @since 1.0.0
 */

namespace Seventhqueen\Typer\Customizer\Control;

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * FullScreenSlider control class.
 *
 * @since 1.0.0
 * @ignore
 * @access private
 *
 * @package Typer\Customizer
 */
class FullScreenSlider extends \Seventhqueen\Typer\Customizer\Base\Control {

	/**
	 * Control's type.
	 *
	 * @since 1.0.0
	 *
	 * @var string
	 */
	public $type = 'sq-control-fullscreen-slider';

	/**
	 * Refresh the parameters passed to the JavaScript via JSON.
	 *
	 * @since 1.0.0
	 */
	public function to_json() {
		parent::to_json();
	}

	/**
	 * An Underscore (JS) template for control wrapper.
	 *
	 * Use to create the control template.
	 *
	 * @since 1.0.0
	 */
	protected function control_template() {
		?>
		<div class="rangeslider-wrap">
			<input class="viewport-slider" type="range" min="1" max="4" value="{{ data.value }}" step="1"
			       labels="<span class='query-slider query-off'>Off</span>, <span class='query-slider query-mobile'></span>, <span class='query-slider query-tablet'></span>, <span class='query-slider query-desktop'></span>" {{{ data.inputAttrs }}} id="{{ data.id }}" {{{ data.link }}}>
		</div>
		<?php
	}
}
