<?php

namespace Seventhqueen\Typer\Config\Customizer;

use function Seventhqueen\Typer\typer;

/**
 * Class PostNavigationOptions
 * @package Seventhqueen\Typer\Config\Customizer
 */
class PostNavigationOptions {

	/**
	 * @var array
	 */
	private $sq = [];

	/**
	 * @var string
	 */
	private $panel = '';

	/**
	 * @param $name
	 *
	 * @return $this
	 */
	public function set_panel_name( $name ) {
		$this->panel = $name;

		return $this;
	}

	/**
	 * @param int $priority
	 *
	 * @return array
	 */
	public function get_section( $priority = 10 ) {
		return [
			'title'    => esc_html__( 'Post Navigation, Autoload & Related', 'typer' ),
			'panel'    => $this->panel,
			'priority' => $priority
		];
	}

	/**
	 * @return string
	 */
	public function get_section_slug() {
		return 'svq_section_blog_post_nav';
	}

	/**
	 * @return array
	 */
	public function get_options() {

		$this->sq['media_separator_19_general'] = [
			'section' => $this->get_section_slug(),
			'type'    => 'sq-control-separator',
			'label'   => esc_html__( 'Post Navigation', 'typer' ),
		];

		$this->sq['blog_post_nav_enabled'] = [
			'section'     => $this->get_section_slug(),
			'type'        => 'switch',
			'choices'     => typer()->get_config( 'switch_options' ),
			'default'     => '1',
			'title'       => esc_html__( 'Show Post Navigation', 'typer' ),
			'description' => esc_html__( 'Display Next & Previous articles', 'typer' ),
		];

		$this->sq['blog_post_nav'] = [
			'section'         => $this->get_section_slug(),
			'type'            => 'sq-control-radio-image',
			'choices'         => typer()->get_config( 'blog_nav_options' ),
			'default'         => 'normal',
			'title'           => esc_html__( 'Position', 'typer' ),
			'description'     => esc_html__( 'Where to show prev/next posts on post page', 'typer' ),
			'active_callback' => [
				[
					'setting' => 'blog_post_nav_enabled',
					'value'   => true
				],
			],
		];

		$this->sq['media_separator_20_general'] = [
			'section' => $this->get_section_slug(),
			'type'    => 'sq-control-separator',
			'label'   => esc_html__( 'Related Posts', 'typer' ),
		];

		$this->sq['blog_related_posts_enabled'] = [
			'section' => $this->get_section_slug(),
			'type'    => 'switch',
			'choices' => typer()->get_config( 'switch_options' ),
			'default' => '1',
			'title'   => esc_html__( 'Show Related Posts', 'typer' ),
		];

		$this->sq['blog_related_posts'] = [
			'section'         => $this->get_section_slug(),
			'type'            => 'select',
			'choices'         => [
				'default' => esc_html__( 'Related to post categories', 'typer' ),
				'author'  => esc_html__( 'Related to the current author', 'typer' )
			],
			'default'         => 'author',
			'title'           => esc_html__( 'Type', 'typer' ),
			'description'     => esc_html__( 'What kind of related posts to display?', 'typer' ),
			'active_callback' => [
				[
					'setting' => 'blog_related_posts_enabled',
					'value'   => true
				],
			],
		];

		$this->sq['blog_related_thumbnail'] = [
			'section'         => $this->get_section_slug(),
			'type'            => 'sq-control-radio-image',
			'choices'         => typer()->get_config( 'thumbnail_width_options' ),
			'default'         => 'normal',
			'title'           => esc_html__( 'Post image size', 'typer' ),
			'description'     => esc_html__( 'How do you want your thumbs to be displayed?', 'typer' ),
			'active_callback' => [
				[
					'setting' => 'blog_related_posts_enabled',
					'value'   => true
				],
			],
		];

		$this->sq['blog_related_title_line_clamp'] = [
			'section'         => $this->get_section_slug(),
			'type'            => 'number',
			'title'           => esc_html__( 'Title max lines', 'typer' ),
			'description'     => esc_html__( 'Truncates titles to a predefined number of lines. If you have long titles and want to display the entire title, use a high number like 999.', 'typer' ),
			'default'         => 2,
			'choices'         => [
				'min'  => 1,
				'max'  => 999,
				'step' => 1,
			],
			'transport'       => 'postMessage',
			'css_vars'        => [
				[ '--line-clamp-related-list-title' ],
			],
			'active_callback' => [
				[
					'setting' => 'blog_related_posts_enabled',
					'value'   => true
				],
			],
		];

		$this->sq['blog_related_excerpt_line_clamp'] = [
			'section'         => $this->get_section_slug(),
			'type'            => 'number',
			'title'           => esc_html__( 'Excerpt max lines', 'typer' ),
			'description'     => esc_html__( 'Truncates excerpt to a predefined number of lines. To display the entire excerpt use a high number like 999.', 'typer' ),
			'default'         => '',
			'choices'         => [
				'min'  => 1,
				'max'  => 999,
				'step' => 1,
			],
			'transport'       => 'postMessage',
			'css_vars'        => [
				[ '--line-clamp-related-list-text' ],
			],
			'active_callback' => [
				[
					'setting' => 'blog_related_posts_enabled',
					'value'   => true
				],
			],
		];

		$this->sq['blog_related_bg_color'] = [
			'section'         => $this->get_section_slug(),
			'type'            => 'color',
			'default'         => '#faf8f5',
			'title'           => esc_html__( 'Background color', 'typer' ),
			'transport'       => 'postMessage',
			'css_vars'        => [
				[ '--related-color' ],
				[ '--related-h', 'hex_to_hsl_h' ],
				[ '--related-s', 'hex_to_hsl_s' ],
				[ '--related-l', 'hex_to_hsl_l' ],
				[ '--related-contrast-color', 'color_contrast' ],
			],
			'active_callback' => [
				[
					'setting' => 'blog_related_posts_enabled',
					'value'   => true
				]
			],
		];

		$this->sq['blog_related_bg_image'] = [
			'section'         => $this->get_section_slug(),
			'type'            => 'sq-control-background',
			'default'         => [
				'image'    => get_parent_theme_file_uri( 'assets/img/related-bg.png' ),
				'position' => 'top',
				'size'     => 'cover'
			],
			'title'           => esc_html__( 'Background image', 'typer' ),
			'exclude'         => [ 'type', 'color', 'attachment' ],
			'output'          => [
				[
					'element' => [
						'.svq-media-slider.svq-post-related:after, .svq-media-slider.svq-author-related:after'
					],
				],
			],
			'active_callback' => [
				[
					'setting' => 'blog_related_posts_enabled',
					'value'   => true
				]
			],
		];

		return $this->sq;

	}

}
