<?php

namespace Seventhqueen\Typer\Config\Customizer;

use function Seventhqueen\Typer\typer;

/**
 * Class PageOptions
 * @package Seventhqueen\Typer\Config\Customizer
 */
class PageOptions {

	/**
	 * @var array
	 */
	private $sq = [];

	/**
	 * @var string
	 */
	private $panel = '';

	/**
	 * @param $name
	 *
	 * @return $this
	 */
	public function set_panel_name( $name ) {
		$this->panel = $name;

		return $this;
	}

	/**
	 * @param int $priority
	 *
	 * @return array
	 */
	public function get_section( $priority = 10 ) {
		return [
			'title'    => esc_html__( 'Page', 'typer' ),
			'panel'    => 'typer',
			'priority' => $priority
		];
	}

	/**
	 * @return string
	 */
	public function get_section_slug() {
		return 'svq_section_page';
	}

	/**
	 * @return array
	 */
	public function get_options() {

		$this->sq['media_show_breadcrumbs_page'] = [
			'section' => $this->get_section_slug(),
			'type'    => 'sq-control-radio-image',
			'choices' => typer()->get_config( 'breadcrumbs_options' ),
			'default' => '2',
			'title'   => esc_html__( 'Display Breadcrumbs(above the title)', 'typer' )
		];

		$this->sq['page_separator_title'] = [
			'section' => $this->get_section_slug(),
			'type'    => 'sq-control-separator',
			'label'   => esc_html__( 'Title', 'typer' )
		];

		$this->sq['media_title_size_page'] = [
			'section' => $this->get_section_slug(),
			'type'    => 'sq-control-radio-image',
			'choices' => typer()->get_config( 'title_size_options' ),
			'default' => 'default',
			'title'   => esc_html__( 'Size', 'typer' )
		];

		$this->sq['media_content_position_h_page'] = [
			'section' => $this->get_section_slug(),
			'type'    => 'sq-control-radio-image',
			'choices' => typer()->get_config( 'title_alignment_page_options' ),
			'default' => 'default',
			'title'   => esc_html__( 'Alignment', 'typer' )
		];

		$this->sq['page_separator_shapes'] = [
			'section' => $this->get_section_slug(),
			'type'    => 'sq-control-separator',
			'label'   => esc_html__( 'Parallax shapes', 'typer' )
		];

		$this->sq['media_shapes_show_page'] = [
			'section' => $this->get_section_slug(),
			'type'    => 'switch',
			'choices' => typer()->get_config( 'switch_options' ),
			'default' => '0',
			'title'   => esc_html__( 'Show', 'typer' )
		];

		return $this->sq;

	}

}
