<?php

namespace Seventhqueen\Typer\Config\Customizer;

use function Seventhqueen\Typer\typer;

/**
 * Class NotFoundOptions
 * @package Seventhqueen\Typer\Config\Customizer
 */
class NotFoundOptions {

	/**
	 * @var array
	 */
	private $sq = [];

	/**
	 * @var string
	 */
	private $panel = '';

	/**
	 * @param $name
	 *
	 * @return $this
	 */
	public function set_panel_name( $name ) {
		$this->panel = $name;

		return $this;
	}

	/**
	 * @param int $priority
	 *
	 * @return array
	 */
	public function get_section( $priority = 10 ) {
		return [
			'title'    => esc_html__( '404 Page', 'typer' ),
			'panel'    => $this->panel,
			'priority' => $priority
		];
	}

	/**
	 * @return string
	 */
	public function get_section_slug() {
		return 'svq_section_404';
	}

	/**
	 * @return array
	 */
	public function get_options() {

		$this->sq['404_image'] = [
			'section'     => $this->get_section_slug(),
			'type'        => 'image',
			'default'     => get_template_directory_uri() . '/assets/img/404_page_not_found.png',
			'title'       => esc_html__( 'Custom image', 'typer' ),
			'description' => esc_html__( 'Change the default image on 404 page', 'typer' )
		];

		$this->sq['404_message'] = [
			'section' => $this->get_section_slug(),
			'type'    => 'textarea',
			'default' => esc_html__( 'The page you are looking for might have been removed, had its name changed, or is temporarily unavailable. Maybe try a search?', 'typer' ),
			'title'   => esc_html__( 'Results message', 'typer' )
		];

		$this->sq['404_show_footer'] = [
			'section' => $this->get_section_slug(),
			'type'    => 'switch',
			'choices' => typer()->get_config( 'switch_options' ),
			'default' => '0',
			'title'   => esc_html__( 'Show footer on 404 page', 'typer' )
		];

		return $this->sq;

	}

}
