<?php

namespace Seventhqueen\Typer\Config\Customizer;

use function Seventhqueen\Typer\typer;

/**
 * Class LayoutOptions
 * @package Seventhqueen\Typer\Config\Customizer
 */
class LayoutOptions {

	/**
	 * @var array
	 */
	private $sq = [];

	/**
	 * @var string
	 */
	private $panel = '';

	/**
	 * @param $name
	 *
	 * @return $this
	 */
	public function set_panel_name( $name ) {
		$this->panel = $name;

		return $this;
	}

	/**
	 * @param int $priority
	 *
	 * @return array
	 */
	public function get_section( $priority = 10 ) {
		return [
			'title'    => esc_html__( 'Layout', 'typer' ),
			'panel'    => $this->panel,
			'priority' => $priority
		];
	}

	/**
	 * @return string
	 */
	public function get_section_slug() {
		return 'svq_section_layout';
	}

	/**
	 * @return array
	 */
	public function get_options() {

		$options = [
			'general' => esc_html__( 'General', 'typer' ),
			'post'    => esc_html__( 'Single Post', 'typer' ),
			'archive' => esc_html__( 'Archive Page', 'typer' ),
		];

		$this->sq['layout_boxed'] = [
			'section' => $this->get_section_slug(),
			'type'    => 'switch',
			'choices' => typer()->get_config( 'switch_options' ),
			'default' => '0',
			'title'   => esc_html__( 'Boxed Layout', 'typer' )
		];

		$this->sq['layout_boxed_width'] = [
			'section'         => $this->get_section_slug(),
			'type'            => 'sq-control-input-slider',
			'choices'         => [
				'min'  => 1000,
				'max'  => 1800,
				'step' => 10,
			],
			'default'         => 1400,
			'transport'       => 'postMessage',
			'css_vars'        => [
				[ '--layout-max-width' ],
			],
			'title'           => esc_html__( 'Layout width', 'typer' ),
			'active_callback' => [
				[
					'setting' => 'layout_boxed',
					'value'   => true
				]
			]
		];

		$this->sq['layout_boxed_bg_color'] = [
			'section'         => $this->get_section_slug(),
			'type'            => 'color',
			'default'         => '#f4f4f4',
			'title'           => esc_html__( 'Background color', 'typer' ),
			'transport'       => 'postMessage',
			'output'          => array(
				array(
					'element'  => '.layout-boxed',
					'property' => 'background-color'
				),
			),
			'active_callback' => [
				[
					'setting' => 'layout_boxed',
					'value'   => true
				]
			],
		];

		foreach ( $options as $option => $name ) {
			$this->sq[ 'layout_separator_' . $option ] = [
				'section' => $this->get_section_slug(),
				'type'    => 'sq-control-separator',
				'label'   => $name
			];

			$this->sq[ 'site_layout_' . $option ] = [
				'section'     => $this->get_section_slug(),
				'type'        => 'sq-control-radio-image',
				'choices'     => typer()->get_config( 'layout_options' ),
				'default'     => $option === 'archive' ? 'sr' : 'no-side',
				'title'       => esc_html__( 'Layout', 'typer' ),
				'description' => esc_html__( 'You can pick up to 2 sidebars.', 'typer' )
			];

			$this->sq[ 'container_width_' . $option ] = [
				'section'         => $this->get_section_slug(),
				'type'            => 'sq-control-radio-image',
				'choices'         => typer()->get_config( 'layout_width_options' ),
				'default'         => $option === 'general' ? 'large' : 'small',
				'title'           => esc_html__( 'Container width', 'typer' ),
				'description'     => esc_html__( 'Note: When picking a layout with sidebar, the container width will be forced to large.', 'typer' ),
				'active_callback' => [
					[
						'setting'  => 'site_layout_' . $option,
						'operator' => '==',
						'value'    => 'no-side'
					]
				]
			];

			$this->sq[ 'sticky_sidebar_primary_' . $option ] = [
				'section'         => $this->get_section_slug(),
				'type'            => 'switch',
				'choices'         => typer()->get_config( 'switch_options' ),
				'default'         => '0',
				'title'           => esc_html__( 'Sticky primary sidebar', 'typer' ),
				'active_callback' => [
					[
						'setting'  => 'site_layout_' . $option,
						'operator' => '!=',
						'value'    => 'no-side'
					]
				]
			];

			$this->sq[ 'sticky_sidebar_secondary_' . $option ] = [
				'section'         => $this->get_section_slug(),
				'type'            => 'switch',
				'choices'         => typer()->get_config( 'switch_options' ),
				'default'         => '0',
				'title'           => esc_html__( 'Sticky secondary sidebar', 'typer' ),
				'active_callback' => [
					[
						'setting'  => 'site_layout_' . $option,
						'operator' => '!=',
						'value'    => 'no-side'
					],
					[
						'setting'  => 'site_layout_' . $option,
						'operator' => '!=',
						'value'    => 'sl'
					],
					[
						'setting'  => 'site_layout_' . $option,
						'operator' => '!=',
						'value'    => 'sr'
					]
				]
			];

			$this->sq[ 'sticky_sidebar_gap_' . $option ] = [
				'section'         => $this->get_section_slug(),
				'type'            => 'sq-control-input',
				'title'           => esc_html__( 'Sticky top gap', 'typer' ),
				'default'         => [
					'size' => '80',
					'unit' => 'px'
				],
				'units'           => [ 'px' ],
				'defaultUnit'     => 'px',
				'active_callback' => [
					[
						'setting'  => 'site_layout_' . $option,
						'operator' => '!=',
						'value'    => 'no-side'
					]
				]
			];
		}

		return $this->sq;

	}

}
