<?php

namespace Seventhqueen\Typer\Config\Customizer;

use function Seventhqueen\Typer\typer;

/**
 * Class HeaderOptions
 * @package Seventhqueen\Typer\Config\Customizer
 */
class HeaderOptions {

	/**
	 * @var array
	 */
	private $sq = [];

	/**
	 * @var string
	 */
	private $panel = '';

	/**
	 * @param $name
	 *
	 * @return $this
	 */
	public function set_panel_name( $name ) {
		$this->panel = $name;

		return $this;
	}

	/**
	 * @param int $priority
	 *
	 * @return array
	 */
	public function get_section( $priority = 10 ) {
		return [
			'title'    => esc_html__( 'Header', 'typer' ),
			'panel'    => $this->panel,
			'priority' => $priority
		];
	}

	/**
	 * @return string
	 */
	public function get_section_slug() {
		return 'svq_section_header';
	}

	/**
	 * @return array
	 */
	public function get_options() {

		$this->sq['header_always_dark'] = [
			'section'     => $this->get_section_slug(),
			'type'        => 'switch',
			'choices'     => typer()->get_config( 'switch_options' ),
			'default'     => '0',
			'title'       => esc_html__( 'Header Dark Mode', 'typer' ),
			'description' => esc_html__( 'Your header will always be in dark mode', 'typer' )
		];

		$this->sq['header_sticky'] = [
			'section'     => $this->get_section_slug(),
			'type'        => 'switch',
			'choices'     => typer()->get_config( 'switch_options' ),
			'default'     => '1',
			'title'       => esc_html__( 'Sticky', 'typer' ),
			'description' => esc_html__( 'Enable Sticky Header behaviour on scroll', 'typer' )
		];

		$this->sq['header_search'] = [
			'section'     => $this->get_section_slug(),
			'type'        => 'switch',
			'choices'     => typer()->get_config( 'switch_options' ),
			'default'     => '1',
			'title'       => esc_html__( 'Search', 'typer' ),
			'description' => esc_html__( 'Show search in header', 'typer' )
		];


		$this->sq['header_menu_position'] = [
			'section' => $this->get_section_slug(),
			'type'    => 'radio',
			'choices' => typer()->get_config( 'menu_position_options' ),
			'default' => 'right',
			'title'   => esc_html__( 'Menu alignment', 'typer' )
		];

		return $this->sq;

	}

}
