<?php

namespace Seventhqueen\Typer\Config\Customizer;

use function Seventhqueen\Typer\typer;

/**
 * Class FooterOptions
 * @package Seventhqueen\Typer\Config\Customizer
 */
class FooterOptions {

	/**
	 * @var array
	 */
	private $sq = [];

	/**
	 * @var string
	 */
	private $panel = '';

	/**
	 * @param $name
	 *
	 * @return $this
	 */
	public function set_panel_name( $name ) {
		$this->panel = $name;

		return $this;
	}

	/**
	 * @param int $priority
	 *
	 * @return array
	 */
	public function get_section( $priority = 10 ) {
		return [
			'title'    => esc_html__( 'Footer', 'typer' ),
			'panel'    => $this->panel,
			'priority' => $priority
		];
	}

	/**
	 * @return string
	 */
	public function get_section_slug() {
		return 'svq_section_footer';
	}

	/**
	 * @return array
	 */
	public function get_options() {

		$this->sq['footer_copyright'] = [
			'section' => $this->get_section_slug(),
			'type'    => 'editor',
			'default' => 'Made with &#10084; by <a href="https://seventhqueen.com" rel="nofollow" target="_blank">SeventhQueen</a>',
			'label'   => esc_html__( 'Copyright text', 'typer' ),
		];

		$this->sq['footer_bg_color'] = [
			'section'         => $this->get_section_slug(),
			'type'            => 'color',
			'default'         => '#ffffff',
			'title'           => esc_html__( 'Footer background', 'typer' ),
			'description'     => esc_html__( 'Set a background color for your footer.', 'typer' ),
			'transport'       => 'postMessage',
			'css_vars'        => [
				[ '--footer-bg-h', 'hex_to_hsl_h' ],
				[ '--footer-bg-s', 'hex_to_hsl_s' ],
				[ '--footer-bg-l', 'hex_to_hsl_l' ],
				[ '--footer-bg-contrast-color', 'color_contrast' ],
			]
		];

		return $this->sq;

	}

}
