<?php

namespace Seventhqueen\Typer\Config\Customizer;

/**
 * Class ColorOptions
 * @package Seventhqueen\Typer\Config\Customizer
 */
class ColorOptions {

	/**
	 * @var array
	 */
	private $sq = [];

	/**
	 * @var string
	 */
	private $panel = '';

	/**
	 * @param $name
	 *
	 * @return $this
	 */
	public function set_panel_name( $name ) {
		$this->panel = $name;

		return $this;
	}

	/**
	 * @param int $priority
	 *
	 * @return array
	 */
	public function get_section( $priority = 10 ) {
		return [
			'title'    => esc_html__( 'Site Colors', 'typer' ),
			'panel'    => $this->panel,
			'priority' => $priority
		];
	}

	/**
	 * @return string
	 */
	public function get_section_slug() {
		return 'svq_section_colors';
	}

	/**
	 * @return array
	 */
	public function get_options() {


		$this->sq['color-preset'] = [
			'section'     => $this->get_section_slug(),
			'type'        => 'radio',
			'default'     => 'light',
			'choices' => [
				'light'    => esc_html__( 'Light', 'typer' ),
				'dark'   => esc_html__( 'Dark', 'typer' ),
				'tutorials'   => esc_html__( 'Tutorials Hub', 'typer' ),
			],
			'title'       => esc_html__( 'Color Presets', 'typer' ),
			'description' => esc_html__( 'Choose from predefined color presets.', 'typer' ),
			'preset'      => [
				'light'    => [
					'settings' => [
						'body-bg-color' => '#ffffff',
						'text-color' => '#4b4f56',
						'heading-color' => '#242424',
						'primary-color' => '#ca6958',
						'light-color' => '#faf8f5',
						'dark-color' => '#242424',
						'link-color' => '#ca6958',
						'border-color' => '#f1ece4',
						'text-meta-color' => '#90949c',
					],
				],
				'dark'    => [
					'settings' => [
						'body-bg-color' => '#121212',
						'text-color' => '#888888',
						'heading-color' => '#d0d0d0',
						'primary-color' => '#d86252',
						'light-color' => '#1a1a1a',
						'dark-color' => '#e0e0e0',
						'link-color' => '#d86252',
						'border-color' => '#383838',
						'text-meta-color' => '#888888',
					],
				],
				'tutorials'    => [
					'settings' => [
						'body-bg-color' => '#ffffff',
						'text-color' => '#4b4f56',
						'heading-color' => '#242424',
						'primary-color' => '#621aa5',
						'light-color' => '#fafafa',
						'dark-color' => '#242424',
						'link-color' => '#8734d4',
						'border-color' => '#e5e5e5',
						'text-meta-color' => '#90949c',
					],
				],
			],
			'transport'   => 'postMessage',

		];

		$this->sq['body-bg-color'] = [
			'section'     => $this->get_section_slug(),
			'type'        => 'color',
			'default'     => '#ffffff',
			'title'       => esc_html__( 'Body Background color', 'typer' ),
			'description' => esc_html__( 'Background color for your site', 'typer' ),
			'transport'   => 'postMessage',
			'css_vars'    => [
				[ '--body-bg-h', 'hex_to_hsl_h' ],
				[ '--body-bg-s', 'hex_to_hsl_s' ],
				[ '--body-bg-l', 'hex_to_hsl_l' ],
				[ '--body-bg-contrast-color', 'color_contrast' ],
			],
		];

		$this->sq['text-color'] = [
			'section'     => $this->get_section_slug(),
			'type'        => 'color',
			'default'     => '#4b4f56',
			'title'       => esc_html__( 'Site Text color', 'typer' ),
			'description' => esc_html__( 'General site text color', 'typer' ),
			'transport'   => 'postMessage',
			'css_vars'    => [
				[ '--text-color' ],

			],
		];

		$this->sq['heading-color'] = [
			'section'     => $this->get_section_slug(),
			'type'        => 'color',
			'default'     => '#242424',
			'title'       => esc_html__( 'Headings color', 'typer' ),
			'description' => esc_html__( 'Color used for all the headings in the site(H1-H6)', 'typer' ),
			'transport'   => 'postMessage',
			'css_vars'    => [
				[ '--heading-color' ],

			],
		];

		$this->sq['primary-color'] = [
			'section'     => $this->get_section_slug(),
			'type'        => 'color',
			'default'     => '#ca6958',
			'title'       => esc_html__( 'Primary color', 'typer' ),
			'description' => esc_html__( 'Set an accent color for your site. Used on buttons and other colored components', 'typer' ),
			'transport'   => 'postMessage',
			'css_vars'    => [
				[ '--primary-h', 'hex_to_hsl_h' ],
				[ '--primary-s', 'hex_to_hsl_s' ],
				[ '--primary-l', 'hex_to_hsl_l' ],
				[ '--primary-contrast-color', 'color_contrast' ],
			],
		];

		$this->sq['light-color'] = [
			'section'     => $this->get_section_slug(),
			'type'        => 'color',
			'default'     => '#faf8f5',
			'title'       => esc_html__( 'Lighter color', 'typer' ),
			'description' => esc_html__( 'Normally is a color that is close to the background color', 'typer' ),
			'transport'   => 'postMessage',
			'css_vars'    => [
				[ '--light-h', 'hex_to_hsl_h' ],
				[ '--light-s', 'hex_to_hsl_s' ],
				[ '--light-l', 'hex_to_hsl_l' ],
				[ '--light-contrast-color', 'color_contrast' ],
			],
		];

		$this->sq['dark-color'] = [
			'section'     => $this->get_section_slug(),
			'type'        => 'color',
			'default'     => '#242424',
			'title'       => esc_html__( 'Darker color', 'typer' ),
			'description' => esc_html__( 'Normally is a color that is very different from the background color', 'typer' ),
			'transport'   => 'postMessage',
			'css_vars'    => [
				[ '--dark-h', 'hex_to_hsl_h' ],
				[ '--dark-s', 'hex_to_hsl_s' ],
				[ '--dark-l', 'hex_to_hsl_l' ],
				[ '--dark-contrast-color', 'color_contrast' ],
			],
		];

		$this->sq['link-color'] = [
			'section'     => $this->get_section_slug(),
			'type'        => 'color',
			'default'     => '#ca6958',
			'title'       => esc_html__( 'Link color', 'typer' ),
			'description' => esc_html__( 'Links(anchors) color', 'typer' ),
			'transport'   => 'postMessage',
			'css_vars'    => [
				[ '--link-h', 'hex_to_hsl_h' ],
				[ '--link-s', 'hex_to_hsl_s' ],
				[ '--link-l', 'hex_to_hsl_l' ],
				[ '--link-contrast-color', 'color_contrast' ],
			],
		];

		$this->sq['border-color'] = [
			'section'     => $this->get_section_slug(),
			'type'        => 'color',
			'default'     => '#f1ece4',
			'title'       => esc_html__( 'Border color', 'typer' ),
			'description' => esc_html__( 'Site Borders color', 'typer' ),
			'transport'   => 'postMessage',
			'css_vars'    => [
				[ '--border-color' ],
			],
		];

		$this->sq['text-meta-color'] = [
			'section'     => $this->get_section_slug(),
			'type'        => 'color',
			'default'     => '#90949c',
			'title'       => esc_html__( 'Meta Text color', 'typer' ),
			'description' => esc_html__( 'Blog meta text color.', 'typer' ),
			'transport'   => 'postMessage',
			'css_vars'    => [
				[ '--text-meta-color' ],
			],
		];

		return $this->sq;

	}

}
