<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package typer
 */

namespace Seventhqueen\Typer;

?>
<!DOCTYPE html>
<html <?php language_attributes(); ?> class="<?php echo esc_attr( typer()->get_html_class( 'no-js' ) ) ?>" dir="ltr">
	<head>
		<meta charset="<?php bloginfo( 'charset' ); ?>">
		<meta http-equiv="X-UA-Compatible" content="IE=edge"/>
		<meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1">
		<meta name="author" content="SeventhQueen"/>
		<link rel="profile" href="http://gmpg.org/xfn/11">

		<?php
		if ( ! typer()->is_amp() ) {
			?>
			<script>document.documentElement.classList.remove('no-js');</script>
			<?php
		}
		?>

		<?php wp_head(); ?>
	</head>

	<body <?php body_class(); ?>>
		<?php if( typer()->get_option( 'page_preloader' ) ) :?>
			<div class="svq-page-loader"></div>
		<?php endif; ?>
		<?php wp_body_open(); ?>

		<?php do_action( 'typer_after_body' ); ?>

		<div class="svq-page-wrapper">
			<a class="skip-link screen-reader-text" href="#primary"><?php esc_html_e( 'Skip to content', 'typer' ); ?></a>

			<?php
			/**
			 * Included Header section using actions
			 *
			 * Templates used:
			 * @see template-parts/header.php - (outputs header)
			 *
			 * @hooked typer_show_header - 10
			 */
			do_action( 'typer_header' );
