(function ($) {

	'use strict';

	var ArticleSliderHandler = function ($scope, $) {
		if ($scope.find('.svq-media-slider.svq-media-slider--featured')) {
			SQ.documentOnLoad.initNestedCarousel();
		}

		if ($scope.find('.svq-media-slider:not(.svq-media-slider--featured)') || $scope.find('.svq-panel-slider.swiper-container-horizontal')) {
			SQ.documentOnLoad.initArticlesCarousel();
		}

		if ($scope.find('.svq-panel-slider')) {
			SQ.documentOnLoad.initArticlePanelCarousel();
		}
	};

	var OnboardingHandler = function ($scope, $) {
		SQ.initialize.initOnboardingSlider();
	};

	var PostsHandler = function ($scope, $) {
		if ($scope.find('.svq-masonry-articles')) {
			setTimeout(function () {
				SQ.initialize.initMasonry();
			}, 1000);
		}
	};

	$(window).on('elementor/frontend/init', function () {
			if (window.elementorFrontend) {
				elementorFrontend.hooks.addAction('frontend/element_ready/widget', function ($scope) {
					$(window).trigger('reveal');
					window.dispatchEvent(new Event('loadLazy'));
				});

				elementorFrontend.hooks.addAction(
					'frontend/element_ready/typer-article-slider.default',
					ArticleSliderHandler
				);

				elementorFrontend.hooks.addAction(
					'frontend/element_ready/typer-onboarding.default',
					OnboardingHandler
				);

				elementorFrontend.hooks.addAction(
					'frontend/element_ready/typer-posts.default',
					PostsHandler
				);
			}
		}
	);
})(jQuery);
