var SQ = SQ || {};

(function ($) {

	// USE STRICT
	'use strict';

	SQ.initialize = {
		init: function () {
			SQ.initialize.responsiveClasses();
			SQ.initialize.browserDetect();
			SQ.initialize.initProgressBar();
			SQ.initialize.initPanelContentFade();
			SQ.initialize.initStickyHeader();
			SQ.initialize.initStickyCommentTitle();
			SQ.initialize.initCommentsModal();
			SQ.initialize.initCommentsActions();
			SQ.initialize.initCommentsForm();
			SQ.initialize.initReadingTime();
			SQ.initialize.initFloatingShare();
			SQ.initialize.initFloatingShareCollide();
			SQ.initialize.initStickySidebar();
			SQ.initialize.initArticleNavigation();
			SQ.initialize.initButtonRippleEffect();
			SQ.initialize.initHeaderActions();
			SQ.initialize.initOnboardingSlider();
			SQ.initialize.initSectionReveal();
			SQ.initialize.initElementReveal();
			SQ.initialize.initMasonry();
			SQ.initialize.closeSelfPopup();
			SQ.initialize.enableMultiLevelMenu();
			SQ.initialize.initCommentsAjaxPagination();
			SQ.initialize.initPostsWidgetAjaxPagination();
		},

		responsiveClasses: function () {
			var jRes = jRespond([
				{
					label: 'extra-small',
					enter: 0,
					exit: 575, //479
				},
				{
					label: 'small',
					enter: 576, //480,
					exit: 767,
				},
				{
					label: 'medium',
					enter: 768,
					exit: 991,
				},
				{
					label: 'large',
					enter: 992,
					exit: 1199,
				},
				{
					label: 'extra-large',
					enter: 1200,
					exit: 10000,
				},
			]);

			jRes.addFunc([
				{
					breakpoint: 'extra-large',
					enter: function () {
						$body.addClass('device-xl');
					},
					exit: function () {
						$body.removeClass('device-xl');
					},
				},
				{
					breakpoint: 'large',
					enter: function () {
						$body.addClass('device-lg');
					},
					exit: function () {
						$body.removeClass('device-lg');
					},
				},
				{
					breakpoint: 'medium',
					enter: function () {
						$body.addClass('device-md');
					},
					exit: function () {
						$body.removeClass('device-md');
					},
				},
				{
					breakpoint: 'small',
					enter: function () {
						$body.addClass('device-sm');
					},
					exit: function () {
						$body.removeClass('device-sm');
					},
				},
				{
					breakpoint: 'extra-small',
					enter: function () {
						$body.addClass('device-xs');
					},
					exit: function () {
						$body.removeClass('device-xs');
					},
				},
			]);
		},

		browserDetect: function () {
			var BrowserDetect = {
				init: function () {
					this.browser = this.searchString(this.dataBrowser) || 'An unknown browser';
					this.version = this.searchVersion(navigator.userAgent) ||
						this.searchVersion(navigator.appVersion) || 'An unknown version';
					this.OS = this.searchString(this.dataOS) || 'An unknown OS';
				},
				searchString: function (data) {
					for (var i = 0; i < data.length; i++) {
						var dataString = data[i].string;
						var dataProp = data[i].prop;
						this.versionSearchString = data[i].versionSearch || data[i].identity;

						if (dataString) {
							if (dataString.indexOf(data[i].subString) !== -1)
								return data[i].identity;
						} else if (dataProp) {
							return data[i].identity;
						}
					}
				},
				searchVersion: function (dataString) {
					var index = dataString.indexOf(this.versionSearchString);
					if (index === -1) return;
					return parseFloat(dataString.substring(
						index + this.versionSearchString.length + 1));
				},
				dataBrowser: [
					{
						string: navigator.userAgent,
						subString: 'Chrome',
						identity: 'Chrome',
					}, {
						string: navigator.userAgent,
						subString: 'OmniWeb',
						versionSearch: 'OmniWeb/',
						identity: 'OmniWeb',
					}, {
						string: navigator.vendor,
						subString: 'Apple',
						identity: 'Safari',
						versionSearch: 'Version',
					}, {
						prop: window.opera,
						identity: 'Opera',
						versionSearch: 'Version',
					}, {
						string: navigator.vendor,
						subString: 'iCab',
						identity: 'iCab',
					}, {
						string: navigator.vendor,
						subString: 'KDE',
						identity: 'Konqueror',
					}, {
						string: navigator.userAgent,
						subString: 'Firefox',
						identity: 'Firefox',
					}, {
						string: navigator.vendor,
						subString: 'Camino',
						identity: 'Camino',
					}, { // for newer Netscapes (6+)
						string: navigator.userAgent,
						subString: 'Netscape',
						identity: 'Netscape',
					}, {
						string: navigator.userAgent,
						subString: 'MSIE',
						identity: 'Explorer',
						versionSearch: 'MSIE',
					}, { // Added this discriminant for improved IE compatibility
						string: navigator.userAgent,
						subString: 'Trident',
						identity: 'Explorer',
						versionSearch: 'Trident',
					}, {
						string: navigator.userAgent,
						subString: 'Gecko',
						identity: 'Mozilla',
						versionSearch: 'rv',
					}, { // for older Netscapes (4-)
						string: navigator.userAgent,
						subString: 'Mozilla',
						identity: 'Netscape',
						versionSearch: 'Mozilla',
					}],
				dataOS: [
					{
						string: navigator.platform,
						subString: 'Win',
						identity: 'Windows',
					}, {
						string: navigator.platform,
						subString: 'Mac',
						identity: 'Mac',
					}, {
						string: navigator.userAgent,
						subString: 'iPhone',
						identity: 'iPhone/iPod',
					}, {
						string: navigator.platform,
						subString: 'Linux',
						identity: 'Linux',
					}],

			};

			if (typeof BrowserDetect.browser === 'undefined') {
				BrowserDetect.init();
			}

			function addHtmlClass(browserClass) {
				'use strict';

				var htmlElt = document.getElementsByTagName('html')[0];

				if (htmlElt.className.indexOf(browserClass) === -1) {
					htmlElt.className = htmlElt.className + ' ' + browserClass;
				}
			}

			addHtmlClass(BrowserDetect.browser.toLowerCase());

			var isMobile = {
				Android: function () {
					return navigator.userAgent.match(/Android/i);
				},
				BlackBerry: function () {
					return navigator.userAgent.match(/BlackBerry/i);
				},
				iOS: function () {
					return navigator.userAgent.match(/iPhone|iPad|iPod/i);
				},
				Opera: function () {
					return navigator.userAgent.match(/Opera Mini/i);
				},
				Windows: function () {
					return navigator.userAgent.match(/IEMobile/i);
				},
				any: function () {
					return (isMobile.Android() || isMobile.BlackBerry() || isMobile.iOS() || isMobile.Opera() ||
						isMobile.Windows());
				},
			};

			if (BrowserDetect.browser === 'Chrome' && isMobile.Android()) {
				$body.addClass('os-android');
			}
			if (BrowserDetect.browser === 'MSIE') {
				$body.addClass('MSIE');
			}
			if (BrowserDetect.browser === 'Trident') {
				$body.addClass('ie-11');
			}

		},

		viewportWidthScrollbar: function () {
			if (window.innerWidth > body.clientWidth + 5) {
				$body.classList.add('has-scrollbar');
				$body.setAttribute('style', '--scroll-bar: ' + (window.innerWidth - $body.clientWidth) + 'px');
			} else {
				$body.classList.remove('has-scrollbar');
			}
		},

		initSectionReveal: function () {
			var elements = document.querySelectorAll('.section-reveal');
			var config = {
				root: null,
				rootMargin: '0px',
			};

			var observer = new IntersectionObserver(function (entries, self) {
					$.each(entries, function (index, entry) {
						if (entry.isIntersecting) {
							$(entry.target).addClass('section-inview animated');
							self.unobserve(entry.target);
						}
					});
				}, config
			);

			$.each(elements, function (index, element) {
				observer.observe(element);
			});
		},

		initElementReveal: function () {
			var elements = document.querySelectorAll('.will-animate');
			var config = {
				root: null,
				rootMargin: '0px',
			};

			var observer = new IntersectionObserver(function (entries, self) {
					var x = 1;
					$.each(entries, function (index, entry) {
						if (entry.isIntersecting) {
							SQ.initialize.revealElement(entry.target, x);
							x++;
							self.unobserve(entry.target);
							entry.target.classList.remove('will-animate');
						}
					});
				}, config
			);

			$.each(elements, function (index, element) {
				observer.observe(element);
			});
		},

		revealElement: function (element, index) {
			var animation = $(element).data('cssanimate');

			$(element).css({'animation-delay': 0.05 * (1 + index) + 's'}).addClass(animation).addClass('animated').data('animation-state', 'done');
		},

		initProgressBar: function () {
			var progressBar = $('#progressBar');
			if (progressBar.length) {
				var getMax = function () {
					return $document.height() - $window.height();
				};

				var getValue = function () {
					return $window.scrollTop();
				};

				if ('max' in document.createElement('progress')) {
					var progressEl = $('.svq-progress-bar progress');

					progressEl.prop({max: getMax(), value: getValue()});

					$document.on('scroll', function () {
						progressEl.prop({value: getValue()});
					});

					$window.resize(function () {
						progressEl.prop({max: getMax(), value: getValue()});
					});
				}
			}
		},

		initPanelContentFade: function () {
			var panel = $('.svq-panel');
			var entryHeader = panel.find('.entry-header');

			if (panel.length && entryHeader.length) {
				var offsetTop = entryHeader.offset().top;
				var height = entryHeader.height();
				var fadeStartPoint = offsetTop - height + height / 2;

				if (panel.hasClass('svq-panel--media-below') || panel.hasClass('svq-panel--half') || offsetTop < height) {
					fadeStartPoint = offsetTop;
				}

				var lastScroll = 0;

				$window.on('scroll', function () {
					var scroll = $(this).scrollTop();

					var ratio = Math.abs(((scroll - fadeStartPoint) / 100) * 0.50);

					if (scroll > lastScroll) {
						if (scroll >= fadeStartPoint) {
							if (ratio <= 1)
								entryHeader.find('.fade-on-scroll').css({
									'transform': 'translateY(' + ratio * 40 + 'px)',
									'opacity': 1 - ratio,
								});
						}
					} else if (scroll < lastScroll) {
						if (scroll >= fadeStartPoint) {
							if (ratio <= 1)
								entryHeader.find('.fade-on-scroll').css({
									'transform': 'translateY(' + ratio * 40 + 'px)',
									'opacity': 1 - ratio,
								});
						} else {
							entryHeader.find('.fade-on-scroll').css({
								'transform': 'translateY(0px)',
								'opacity': 1,
							});
						}
					}

					lastScroll = scroll;
				});
			}
		},

		initStickyHeader: function () {
			var stickyHeader = $('.svq-header--sticky');
			var stickyHeaderInner = stickyHeader.find('.navbar-container');
			var resizeOffset = 100;

			if (stickyHeaderInner.length) {
				stickyHeader.wrap('<div class="header-sticky-wrapper"></div>');
				var wrapper = $('.header-sticky-wrapper');
				wrapper.height(stickyHeaderInner.outerHeight());

				stickyHeader.addClass('is-sticky');
				SQ.initialize.setStickyHeaderTop(stickyHeaderInner);

				$window.on('resize', function () {
					SQ.initialize.setStickyHeaderTop(stickyHeaderInner);
				});

				$window.on('scroll', function () {
					var navScroll = $(this).scrollTop();

					SQ.initialize.setStickyHeaderTop(stickyHeaderInner);

					if (navScroll > resizeOffset) {
						if (!stickyHeaderInner.hasClass('is-resize')) {
							stickyHeaderInner.addClass('is-resize');
						}
					} else {
						if (stickyHeaderInner.hasClass('is-resize')) {
							stickyHeaderInner.removeClass('is-resize');
						}
					}
				});
			}
		},

		adminBarEnabled: function () {
			var adminBar = $('#wpadminbar');
			if (adminBar.length > 0) {
				return true;
			}
			return false;
		},
		getAdminBarHeight: function () {
			var adminBar = $('#wpadminbar');
			if (adminBar.length > 0) {
				return adminBar.outerHeight();
			}
			return 0;

		},

		setStickyHeaderTop: function (stickyHeaderInner) {
			var navScroll = $(window).scrollTop();

			if ($window.width() <= 600) {
				if (SQ.initialize.adminBarEnabled() && navScroll <= 46) {
					stickyHeaderInner.css('top', SQ.initialize.getAdminBarHeight() - navScroll);
				} else {
					stickyHeaderInner.css('top', 0);
				}
			} else {
				stickyHeaderInner.css('top', SQ.initialize.getAdminBarHeight());
			}
		},


		initStickyCommentTitle: function () {
			var stickyTitle = $('.comments-title--sticky');

			if (stickyTitle.length) {
				$('.svq-comments').on('scroll', function () {
					var position = $('.comments-list').offset().top - $document.scrollTop();

					if (position < 0) {
						stickyTitle.addClass('is-active');
					} else {
						stickyTitle.removeClass('is-active');
					}
				});
			}
		},

		initCommentsModal: function () {
			$(document).on('click', '.show-responses', function () {
				$(this).closest('.svq-section-comments').find('.svq-comments').modal('show');
				$body.addClass('modal-el-is-active');
				return false;
			});

			$(document).on('click', '.close-responses', function () {
				$(this).closest('.svq-section-comments').find('.svq-comments').modal('hide');
				$body.removeClass('modal-el-is-active');
			});
		},

		initCommentsActions: function () {
			$(document).on('click', '[data-action="btn-comments-trigger"]', function (e) {
				e.preventDefault();

				var postID = $(this).data('post-id');

				$body.addClass('comments-open');

				$('.for-post-id-' + postID)
					.show()
					.find('.comment-respond')
					.show();

				if (!$('#comments-post-' + postID).hasClass('svq-comments--modal')) {
					$(this).hide();
				}

				$window.trigger('svq-sticky-sidebar-update');
			});

			$(document).on('submit', '.comment-form', function (e) {
				e.preventDefault();

				var _this = $(this);
				var formData = new FormData(this);

				$.ajax({
					method: 'POST',
					url: $(this).attr('action'),
					data: formData,
					context: $(this),
					cache: false,
					contentType: false,
					processData: false,
					beforeSend: function () {
						_this.find('button[type=submit]').prop('disabled', true).addClass('is-loading');
					},
					complete: function () {
						_this.find('button[type=submit]').prop('disabled', false).removeClass('is-loading');
					},
					success: function (response) {
						if (response.status === 'success') {
							_this.find('.request-response').html('');

							if (response.reply_to !== '0') {
								var comment = _this.closest('#comment-' + response.reply_to);
								var commentChildren = comment.children('ul.children').first();

								if (commentChildren.length) {
									commentChildren.append(response.data);
								} else {
									comment.append('<ul class="children">' + response.data + '</ul>');
								}

								var tempForm = _this.find('#wp-temp-form-div');

								if (tempForm.length) {
									_this.find('.cancel-comment-reply-link').hide();
									tempForm.replaceWith(_this.find('.comment-respond'));
								}
							} else {
								var mainContainer = _this.closest('.svq-section-comments');
								mainContainer.find('.svq-comments.comments-empty').removeClass('comments-empty');
								mainContainer.find('.comments-list').append(response.data);

								if (response.comment_status === 'approved') {
									var commentStatus = mainContainer.find('.svq-status-comments');
									if (!commentStatus.hasClass('has-comments')) {
										commentStatus.addClass('has-comments');
									}

									var commentCounter = mainContainer.find('.svq-svg-icon-wrapp');
									if (!commentCounter.attr('data-svg-notifier')) {
										commentCounter.attr('data-svg-notifier', 1);
									} else {
										commentCounter.attr('data-svg-notifier',
											parseInt(commentCounter.attr('data-svg-notifier')) + 1);
									}

									var introText = mainContainer.find('.comments-stat-info');
									introText.html(introText.data('first'));
								}
							}

							window.addComment.init();

							_this.find('input[type=text], input[type=email], textarea').val('');
							_this.find('input[type=checkbox]').prop('checked', false);

							window.dispatchEvent(new Event('resize'));
							window.dispatchEvent(new Event('clear-comment-form-media'));
						} else if (response.status === 'error') {
							_this.find('.request-response').html(response.data);
						}
					},

				});
			});

			$(document).on('click', '.comment-report', function (e) {
				e.preventDefault();

				$.ajax({
					method: 'POST',
					url: '/wp-admin/admin-ajax.php',
					data: {
						comment_id: $(this).data('target'),
						action: 'report_comment',
					},
					context: $(this),
					beforeSend: function () {

					},
					complete: function () {

					},
					success: function (response) {
						if (response.status === 'success') {
							var actionDropdown = $(this).parent();
							if (actionDropdown.find('a').length === 2) {
								$(this).remove();
							} else {
								actionDropdown.closest('.comment-action').remove();
							}
						} else if (response.status === 'error') {
						}
					},
				});
			});
		},

		initCommentsForm: function () {
			var commentForm = $('.sqv-comment-form');

			commentForm.each(function (i, item) {
				if ($(item).children().length !== 0) {
					var target = $(item).find('.comment-form-comment');

					if (!target.length)
						return;

					var subscription = $(item).find('.comment-unsubscribe');
					if (subscription.length) {
						subscription.insertAfter(target);
					}
				}
			});

			var commentFormMedia = $('.comment-form');

			commentFormMedia.each(function (i, item) {
				if ($(item).find('.svq-comment--media').length) {
					var target = $(item).find('.comment-form-comment');

					if (!target.length)
						return;

					var subscription = $(item).find('.comment-unsubscribe');
					if (subscription.length) {
						subscription.insertAfter(target);
					}

					var media = $(item).find('.svq-comment--media');
					if (media.length) {
						media.insertAfter(target);
					}

					var mediaLabel = $(item).find('.svq-comment--media-notes');
					if (mediaLabel.length) {
						mediaLabel.insertAfter(target);
					}
				}
			});
		},

		initReadingTime: function () {
			var noTimePrefix = $('.no-reading-time');
			var readingTime = $('.reading-time');

			if (noTimePrefix.length && readingTime.length) {
				noTimePrefix.hide();

				var words = $('.entry-content').text().replace(/(\r\n|\n|\r)/gm, '').split(' ');
				words = words.filter(function (v) {
					return v !== '';
				});

				$('span#words').html(words.length);

				var readingSpeed = 130;
				var readingTimeSec = (60 / readingSpeed) * words.length;
				var readingTimeMin = Math.round(readingTimeSec / 60);

				if (!readingTimeMin) {
					readingTimeMin = 1;
					noTimePrefix.show();
				}

				readingTime.html(Math.round(readingTimeMin));
			}
		},

		initFloatingShare: function () {
			if (!$.fn.hcSticky) {
				return false;
			}
			var el = $('.sticky_element');

			if (el.length) {
				el.each(function (i, item) {
					$(item).hcSticky({
						stickTo: $(item).parent()[0],
						top: 120,
						responsive: {
							992: {disable: true},
						},
					});
				})
			}
		},

		initStickySidebar: function () {
			if (!$.fn.hcSticky) {
				return false;
			}
			$('.svq-sticky-el').each(function (index, el) {
				var stickElement = null;
				var id = $(el).data('stick-to');
				if ($(el).parent().attr('id') === id) {
					stickElement = $(el).parent()[0];
				}

				if (stickElement) {
					$(el).hcSticky({
						stickTo: stickElement,
						followScroll: false,
						top: parseInt($(el).data('top')),
						responsive: {
							980: {
								disable: true,
							},
						},
					});
				}
			});
		},

		initFloatingShareCollide: function () {
			var el = $('.svq-share--floated');

			if (el.length) {
				var isColliding = function (item_1, item_2) {
					if (!item_1 || !item_2)
						return;

					var object_1 = $(item_1)[0].getBoundingClientRect();
					var object_2 = $(item_2)[0].getBoundingClientRect();

					return (object_1.left < object_2.left + object_2.width && object_1.left + object_1.width >
						object_2.left &&
						object_1.top < object_2.top + object_2.height && object_1.top + object_1.height > object_2.top);
				};

				var last_collide = null;

				$window.on('scroll', function () {
					var shareWidget = $('.div-lower');
					var targets = $(
						'.svq-sidenote--left, .svq--full-width, .alignfull, .alignwide, .is-floated .alignleft, .svq-article-col');

					targets.each(function (index, item) {
						if (isColliding(shareWidget, item)) {
							last_collide = item;
							shareWidget.addClass('el-is-hidden').removeClass('el-is-visible');
						} else if (last_collide === item) {
							if (shareWidget.hasClass('el-is-hidden')) {
								shareWidget.addClass('el-is-visible').removeClass('el-is-hidden');
								last_collide = null;
							}
						}
					});
				});
			}
		},

		initOnboardingSlider: function () {
			var slider = $('.onboard-slider');

			if (slider.length) {
				var skip = $('.btn-onboard-skip');
				var next = $('.btn-onboard-next');
				var close = $('.btn-onboard-close');

				var swiper = new Swiper(slider, {
					slidesPerView: 1,
					autoHeight: true
				});

				next.on('click', function (e) {
					e.preventDefault();
					swiper.slideNext();
				});

				skip.on('click', function () {
					swiper.slideTo(swiper.slides.length - 1);
				});

				close.on('click', function (e) {
					e.preventDefault();
					var closeBtn = $(this).closest('.jet-popup').find('.jet-popup__close-button');
					var overlay = $(this).closest('.jet-popup').find('.jet-popup__overlay');

					if (closeBtn.length) {
						closeBtn.trigger('click');
					} else if (overlay.length) {
						overlay.trigger('click');
					}
				});

				$window.resize(function () {
					swiper.update()
				});
			}
		},

		initButtonRippleEffect: function () {
			$body.on('click', '.button-ripple',
				function (e) {
					var x = e.pageX - $(this).offset().left;
					var y = e.pageY - $(this).offset().top;

					$(this).find('.button_ripple').remove();

					$('<span class="button_ripple"/>').appendTo(this).css({left: x, top: y});
				});

			$body.on('keydown', function (e) {
				if (e.which == 9) {
					$body.addClass('keyboardfocus');
				}
			});

			$body.on('click', function (e) {
				$body.removeClass('keyboardfocus');
			});
		},

		initHeaderActions: function () {
			$('[data-action="btn-search-toggle"]').on('click', function (e) {
				e.preventDefault();

				$('.ty-search').toggleClass('is-visible').find('.ty-search-input').focus();
			});

			$('[data-mobile-style="full-height"]').on('click', function () {
				if ($(this).hasClass('collapsed')) {
					$('.navbar-container').addClass('is-expanded');
				} else {
					$('.navbar-container').removeClass('is-expanded');
				}
			});
		},

		initArticleNavigation: function () {
			var nav = $('.nav-article-section');

			if (nav.length) {
				var didScroll;
				var lastScrollTop = 0;
				var delta = 10;

				if ($window.height() >= $document.height()) {
					nav.removeClass('nav-down').addClass('nav-up');
				}

				$window.resize(function () {
					if ($window.height() >= $document.height()) {
						nav.removeClass('nav-down').addClass('nav-up');
					}
				});

				$window.on('scroll', function (event) {
					didScroll = true;
				});

				var showedBefore = false;

				setInterval(function () {
					if (didScroll) {
						var st = $(this).scrollTop();

						if (Math.abs(lastScrollTop - st) <= delta)
							return;

						if (st > lastScrollTop || st < 100) {
							nav.removeClass('nav-up').addClass('nav-down').removeClass('nav-hidden');
						} else if (st + $window.height() < $document.height()) {
							if (!showedBefore) {
								SQ.initialize.initLazy();
								showedBefore = true;
							}
							nav.removeClass('nav-down').addClass('nav-up');
						}

						lastScrollTop = st;
						didScroll = false;
					}
				}, 200);
			}
		},
		closeSelfPopup: function () {
			$('.login-popup, .register-popup').on('click', function () {
				var $popup = $(this).closest('.jet-popup ');

				if ($popup.length === 1) {

					var popupId = $popup.attr('id');

					$window.trigger({
						type: 'jet-popup-close-trigger',
						popupData: {
							popupId: popupId,
							constantly: false
						}
					});
				}
			});
		},
		enableMultiLevelMenu: function () {
			$('.widget_nav_menu .menu li.menu-item-has-children a').on('click', function (e) {
				if ($(this).next('ul.sub-menu').length) {
					e.preventDefault();

					var _this = $(this);

					$('.widget_nav_menu .menu > li.menu-item-has-children > a.active-menu').each(function () {
						if (!$(this).is(_this) && !$(this).next().find(_this).length) {
							$(this).removeClass("active-menu");
							$(this).next().slideUp();
						}
					});

					_this.toggleClass("active-menu");

					if (!_this.next().is(":visible")) {
						_this.next().slideDown();
					} else {
						_this.next().slideUp();
					}
				}
			});

			/* Allow to click on parent items that have a link */
			$('#header a.dropdown-toggle').on('click', function (e) {
				if (!$('html').hasClass('touchevents') && $(window).width() >= 991) {
					location.href = this.href;
				}
			});

			$('.dropdown-menu a.dropdown-toggle').on('click', function (e) {

				if (!$(this).next().hasClass('show')) {
					$(this).parents('.dropdown-menu').first().find('.show').removeClass("show");
				}

				var $subMenu = $(this).next(".dropdown-menu");
				$subMenu.toggleClass('show');
				$(this).closest(".dropdown").toggleClass('show');

				$(this).parents('li.nav-item.dropdown.show').on('hidden.bs.dropdown', function (e) {
					$('.dropdown-submenu .show').removeClass("show");
				});

				return false;
			});
		},

		initCommentsAjaxPagination: function () {
			$(document).on('click', '.svq-section-comments .svq-get-prev-comments, .svq-section-comments .svq-get-next-comments', function (e) {
				e.preventDefault();

				var _this = $(this);
				var listing = _this.closest('.svq-comments');
				var container = _this.closest('.svq-section-comments');

				$.ajax({
					method: 'get',
					url: $(this).attr('href'),
					beforeSend: function () {
						listing.addClass('section-is-loading');

						var tempForm = $('#wp-temp-form-div');

						if (tempForm.length) {
							_this.find('.cancel-comment-reply-link').hide();
							tempForm.replaceWith(_this.find('.comment-respond'));
						}
					},
					complete: function () {
						listing.removeClass('section-is-loading');
					},
					success: function (response) {
						if (response) {
							var dom = $(response);

							if (container.hasClass('svq-comments--modal')) {
								var modalCommentList = dom.find('#svq-comments .comments-list').first();

								if (modalCommentList.length) {
									listing.find('.comments-list').first().replaceWith(modalCommentList);
								}

								var modalNav = dom.find('#svq-comments .navigation.comment-navigation').first();

								if (modalNav.length) {
									listing.find('.navigation.comment-navigation').first().replaceWith(modalNav);
								}
							} else {
								var commentList = dom.find('#svq-comments');

								if (commentList.length) {
									listing.replaceWith(commentList);
									container.find('.svq-comments').show();
								}
							}

							window.addComment.init();

							SQ.initialize.initLazy();
						}
					}
				});
			});
		},

		initPostsWidgetAjaxPagination: function () {
			$('.elementor-widget-typer-posts').on('click', '.svq-ajax-pagination a.page-numbers', function (e) {
				e.preventDefault();
				var elementId = $(this).closest('.elementor-widget-typer-posts').data('id');

				$.urlParam = function (name, url) {
					var results = new RegExp('[\?&]' + name + '=([^&#]*)').exec(url);
					return results[1] || 0;
				};

				$.ajax({
					method: 'POST',
					url: $(this).parent().data('ajax'),
					data: {
						action: 'typer_widget_get_posts',
						check: $(this).parent().data('nonce'),
						params: $(this).parent().data('params'),
						page: $.urlParam('typer_page', $(this).attr('href'))
					},
					context: $(this),
					success: function (response) {
						if (response.length) {
							var container = $(this).closest('.elementor-widget-typer-posts');
							container.html(response);

							$([document.documentElement, document.body]).animate({
								scrollTop: container.offset().top
							}, 500);

							$window.trigger('reveal');
							$window.trigger('masonry');
							SQ.initialize.initLazy();
						}
					},

				});
			});
		},

		initMasonry: function () {
			var masonryArticles = $('.svq-masonry-articles');
			if (masonryArticles.length) {
				masonryArticles.masonry({
					itemSelector: '.svq-article-col',
					columnWidth: '.svq-grid-sizer'
				});
			}
		},

		initLazy: function () {
			if (typeof LazyLoad === 'function') {
				new LazyLoad({
					elements_selector: '.lazy',
					class_loading: 'lazy-is-loading',
					class_loaded: 'lazy-is-loaded'
				});
			}
		}

	};

	SQ.documentOnReady = {
		init: function () {
			SQ.initialize.init();

			objectFitPolyfill();
		},
	};

	SQ.documentOnLoad = {
		init: function () {
			SQ.documentOnLoad.initNestedCarousel();
			SQ.documentOnLoad.initArticlesCarousel();
			SQ.documentOnLoad.initGalleryCarousel();
			SQ.documentOnLoad.initArticlePanelCarousel();
			SQ.documentOnLoad.initPreloader();
		},

		initArticlesCarousel: function () {
			$('.svq-slider-articles').each(function () {
				var swiper = new Swiper($(this), {
					slidesPerView: 'auto',
					nested: $(this).hasClass('svq-nested')
				});

				$(this).find('.slide-to--next').on('click', function (e) {
					e.preventDefault();
					swiper.slideNext();
				});

				$(this).find('.slide-to--back').on('click', function (e) {
					e.preventDefault();
					swiper.slidePrev();
				});

				$window.resize(function () {
					swiper.update()
				})
			});
		},

		initNestedCarousel: function () {
			$('.svq-media-slider').each(function () {
				var masterCarousel = $(this).find('.svq-master-carousel');
				var childCarousel = $(this).find('.svq-child-carousel');

				var categories = [];

				if (masterCarousel.length) {
					categories = masterCarousel.data('slider-categories');
				}

				if (childCarousel.length) {
					var sliderId = childCarousel.data('slider-id');
					if (sliderId) {
						childCarousel = $('.svq-child-carousel-' + sliderId);
					}

					var carousel = new Swiper(childCarousel, {
						autoHeight: true,
						slidesPerView: 1,
						pagination: {
							el: '.svq-nav-pagination',
							clickable: true,
							type: 'custom',
							renderCustom: function (swiper, current, total) {
								var navItems = '';

								if (categories.length) {
									for (var i = 0; i < total; i++) {
										var className = (current - 1) === i ? 'svq-list-item-active' : '';

										navItems += '<li class="svq-list-item swiper-slide ' + className + '">' +
											'<a href="#" class="svq-item-link svq-slider-nav-btn" role="tab" data-go-to-slide="' + i + '">' +
											(categories[i]) +
											'</a>' +
											'</li>';
									}
								}

								return navItems;
							},
						}
					});

					$window.resize(function () {
						carousel.update()
					});

					if (masterCarousel.length) {
						var sliderId = masterCarousel.data('slider-id');
						if (sliderId) {
							masterCarousel = $('.svq-master-carousel-' + sliderId);
						}

						var nav = new Swiper(masterCarousel, {
							slidesPerView: 'auto',
						});

						var pagination = $(this).find('.svq-nav-pagination');

						pagination.on('click', '.svq-slider-nav-btn', function (e) {
							e.preventDefault();
							nav.slideTo(parseInt($(this).data('go-to-slide')));
							carousel.slideTo(parseInt($(this).data('go-to-slide')));
						});

						$window.resize(function () {
							nav.update()
						});

						carousel.on('slideChange', function () {
							nav.slideTo(carousel.realIndex);
						})
					}

					var sliderBackBtn = $(this).find('.slide-to--back');
					var sliderNextBtn = $(this).find('.slide-to--next');

					sliderBackBtn.on('click', function (e) {
						e.preventDefault();
						var subCarousel = childCarousel.find('.svq-slider-articles');
						var index = carousel.realIndex;

						if (subCarousel[index]) {
							var subCarouselSwiper = subCarousel[index].swiper;

							if (subCarouselSwiper.isBeginning) {
								carousel.slidePrev();
							} else {
								subCarouselSwiper.slidePrev();
							}

							if (subCarouselSwiper.isBeginning && index - 1 === 0) {
								sliderBackBtn.trigger('is-not-visible');
							}
							sliderNextBtn.trigger('is-visible');
						}
					});

					sliderNextBtn.on('click', function (e) {
						e.preventDefault();
						var subCarousel = childCarousel.find('.svq-slider-articles');
						var index = carousel.realIndex;

						if (subCarousel[index]) {
							var subCarouselSwiper = subCarousel[index].swiper;

							if (subCarouselSwiper.isEnd) {
								carousel.slideNext();
							} else {
								subCarouselSwiper.slideNext();
							}

							if (subCarouselSwiper.isEnd && carousel.slides.length === index) {
								sliderNextBtn.trigger('is-not-visible');
							}
							sliderBackBtn.trigger('is-visible');
						}
					});

					sliderBackBtn
						.on('is-visible', function () {
							$(this).addClass('is-visible');
						})
						.on('is-not-visible', function () {
							$(this).removeClass('is-visible');
						});

					sliderNextBtn
						.on('is-visible', function () {
							$(this).addClass('is-visible');
						})
						.on('is-not-visible', function () {
							$(this).removeClass('is-visible');
						});
				}
			});
		},

		initGalleryCarousel: function () {
			$('.svq-gallery-slider').each(function () {
				var gallerySwiper = new Swiper($(this), {
					slidesPerView: 'auto',
					freeMode: true,
					freeModeMomentumRatio: 0.5,
					freeModeMomentumVelocityRatio: 0.3,
					freeModeMinimumVelocity: 0.5,
					navigation: {
						nextEl: '.svq-gallery-control-next',
						prevEl: '.svq-gallery-control-prev',
					},
					pagination: {
						el: '.swiper-pagination',
						type: 'bullets',
					},
					on: {
						init: function () {
							objectFitPolyfill();
						}
					}
				});

				$window.resize(function () {
					gallerySwiper.update()
				});
			});
		},

		initArticlePanelCarousel: function () {
			$('.svq-panel-slider').each(function () {
				var swiper = new Swiper($(this), {
					autoHeight: true,
					slidesPerView: 'auto',
					effect: 'fade',
					navigation: {
						nextEl: '.svq-panel-control-next',
						prevEl: '.svq-panel-control-prev',
					},
					pagination: {
						el: '.swiper-pagination',
						type: 'fraction'
					},
				});

				$window.resize(function () {
					swiper.update()
				})
			});
		},


		initPreloader: function () {
			var pageLoader = $('.svq-page-loader');

			if (pageLoader.length) {
				pageLoader.addClass('not-visible');
			}
		},
	};

	var $window = $(window),
		$body = $('body'),
		$document = $(document);

	$document.ready(SQ.documentOnReady.init);
	$window.on('load', SQ.documentOnLoad.init);

	$window.on('reveal', function () {
		SQ.initialize.initElementReveal();
	});

	$window.on('svq-post-changed', function () {
		SQ.initialize.initLazy();
		window.dispatchEvent(new Event('loadLazy'));
		SQ.initialize.initElementReveal();
		SQ.initialize.initFloatingShare();
		SQ.initialize.initFloatingShareCollide();
		SQ.initialize.initStickySidebar();
		objectFitPolyfill();
	});

	$window.on('masonry', function () {
		SQ.initialize.initMasonry();
	});

})(jQuery);
