<?php
/**
 * SQ Social Share
 * Author: SeventhQueen
 */

/**
 * The goal is to create a plugin that will automatically display selected social network(s) sharing buttons in posts and/or on pages.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

//making sure value is an array when no settings saved
$first_use = false;
if ( ! isset( $value ) || $value === false ) {
	$value     = [];
	$first_use = true;
}

//current platforms
$platforms = SQSocialShare::$default_platforms;

//default post types
$post_types = [];
if ( $first_use ) {
	$post_types = [ 'post', 'page' ];
}
if ( isset( $value['post_type'] ) ) {
	$post_types = $value['post_type'];
}

$show_on_select = 0;
if ( isset( $value['select_text'] ) ) {
	$show_on_select = $value['select_text'];
}

?>

<h1><?php esc_html_e( 'Social Share Settings', 'sq-social-share' ); ?></h1>

<form method="POST" action="">

    <h4><?php esc_html_e( 'Sharing platforms', 'sq-social-share' ); ?></h4>

    <div id="sortable-wrap">

		<?php
		$render_platforms = [];
		//loop trough saved data
		if ( isset( $value['platforms'] ) ) {
			foreach ( $value['platforms'] as $slug => $platform ) {
				if ( is_array( $platform ) ) {
					$render_platforms[] = $slug;
				}
			}
		}

		//just make sure we are rendering all platforms
		foreach ( $platforms as $slug => $platform ) {
			if ( ! in_array( $slug, $render_platforms, true ) ) {
				$render_platforms[] = $slug;
			}
		}

		//render the sortable data
		foreach ( $render_platforms as $slug ) :
			if ( isset( $platforms[ $slug ] ) ) :
				$color = '';
				$checked  = ' checked="checked"';

				//if we have saved data
				if ( isset( $value['platforms'][ $slug ] ) ) {

					if ( isset( $value['platforms'][ $slug ]['color'] ) ) {
						$color = $value['platforms'][ $slug ]['color'];
					}
					if ( ! isset( $value['platforms'][ $slug ]['enabled'] ) ) {
						$checked = '';
					}
				}

				?>

                <div class="social-sortable">
                    <div class="social-sortable-wrap">
                        <div class="social-share-row w100">
                            <strong><?php echo esc_html( $platforms[ $slug ]['name'] ); ?></strong>
                        </div>
                        <div class="social-share-row w100">
                            <input type="checkbox" <?php echo esc_attr( $checked ); ?>
                                   name="social_share[platforms][<?php echo esc_attr( $slug ); ?>][enabled]"
                                   value="1"> <?php esc_html_e( 'Enabled', 'sq-social-share' ); ?>
                        </div>
                        <div class="social-share-row w250">
                            <input class="social-color-picker" type="text"
                                   name="social_share[platforms][<?php echo esc_attr( $slug ); ?>][color]"
                                   value="<?php echo esc_attr( $color ); ?>">
                        </div>
                        <div class="social-share-row w20 sk-drag"><span class="dashicons dashicons-move"></span></div>
                    </div>
                </div>

			<?php
			endif;
		endforeach; ?>

    </div>

    <h4><?php esc_html_e( 'On what post types to show', 'sq-social-share' ); ?></h4>

    <select multiple name="social_share[post_type][]">
		<?php

		foreach ( get_post_types( [ 'public' => true ], 'names' ) as $post_type ) {

			$selected = in_array( $post_type, $post_types, true ) ? ' selected="selected"' : '';

			echo '<option' . esc_attr( $selected ) . ' value="' . esc_attr( $post_type ) . '">' . ucfirst( esc_html( $post_type ) ) . '</option>';
		}
		?>
    </select>
    <br>
    <small><?php esc_html_e( 'Press Ctrl+Click to select multiple post types', 'sq-social-share' ); ?></small>

    <h4><?php esc_html_e( 'Show share on select', 'sq-social-share' ); ?></h4>
    <label>
        <input type="checkbox" name="social_share[select_text]" <?php checked( $show_on_select, '1' ); ?>
               value="1"> <?php esc_html_e( 'Yes', 'sq-social-share' ); ?>
    </label>

	<?php wp_nonce_field( 'social_share_options_save_action', 'social_nonce' ); ?>

    <br>
    <br>
    <input type="submit" value="<?php esc_attr_e( 'Save', 'sq-social-share' ); ?>"
           class="button button-primary button-large">
</form>
<style>
    .social-sortable {
        clear: both;
    }

    .social-sortable-wrap {
        padding: 8px;
        background-color: #fafafa;
        margin-bottom: 4px;
        display: inline-block;
        -webkit-border-radius: 4px;
        -moz-border-radius: 4px;
        border-radius: 4px;
    }

    .social-share-row {
        width: 200px;
        float: left;
        display: inline-block;
        padding-top: 10px;
    }

    .w100 {
        width: 100px;
    }

    .w250 {
        width: 250px;
        text-align: right;
    }

    .w20 {
        width: 20px;
    }
</style>
