const SocialSelectShare = (function () {

    function SocialSelectShare() {
        const _networks = {
            twitter: true
        };

        const _twitterConfig = {
            username: '',
            url: 'https://twitter.com/intent/tweet?text=',
            icon: '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" class="ss-share-icon"><path d="M8.2,20.2c6.5,0,11.7-5.2,11.8-11.6c0-0.1,0-0.1,0-0.2c0-0.2,0-0.4,0-0.5c0.8-0.6,1.5-1.3,2.1-2.2c-0.8,0.3-1.6,0.6-2.4,0.7c0.9-0.5,1.5-1.3,1.8-2.3c-0.8,0.5-1.7,0.8-2.6,1c-1.6-1.7-4.2-1.7-5.9-0.1c-1.1,1-1.5,2.5-1.2,3.9C8.5,8.7,5.4,7.1,3.3,4.6c-1.1,1.9-0.6,4.3,1.3,5.5c-0.7,0-1.3-0.2-1.9-0.5l0,0c0,2,1.4,3.7,3.3,4.1c-0.6,0.2-1.2,0.2-1.9,0.1c0.5,1.7,2.1,2.8,3.9,2.9c-1.7,1.4-3.9,2-6.1,1.7C3.8,19.5,6,20.2,8.2,20.2"/></svg>'
        };

        let _selection = '';
        let _text = '';
        let _icons = {};
        let _arrowSize = 5;
        let _buttonMargin = 7 * 2;
        let _iconSize = 24 + _buttonMargin;
        let _selectableElements = ['body'];

        function createTwitterButton() {
            const txt = _twitterConfig.username
                ? ` ${_twitterConfig.username} ${window.location.href}`
                : ` ${window.location.href}`;

            const btn = new Button(_twitterConfig.icon, function () {
                window.open(_twitterConfig.url + encodeURIComponent(_text) + txt, 'Share', 'width=550, height=280');
                return false;
            });

            return btn;
        }

        function getIcons() {
            const icons = document.createElement('div');
            let length = 0;

            if (_networks.twitter) {
                icons.appendChild(createTwitterButton());
                length++;
            }

            _icons = {icons, length};
        }

        function getTooltipPosition() {
            const selection = _selection.getRangeAt(0).getBoundingClientRect();
            const DOCUMENT_SCROLL_TOP = window.pageXOffset
                || document.documentElement.scrollTop
                || document.body.scrollTop;
            const top = selection.top + DOCUMENT_SCROLL_TOP - _iconSize - _arrowSize;
            const left = selection.left + (selection.width - _iconSize * _icons.length) / 2;
            return {top, left}
        }

        function moveTooltip() {
            const {top, left} = getTooltipPosition();
            let tooltip = document.querySelector('.ss-share');
            tooltip.style.top = `${top}px`;
            tooltip.style.left = `${left}px`;
        }

        function createTooltip(top = 0, left = 0) {
            const tooltip = document.createElement('div');
            tooltip.className = 'ss-share';
            tooltip.style.cssText = 'top:' + top + 'px;'
                + 'left:' + left + 'px;';

            tooltip.appendChild(_icons.icons);

            const arrow = document.createElement('div');
            arrow.className = 'ss-share-arrow';

            tooltip.appendChild(arrow);

            return tooltip;
        }

        function drawTooltip() {
            const {top, left} = getTooltipPosition();
            const tooltip = createTooltip(top, left);
            document.body.appendChild(tooltip);
        }

        function hasSelection() {
            return !!window.getSelection().toString();
        }

        function hasTooltipDrawn() {
            return !!document.querySelector('.ss-share');
        }

        function updateTextSelection() {
            _selection = window.getSelection();
            _text = _selection.toString();
        }

        function getClosestElement(element, ancestor) {
            if (Element.prototype.closest) {
                return element.closest(ancestor);
            } else {
                // IE 9+ polyfill
                let el = element;
                do {
                    if (el.matches(ancestor)) return el;
                    el = el.parentNode;
                } while (el !== null && el.nodeType === Node.ELEMENT_NODE);
                return null
            }
        }

        function isSelectableElement() {
            let currentSelectedElement = window.getSelection().baseNode.parentNode;
            return _selectableElements.some(function (ancestor) {
                return getClosestElement(currentSelectedElement, ancestor);
            })
        }

        function attachEvents() {
            window.addEventListener('mouseup', function () {
                setTimeout(function mouseTimeout() {
                    if (hasTooltipDrawn()) {
                        if (hasSelection() && isSelectableElement()) {
                            updateTextSelection();
                            moveTooltip();
                            return;
                        } else {
                            document.querySelector('.ss-share').remove();
                        }
                    }
                    if (hasSelection() && isSelectableElement()) {
                        updateTextSelection();
                        drawTooltip();
                    }
                }, 10)
            }, false)
        }

        function config(options) {
            _networks.twitter = options.twitter === undefined
                ? _networks.twitter
                : options.twitter;
            _twitterConfig.username = options.twitterUsername === undefined
                ? _twitterConfig.username
                : options.twitterUsername;
            _selectableElements = options.selectableElements || _selectableElements;
            return this;
        }

        function init() {
            getIcons();
            attachEvents();
            return this;
        }

        return {
            config,
            init
        }
    }

    function Button(icon, clickFn) {
        const btn = document.createElement('div');
        btn.className = 'ss-share-btn';
        btn.innerHTML = icon;
        btn.onclick = clickFn;

        return btn;
    }

    return SocialSelectShare
}());

jQuery(document).ready(function ($) {
    let sss = new SocialSelectShare();
    sss.config({
        twitter: true,
        twitterUsername: '',
        selectableElements: ['.entry-content']
    }).init();
});
