<?php 
/* add_ons_php */

add_filter( 'dokan_new_product_popup_args', function($error, $data){
	$is_updating = false;
	if ( ! empty( $data['ID'] ) ) {
        $post_arr['ID'] = absint( $data['ID'] );
        if ( function_exists('dokan_is_product_author') && ! dokan_is_product_author( $post_arr['ID'] ) ) {
            return new WP_Error( 'not-own', __( 'I swear this is not your product!', 'townhub-add-ons' ) );
        }
        $is_updating = true;
    }
    if( false == $is_updating ){
    	$user_id = get_current_user_id();
    	$woo_limit = get_user_meta( $user_id, ESB_META_PREFIX.'woo_limit',  true );
    	if( $woo_limit === '' ) $woo_limit = 10;
    	$ltPosts = get_posts(array(
            'fields'                => 'ids',
            'post_type'             => 'product',
            'author'                => $user_id,
            'posts_per_page'        => -1,
            'post_status'           => array('publish', 'pending', 'private'), // publish, future, draft, pending, private, trash, auto-draft, inherit
            'suppress_filters'      => false,
        ));
        if( count( $ltPosts ) >= (int)$woo_limit ){
        	return new WP_Error( 'plan-limit', __( 'Your products submission limit has been reached. Please upgrade your subscription plan.', 'townhub-add-ons' ) );
        }
    }
    return $error;
}, 10, 2 );

$dokan_register_redirect = '';
// fix register - action run only if seller is created
add_action('dokan_new_seller_created', function($user_id, $dokan_settings){
    global $dokan_register_redirect;
    // only active default author plan when registered user logged + has free_lplan value
    $inserted_free_membership = false;
    $free_lplan = townhub_addons_get_option('free_lplan');
    if( !empty($free_lplan) ){
        Esb_Class_Form_Handler::insert_free_subscription( $free_lplan, $user_id, false );
        $inserted_free_membership = true;
    }
    // redirect to free membership active page
    if(  $inserted_free_membership ){
        if( townhub_addons_get_option('auto_active_free_sub') == 'yes' && townhub_addons_get_option('free_redirect_submit') == 'yes' ){
            $dokan_register_redirect = get_permalink( esb_addons_get_wpml_option('submit_page') );
        }else{
            $checkout_page_id = esb_addons_get_wpml_option('checkout_success_page');
            if( $checkout_page_id != 'none' ){
                $dokan_register_redirect = get_permalink($checkout_page_id); 
            }
        }
    }
}, 10, 2);

add_filter( 'woocommerce_registration_redirect', function($redirect){
    global $dokan_register_redirect;
    if( !empty($dokan_register_redirect) ){
        return $dokan_register_redirect;
    }
    return $redirect;
}, 10, 1 );