<?php 
/* add_ons_php */

// Page ID
if(!function_exists('townhub_page_columns_head')){
    function townhub_page_columns_head($defaults) {
        $defaults['page_id'] = 'ID';
        return $defaults;
    }
}
if(!function_exists('townhub_page_columns_content')){
    // CUSTOM POSTS
    function townhub_page_columns_content($column_name, $post_ID) { 
        if ($column_name == 'page_id') {
            echo $post_ID;
        }
    }
}

add_filter('manage_page_posts_columns', 'townhub_page_columns_head', 10);
add_action('manage_page_posts_custom_column', 'townhub_page_columns_content', 10, 2);  

// Post ID
if(!function_exists('townhub_post_columns_head')){
    function townhub_post_columns_head($defaults) {
        $defaults['post_id'] = 'ID';
        return $defaults;
    }
}
if(!function_exists('townhub_post_columns_content')){
    // CUSTOM POSTS
    function townhub_post_columns_content($column_name, $post_ID) {
        if ($column_name == 'post_id') {
            echo $post_ID;
        }
    }
}

add_filter('manage_post_posts_columns', 'townhub_post_columns_head', 10);
add_action('manage_post_posts_custom_column', 'townhub_post_columns_content', 10, 2);

require_once ESB_ABSPATH . 'posttypes/cpt-listing-type.php';


require_once ESB_ABSPATH .'posttypes/cpt-listing.php';
// require_once ESB_ABSPATH .'posttypes/townhub-listing.php';
//require_once ESB_ABSPATH .'posttypes/townhub-booking.php';
require_once ESB_ABSPATH . 'posttypes/cpt-room.php';
require_once ESB_ABSPATH . 'posttypes/cpt-product.php';

// for listing pricing lplan
require_once ESB_ABSPATH .'posttypes/cpt-plan.php';
// for listing membership - users screen columns
require_once ESB_ABSPATH .'posttypes/cpt-membership.php';
// for listing lorder type
require_once ESB_ABSPATH .'posttypes/cpt-order.php';
// for listing cthinvoice type
require_once ESB_ABSPATH .'posttypes/cpt-invoice.php';
// for listing lbooking type
require_once ESB_ABSPATH .'posttypes/cpt-booking.php';
// for listing lmessage type
require_once ESB_ABSPATH .'posttypes/cpt-message.php';
// for listing claim
require_once ESB_ABSPATH .'posttypes/cpt-claim.php';
require_once ESB_ABSPATH .'posttypes/cpt-lreport.php';
// for listing ads
require_once ESB_ABSPATH .'posttypes/ads.php';
require_once ESB_ABSPATH .'posttypes/cpt-withdrawal.php';

// require_once ESB_ABSPATH . 'posttypes/payments.php';
require_once ESB_ABSPATH . 'posttypes/cpt-ad.php';
require_once ESB_ABSPATH . 'posttypes/cpt-coupon-code.php';


require_once ESB_ABSPATH . 'posttypes/search.php';
require_once ESB_ABSPATH . 'posttypes/emails.php';


require_once ESB_ABSPATH .'posttypes/cpt-member.php';
// require_once ESB_ABSPATH .'posttypes/cpt-faq.php';
require_once ESB_ABSPATH . 'posttypes/cpt-testimonial.php';



abstract class Esb_Class_CPT {
    protected $name = '';
    protected $meta_boxes = array();
    protected $has_builtin_metas = false;
    protected $tabs = array();
    protected $fields = array();
    protected $has_columns = false;

    protected $meta_df_options = array();

    public function __construct( ) {
        $this->set_meta_option_default();
        $this->set_meta_boxes();
        $this->set_meta_columns();
        $this->init();
    }
    protected function init(){
        add_action( 'init', array($this, 'register') );

        if(!empty($this->meta_boxes)){
            add_action( 'add_meta_boxes_'.$this->name, array($this, 'add_meta_boxes') );
            // add_action( 'save_post_'.$this->name, array($this, 'save_post'), 10, 3 );
        }
        if($this->has_builtin_metas){
            $this->set_builtin_metas();
        }
        if(!empty($this->meta_boxes) || $this->has_builtin_metas ){
            add_action( 'save_post_'.$this->name, array($this, 'save_post'), 10, 3 );
        }
        if($this->has_columns){
            add_action( 'manage_'.$this->name.'_posts_columns', array($this, 'meta_columns_head') );
            add_action( 'manage_'.$this->name.'_posts_custom_column', array($this, 'meta_columns_content'), 10, 2 );
        }
        if( $this->has_builtin_metas ){
            add_action( 'current_screen', array($this, 'current_screen') );
            add_action('rest_api_init', array($this, 'rest_api'));

            add_action( 'add_meta_boxes_'.$this->name, array($this, 'add_builtin_meta_boxes') );
        }
    }
    public function rest_api(){
        register_rest_route( 'cth/v1', '/'.$this->name.'/metabox/(?P<pid>[\d]+)', array(
            'methods' => WP_REST_Server::READABLE,
            'callback' => array($this, 'get_metas'),
            'permission_callback' => function () {
                return current_user_can( 'edit_posts' );
            }
        ) );
    }

    protected function set_meta_option_default(){
        $this->meta_df_options = array(
            'title'                 => __( 'Default title', 'townhub-add-ons' ),
            'context'               => 'normal', // normal - side - advanced
            'priority'              => 'default', // default - high - low
            'callback_args'         => array()
        );
    }

    protected function set_meta_boxes(){}

    protected function can_save($post_id){
        /*
         * We need to verify this came from our screen and with proper authorization,
         * because the save_post action can be triggered at other times.
         */
        // If this is just a revision, don't send the email.
        if ( wp_is_post_revision( $post_id ) )
            return false;

        // Check if our nonce is set.
        if ( ! isset( $_POST['_cth_cpt_nonce'] ) ) {
            return false;
        }
        // Verify that the nonce is valid.
        if ( ! wp_verify_nonce( $_POST['_cth_cpt_nonce'], 'cth-cpt-fields' ) ) {
            return false;
        }
        // If this is an autosave, our form has not been submitted, so we don't want to do anything.
        if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
            return false;
        }
        // Check the user's permissions.
        if ( ! current_user_can( 'edit_post', $post_id ) ) {
            return false;
        }

        return true;
    }

    protected function filter_meta_args($args, $post){
        return $args;
    }

    public function add_meta_boxes($post){
        $count = 0; // for print nonce on first
        foreach ($this->meta_boxes as $key => $options) {
            $options = array_merge($this->meta_df_options, $options);
            $options['callback_args'] = array_merge($options['callback_args'], array('index_count'  => $count));
            $options['callback_args'] = $this->filter_meta_args($options['callback_args'], $post);
            $callback = isset( $options['callback_func'] ) ? $options['callback_func'] : array($this, $this->name.'_'.$key.'_callback');
            add_meta_box(
                $this->name.'_'.$key,
                $options['title'],
                $callback,
                $this->name,
                $options['context'],
                $options['priority'],
                $options['callback_args']
            );
            $count++;
        }
    }

    public function add_builtin_meta_boxes($post){
        $ptName = ucfirst($this->name);
        $postType = get_post_type_object($this->name);
        if ($postType) {
            $ptName = $postType->labels->singular_name;
        }
        add_meta_box(
            $this->name.'_bin_metas',
            sprintf( _x('%s Details', 'Metabox title', 'townhub-add-ons'), $ptName ),
            array($this, 'builtin_meta_callback'),
            $this->name,
            'normal', // normal - side - advanced
            'high', // default - high - low
            array()
        );
    }

    public function builtin_meta_callback($post, $args){
        wp_nonce_field('cth-cpt-fields', '_cth_cpt_nonce', false);
        ?>
        <div class="cthopts-tabs" ptype="<?php echo esc_attr($this->name); ?>" pid="<?php echo esc_attr($post->ID); ?>"></div>
        <?php
    }

    public function save_post($post_id, $post, $update){}
    protected function set_meta_columns(){}
    public function meta_columns_head($columns){}
    public function meta_columns_content($column_name, $post_ID){}

    protected function set_builtin_metas(){}
    // new theme options
    public function current_screen(){
        if ( function_exists('get_current_screen')) {  
            // $pt = get_current_screen()->post_type;
            $currenscreen = get_current_screen();
            if( $currenscreen->id == $this->name && $currenscreen->base == 'post' && $currenscreen->post_type == $this->name ){
                add_action( 'admin_enqueue_scripts', array($this, 'builtin_metas_scripts') );
            }
        }
    }
    public function builtin_metas_scripts(){
        wp_enqueue_style('fontawesome-pro', ESB_DIR_URL . '/assets/vendors/fontawesome-pro-5.10.0-web/css/all.min.css', false);
        wp_enqueue_style('cthtabs', ESB_DIR_URL . '/inc/cthoptions/css/metabox.css', false);

        wp_enqueue_script('react', ESB_DIR_URL . '/inc/cthoptions/vendors/react.production.min.js', array(), null, true);
        wp_enqueue_script('react-dom', ESB_DIR_URL . '/inc/cthoptions/vendors/react-dom.production.min.js', array(), null, true);
        // media library
        wp_enqueue_media();

        wp_enqueue_script('cthoptions-37', ESB_DIR_URL . '/inc/cthoptions/js/53.bundle.js', array('underscore'), null, true);
        wp_enqueue_script('cthoptions-707', ESB_DIR_URL . '/inc/cthoptions/js/875.bundle.js', array(), null, true);
        wp_enqueue_script('cthoptions-tab', ESB_DIR_URL . '/inc/cthoptions/js/tab.bundle.js', array('react', 'react-dom', 'cthoptions-37', 'cthoptions-707'), null, true);

        // wp_localize_script('cthoptions-form', '_cth_rest_url', get_rest_url());
        // wp_localize_script('cthoptions-form', '_cth_tabs', $tabs);
        wp_localize_script('cthoptions-tab', '_cth_options', [
            'rest_url'      => esc_url_raw( rest_url() ), // get_rest_url(),
            'nonce'         => wp_create_nonce( 'wp_rest' ),
            'tabs'          => $this->tabs,
            'options'       => $this->fields,
            'i18n'          => array(
                'submit'        => _x( 'Save Changes', 'Theme Option', 'townhub-add-ons' ),
                'submitting'    => _x( 'Submitting', 'Theme Option', 'townhub-add-ons' ),
                'reset'         => _x( 'Reset Section', 'Theme Option', 'townhub-add-ons' ),
                'rpfadd'        => _x( 'Add', 'Theme Option - Repeater', 'townhub-add-ons' ),
                'rpfdelete'     => _x( 'Delete', 'Theme Option - Repeater', 'townhub-add-ons' ),

                'icf_select_icon'       => _x( 'Select an icon', 'Theme Option - Icon', 'townhub-add-ons' ),
                'icf_select'            => _x( 'Select', 'Theme Option - Icon', 'townhub-add-ons' ),
                'icf_all'               => _x( 'All', 'Theme Option - Icon', 'townhub-add-ons' ),
                'icf_solid'             => _x( 'Solid', 'Theme Option - Icon', 'townhub-add-ons' ),
                'icf_regular'           => _x( 'Regular', 'Theme Option - Icon', 'townhub-add-ons' ),
                'icf_light'             => _x( 'Light', 'Theme Option - Icon', 'townhub-add-ons' ),
                'icf_brands'            => _x( 'Brands', 'Theme Option - Icon', 'townhub-add-ons' ),
                'icf_duotone'           => _x( 'Duotone', 'Theme Option - Icon', 'townhub-add-ons' ),
                'icf_type_search'       => _x( 'Type to search', 'Theme Option - Icon', 'townhub-add-ons' ),

                'ff_family'             => _x( 'Font Family', 'Theme Option - GFont', 'townhub-add-ons' ),
                'ff_variant'            => _x( 'Font Weight & Style', 'Theme Option - GFont', 'townhub-add-ons' ),
                'ff_subset'             => _x( 'Font Subsets', 'Theme Option - GFont', 'townhub-add-ons' ),
                'ff_size'               => _x( 'Font Size', 'Theme Option - GFont', 'townhub-add-ons' ),
                'ff_lineHeight'         => _x( 'Line Height', 'Theme Option - GFont', 'townhub-add-ons' ),
                'ff_color'              => _x( 'Color', 'Theme Option - GFont', 'townhub-add-ons' ),
                'ff_selectors'          => _x( 'CSS Selectors', 'Theme Option - GFont', 'townhub-add-ons' ),

                'tn_width'              => _x( 'Width (px)', 'Theme Option - Thumbnail', 'townhub-add-ons' ),
                'tn_height'             => _x( 'Height (px)', 'Theme Option - Thumbnail', 'townhub-add-ons' ),
                'tn_crop'               => _x( 'Hard crop?', 'Theme Option - Thumbnail', 'townhub-add-ons' ),

                'sc_url'                => _x( 'URL', 'Theme Option - Socials', 'townhub-add-ons' ),

                'icl_label'             => _x( 'Label', 'Theme Option - Icon List', 'townhub-add-ons' ),
                'icl_url'               => _x( 'URL', 'Theme Option - Icon List', 'townhub-add-ons' ),
            ),
        ]);
        wp_localize_script('cthoptions-tab', '_gFonts', $this->google_fonts());
    }
    protected function google_fonts(){
        global $wp_filesystem;
        require_once ( ABSPATH . '/wp-admin/includes/file.php' );
        WP_Filesystem();
        $local_file = ESB_ABSPATH. '/inc/cthoptions/vendors/google-fonts-by-popularity.json';
        if ( $wp_filesystem->exists( $local_file ) ) {
            $jsonObj = json_decode( $wp_filesystem->get_contents( $local_file ), true );
            if( $jsonObj ){
                return $jsonObj['items'];
            }
        } 
        return [];
    }
    public function get_metas(WP_REST_Request $request){
        $pid = $request->get_param('pid');
        $return = [ 'debug' => false, 'pid' => $pid ];
        if( $pid && get_post( $pid ) ){
            if( !empty($this->fields) ){
                foreach ($this->fields as $fname => $fopts) {
                    $mtval = get_post_meta( $pid, ESB_META_PREFIX . $fname, true );
                    $return[$fname.'_raw'] = $mtval;
                    switch ($fopts['type']) {
                        case 'Switch':
                            if( isset($fopts['returnValue']) && $mtval ==  $fopts['returnValue'] ){
                                $mtval = true;
                            }else{
                                $mtval = false;
                            }
                            break;
                        case 'WPMedia':
                            if( isset($fopts['single']) && $fopts['single'] && ( ( isset($fopts['idOnly']) && $fopts['idOnly'] ) || ( isset($fopts['urlOnly']) && $fopts['urlOnly'] ) ) ){
                                $return[$fname.'_dep'] = get_post_meta( $pid, ESB_META_PREFIX . $fname.'_dep', true );
                            }
                            break;
                    }
                    $return[$fname] = $mtval;
                }
            }
        }
        return new WP_REST_Response( $return, 200 );
    }
    protected function save_builtin_metas($post_id){
        if( !empty($this->fields) ){
            foreach ($this->fields as $fname => $fopts) {
                if( $fopts['type'] == 'WPMedia' ){
                    if( isset($_POST[$fname.'_dep']) && isset($fopts['single']) && $fopts['single'] && ( ( isset($fopts['idOnly']) && $fopts['idOnly'] ) || ( isset($fopts['urlOnly']) && $fopts['urlOnly'] ) ) ){
                        update_post_meta( $post_id, ESB_META_PREFIX . $fname.'_dep', $_POST[$fname.'_dep'] );
                    }
                }
                if( $fopts['type'] == 'Switch' && !isset($_POST[$fname])  ){
                    update_post_meta( $post_id, ESB_META_PREFIX . $fname, false );
                }
                if( isset($_POST[$fname]) ){
                    update_post_meta( $post_id, ESB_META_PREFIX . $fname, $_POST[$fname] );
                }
            }
        }
    }
}