<?php
/* add_ons_php */

if (!function_exists('townhub_select_media_file_field')) {
    function townhub_select_media_file_field($f_id = 'cat_header_image', $f_title = 'Header Background Image', $term_values = array(), $new_screen = true)
    {
        if ($new_screen) {
            echo '<div class="form-field media-field-wrap">';
            echo '<label for="term_meta[' . $f_id . ']">' . $f_title . '</label>';
        } else {
            echo '<tr class="form-field media-field-wrap">';
            echo '<th scope="row" valign="top"><label for="term_meta[' . $f_id . ']">' . $f_title . '</label></th>';
            echo '<td>';
        }

        echo '<img class="term_meta_' . $f_id . '__preview" src="' . (isset($term_values[$f_id]['url']) ? esc_attr($term_values[$f_id]['url']) : '') . '" alt="" ' . (isset($term_values[$f_id]['url']) ? ' style="display:block;width:200px;height=auto;"' : ' style="display:none;width:200px;height=auto;"') . '>';
        echo '<input type="hidden" name="term_meta[' . $f_id . '][url]" class="term_meta_' . $f_id . '__url" value="' . (isset($term_values[$f_id]['url']) ? esc_attr($term_values[$f_id]['url']) : '') . '">';
        echo '<input type="hidden" name="term_meta[' . $f_id . '][id]" class="term_meta_' . $f_id . '__id" value="' . (isset($term_values[$f_id]['id']) ? esc_attr($term_values[$f_id]['id']) : '') . '">';

        echo '<p class="description">
            <a href="#" data-uploader_title="' . $f_title . '" class="button button-primary upload_image_button metakey-term_meta fieldkey-' . $f_id . '">' . esc_html__('Upload Image', 'townhub-add-ons') . '</a>  
            <a href="#" class="button button-secondary remove_image_button metakey-term_meta fieldkey-' . $f_id . '">' . esc_html__('Remove', 'townhub-add-ons') . '</a>
            </p>';
        if ($new_screen) {
            echo '</div>';

        } else {
            echo '</td>';
            echo '</tr>';
        }

    }
}

if (!function_exists('townhub_radio_options_field')) {
    /**
     * field_options : array('id','name','desc','values','default')
     *
     */
    function townhub_radio_options_field($field_options, $term_values = array(), $new_screen = true)
    {
        if (isset($term_values[$field_options['id']]) && $term_values[$field_options['id']] != '') {
            $checked = $term_values[$field_options['id']];
        } elseif (isset($field_options['default'])) {
            $checked = $field_options['default'];
        } else {
            $checked = ' No provide default value';
        }
        if ($new_screen) {
            echo '<div class="form-field">';
            echo '<label for="term_meta[' . $field_options['id'] . ']">' . $field_options['name'] . '</label>';
        } else {
            echo '<tr class="form-field">';
            echo '<th scope="row" valign="top"><label for="term_meta[' . $field_options['id'] . ']">' . $field_options['name'] . '</label></th>';
            echo '<td>';
        }

        if (!empty($field_options['values'])) {
            foreach ($field_options['values'] as $val => $opt) {
                echo '<input type="radio" name="term_meta[' . $field_options['id'] . ']" id="term_meta[' . $field_options['id'] . ']" value="' . $val . '" ' . checked($checked, $val, false) . '>' . $opt . '&nbsp;&nbsp;';
            }
        }
        if (isset($field_options['desc'])) {
            echo '<p class="description">' . $field_options['desc'] . '</p>';
        }
        if ($new_screen) {
            echo '</div>';

        } else {
            echo '</td>';
            echo '</tr>';
        }

    }
}

function townhub_addons_select_options_field($field_options, $term_values = array(), $new_screen = true)
{
    if (isset($term_values[$field_options['id']]) && $term_values[$field_options['id']] != '') {
        $selected = $term_values[$field_options['id']];
    } elseif (isset($field_options['default'])) {
        $selected = $field_options['default'];
    } else {
        $selected = '';
    }
    if ($new_screen) {
        echo '<div class="form-field">';
        echo '<label for="term_meta[' . $field_options['id'] . ']">' . $field_options['name'] . '</label>';
    } else {
        echo '<tr class="form-field">';
        echo '<th scope="row" valign="top"><label for="term_meta[' . $field_options['id'] . ']">' . $field_options['name'] . '</label></th>';
        echo '<td>';
    }
    echo '<select name="term_meta[' . $field_options['id'] . ']" id="term_meta[' . $field_options['id'] . ']">';
    if (!empty($field_options['values'])) {
        foreach ($field_options['values'] as $val => $opt) {
            echo '<option value="' . $val . '" ' . selected($selected, $val, false) . '>' . $opt . '</option>';
            // echo '<input type="radio" name="term_meta['.$field_options['id'].']" id="term_meta['.$field_options['id'].']" value="'.$val.'" '.checked( $checked, $val,false).'>'.$opt.'&nbsp;&nbsp;';
        }
    }
    echo '</select>';
    if (isset($field_options['desc'])) {
        echo '<p class="description">' . $field_options['desc'] . '</p>';
    }
    if ($new_screen) {
        echo '</div>';

    } else {
        echo '</td>';
        echo '</tr>';
    }

}

function townhub_addons_select2_options_field($field_options, $term_values = array(), $new_screen = true)
{
    if (isset($term_values[$field_options['id']]) && $term_values[$field_options['id']] != '') {
        $selected = $term_values[$field_options['id']];
    } elseif (isset($field_options['default'])) {
        $selected = $field_options['default'];
    } else {
        $selected = '';
    }
    if ($new_screen) {
        echo '<div class="form-field">';
        echo '<label for="term_meta[' . $field_options['id'] . '][]">' . $field_options['name'] . '</label>';
    } else {
        echo '<tr class="form-field">';
        echo '<th scope="row" valign="top"><label for="term_meta[' . $field_options['id'] . '][]">' . $field_options['name'] . '</label></th>';
        echo '<td>';
    }

    echo '<input type="hidden" name="term_meta[' . $field_options['id'] . ']" value="">'; // for delete all option

    echo '<select name="term_meta[' . $field_options['id'] . '][]" id="term_meta[' . $field_options['id'] . '][]" class="js-example-basic-multiple" multiple="multiple">';
    if (!empty($field_options['values'])) {
        foreach ($field_options['values'] as $val => $opt) {

            if (in_array($val, (array) $selected)) {
                echo '<option value="' . $val . '" selected>' . $opt . '</option>';
            } else {
                echo '<option value="' . $val . '">' . $opt . '</option>';
            }

        }
    }
    echo '</select>';
    if (isset($field_options['desc'])) {
        echo '<p class="description">' . $field_options['desc'] . '</p>';
    }
    if ($new_screen) {
        echo '</div>';

    } else {
        echo '</td>';
        echo '</tr>';
    }

}

function townhub_addons_text_options_field($field_options, $term_values = array(), $new_screen = true)
{
    if (isset($term_values[$field_options['id']]) && $term_values[$field_options['id']] != '') {
        $value = $term_values[$field_options['id']];
    } elseif (isset($field_options['default'])) {
        $value = $field_options['default'];
    } else {
        $value = '';
    }
    if ($new_screen) {
        echo '<div class="form-field">';
        echo '<label for="term_meta[' . $field_options['id'] . ']">' . $field_options['name'] . '</label>';
    } else {
        echo '<tr class="form-field">';
        echo '<th scope="row" valign="top"><label for="term_meta[' . $field_options['id'] . ']">' . $field_options['name'] . '</label></th>';
        echo '<td>';
    }
    echo '<input type="text" name="term_meta[' . $field_options['id'] . ']" id="term_meta[' . $field_options['id'] . ']" value="' . $value . '">';

    if (isset($field_options['desc'])) {
        echo '<p class="description">' . $field_options['desc'] . '</p>';
    }
    if ($new_screen) {
        echo '</div>';

    } else {
        echo '</td>';
        echo '</tr>';
    }

}

if (!function_exists('townhub_repeat_fields_options_field')) {
    function townhub_repeat_fields_options_field($field_options, $term_values = array(), $new_screen = true)
    {
        // cth_create_opening_tag_new($value);
        // global $gather_stripe_options, $global_opt_name ;

        //$repeat_vs = get_option($value['id']);

        // echo '<pre>';
        // var_dump( $term_values[$field_options['id']] );

        if ($new_screen) {
            echo '<div class="form-field">';
            echo '<label for="term_meta[' . $field_options['id'] . ']">' . $field_options['name'] . '</label>';
        } else {
            echo '<tr class="form-field">';
            echo '<th scope="row" valign="top"><label for="term_meta[' . $field_options['id'] . ']">' . $field_options['name'] . '</label></th>';
            echo '<td>';
        }

        // if(!empty($field_options['values'])){
        //     foreach ($field_options['values'] as $val => $opt) {
        //         echo '<input type="radio" name="term_meta['.$field_options['id'].']" id="term_meta['.$field_options['id'].']" value="'.$val.'" '.checked( $checked, $val,false).'>'.$opt.'&nbsp;&nbsp;';
        //     }
        // }
        // if(isset($field_options['desc'])){
        //     echo '<p class="description">'.$field_options['desc'].'</p>';
        // }

        // if(isset($term_values[$field_options['id']]) && $term_values[$field_options['id']] != ''){

        echo '<table class="repeatfield_table">
		    		<thead><tr>
		    			<th>Field Type</th>
		    			<th>Field Name</th>
		    			<th>Field Label</th>
		    			<th class="field_values_col">Field Values</th>

		    		</tr></thead>';
        echo '<input type="hidden" name="term_meta[' . $field_options['id'] . ']" value="">'; // for delete all option
        echo '<tbody><tr data-key="0" class="hide"></tr>';

        if (isset($term_values[$field_options['id']]) && !empty($term_values[$field_options['id']])) {
            $key = 1;
            foreach ($term_values[$field_options['id']] as $val) {
                // if($repeat_vs && !empty($repeat_vs)){
                //     foreach ($repeat_vs as $key => $val) {
                echo '<tr data-key="' . $key . '">';
                if (isset($val['type'])) {
                    echo '<td><select name="term_meta[' . $field_options['id'] . ']' . '[' . $key . '][type]" class="select_field_type" data-name="term_meta[' . $field_options['id'] . ']' . '[' . $key . ']" data-type="' . $val['type'] . '"';

                    echo '>';

                    echo '<option value="text"' . (($val['type'] == 'text') ? ' selected="selected"' : '') . '>Text Field</option>
										<option value="select"' . (($val['type'] == 'select') ? ' selected="selected"' : '') . '>Select Field</option>
										<option value="checkbox"' . (($val['type'] == 'checkbox') ? ' selected="selected"' : '') . '>Checkbox Field</option>
										<option value="radio"' . (($val['type'] == 'radio') ? ' selected="selected"' : '') . '>Radio Field</option>
										<option value="switch"' . (($val['type'] == 'switch') ? ' selected="selected"' : '') . '>Switch Field</option>
										<option value="textarea"' . (($val['type'] == 'textarea') ? ' selected="selected"' : '') . '>Textarea Field</option>';
                    echo '</select></td>';
                }
                if (isset($val['name'])) {
                    echo '<td><input type="text" name="term_meta[' . $field_options['id'] . ']' . '[' . $key . '][name]" value="' . $val['name'] . '" placeholder="Field Name"></td>';
                }
                if (isset($val['label'])) {
                    echo '<td><input type="text" name="term_meta[' . $field_options['id'] . ']' . '[' . $key . '][label]" value="' . $val['label'] . '" placeholder="Field Label"></td>';
                }
                // if(isset($val['value'])){echo'<pre>val value';var_dump($val['value']);
                if (isset($val['type']) && ($val['type'] == 'select' || $val['type'] == 'radio')) {
                    echo '<td  class="field_values_col field_select_ops">';
                    echo '<table><tr data-key="0" class="hide"></tr>';

                    if (!empty($val['value'])) {
                        foreach ((array) $val['value'] as $op_in => $sl_ops) {
                            echo '<tr data-key="' . $op_in . '">';
                            if (isset($sl_ops['name'])) {
                                echo '<td><input type="text" name="term_meta[' . $field_options['id'] . ']' . '[' . $key . '][value][' . $op_in . '][name]" value="' . $sl_ops['name'] . '" placeholder="Option Name"></td>';
                            }
                            if (isset($sl_ops['value'])) {
                                echo '<td><input type="text" name="term_meta[' . $field_options['id'] . ']' . '[' . $key . '][value][' . $op_in . '][value]" value="' . $sl_ops['value'] . '" placeholder="Option Value"></td>';
                            }
                            echo '<td><a href="#" class="repeatable_fields_select_remove_option"><span class="dashicons dashicons-minus"></span></a></td></tr>';
                        }

                    }

                    echo '<tr><td><a href="#" class="repeatable_fields_select_add_option" data-name="term_meta[' . $field_options['id'] . ']' . '[' . $key . '][value]"><span class="dashicons dashicons-plus"></span></a><td><td></td></tr>';
                    echo '</table>';

                    echo '</td>';
                } else {
                    echo '<td  class="field_values_col"><input type="text" name="term_meta[' . $field_options['id'] . ']' . '[' . $key . '][value]" value="' . $val['value'] . '"  placeholder="Field Value"></td>';
                }

                // }
                if (isset($field_options['required']) && $field_options['required']) {
                    $checked = '';
                    if (isset($val['required']) && $val['required'] === 'true') {
                        $checked = ' checked="checked" ';
                    }
                    echo '<td><input type="checkbox" name="term_meta[' . $field_options['id'] . ']' . '[' . $key . '][required]" value="true" ' . $checked . '/>Required Field?</td>';
                }
                echo '<td><a href="#" class="repeatable_fields_remove_field"><span class="dashicons dashicons-trash"></span></a></td></tr>';

                // <span class="dashicons dashicons-trash"></span>

                $key++;
            }
        }

        echo '</tbody>';

        echo '<tfoot><tr><td><a href="#" class="repeatable_fields_add_field" data-name="term_meta[' . $field_options['id'] . ']' . '">Add Field</a><td><td></td></tr></tfoot>';

        echo '</table>';

        if ($new_screen) {
            echo '</div>';

        } else {
            echo '</td>';
            echo '</tr>';
        }

        // cth_create_closing_tag_new($value);
    }
}

function townhub_features_select_new_field($field_options, $term_values = array(), $new_screen = true)
{
    // if(isset($term_values[$field_options['id']]) && $term_values[$field_options['id']] != ''){
    //     $checked = $term_values[$field_options['id']];
    // }elseif( isset($field_options['default']) ){
    //     $checked = $field_options['default'];
    // }else{
    //     $checked = ' No provide default value';
    // }

    $features = get_terms(array(
        // 'orderby'    => 'count',
        'taxonomy'   => 'listing_feature',
        'hide_empty' => false,
    ));

    // var_dump($term_values);

    $selected = isset($term_values[$field_options['id']]) ? $term_values[$field_options['id']] : array();

    if ($new_screen) {
        echo '<div class="form-field">';
        echo '<label for="term_meta[' . $field_options['id'] . '][]">' . $field_options['name'] . '</label>';
    } else {
        echo '<tr class="form-field">';
        echo '<th scope="row" valign="top"><label for="term_meta[' . $field_options['id'] . '][]">' . $field_options['name'] . '</label></th>';
        echo '<td>';
    }
    echo '<input type="hidden" name="term_meta[' . $field_options['id'] . ']" value="">'; // for delete all option

    if (!empty($features) && !is_wp_error($features)) {

        $feature_group = array();
        foreach ($features as $key => $term) {
            if (townhub_addons_get_option('feature_parent_group') == 'yes') {
                if ($term->parent) {
                    if (!isset($feature_group[$term->parent]) || !is_array($feature_group[$term->parent])) {
                        $feature_group[$term->parent] = array();
                    }

                    $feature_group[$term->parent][$term->term_id] = $term->name;
                } else {
                    if (!isset($feature_group[$term->term_id])) {
                        $feature_group[$term->term_id] = $term->name;
                    }

                }
            } else {
                if (!isset($feature_group[$term->term_id])) {
                    $feature_group[$term->term_id] = $term->name;
                }

            }

        }

        echo '<div class="lcat-features-wrap">';
        foreach ($feature_group as $tid => $tvalue) {
            if (is_array($tvalue) && count($tvalue)) {
                $term = get_term_by('id', $tid, 'listing_feature');
                // var_dump($term);
                if ($term) {

                    $fea_checked = '';
                    if (in_array($tid, (array) $selected)) {
                        $fea_checked = ' checked="checked"';
                    }

                    echo '<div class="lcat-feature-item lcat-feature-item-has-children">

											<label class="lcat-fea-lbl" for="' . $field_options['id'] . '_' . $tid . '">
			        							<input type="checkbox" id="' . $field_options['id'] . '_' . $tid . '" name="term_meta[' . $field_options['id'] . '][' . $tid . ']" value="' . $tid . '"' . $fea_checked . '>' . $term->name . '
			        						</label>

			        					</div>';

                    echo '<div class="lcat-feature-children">';

                    foreach ($tvalue as $id => $name) {
                        $fea_checked = '';
                        if (in_array($id, (array) $selected)) {
                            $fea_checked = ' checked="checked"';
                        }

                        echo '<div class="lcat-feature-item">

												<label class="lcat-fea-lbl" for="' . $field_options['id'] . '_' . $id . '">
				        							<input type="checkbox" id="' . $field_options['id'] . '_' . $id . '" name="term_meta[' . $field_options['id'] . '][' . $id . ']" value="' . $id . '"' . $fea_checked . '>' . $name . '
				        						</label>

				        					</div>';
                    }

                    echo '</div>';
                }

            } else {
                $fea_checked = '';
                if (in_array($tid, (array) $selected)) {
                    $fea_checked = ' checked="checked"';
                }

                echo '<div class="lcat-feature-item">

										<label class="lcat-fea-lbl" for="' . $field_options['id'] . '_' . $tid . '">
		        							<input type="checkbox" id="' . $field_options['id'] . '_' . $tid . '" name="term_meta[' . $field_options['id'] . '][' . $tid . ']" value="' . $tid . '"' . $fea_checked . '>' . $tvalue . '
		        						</label>

		        					</div>';

            }

        }

        //     foreach ($features as $fea) {
        //         $fea_checked = '';
        //         if (in_array($fea->term_id, (array)$selected)) $fea_checked = ' checked="checked"';
        //         echo     '<div class="lcat-feature-item">

        // <label class="lcat-fea-lbl" for="'.$field_options['id'].'_'.$fea->term_id.'">
        //                             <input type="checkbox" id="'.$field_options['id'].'_'.$fea->term_id.'" name="term_meta['.$field_options['id'].']['.$fea->term_id.']" value="'.$fea->term_id.'"'.$fea_checked.'>' . $fea->name . '
        //                         </label>

        //                     </div>';

        //     }
        echo '</div>'; //end content-widgets-wrap

    } else {

    }

    if (isset($field_options['desc'])) {
        echo '<p class="description">' . $field_options['desc'] . '</p>';
    }
    if ($new_screen) {
        echo '</div>';

    } else {
        echo '</td>';
        echo '</tr>';
    }

}

if (!function_exists('townhub_features_select_field')) {
    /**
     * field_options : array('id','name','desc','values','default')
     *
     */
    function townhub_features_select_field($field_options, $term_values = array(), $new_screen = true)
    {
        // if(isset($term_values[$field_options['id']]) && $term_values[$field_options['id']] != ''){
        //     $checked = $term_values[$field_options['id']];
        // }elseif( isset($field_options['default']) ){
        //     $checked = $field_options['default'];
        // }else{
        //     $checked = ' No provide default value';
        // }

        $features = get_terms(array(
            'orderby'    => 'count',
            'taxonomy'   => 'listing_feature',
            'hide_empty' => false,
        ));

        // var_dump($term_values);

        $selected = isset($term_values[$field_options['id']]) ? $term_values[$field_options['id']] : array();

        if ($new_screen) {
            echo '<div class="form-field">';
            echo '<label for="term_meta[' . $field_options['id'] . '][]">' . $field_options['name'] . '</label>';
        } else {
            echo '<tr class="form-field">';
            echo '<th scope="row" valign="top"><label for="term_meta[' . $field_options['id'] . '][]">' . $field_options['name'] . '</label></th>';
            echo '<td>';
        }
        echo '<input type="hidden" name="term_meta[' . $field_options['id'] . ']" value="">'; // for delete all option

        if (!empty($features) && !is_wp_error($features)) {

            echo '<select class="js-example-basic-multiple" name="term_meta[' . $field_options['id'] . '][]" id="term_meta[' . $field_options['id'] . '][]" multiple="multiple">';

            foreach ($features as $fea) {
                if (in_array($fea->term_id, (array) $selected)) {
                    echo '<option value="' . $fea->term_id . '" selected>' . $fea->name . '</option>';
                } else {
                    echo '<option value="' . $fea->term_id . '">' . $fea->name . '</option>';
                }

            }

            echo '</select>';

        } else {

        }

        if (isset($field_options['desc'])) {
            echo '<p class="description">' . $field_options['desc'] . '</p>';
        }
        if ($new_screen) {
            echo '</div>';

        } else {
            echo '</td>';
            echo '</tr>';
        }

    }
}

if (!function_exists('townhub_addons_content_widgets_order_options_field')) {
    /**
     * field_options : array('id','name','desc','values','default')
     *
     */
    function townhub_addons_content_widgets_order_options_field($field_options, $term_values = array(), $new_screen = true)
    {
        // if(isset($term_values[$field_options['id']]) && $term_values[$field_options['id']] != ''){
        //     $checked = $term_values[$field_options['id']];
        // }elseif( isset($field_options['default']) ){
        //     $checked = $field_options['default'];
        // }else{
        //     $checked = ' No provide default value';
        // }
        $content_widgets_value = isset($term_values[$field_options['id']]) ? $term_values[$field_options['id']] : array();
        $content_widgets_hide  = isset($term_values[$field_options['id_hide']]) ? $term_values[$field_options['id_hide']] : array();
        // var_dump($content_widgets_value);
        if (isset($field_options['default']) && is_array($field_options['default'])) {
            $content_widgets_value = array_unique(array_merge($content_widgets_value, $field_options['default']));
        }

        // var_dump($content_widgets_value);

        $sidebar_widgets_value = isset($term_values[$field_options['id_2']]) ? $term_values[$field_options['id_2']] : array();
        $sidebar_widgets_hide  = isset($term_values[$field_options['id_hide_2']]) ? $term_values[$field_options['id_hide_2']] : array();
        // var_dump($sidebar_widgets_value);
        if (isset($field_options['default_2']) && is_array($field_options['default_2'])) {
            $sidebar_widgets_value = array_unique(array_merge($sidebar_widgets_value, $field_options['default_2']));
        }

        // var_dump($sidebar_widgets_value);

        if ($new_screen) {
            echo '<div class="form-field">';
            echo '<label>' . $field_options['name'] . '</label>';
        } else {
            echo '<tr class="form-field">';
            echo '<th scope="row" valign="top"><label>' . $field_options['name'] . '</label></th>';
            echo '<td>';
        }
        echo '<div class="content-widgets-orders-holder">';
        // echo'<div class="col-md-8">';
        if (!empty($content_widgets_value)) {
            echo '<div class="content-widgets-wrap">';
            foreach ($content_widgets_value as $key => $wname) {
                if (isset($field_options['values'][$wname])) {
                    $hide_checked = '';
                    if (isset($content_widgets_hide[$wname]) && $content_widgets_hide[$wname] == 'on') {
                        $hide_checked = ' checked="checked"';
                    }

                    echo '<div class="content-widgets-item">
				        						<span class="wid-icon"><i class="dashicons dashicons-move"></i></span>' . $field_options['values'][$wname] . '<span class="wid-icon-after"></span>
				        						<input type="hidden" name="term_meta[' . $field_options['id'] . '][]" value="' . $wname . '">

												<label class="lbl-hide-widget" for="' . $field_options['id_hide'] . '_' . $wname . '">' . __('Hide this', 'townhub-add-ons') . '
				        							<input type="hidden" name="term_meta[' . $field_options['id_hide'] . '][' . $wname . ']" value="">
				        							<input type="checkbox" id="' . $field_options['id_hide'] . '_' . $wname . '" name="term_meta[' . $field_options['id_hide'] . '][' . $wname . ']" value="on"' . $hide_checked . '>
				        						</label>

				        					</div>';
                }
            }
            echo '</div>'; //end content-widgets-wrap

        }
        // echo '</div>';
        // echo'<div class="col-md-4">';
        if (!empty($sidebar_widgets_value)) {
            echo '<div class="sidebar-widgets-wrap">';
            foreach ($sidebar_widgets_value as $key => $wname) {
                if (isset($field_options['values_2'][$wname])) {
                    $hide_checked = '';
                    if (isset($sidebar_widgets_hide[$wname]) && $sidebar_widgets_hide[$wname] == 'on') {
                        $hide_checked = ' checked="checked"';
                    }

                    echo '<div class="sidebar-widgets-item">
				        						<span class="wid-icon">
				        							<i class="dashicons dashicons-move"></i>
				        						</span>' . $field_options['values_2'][$wname] . '<span class="wid-icon-after"></span>
				        						<input type="hidden" name="term_meta[' . $field_options['id_2'] . '][]" value="' . $wname . '">
				        						<label class="lbl-hide-widget" for="' . $field_options['id_hide_2'] . '_' . $wname . '">' . __('Hide this', 'townhub-add-ons') . '
				        							<input type="hidden" name="term_meta[' . $field_options['id_hide_2'] . '][' . $wname . ']" value="">
				        							<input type="checkbox" id="' . $field_options['id_hide_2'] . '_' . $wname . '" name="term_meta[' . $field_options['id_hide_2'] . '][' . $wname . ']" value="on"' . $hide_checked . '>
				        						</label>

				        					</div>';
                }
            }
            echo '</div>'; //end sidebar-widgets-wrap

        }
        // echo '</div>';
        echo '</div>';

        // if(!empty($field_options['values'])){
        //     echo '<div class="content-widgets-wrap">';
        //     foreach ($field_options['values'] as $wname => $wlbl) {
        //         echo '<div class="content-widgets-item"><input type="hidden" name="term_meta['.$field_options['id'].'][]" value="'.$wname.'">'.$wlbl.'</div>';
        //         // echo '<input type="radio" name="term_meta['.$field_options['id'].']" id="term_meta['.$field_options['id'].']" value="'.$val.'" '.checked( $checked, $val,false).'>'.$opt.'&nbsp;&nbsp;';
        //     }
        //     echo '</div>';//end content-widgets-wrap

        // }
        if (isset($field_options['desc'])) {
            echo '<p class="description">' . $field_options['desc'] . '</p>';
        }
        if ($new_screen) {
            echo '</div>';

        } else {
            echo '</td>';
            echo '</tr>';
        }

    }
}

if (!function_exists('townhub_addons_icon_select_field')) {
    /**
     * field_options : array('id','name','desc','values','default')
     *
     */
    function townhub_addons_icon_select_field($field_options, $term_values = array(), $new_screen = true)
    {

        if (isset($field_options['icon_ver']) && $field_options['icon_ver'] == '4.7') {
            $icons = townhub_addons_extract_awesome_icon_array();
        } else {
            $icons = townhub_addons_extract_awesome_pro_icon_array();
        }

        $value = isset($term_values[$field_options['id']]) ? $term_values[$field_options['id']] : (null != $field_options['default'] ? $field_options['default'] : '');

        if ($new_screen) {
            echo '<div class="form-field">';
            echo '<label for="term_meta[' . $field_options['id'] . '][]">' . $field_options['name'] . '</label>';
        } else {
            echo '<tr class="form-field">';
            echo '<th scope="row" valign="top"><label for="term_meta[' . $field_options['id'] . ']">' . $field_options['name'] . '</label></th>';
            echo '<td>';
        }

        if (!empty($icons) && !is_wp_error($icons)) {

            //     echo '<select class="js-select2-single" name="term_meta['.$field_options['id'].']" id="term_meta['.$field_options['id'].']">';

            // foreach ( $icons as $icon => $icname ) {
            //     echo '<option value="'.$icon.'" '.selected( $selected, $icon, false ).'><span class="icon-select-icon"><i class="'.$icon.'"></i></span> ' . $icname . '</option>';
            //    }

            // echo '</select>';
            ?>
 				<div class="cth-icons-wrap">
 					<input type="text" name="term_meta[<?php echo $field_options['id'] ?>]" id="term_meta[<?php echo $field_options['id'] ?>]" value="<?php echo $value ?>" placeholder="<?php echo esc_attr_e('Type to search', 'townhub-add-ons'); ?>">
					<a href="#" class="close-icons"><i class="ti-close"></i></a>
					<div class="cth-icons-hold off_select" style="display: none;">
						<?php

            $html = array();
            foreach ($icons as $icon => $icname) {
                $html[] = "\t" . '<div class="cthicon-select" data-font="' . $icon . '">';
                $html[] = "\t\t" . '<i class="' . $icon . '" title="' . $icon . '"></i>';
                $html[] = "\t" . '</div>';
            }

            echo implode("\n\t\t\t", $html);

            ?>
					</div>

					<div class="cth-icon-preview"><i class="<?php echo $value; ?> fa-2x"></i></div>

				</div><!-- .icons-holder -->
			<?php
} else {

        }

        if (isset($field_options['desc'])) {
            echo '<p class="description">' . $field_options['desc'] . '</p>';
        }
        if ($new_screen) {
            echo '</div>';

        } else {
            echo '</td>';
            echo '</tr>';
        }

    }
}
function townhub_addons_extract_awesome_pro_icon_array( $lib = '')
{

    $extracted_icons = array(
        'fab fa-500px'                               => '500px',
        'fab fa-accessible-icon'                     => 'accessible-icon',
        'fab fa-accusoft'                            => 'accusoft',
        'fab fa-acquisitions-incorporated'           => 'acquisitions-incorporated',
        'fab fa-adn'                                 => 'adn',
        'fab fa-adobe'                               => 'adobe',
        'fab fa-adversal'                            => 'adversal',
        'fab fa-affiliatetheme'                      => 'affiliatetheme',
        'fab fa-airbnb'                              => 'airbnb',
        'fab fa-algolia'                             => 'algolia',
        'fab fa-alipay'                              => 'alipay',
        'fab fa-amazon'                              => 'amazon',
        'fab fa-amazon-pay'                          => 'amazon-pay',
        'fab fa-amilia'                              => 'amilia',
        'fab fa-android'                             => 'android',
        'fab fa-angellist'                           => 'angellist',
        'fab fa-angrycreative'                       => 'angrycreative',
        'fab fa-angular'                             => 'angular',
        'fab fa-app-store'                           => 'app-store',
        'fab fa-app-store-ios'                       => 'app-store-ios',
        'fab fa-apper'                               => 'apper',
        'fab fa-apple'                               => 'apple',
        'fab fa-apple-pay'                           => 'apple-pay',
        'fab fa-artstation'                          => 'artstation',
        'fab fa-asymmetrik'                          => 'asymmetrik',
        'fab fa-atlassian'                           => 'atlassian',
        'fab fa-audible'                             => 'audible',
        'fab fa-autoprefixer'                        => 'autoprefixer',
        'fab fa-avianex'                             => 'avianex',
        'fab fa-aviato'                              => 'aviato',
        'fab fa-aws'                                 => 'aws',
        'fab fa-bandcamp'                            => 'bandcamp',
        'fab fa-battle-net'                          => 'battle-net',
        'fab fa-behance'                             => 'behance',
        'fab fa-behance-square'                      => 'behance-square',
        'fab fa-bimobject'                           => 'bimobject',
        'fab fa-bitbucket'                           => 'bitbucket',
        'fab fa-bitcoin'                             => 'bitcoin',
        'fab fa-bity'                                => 'bity',
        'fab fa-black-tie'                           => 'black-tie',
        'fab fa-blackberry'                          => 'blackberry',
        'fab fa-blogger'                             => 'blogger',
        'fab fa-blogger-b'                           => 'blogger-b',
        'fab fa-bluetooth'                           => 'bluetooth',
        'fab fa-bluetooth-b'                         => 'bluetooth-b',
        'fab fa-bootstrap'                           => 'bootstrap',
        'fab fa-btc'                                 => 'btc',
        'fab fa-buffer'                              => 'buffer',
        'fab fa-buromobelexperte'                    => 'buromobelexperte',
        'fab fa-buysellads'                          => 'buysellads',
        'fab fa-canadian-maple-leaf'                 => 'canadian-maple-leaf',
        'fab fa-cc-amazon-pay'                       => 'cc-amazon-pay',
        'fab fa-cc-amex'                             => 'cc-amex',
        'fab fa-cc-apple-pay'                        => 'cc-apple-pay',
        'fab fa-cc-diners-club'                      => 'cc-diners-club',
        'fab fa-cc-discover'                         => 'cc-discover',
        'fab fa-cc-jcb'                              => 'cc-jcb',
        'fab fa-cc-mastercard'                       => 'cc-mastercard',
        'fab fa-cc-paypal'                           => 'cc-paypal',
        'fab fa-cc-stripe'                           => 'cc-stripe',
        'fab fa-cc-visa'                             => 'cc-visa',
        'fab fa-centercode'                          => 'centercode',
        'fab fa-centos'                              => 'centos',
        'fab fa-chrome'                              => 'chrome',
        'fab fa-chromecast'                          => 'chromecast',
        'fab fa-cloudscale'                          => 'cloudscale',
        'fab fa-cloudsmith'                          => 'cloudsmith',
        'fab fa-cloudversify'                        => 'cloudversify',
        'fab fa-codepen'                             => 'codepen',
        'fab fa-codiepie'                            => 'codiepie',
        'fab fa-confluence'                          => 'confluence',
        'fab fa-connectdevelop'                      => 'connectdevelop',
        'fab fa-contao'                              => 'contao',
        'fab fa-cotton-bureau'                       => 'cotton-bureau',
        'fab fa-cpanel'                              => 'cpanel',
        'fab fa-creative-commons'                    => 'creative-commons',
        'fab fa-creative-commons-by'                 => 'creative-commons-by',
        'fab fa-creative-commons-nc'                 => 'creative-commons-nc',
        'fab fa-creative-commons-nc-eu'              => 'creative-commons-nc-eu',
        'fab fa-creative-commons-nc-jp'              => 'creative-commons-nc-jp',
        'fab fa-creative-commons-nd'                 => 'creative-commons-nd',
        'fab fa-creative-commons-pd'                 => 'creative-commons-pd',
        'fab fa-creative-commons-pd-alt'             => 'creative-commons-pd-alt',
        'fab fa-creative-commons-remix'              => 'creative-commons-remix',
        'fab fa-creative-commons-sa'                 => 'creative-commons-sa',
        'fab fa-creative-commons-sampling'           => 'creative-commons-sampling',
        'fab fa-creative-commons-sampling-plus'      => 'creative-commons-sampling-plus',
        'fab fa-creative-commons-share'              => 'creative-commons-share',
        'fab fa-creative-commons-zero'               => 'creative-commons-zero',
        'fab fa-critical-role'                       => 'critical-role',
        'fab fa-css3'                                => 'css3',
        'fab fa-css3-alt'                            => 'css3-alt',
        'fab fa-cuttlefish'                          => 'cuttlefish',
        'fab fa-d-and-d'                             => 'd-and-d',
        'fab fa-d-and-d-beyond'                      => 'd-and-d-beyond',
        'fab fa-dashcube'                            => 'dashcube',
        'fab fa-delicious'                           => 'delicious',
        'fab fa-deploydog'                           => 'deploydog',
        'fab fa-deskpro'                             => 'deskpro',
        'fab fa-dev'                                 => 'dev',
        'fab fa-deviantart'                          => 'deviantart',
        'fab fa-dhl'                                 => 'dhl',
        'fab fa-diaspora'                            => 'diaspora',
        'fab fa-digg'                                => 'digg',
        'fab fa-digital-ocean'                       => 'digital-ocean',
        'fab fa-discord'                             => 'discord',
        'fab fa-discourse'                           => 'discourse',
        'fab fa-dochub'                              => 'dochub',
        'fab fa-docker'                              => 'docker',
        'fab fa-draft2digital'                       => 'draft2digital',
        'fab fa-dribbble'                            => 'dribbble',
        'fab fa-dribbble-square'                     => 'dribbble-square',
        'fab fa-dropbox'                             => 'dropbox',
        'fab fa-drupal'                              => 'drupal',
        'fab fa-dyalog'                              => 'dyalog',
        'fab fa-earlybirds'                          => 'earlybirds',
        'fab fa-ebay'                                => 'ebay',
        'fab fa-edge'                                => 'edge',
        'fab fa-elementor'                           => 'elementor',
        'fab fa-ello'                                => 'ello',
        'fab fa-ember'                               => 'ember',
        'fab fa-empire'                              => 'empire',
        'fab fa-envira'                              => 'envira',
        'fab fa-erlang'                              => 'erlang',
        'fab fa-ethereum'                            => 'ethereum',
        'fab fa-etsy'                                => 'etsy',
        'fab fa-evernote'                            => 'evernote',
        'fab fa-expeditedssl'                        => 'expeditedssl',
        'fab fa-facebook'                            => 'facebook',
        'fab fa-facebook-f'                          => 'facebook-f',
        'fab fa-facebook-messenger'                  => 'facebook-messenger',
        'fab fa-facebook-square'                     => 'facebook-square',
        'fab fa-fantasy-flight-games'                => 'fantasy-flight-games',
        'fab fa-fedex'                               => 'fedex',
        'fab fa-fedora'                              => 'fedora',
        'fab fa-figma'                               => 'figma',
        'fab fa-firefox'                             => 'firefox',
        'fab fa-first-order'                         => 'first-order',
        'fab fa-first-order-alt'                     => 'first-order-alt',
        'fab fa-firstdraft'                          => 'firstdraft',
        'fab fa-flickr'                              => 'flickr',
        'fab fa-flipboard'                           => 'flipboard',
        'fab fa-fly'                                 => 'fly',
        'fab fa-font-awesome'                        => 'font-awesome',
        'fab fa-font-awesome-alt'                    => 'font-awesome-alt',
        'fab fa-font-awesome-flag'                   => 'font-awesome-flag',
        'fab fa-font-awesome-logo-full'              => 'font-awesome-logo-full',
        'fab fa-fonticons'                           => 'fonticons',
        'fab fa-fonticons-fi'                        => 'fonticons-fi',
        'fab fa-fort-awesome'                        => 'fort-awesome',
        'fab fa-fort-awesome-alt'                    => 'fort-awesome-alt',
        'fab fa-forumbee'                            => 'forumbee',
        'fab fa-foursquare'                          => 'foursquare',
        'fab fa-free-code-camp'                      => 'free-code-camp',
        'fab fa-freebsd'                             => 'freebsd',
        'fab fa-fulcrum'                             => 'fulcrum',
        'fab fa-galactic-republic'                   => 'galactic-republic',
        'fab fa-galactic-senate'                     => 'galactic-senate',
        'fab fa-get-pocket'                          => 'get-pocket',
        'fab fa-gg'                                  => 'gg',
        'fab fa-gg-circle'                           => 'gg-circle',
        'fab fa-git'                                 => 'git',
        'fab fa-git-alt'                             => 'git-alt',
        'fab fa-git-square'                          => 'git-square',
        'fab fa-github'                              => 'github',
        'fab fa-github-alt'                          => 'github-alt',
        'fab fa-github-square'                       => 'github-square',
        'fab fa-gitkraken'                           => 'gitkraken',
        'fab fa-gitlab'                              => 'gitlab',
        'fab fa-gitter'                              => 'gitter',
        'fab fa-glide'                               => 'glide',
        'fab fa-glide-g'                             => 'glide-g',
        'fab fa-gofore'                              => 'gofore',
        'fab fa-goodreads'                           => 'goodreads',
        'fab fa-goodreads-g'                         => 'goodreads-g',
        'fab fa-google'                              => 'google',
        'fab fa-google-drive'                        => 'google-drive',
        'fab fa-google-play'                         => 'google-play',
        'fab fa-google-plus'                         => 'google-plus',
        'fab fa-google-plus-g'                       => 'google-plus-g',
        'fab fa-google-plus-square'                  => 'google-plus-square',
        'fab fa-google-wallet'                       => 'google-wallet',
        'fab fa-gratipay'                            => 'gratipay',
        'fab fa-grav'                                => 'grav',
        'fab fa-gripfire'                            => 'gripfire',
        'fab fa-grunt'                               => 'grunt',
        'fab fa-gulp'                                => 'gulp',
        'fab fa-hacker-news'                         => 'hacker-news',
        'fab fa-hacker-news-square'                  => 'hacker-news-square',
        'fab fa-hackerrank'                          => 'hackerrank',
        'fab fa-hips'                                => 'hips',
        'fab fa-hire-a-helper'                       => 'hire-a-helper',
        'fab fa-hooli'                               => 'hooli',
        'fab fa-hornbill'                            => 'hornbill',
        'fab fa-hotjar'                              => 'hotjar',
        'fab fa-houzz'                               => 'houzz',
        'fab fa-html5'                               => 'html5',
        'fab fa-hubspot'                             => 'hubspot',
        'fab fa-imdb'                                => 'imdb',
        'fab fa-instagram'                           => 'instagram',
        'fab fa-intercom'                            => 'intercom',
        'fab fa-internet-explorer'                   => 'internet-explorer',
        'fab fa-invision'                            => 'invision',
        'fab fa-ioxhost'                             => 'ioxhost',
        'fab fa-itch-io'                             => 'itch-io',
        'fab fa-itunes'                              => 'itunes',
        'fab fa-itunes-note'                         => 'itunes-note',
        'fab fa-java'                                => 'java',
        'fab fa-jedi-order'                          => 'jedi-order',
        'fab fa-jenkins'                             => 'jenkins',
        'fab fa-jira'                                => 'jira',
        'fab fa-joget'                               => 'joget',
        'fab fa-joomla'                              => 'joomla',
        'fab fa-js'                                  => 'js',
        'fab fa-js-square'                           => 'js-square',
        'fab fa-jsfiddle'                            => 'jsfiddle',
        'fab fa-kaggle'                              => 'kaggle',
        'fab fa-keybase'                             => 'keybase',
        'fab fa-keycdn'                              => 'keycdn',
        'fab fa-kickstarter'                         => 'kickstarter',
        'fab fa-kickstarter-k'                       => 'kickstarter-k',
        'fab fa-korvue'                              => 'korvue',
        'fab fa-laravel'                             => 'laravel',
        'fab fa-lastfm'                              => 'lastfm',
        'fab fa-lastfm-square'                       => 'lastfm-square',
        'fab fa-leanpub'                             => 'leanpub',
        'fab fa-less'                                => 'less',
        'fab fa-line'                                => 'line',
        'fab fa-linkedin'                            => 'linkedin',
        'fab fa-linkedin-in'                         => 'linkedin-in',
        'fab fa-linode'                              => 'linode',
        'fab fa-linux'                               => 'linux',
        'fab fa-lyft'                                => 'lyft',
        'fab fa-magento'                             => 'magento',
        'fab fa-mailchimp'                           => 'mailchimp',
        'fab fa-mandalorian'                         => 'mandalorian',
        'fab fa-markdown'                            => 'markdown',
        'fab fa-mastodon'                            => 'mastodon',
        'fab fa-maxcdn'                              => 'maxcdn',
        'fab fa-medapps'                             => 'medapps',
        'fab fa-medium'                              => 'medium',
        'fab fa-medium-m'                            => 'medium-m',
        'fab fa-medrt'                               => 'medrt',
        'fab fa-meetup'                              => 'meetup',
        'fab fa-megaport'                            => 'megaport',
        'fab fa-mendeley'                            => 'mendeley',
        'fab fa-microsoft'                           => 'microsoft',
        'fab fa-mix'                                 => 'mix',
        'fab fa-mixcloud'                            => 'mixcloud',
        'fab fa-mizuni'                              => 'mizuni',
        'fab fa-modx'                                => 'modx',
        'fab fa-monero'                              => 'monero',
        'fab fa-napster'                             => 'napster',
        'fab fa-neos'                                => 'neos',
        'fab fa-nimblr'                              => 'nimblr',
        'fab fa-node'                                => 'node',
        'fab fa-node-js'                             => 'node-js',
        'fab fa-npm'                                 => 'npm',
        'fab fa-ns8'                                 => 'ns8',
        'fab fa-nutritionix'                         => 'nutritionix',
        'fab fa-odnoklassniki'                       => 'odnoklassniki',
        'fab fa-odnoklassniki-square'                => 'odnoklassniki-square',
        'fab fa-old-republic'                        => 'old-republic',
        'fab fa-opencart'                            => 'opencart',
        'fab fa-openid'                              => 'openid',
        'fab fa-opera'                               => 'opera',
        'fab fa-optin-monster'                       => 'optin-monster',
        'fab fa-osi'                                 => 'osi',
        'fab fa-page4'                               => 'page4',
        'fab fa-pagelines'                           => 'pagelines',
        'fab fa-palfed'                              => 'palfed',
        'fab fa-patreon'                             => 'patreon',
        'fab fa-paypal'                              => 'paypal',
        'fab fa-penny-arcade'                        => 'penny-arcade',
        'fab fa-periscope'                           => 'periscope',
        'fab fa-phabricator'                         => 'phabricator',
        'fab fa-phoenix-framework'                   => 'phoenix-framework',
        'fab fa-phoenix-squadron'                    => 'phoenix-squadron',
        'fab fa-php'                                 => 'php',
        'fab fa-pied-piper'                          => 'pied-piper',
        'fab fa-pied-piper-alt'                      => 'pied-piper-alt',
        'fab fa-pied-piper-hat'                      => 'pied-piper-hat',
        'fab fa-pied-piper-pp'                       => 'pied-piper-pp',
        'fab fa-pinterest'                           => 'pinterest',
        'fab fa-pinterest-p'                         => 'pinterest-p',
        'fab fa-pinterest-square'                    => 'pinterest-square',
        'fab fa-playstation'                         => 'playstation',
        'fab fa-product-hunt'                        => 'product-hunt',
        'fab fa-pushed'                              => 'pushed',
        'fab fa-python'                              => 'python',
        'fab fa-qq'                                  => 'qq',
        'fab fa-quinscape'                           => 'quinscape',
        'fab fa-quora'                               => 'quora',
        'fab fa-r-project'                           => 'r-project',
        'fab fa-raspberry-pi'                        => 'raspberry-pi',
        'fab fa-ravelry'                             => 'ravelry',
        'fab fa-react'                               => 'react',
        'fab fa-reacteurope'                         => 'reacteurope',
        'fab fa-readme'                              => 'readme',
        'fab fa-rebel'                               => 'rebel',
        'fab fa-red-river'                           => 'red-river',
        'fab fa-reddit'                              => 'reddit',
        'fab fa-reddit-alien'                        => 'reddit-alien',
        'fab fa-reddit-square'                       => 'reddit-square',
        'fab fa-redhat'                              => 'redhat',
        'fab fa-renren'                              => 'renren',
        'fab fa-replyd'                              => 'replyd',
        'fab fa-researchgate'                        => 'researchgate',
        'fab fa-resolving'                           => 'resolving',
        'fab fa-rev'                                 => 'rev',
        'fab fa-rocketchat'                          => 'rocketchat',
        'fab fa-rockrms'                             => 'rockrms',
        'fab fa-safari'                              => 'safari',
        'fab fa-salesforce'                          => 'salesforce',
        'fab fa-sass'                                => 'sass',
        'fab fa-schlix'                              => 'schlix',
        'fab fa-scribd'                              => 'scribd',
        'fab fa-searchengin'                         => 'searchengin',
        'fab fa-sellcast'                            => 'sellcast',
        'fab fa-sellsy'                              => 'sellsy',
        'fab fa-servicestack'                        => 'servicestack',
        'fab fa-shirtsinbulk'                        => 'shirtsinbulk',
        'fab fa-shopware'                            => 'shopware',
        'fab fa-simplybuilt'                         => 'simplybuilt',
        'fab fa-sistrix'                             => 'sistrix',
        'fab fa-sith'                                => 'sith',
        'fab fa-sketch'                              => 'sketch',
        'fab fa-skyatlas'                            => 'skyatlas',
        'fab fa-skype'                               => 'skype',
        'fab fa-slack'                               => 'slack',
        'fab fa-slack-hash'                          => 'slack-hash',
        'fab fa-slideshare'                          => 'slideshare',
        'fab fa-snapchat'                            => 'snapchat',
        'fab fa-snapchat-ghost'                      => 'snapchat-ghost',
        'fab fa-snapchat-square'                     => 'snapchat-square',
        'fab fa-soundcloud'                          => 'soundcloud',
        'fab fa-sourcetree'                          => 'sourcetree',
        'fab fa-speakap'                             => 'speakap',
        'fab fa-speaker-deck'                        => 'speaker-deck',
        'fab fa-spotify'                             => 'spotify',
        'fab fa-squarespace'                         => 'squarespace',
        'fab fa-stack-exchange'                      => 'stack-exchange',
        'fab fa-stack-overflow'                      => 'stack-overflow',
        'fab fa-stackpath'                           => 'stackpath',
        'fab fa-staylinked'                          => 'staylinked',
        'fab fa-steam'                               => 'steam',
        'fab fa-steam-square'                        => 'steam-square',
        'fab fa-steam-symbol'                        => 'steam-symbol',
        'fab fa-sticker-mule'                        => 'sticker-mule',
        'fab fa-strava'                              => 'strava',
        'fab fa-stripe'                              => 'stripe',
        'fab fa-stripe-s'                            => 'stripe-s',
        'fab fa-studiovinari'                        => 'studiovinari',
        'fab fa-stumbleupon'                         => 'stumbleupon',
        'fab fa-stumbleupon-circle'                  => 'stumbleupon-circle',
        'fab fa-superpowers'                         => 'superpowers',
        'fab fa-supple'                              => 'supple',
        'fab fa-suse'                                => 'suse',
        'fab fa-symfony'                             => 'symfony',
        'fab fa-teamspeak'                           => 'teamspeak',
        'fab fa-telegram'                            => 'telegram',
        'fab fa-telegram-plane'                      => 'telegram-plane',
        'fab fa-tencent-weibo'                       => 'tencent-weibo',
        'fab fa-the-red-yeti'                        => 'the-red-yeti',
        'fab fa-themeco'                             => 'themeco',
        'fab fa-themeisle'                           => 'themeisle',
        'fab fa-think-peaks'                         => 'think-peaks',
        'fab fa-trade-federation'                    => 'trade-federation',
        'fab fa-trello'                              => 'trello',
        'fab fa-tripadvisor'                         => 'tripadvisor',
        'fab fa-tumblr'                              => 'tumblr',
        'fab fa-tumblr-square'                       => 'tumblr-square',
        'fab fa-twitch'                              => 'twitch',
        'fab fa-twitter'                             => 'twitter',
        'fab fa-twitter-square'                      => 'twitter-square',
        'fab fa-typo3'                               => 'typo3',
        'fab fa-uber'                                => 'uber',
        'fab fa-ubuntu'                              => 'ubuntu',
        'fab fa-uikit'                               => 'uikit',
        'fab fa-uniregistry'                         => 'uniregistry',
        'fab fa-untappd'                             => 'untappd',
        'fab fa-ups'                                 => 'ups',
        'fab fa-usb'                                 => 'usb',
        'fab fa-usps'                                => 'usps',
        'fab fa-ussunnah'                            => 'ussunnah',
        'fab fa-vaadin'                              => 'vaadin',
        'fab fa-viacoin'                             => 'viacoin',
        'fab fa-viadeo'                              => 'viadeo',
        'fab fa-viadeo-square'                       => 'viadeo-square',
        'fab fa-viber'                               => 'viber',
        'fab fa-vimeo'                               => 'vimeo',
        'fab fa-vimeo-square'                        => 'vimeo-square',
        'fab fa-vimeo-v'                             => 'vimeo-v',
        'fab fa-vine'                                => 'vine',
        'fab fa-vk'                                  => 'vk',
        'fab fa-vnv'                                 => 'vnv',
        'fab fa-vuejs'                               => 'vuejs',
        'fab fa-waze'                                => 'waze',
        'fab fa-weebly'                              => 'weebly',
        'fab fa-weibo'                               => 'weibo',
        'fab fa-weixin'                              => 'weixin',
        'fab fa-whatsapp'                            => 'whatsapp',
        'fab fa-whatsapp-square'                     => 'whatsapp-square',
        'fab fa-whmcs'                               => 'whmcs',
        'fab fa-wikipedia-w'                         => 'wikipedia-w',
        'fab fa-windows'                             => 'windows',
        'fab fa-wix'                                 => 'wix',
        'fab fa-wizards-of-the-coast'                => 'wizards-of-the-coast',
        'fab fa-wolf-pack-battalion'                 => 'wolf-pack-battalion',
        'fab fa-wordpress'                           => 'wordpress',
        'fab fa-wordpress-simple'                    => 'wordpress-simple',
        'fab fa-wpbeginner'                          => 'wpbeginner',
        'fab fa-wpexplorer'                          => 'wpexplorer',
        'fab fa-wpforms'                             => 'wpforms',
        'fab fa-wpressr'                             => 'wpressr',
        'fab fa-xbox'                                => 'xbox',
        'fab fa-xing'                                => 'xing',
        'fab fa-xing-square'                         => 'xing-square',
        'fab fa-y-combinator'                        => 'y-combinator',
        'fab fa-yahoo'                               => 'yahoo',
        'fab fa-yammer'                              => 'yammer',
        'fab fa-yandex'                              => 'yandex',
        'fab fa-yandex-international'                => 'yandex-international',
        'fab fa-yarn'                                => 'yarn',
        'fab fa-yelp'                                => 'yelp',
        'fab fa-yoast'                               => 'yoast',
        'fab fa-youtube'                             => 'youtube',
        'fab fa-youtube-square'                      => 'youtube-square',
        'fab fa-zhihu'                               => 'zhihu',
        'fad fa-abacus'                              => 'abacus',
        'fad fa-acorn'                               => 'acorn',
        'fad fa-ad'                                  => 'ad',
        'fad fa-address-book'                        => 'address-book',
        'fad fa-address-card'                        => 'address-card',
        'fad fa-adjust'                              => 'adjust',
        'fad fa-air-freshener'                       => 'air-freshener',
        'fad fa-alarm-clock'                         => 'alarm-clock',
        'fad fa-alarm-exclamation'                   => 'alarm-exclamation',
        'fad fa-alarm-plus'                          => 'alarm-plus',
        'fad fa-alarm-snooze'                        => 'alarm-snooze',
        'fad fa-alicorn'                             => 'alicorn',
        'fad fa-align-center'                        => 'align-center',
        'fad fa-align-justify'                       => 'align-justify',
        'fad fa-align-left'                          => 'align-left',
        'fad fa-align-right'                         => 'align-right',
        'fad fa-align-slash'                         => 'align-slash',
        'fad fa-allergies'                           => 'allergies',
        'fad fa-ambulance'                           => 'ambulance',
        'fad fa-american-sign-language-interpreting' => 'american-sign-language-interpreting',
        'fad fa-analytics'                           => 'analytics',
        'fad fa-anchor'                              => 'anchor',
        'fad fa-angel'                               => 'angel',
        'fad fa-angle-double-down'                   => 'angle-double-down',
        'fad fa-angle-double-left'                   => 'angle-double-left',
        'fad fa-angle-double-right'                  => 'angle-double-right',
        'fad fa-angle-double-up'                     => 'angle-double-up',
        'fad fa-angle-down'                          => 'angle-down',
        'fad fa-angle-left'                          => 'angle-left',
        'fad fa-angle-right'                         => 'angle-right',
        'fad fa-angle-up'                            => 'angle-up',
        'fad fa-angry'                               => 'angry',
        'fad fa-ankh'                                => 'ankh',
        'fad fa-apple-alt'                           => 'apple-alt',
        'fad fa-apple-crate'                         => 'apple-crate',
        'fad fa-archive'                             => 'archive',
        'fad fa-archway'                             => 'archway',
        'fad fa-arrow-alt-circle-down'               => 'arrow-alt-circle-down',
        'fad fa-arrow-alt-circle-left'               => 'arrow-alt-circle-left',
        'fad fa-arrow-alt-circle-right'              => 'arrow-alt-circle-right',
        'fad fa-arrow-alt-circle-up'                 => 'arrow-alt-circle-up',
        'fad fa-arrow-alt-down'                      => 'arrow-alt-down',
        'fad fa-arrow-alt-from-bottom'               => 'arrow-alt-from-bottom',
        'fad fa-arrow-alt-from-left'                 => 'arrow-alt-from-left',
        'fad fa-arrow-alt-from-right'                => 'arrow-alt-from-right',
        'fad fa-arrow-alt-from-top'                  => 'arrow-alt-from-top',
        'fad fa-arrow-alt-left'                      => 'arrow-alt-left',
        'fad fa-arrow-alt-right'                     => 'arrow-alt-right',
        'fad fa-arrow-alt-square-down'               => 'arrow-alt-square-down',
        'fad fa-arrow-alt-square-left'               => 'arrow-alt-square-left',
        'fad fa-arrow-alt-square-right'              => 'arrow-alt-square-right',
        'fad fa-arrow-alt-square-up'                 => 'arrow-alt-square-up',
        'fad fa-arrow-alt-to-bottom'                 => 'arrow-alt-to-bottom',
        'fad fa-arrow-alt-to-left'                   => 'arrow-alt-to-left',
        'fad fa-arrow-alt-to-right'                  => 'arrow-alt-to-right',
        'fad fa-arrow-alt-to-top'                    => 'arrow-alt-to-top',
        'fad fa-arrow-alt-up'                        => 'arrow-alt-up',
        'fad fa-arrow-circle-down'                   => 'arrow-circle-down',
        'fad fa-arrow-circle-left'                   => 'arrow-circle-left',
        'fad fa-arrow-circle-right'                  => 'arrow-circle-right',
        'fad fa-arrow-circle-up'                     => 'arrow-circle-up',
        'fad fa-arrow-down'                          => 'arrow-down',
        'fad fa-arrow-from-bottom'                   => 'arrow-from-bottom',
        'fad fa-arrow-from-left'                     => 'arrow-from-left',
        'fad fa-arrow-from-right'                    => 'arrow-from-right',
        'fad fa-arrow-from-top'                      => 'arrow-from-top',
        'fad fa-arrow-left'                          => 'arrow-left',
        'fad fa-arrow-right'                         => 'arrow-right',
        'fad fa-arrow-square-down'                   => 'arrow-square-down',
        'fad fa-arrow-square-left'                   => 'arrow-square-left',
        'fad fa-arrow-square-right'                  => 'arrow-square-right',
        'fad fa-arrow-square-up'                     => 'arrow-square-up',
        'fad fa-arrow-to-bottom'                     => 'arrow-to-bottom',
        'fad fa-arrow-to-left'                       => 'arrow-to-left',
        'fad fa-arrow-to-right'                      => 'arrow-to-right',
        'fad fa-arrow-to-top'                        => 'arrow-to-top',
        'fad fa-arrow-up'                            => 'arrow-up',
        'fad fa-arrows'                              => 'arrows',
        'fad fa-arrows-alt'                          => 'arrows-alt',
        'fad fa-arrows-alt-h'                        => 'arrows-alt-h',
        'fad fa-arrows-alt-v'                        => 'arrows-alt-v',
        'fad fa-arrows-h'                            => 'arrows-h',
        'fad fa-arrows-v'                            => 'arrows-v',
        'fad fa-assistive-listening-systems'         => 'assistive-listening-systems',
        'fad fa-asterisk'                            => 'asterisk',
        'fad fa-at'                                  => 'at',
        'fad fa-atlas'                               => 'atlas',
        'fad fa-atom'                                => 'atom',
        'fad fa-atom-alt'                            => 'atom-alt',
        'fad fa-audio-description'                   => 'audio-description',
        'fad fa-award'                               => 'award',
        'fad fa-axe'                                 => 'axe',
        'fad fa-axe-battle'                          => 'axe-battle',
        'fad fa-baby'                                => 'baby',
        'fad fa-baby-carriage'                       => 'baby-carriage',
        'fad fa-backpack'                            => 'backpack',
        'fad fa-backspace'                           => 'backspace',
        'fad fa-backward'                            => 'backward',
        'fad fa-bacon'                               => 'bacon',
        'fad fa-badge'                               => 'badge',
        'fad fa-badge-check'                         => 'badge-check',
        'fad fa-badge-dollar'                        => 'badge-dollar',
        'fad fa-badge-percent'                       => 'badge-percent',
        'fad fa-badger-honey'                        => 'badger-honey',
        'fad fa-bags-shopping'                       => 'bags-shopping',
        'fad fa-balance-scale'                       => 'balance-scale',
        'fad fa-balance-scale-left'                  => 'balance-scale-left',
        'fad fa-balance-scale-right'                 => 'balance-scale-right',
        'fad fa-ball-pile'                           => 'ball-pile',
        'fad fa-ballot'                              => 'ballot',
        'fad fa-ballot-check'                        => 'ballot-check',
        'fad fa-ban'                                 => 'ban',
        'fad fa-band-aid'                            => 'band-aid',
        'fad fa-barcode'                             => 'barcode',
        'fad fa-barcode-alt'                         => 'barcode-alt',
        'fad fa-barcode-read'                        => 'barcode-read',
        'fad fa-barcode-scan'                        => 'barcode-scan',
        'fad fa-bars'                                => 'bars',
        'fad fa-baseball'                            => 'baseball',
        'fad fa-baseball-ball'                       => 'baseball-ball',
        'fad fa-basketball-ball'                     => 'basketball-ball',
        'fad fa-basketball-hoop'                     => 'basketball-hoop',
        'fad fa-bat'                                 => 'bat',
        'fad fa-bath'                                => 'bath',
        'fad fa-battery-bolt'                        => 'battery-bolt',
        'fad fa-battery-empty'                       => 'battery-empty',
        'fad fa-battery-full'                        => 'battery-full',
        'fad fa-battery-half'                        => 'battery-half',
        'fad fa-battery-quarter'                     => 'battery-quarter',
        'fad fa-battery-slash'                       => 'battery-slash',
        'fad fa-battery-three-quarters'              => 'battery-three-quarters',
        'fad fa-bed'                                 => 'bed',
        'fad fa-beer'                                => 'beer',
        'fad fa-bell'                                => 'bell',
        'fad fa-bell-exclamation'                    => 'bell-exclamation',
        'fad fa-bell-plus'                           => 'bell-plus',
        'fad fa-bell-school'                         => 'bell-school',
        'fad fa-bell-school-slash'                   => 'bell-school-slash',
        'fad fa-bell-slash'                          => 'bell-slash',
        'fad fa-bells'                               => 'bells',
        'fad fa-bezier-curve'                        => 'bezier-curve',
        'fad fa-bible'                               => 'bible',
        'fad fa-bicycle'                             => 'bicycle',
        'fad fa-biking'                              => 'biking',
        'fad fa-biking-mountain'                     => 'biking-mountain',
        'fad fa-binoculars'                          => 'binoculars',
        'fad fa-biohazard'                           => 'biohazard',
        'fad fa-birthday-cake'                       => 'birthday-cake',
        'fad fa-blanket'                             => 'blanket',
        'fad fa-blender'                             => 'blender',
        'fad fa-blender-phone'                       => 'blender-phone',
        'fad fa-blind'                               => 'blind',
        'fad fa-blog'                                => 'blog',
        'fad fa-bold'                                => 'bold',
        'fad fa-bolt'                                => 'bolt',
        'fad fa-bomb'                                => 'bomb',
        'fad fa-bone'                                => 'bone',
        'fad fa-bone-break'                          => 'bone-break',
        'fad fa-bong'                                => 'bong',
        'fad fa-book'                                => 'book',
        'fad fa-book-alt'                            => 'book-alt',
        'fad fa-book-dead'                           => 'book-dead',
        'fad fa-book-heart'                          => 'book-heart',
        'fad fa-book-medical'                        => 'book-medical',
        'fad fa-book-open'                           => 'book-open',
        'fad fa-book-reader'                         => 'book-reader',
        'fad fa-book-spells'                         => 'book-spells',
        'fad fa-book-user'                           => 'book-user',
        'fad fa-bookmark'                            => 'bookmark',
        'fad fa-books'                               => 'books',
        'fad fa-books-medical'                       => 'books-medical',
        'fad fa-boot'                                => 'boot',
        'fad fa-booth-curtain'                       => 'booth-curtain',
        'fad fa-border-all'                          => 'border-all',
        'fad fa-border-bottom'                       => 'border-bottom',
        'fad fa-border-inner'                        => 'border-inner',
        'fad fa-border-left'                         => 'border-left',
        'fad fa-border-none'                         => 'border-none',
        'fad fa-border-outer'                        => 'border-outer',
        'fad fa-border-right'                        => 'border-right',
        'fad fa-border-style'                        => 'border-style',
        'fad fa-border-style-alt'                    => 'border-style-alt',
        'fad fa-border-top'                          => 'border-top',
        'fad fa-bow-arrow'                           => 'bow-arrow',
        'fad fa-bowling-ball'                        => 'bowling-ball',
        'fad fa-bowling-pins'                        => 'bowling-pins',
        'fad fa-box'                                 => 'box',
        'fad fa-box-alt'                             => 'box-alt',
        'fad fa-box-ballot'                          => 'box-ballot',
        'fad fa-box-check'                           => 'box-check',
        'fad fa-box-fragile'                         => 'box-fragile',
        'fad fa-box-full'                            => 'box-full',
        'fad fa-box-heart'                           => 'box-heart',
        'fad fa-box-open'                            => 'box-open',
        'fad fa-box-up'                              => 'box-up',
        'fad fa-box-usd'                             => 'box-usd',
        'fad fa-boxes'                               => 'boxes',
        'fad fa-boxes-alt'                           => 'boxes-alt',
        'fad fa-boxing-glove'                        => 'boxing-glove',
        'fad fa-brackets'                            => 'brackets',
        'fad fa-brackets-curly'                      => 'brackets-curly',
        'fad fa-braille'                             => 'braille',
        'fad fa-brain'                               => 'brain',
        'fad fa-bread-loaf'                          => 'bread-loaf',
        'fad fa-bread-slice'                         => 'bread-slice',
        'fad fa-briefcase'                           => 'briefcase',
        'fad fa-briefcase-medical'                   => 'briefcase-medical',
        'fad fa-bring-forward'                       => 'bring-forward',
        'fad fa-bring-front'                         => 'bring-front',
        'fad fa-broadcast-tower'                     => 'broadcast-tower',
        'fad fa-broom'                               => 'broom',
        'fad fa-browser'                             => 'browser',
        'fad fa-brush'                               => 'brush',
        'fad fa-bug'                                 => 'bug',
        'fad fa-building'                            => 'building',
        'fad fa-bullhorn'                            => 'bullhorn',
        'fad fa-bullseye'                            => 'bullseye',
        'fad fa-bullseye-arrow'                      => 'bullseye-arrow',
        'fad fa-bullseye-pointer'                    => 'bullseye-pointer',
        'fad fa-burger-soda'                         => 'burger-soda',
        'fad fa-burn'                                => 'burn',
        'fad fa-burrito'                             => 'burrito',
        'fad fa-bus'                                 => 'bus',
        'fad fa-bus-alt'                             => 'bus-alt',
        'fad fa-bus-school'                          => 'bus-school',
        'fad fa-business-time'                       => 'business-time',
        'fad fa-cabinet-filing'                      => 'cabinet-filing',
        'fad fa-calculator'                          => 'calculator',
        'fad fa-calculator-alt'                      => 'calculator-alt',
        'fad fa-calendar'                            => 'calendar',
        'fad fa-calendar-alt'                        => 'calendar-alt',
        'fad fa-calendar-check'                      => 'calendar-check',
        'fad fa-calendar-day'                        => 'calendar-day',
        'fad fa-calendar-edit'                       => 'calendar-edit',
        'fad fa-calendar-exclamation'                => 'calendar-exclamation',
        'fad fa-calendar-minus'                      => 'calendar-minus',
        'fad fa-calendar-plus'                       => 'calendar-plus',
        'fad fa-calendar-star'                       => 'calendar-star',
        'fad fa-calendar-times'                      => 'calendar-times',
        'fad fa-calendar-week'                       => 'calendar-week',
        'fad fa-camera'                              => 'camera',
        'fad fa-camera-alt'                          => 'camera-alt',
        'fad fa-camera-retro'                        => 'camera-retro',
        'fad fa-campfire'                            => 'campfire',
        'fad fa-campground'                          => 'campground',
        'fad fa-candle-holder'                       => 'candle-holder',
        'fad fa-candy-cane'                          => 'candy-cane',
        'fad fa-candy-corn'                          => 'candy-corn',
        'fad fa-cannabis'                            => 'cannabis',
        'fad fa-capsules'                            => 'capsules',
        'fad fa-car'                                 => 'car',
        'fad fa-car-alt'                             => 'car-alt',
        'fad fa-car-battery'                         => 'car-battery',
        'fad fa-car-building'                        => 'car-building',
        'fad fa-car-bump'                            => 'car-bump',
        'fad fa-car-bus'                             => 'car-bus',
        'fad fa-car-crash'                           => 'car-crash',
        'fad fa-car-garage'                          => 'car-garage',
        'fad fa-car-mechanic'                        => 'car-mechanic',
        'fad fa-car-side'                            => 'car-side',
        'fad fa-car-tilt'                            => 'car-tilt',
        'fad fa-car-wash'                            => 'car-wash',
        'fad fa-caret-circle-down'                   => 'caret-circle-down',
        'fad fa-caret-circle-left'                   => 'caret-circle-left',
        'fad fa-caret-circle-right'                  => 'caret-circle-right',
        'fad fa-caret-circle-up'                     => 'caret-circle-up',
        'fad fa-caret-down'                          => 'caret-down',
        'fad fa-caret-left'                          => 'caret-left',
        'fad fa-caret-right'                         => 'caret-right',
        'fad fa-caret-square-down'                   => 'caret-square-down',
        'fad fa-caret-square-left'                   => 'caret-square-left',
        'fad fa-caret-square-right'                  => 'caret-square-right',
        'fad fa-caret-square-up'                     => 'caret-square-up',
        'fad fa-caret-up'                            => 'caret-up',
        'fad fa-carrot'                              => 'carrot',
        'fad fa-cars'                                => 'cars',
        'fad fa-cart-arrow-down'                     => 'cart-arrow-down',
        'fad fa-cart-plus'                           => 'cart-plus',
        'fad fa-cash-register'                       => 'cash-register',
        'fad fa-cat'                                 => 'cat',
        'fad fa-cauldron'                            => 'cauldron',
        'fad fa-certificate'                         => 'certificate',
        'fad fa-chair'                               => 'chair',
        'fad fa-chair-office'                        => 'chair-office',
        'fad fa-chalkboard'                          => 'chalkboard',
        'fad fa-chalkboard-teacher'                  => 'chalkboard-teacher',
        'fad fa-charging-station'                    => 'charging-station',
        'fad fa-chart-area'                          => 'chart-area',
        'fad fa-chart-bar'                           => 'chart-bar',
        'fad fa-chart-line'                          => 'chart-line',
        'fad fa-chart-line-down'                     => 'chart-line-down',
        'fad fa-chart-network'                       => 'chart-network',
        'fad fa-chart-pie'                           => 'chart-pie',
        'fad fa-chart-pie-alt'                       => 'chart-pie-alt',
        'fad fa-chart-scatter'                       => 'chart-scatter',
        'fad fa-check'                               => 'check',
        'fad fa-check-circle'                        => 'check-circle',
        'fad fa-check-double'                        => 'check-double',
        'fad fa-check-square'                        => 'check-square',
        'fad fa-cheese'                              => 'cheese',
        'fad fa-cheese-swiss'                        => 'cheese-swiss',
        'fad fa-cheeseburger'                        => 'cheeseburger',
        'fad fa-chess'                               => 'chess',
        'fad fa-chess-bishop'                        => 'chess-bishop',
        'fad fa-chess-bishop-alt'                    => 'chess-bishop-alt',
        'fad fa-chess-board'                         => 'chess-board',
        'fad fa-chess-clock'                         => 'chess-clock',
        'fad fa-chess-clock-alt'                     => 'chess-clock-alt',
        'fad fa-chess-king'                          => 'chess-king',
        'fad fa-chess-king-alt'                      => 'chess-king-alt',
        'fad fa-chess-knight'                        => 'chess-knight',
        'fad fa-chess-knight-alt'                    => 'chess-knight-alt',
        'fad fa-chess-pawn'                          => 'chess-pawn',
        'fad fa-chess-pawn-alt'                      => 'chess-pawn-alt',
        'fad fa-chess-queen'                         => 'chess-queen',
        'fad fa-chess-queen-alt'                     => 'chess-queen-alt',
        'fad fa-chess-rook'                          => 'chess-rook',
        'fad fa-chess-rook-alt'                      => 'chess-rook-alt',
        'fad fa-chevron-circle-down'                 => 'chevron-circle-down',
        'fad fa-chevron-circle-left'                 => 'chevron-circle-left',
        'fad fa-chevron-circle-right'                => 'chevron-circle-right',
        'fad fa-chevron-circle-up'                   => 'chevron-circle-up',
        'fad fa-chevron-double-down'                 => 'chevron-double-down',
        'fad fa-chevron-double-left'                 => 'chevron-double-left',
        'fad fa-chevron-double-right'                => 'chevron-double-right',
        'fad fa-chevron-double-up'                   => 'chevron-double-up',
        'fad fa-chevron-down'                        => 'chevron-down',
        'fad fa-chevron-left'                        => 'chevron-left',
        'fad fa-chevron-right'                       => 'chevron-right',
        'fad fa-chevron-square-down'                 => 'chevron-square-down',
        'fad fa-chevron-square-left'                 => 'chevron-square-left',
        'fad fa-chevron-square-right'                => 'chevron-square-right',
        'fad fa-chevron-square-up'                   => 'chevron-square-up',
        'fad fa-chevron-up'                          => 'chevron-up',
        'fad fa-child'                               => 'child',
        'fad fa-chimney'                             => 'chimney',
        'fad fa-church'                              => 'church',
        'fad fa-circle'                              => 'circle',
        'fad fa-circle-notch'                        => 'circle-notch',
        'fad fa-city'                                => 'city',
        'fad fa-claw-marks'                          => 'claw-marks',
        'fad fa-clinic-medical'                      => 'clinic-medical',
        'fad fa-clipboard'                           => 'clipboard',
        'fad fa-clipboard-check'                     => 'clipboard-check',
        'fad fa-clipboard-list'                      => 'clipboard-list',
        'fad fa-clipboard-list-check'                => 'clipboard-list-check',
        'fad fa-clipboard-prescription'              => 'clipboard-prescription',
        'fad fa-clipboard-user'                      => 'clipboard-user',
        'fad fa-clock'                               => 'clock',
        'fad fa-clone'                               => 'clone',
        'fad fa-closed-captioning'                   => 'closed-captioning',
        'fad fa-cloud'                               => 'cloud',
        'fad fa-cloud-download'                      => 'cloud-download',
        'fad fa-cloud-download-alt'                  => 'cloud-download-alt',
        'fad fa-cloud-drizzle'                       => 'cloud-drizzle',
        'fad fa-cloud-hail'                          => 'cloud-hail',
        'fad fa-cloud-hail-mixed'                    => 'cloud-hail-mixed',
        'fad fa-cloud-meatball'                      => 'cloud-meatball',
        'fad fa-cloud-moon'                          => 'cloud-moon',
        'fad fa-cloud-moon-rain'                     => 'cloud-moon-rain',
        'fad fa-cloud-rain'                          => 'cloud-rain',
        'fad fa-cloud-rainbow'                       => 'cloud-rainbow',
        'fad fa-cloud-showers'                       => 'cloud-showers',
        'fad fa-cloud-showers-heavy'                 => 'cloud-showers-heavy',
        'fad fa-cloud-sleet'                         => 'cloud-sleet',
        'fad fa-cloud-snow'                          => 'cloud-snow',
        'fad fa-cloud-sun'                           => 'cloud-sun',
        'fad fa-cloud-sun-rain'                      => 'cloud-sun-rain',
        'fad fa-cloud-upload'                        => 'cloud-upload',
        'fad fa-cloud-upload-alt'                    => 'cloud-upload-alt',
        'fad fa-clouds'                              => 'clouds',
        'fad fa-clouds-moon'                         => 'clouds-moon',
        'fad fa-clouds-sun'                          => 'clouds-sun',
        'fad fa-club'                                => 'club',
        'fad fa-cocktail'                            => 'cocktail',
        'fad fa-code'                                => 'code',
        'fad fa-code-branch'                         => 'code-branch',
        'fad fa-code-commit'                         => 'code-commit',
        'fad fa-code-merge'                          => 'code-merge',
        'fad fa-coffee'                              => 'coffee',
        'fad fa-coffee-togo'                         => 'coffee-togo',
        'fad fa-coffin'                              => 'coffin',
        'fad fa-cog'                                 => 'cog',
        'fad fa-cogs'                                => 'cogs',
        'fad fa-coin'                                => 'coin',
        'fad fa-coins'                               => 'coins',
        'fad fa-columns'                             => 'columns',
        'fad fa-comment'                             => 'comment',
        'fad fa-comment-alt'                         => 'comment-alt',
        'fad fa-comment-alt-check'                   => 'comment-alt-check',
        'fad fa-comment-alt-dollar'                  => 'comment-alt-dollar',
        'fad fa-comment-alt-dots'                    => 'comment-alt-dots',
        'fad fa-comment-alt-edit'                    => 'comment-alt-edit',
        'fad fa-comment-alt-exclamation'             => 'comment-alt-exclamation',
        'fad fa-comment-alt-lines'                   => 'comment-alt-lines',
        'fad fa-comment-alt-medical'                 => 'comment-alt-medical',
        'fad fa-comment-alt-minus'                   => 'comment-alt-minus',
        'fad fa-comment-alt-plus'                    => 'comment-alt-plus',
        'fad fa-comment-alt-slash'                   => 'comment-alt-slash',
        'fad fa-comment-alt-smile'                   => 'comment-alt-smile',
        'fad fa-comment-alt-times'                   => 'comment-alt-times',
        'fad fa-comment-check'                       => 'comment-check',
        'fad fa-comment-dollar'                      => 'comment-dollar',
        'fad fa-comment-dots'                        => 'comment-dots',
        'fad fa-comment-edit'                        => 'comment-edit',
        'fad fa-comment-exclamation'                 => 'comment-exclamation',
        'fad fa-comment-lines'                       => 'comment-lines',
        'fad fa-comment-medical'                     => 'comment-medical',
        'fad fa-comment-minus'                       => 'comment-minus',
        'fad fa-comment-plus'                        => 'comment-plus',
        'fad fa-comment-slash'                       => 'comment-slash',
        'fad fa-comment-smile'                       => 'comment-smile',
        'fad fa-comment-times'                       => 'comment-times',
        'fad fa-comments'                            => 'comments',
        'fad fa-comments-alt'                        => 'comments-alt',
        'fad fa-comments-alt-dollar'                 => 'comments-alt-dollar',
        'fad fa-comments-dollar'                     => 'comments-dollar',
        'fad fa-compact-disc'                        => 'compact-disc',
        'fad fa-compass'                             => 'compass',
        'fad fa-compass-slash'                       => 'compass-slash',
        'fad fa-compress'                            => 'compress',
        'fad fa-compress-alt'                        => 'compress-alt',
        'fad fa-compress-arrows-alt'                 => 'compress-arrows-alt',
        'fad fa-compress-wide'                       => 'compress-wide',
        'fad fa-concierge-bell'                      => 'concierge-bell',
        'fad fa-construction'                        => 'construction',
        'fad fa-container-storage'                   => 'container-storage',
        'fad fa-conveyor-belt'                       => 'conveyor-belt',
        'fad fa-conveyor-belt-alt'                   => 'conveyor-belt-alt',
        'fad fa-cookie'                              => 'cookie',
        'fad fa-cookie-bite'                         => 'cookie-bite',
        'fad fa-copy'                                => 'copy',
        'fad fa-copyright'                           => 'copyright',
        'fad fa-corn'                                => 'corn',
        'fad fa-couch'                               => 'couch',
        'fad fa-cow'                                 => 'cow',
        'fad fa-credit-card'                         => 'credit-card',
        'fad fa-credit-card-blank'                   => 'credit-card-blank',
        'fad fa-credit-card-front'                   => 'credit-card-front',
        'fad fa-cricket'                             => 'cricket',
        'fad fa-croissant'                           => 'croissant',
        'fad fa-crop'                                => 'crop',
        'fad fa-crop-alt'                            => 'crop-alt',
        'fad fa-cross'                               => 'cross',
        'fad fa-crosshairs'                          => 'crosshairs',
        'fad fa-crow'                                => 'crow',
        'fad fa-crown'                               => 'crown',
        'fad fa-crutch'                              => 'crutch',
        'fad fa-crutches'                            => 'crutches',
        'fad fa-cube'                                => 'cube',
        'fad fa-cubes'                               => 'cubes',
        'fad fa-curling'                             => 'curling',
        'fad fa-cut'                                 => 'cut',
        'fad fa-dagger'                              => 'dagger',
        'fad fa-database'                            => 'database',
        'fad fa-deaf'                                => 'deaf',
        'fad fa-debug'                               => 'debug',
        'fad fa-deer'                                => 'deer',
        'fad fa-deer-rudolph'                        => 'deer-rudolph',
        'fad fa-democrat'                            => 'democrat',
        'fad fa-desktop'                             => 'desktop',
        'fad fa-desktop-alt'                         => 'desktop-alt',
        'fad fa-dewpoint'                            => 'dewpoint',
        'fad fa-dharmachakra'                        => 'dharmachakra',
        'fad fa-diagnoses'                           => 'diagnoses',
        'fad fa-diamond'                             => 'diamond',
        'fad fa-dice'                                => 'dice',
        'fad fa-dice-d10'                            => 'dice-d10',
        'fad fa-dice-d12'                            => 'dice-d12',
        'fad fa-dice-d20'                            => 'dice-d20',
        'fad fa-dice-d4'                             => 'dice-d4',
        'fad fa-dice-d6'                             => 'dice-d6',
        'fad fa-dice-d8'                             => 'dice-d8',
        'fad fa-dice-five'                           => 'dice-five',
        'fad fa-dice-four'                           => 'dice-four',
        'fad fa-dice-one'                            => 'dice-one',
        'fad fa-dice-six'                            => 'dice-six',
        'fad fa-dice-three'                          => 'dice-three',
        'fad fa-dice-two'                            => 'dice-two',
        'fad fa-digging'                             => 'digging',
        'fad fa-digital-tachograph'                  => 'digital-tachograph',
        'fad fa-diploma'                             => 'diploma',
        'fad fa-directions'                          => 'directions',
        'fad fa-disease'                             => 'disease',
        'fad fa-divide'                              => 'divide',
        'fad fa-dizzy'                               => 'dizzy',
        'fad fa-dna'                                 => 'dna',
        'fad fa-do-not-enter'                        => 'do-not-enter',
        'fad fa-dog'                                 => 'dog',
        'fad fa-dog-leashed'                         => 'dog-leashed',
        'fad fa-dollar-sign'                         => 'dollar-sign',
        'fad fa-dolly'                               => 'dolly',
        'fad fa-dolly-empty'                         => 'dolly-empty',
        'fad fa-dolly-flatbed'                       => 'dolly-flatbed',
        'fad fa-dolly-flatbed-alt'                   => 'dolly-flatbed-alt',
        'fad fa-dolly-flatbed-empty'                 => 'dolly-flatbed-empty',
        'fad fa-donate'                              => 'donate',
        'fad fa-door-closed'                         => 'door-closed',
        'fad fa-door-open'                           => 'door-open',
        'fad fa-dot-circle'                          => 'dot-circle',
        'fad fa-dove'                                => 'dove',
        'fad fa-download'                            => 'download',
        'fad fa-drafting-compass'                    => 'drafting-compass',
        'fad fa-dragon'                              => 'dragon',
        'fad fa-draw-circle'                         => 'draw-circle',
        'fad fa-draw-polygon'                        => 'draw-polygon',
        'fad fa-draw-square'                         => 'draw-square',
        'fad fa-dreidel'                             => 'dreidel',
        'fad fa-drone'                               => 'drone',
        'fad fa-drone-alt'                           => 'drone-alt',
        'fad fa-drum'                                => 'drum',
        'fad fa-drum-steelpan'                       => 'drum-steelpan',
        'fad fa-drumstick'                           => 'drumstick',
        'fad fa-drumstick-bite'                      => 'drumstick-bite',
        'fad fa-dryer'                               => 'dryer',
        'fad fa-dryer-alt'                           => 'dryer-alt',
        'fad fa-duck'                                => 'duck',
        'fad fa-dumbbell'                            => 'dumbbell',
        'fad fa-dumpster'                            => 'dumpster',
        'fad fa-dumpster-fire'                       => 'dumpster-fire',
        'fad fa-dungeon'                             => 'dungeon',
        'fad fa-ear'                                 => 'ear',
        'fad fa-ear-muffs'                           => 'ear-muffs',
        'fad fa-eclipse'                             => 'eclipse',
        'fad fa-eclipse-alt'                         => 'eclipse-alt',
        'fad fa-edit'                                => 'edit',
        'fad fa-egg'                                 => 'egg',
        'fad fa-egg-fried'                           => 'egg-fried',
        'fad fa-eject'                               => 'eject',
        'fad fa-elephant'                            => 'elephant',
        'fad fa-ellipsis-h'                          => 'ellipsis-h',
        'fad fa-ellipsis-h-alt'                      => 'ellipsis-h-alt',
        'fad fa-ellipsis-v'                          => 'ellipsis-v',
        'fad fa-ellipsis-v-alt'                      => 'ellipsis-v-alt',
        'fad fa-empty-set'                           => 'empty-set',
        'fad fa-engine-warning'                      => 'engine-warning',
        'fad fa-envelope'                            => 'envelope',
        'fad fa-envelope-open'                       => 'envelope-open',
        'fad fa-envelope-open-dollar'                => 'envelope-open-dollar',
        'fad fa-envelope-open-text'                  => 'envelope-open-text',
        'fad fa-envelope-square'                     => 'envelope-square',
        'fad fa-equals'                              => 'equals',
        'fad fa-eraser'                              => 'eraser',
        'fad fa-ethernet'                            => 'ethernet',
        'fad fa-euro-sign'                           => 'euro-sign',
        'fad fa-exchange'                            => 'exchange',
        'fad fa-exchange-alt'                        => 'exchange-alt',
        'fad fa-exclamation'                         => 'exclamation',
        'fad fa-exclamation-circle'                  => 'exclamation-circle',
        'fad fa-exclamation-square'                  => 'exclamation-square',
        'fad fa-exclamation-triangle'                => 'exclamation-triangle',
        'fad fa-expand'                              => 'expand',
        'fad fa-expand-alt'                          => 'expand-alt',
        'fad fa-expand-arrows'                       => 'expand-arrows',
        'fad fa-expand-arrows-alt'                   => 'expand-arrows-alt',
        'fad fa-expand-wide'                         => 'expand-wide',
        'fad fa-external-link'                       => 'external-link',
        'fad fa-external-link-alt'                   => 'external-link-alt',
        'fad fa-external-link-square'                => 'external-link-square',
        'fad fa-external-link-square-alt'            => 'external-link-square-alt',
        'fad fa-eye'                                 => 'eye',
        'fad fa-eye-dropper'                         => 'eye-dropper',
        'fad fa-eye-evil'                            => 'eye-evil',
        'fad fa-eye-slash'                           => 'eye-slash',
        'fad fa-fan'                                 => 'fan',
        'fad fa-farm'                                => 'farm',
        'fad fa-fast-backward'                       => 'fast-backward',
        'fad fa-fast-forward'                        => 'fast-forward',
        'fad fa-fax'                                 => 'fax',
        'fad fa-feather'                             => 'feather',
        'fad fa-feather-alt'                         => 'feather-alt',
        'fad fa-female'                              => 'female',
        'fad fa-field-hockey'                        => 'field-hockey',
        'fad fa-fighter-jet'                         => 'fighter-jet',
        'fad fa-file'                                => 'file',
        'fad fa-file-alt'                            => 'file-alt',
        'fad fa-file-archive'                        => 'file-archive',
        'fad fa-file-audio'                          => 'file-audio',
        'fad fa-file-certificate'                    => 'file-certificate',
        'fad fa-file-chart-line'                     => 'file-chart-line',
        'fad fa-file-chart-pie'                      => 'file-chart-pie',
        'fad fa-file-check'                          => 'file-check',
        'fad fa-file-code'                           => 'file-code',
        'fad fa-file-contract'                       => 'file-contract',
        'fad fa-file-csv'                            => 'file-csv',
        'fad fa-file-download'                       => 'file-download',
        'fad fa-file-edit'                           => 'file-edit',
        'fad fa-file-excel'                          => 'file-excel',
        'fad fa-file-exclamation'                    => 'file-exclamation',
        'fad fa-file-export'                         => 'file-export',
        'fad fa-file-image'                          => 'file-image',
        'fad fa-file-import'                         => 'file-import',
        'fad fa-file-invoice'                        => 'file-invoice',
        'fad fa-file-invoice-dollar'                 => 'file-invoice-dollar',
        'fad fa-file-medical'                        => 'file-medical',
        'fad fa-file-medical-alt'                    => 'file-medical-alt',
        'fad fa-file-minus'                          => 'file-minus',
        'fad fa-file-pdf'                            => 'file-pdf',
        'fad fa-file-plus'                           => 'file-plus',
        'fad fa-file-powerpoint'                     => 'file-powerpoint',
        'fad fa-file-prescription'                   => 'file-prescription',
        'fad fa-file-search'                         => 'file-search',
        'fad fa-file-signature'                      => 'file-signature',
        'fad fa-file-spreadsheet'                    => 'file-spreadsheet',
        'fad fa-file-times'                          => 'file-times',
        'fad fa-file-upload'                         => 'file-upload',
        'fad fa-file-user'                           => 'file-user',
        'fad fa-file-video'                          => 'file-video',
        'fad fa-file-word'                           => 'file-word',
        'fad fa-files-medical'                       => 'files-medical',
        'fad fa-fill'                                => 'fill',
        'fad fa-fill-drip'                           => 'fill-drip',
        'fad fa-film'                                => 'film',
        'fad fa-film-alt'                            => 'film-alt',
        'fad fa-filter'                              => 'filter',
        'fad fa-fingerprint'                         => 'fingerprint',
        'fad fa-fire'                                => 'fire',
        'fad fa-fire-alt'                            => 'fire-alt',
        'fad fa-fire-extinguisher'                   => 'fire-extinguisher',
        'fad fa-fire-smoke'                          => 'fire-smoke',
        'fad fa-fireplace'                           => 'fireplace',
        'fad fa-first-aid'                           => 'first-aid',
        'fad fa-fish'                                => 'fish',
        'fad fa-fish-cooked'                         => 'fish-cooked',
        'fad fa-fist-raised'                         => 'fist-raised',
        'fad fa-flag'                                => 'flag',
        'fad fa-flag-alt'                            => 'flag-alt',
        'fad fa-flag-checkered'                      => 'flag-checkered',
        'fad fa-flag-usa'                            => 'flag-usa',
        'fad fa-flame'                               => 'flame',
        'fad fa-flask'                               => 'flask',
        'fad fa-flask-poison'                        => 'flask-poison',
        'fad fa-flask-potion'                        => 'flask-potion',
        'fad fa-flower'                              => 'flower',
        'fad fa-flower-daffodil'                     => 'flower-daffodil',
        'fad fa-flower-tulip'                        => 'flower-tulip',
        'fad fa-flushed'                             => 'flushed',
        'fad fa-fog'                                 => 'fog',
        'fad fa-folder'                              => 'folder',
        'fad fa-folder-minus'                        => 'folder-minus',
        'fad fa-folder-open'                         => 'folder-open',
        'fad fa-folder-plus'                         => 'folder-plus',
        'fad fa-folder-times'                        => 'folder-times',
        'fad fa-folder-tree'                         => 'folder-tree',
        'fad fa-folders'                             => 'folders',
        'fad fa-font'                                => 'font',
        'fad fa-font-awesome-logo-full'              => 'font-awesome-logo-full',
        'fad fa-font-case'                           => 'font-case',
        'fad fa-football-ball'                       => 'football-ball',
        'fad fa-football-helmet'                     => 'football-helmet',
        'fad fa-forklift'                            => 'forklift',
        'fad fa-forward'                             => 'forward',
        'fad fa-fragile'                             => 'fragile',
        'fad fa-french-fries'                        => 'french-fries',
        'fad fa-frog'                                => 'frog',
        'fad fa-frosty-head'                         => 'frosty-head',
        'fad fa-frown'                               => 'frown',
        'fad fa-frown-open'                          => 'frown-open',
        'fad fa-function'                            => 'function',
        'fad fa-funnel-dollar'                       => 'funnel-dollar',
        'fad fa-futbol'                              => 'futbol',
        'fad fa-game-board'                          => 'game-board',
        'fad fa-game-board-alt'                      => 'game-board-alt',
        'fad fa-gamepad'                             => 'gamepad',
        'fad fa-gas-pump'                            => 'gas-pump',
        'fad fa-gas-pump-slash'                      => 'gas-pump-slash',
        'fad fa-gavel'                               => 'gavel',
        'fad fa-gem'                                 => 'gem',
        'fad fa-genderless'                          => 'genderless',
        'fad fa-ghost'                               => 'ghost',
        'fad fa-gift'                                => 'gift',
        'fad fa-gift-card'                           => 'gift-card',
        'fad fa-gifts'                               => 'gifts',
        'fad fa-gingerbread-man'                     => 'gingerbread-man',
        'fad fa-glass'                               => 'glass',
        'fad fa-glass-champagne'                     => 'glass-champagne',
        'fad fa-glass-cheers'                        => 'glass-cheers',
        'fad fa-glass-citrus'                        => 'glass-citrus',
        'fad fa-glass-martini'                       => 'glass-martini',
        'fad fa-glass-martini-alt'                   => 'glass-martini-alt',
        'fad fa-glass-whiskey'                       => 'glass-whiskey',
        'fad fa-glass-whiskey-rocks'                 => 'glass-whiskey-rocks',
        'fad fa-glasses'                             => 'glasses',
        'fad fa-glasses-alt'                         => 'glasses-alt',
        'fad fa-globe'                               => 'globe',
        'fad fa-globe-africa'                        => 'globe-africa',
        'fad fa-globe-americas'                      => 'globe-americas',
        'fad fa-globe-asia'                          => 'globe-asia',
        'fad fa-globe-europe'                        => 'globe-europe',
        'fad fa-globe-snow'                          => 'globe-snow',
        'fad fa-globe-stand'                         => 'globe-stand',
        'fad fa-golf-ball'                           => 'golf-ball',
        'fad fa-golf-club'                           => 'golf-club',
        'fad fa-gopuram'                             => 'gopuram',
        'fad fa-graduation-cap'                      => 'graduation-cap',
        'fad fa-greater-than'                        => 'greater-than',
        'fad fa-greater-than-equal'                  => 'greater-than-equal',
        'fad fa-grimace'                             => 'grimace',
        'fad fa-grin'                                => 'grin',
        'fad fa-grin-alt'                            => 'grin-alt',
        'fad fa-grin-beam'                           => 'grin-beam',
        'fad fa-grin-beam-sweat'                     => 'grin-beam-sweat',
        'fad fa-grin-hearts'                         => 'grin-hearts',
        'fad fa-grin-squint'                         => 'grin-squint',
        'fad fa-grin-squint-tears'                   => 'grin-squint-tears',
        'fad fa-grin-stars'                          => 'grin-stars',
        'fad fa-grin-tears'                          => 'grin-tears',
        'fad fa-grin-tongue'                         => 'grin-tongue',
        'fad fa-grin-tongue-squint'                  => 'grin-tongue-squint',
        'fad fa-grin-tongue-wink'                    => 'grin-tongue-wink',
        'fad fa-grin-wink'                           => 'grin-wink',
        'fad fa-grip-horizontal'                     => 'grip-horizontal',
        'fad fa-grip-lines'                          => 'grip-lines',
        'fad fa-grip-lines-vertical'                 => 'grip-lines-vertical',
        'fad fa-grip-vertical'                       => 'grip-vertical',
        'fad fa-guitar'                              => 'guitar',
        'fad fa-h-square'                            => 'h-square',
        'fad fa-h1'                                  => 'h1',
        'fad fa-h2'                                  => 'h2',
        'fad fa-h3'                                  => 'h3',
        'fad fa-h4'                                  => 'h4',
        'fad fa-hamburger'                           => 'hamburger',
        'fad fa-hammer'                              => 'hammer',
        'fad fa-hammer-war'                          => 'hammer-war',
        'fad fa-hamsa'                               => 'hamsa',
        'fad fa-hand-heart'                          => 'hand-heart',
        'fad fa-hand-holding'                        => 'hand-holding',
        'fad fa-hand-holding-box'                    => 'hand-holding-box',
        'fad fa-hand-holding-heart'                  => 'hand-holding-heart',
        'fad fa-hand-holding-magic'                  => 'hand-holding-magic',
        'fad fa-hand-holding-seedling'               => 'hand-holding-seedling',
        'fad fa-hand-holding-usd'                    => 'hand-holding-usd',
        'fad fa-hand-holding-water'                  => 'hand-holding-water',
        'fad fa-hand-lizard'                         => 'hand-lizard',
        'fad fa-hand-middle-finger'                  => 'hand-middle-finger',
        'fad fa-hand-paper'                          => 'hand-paper',
        'fad fa-hand-peace'                          => 'hand-peace',
        'fad fa-hand-point-down'                     => 'hand-point-down',
        'fad fa-hand-point-left'                     => 'hand-point-left',
        'fad fa-hand-point-right'                    => 'hand-point-right',
        'fad fa-hand-point-up'                       => 'hand-point-up',
        'fad fa-hand-pointer'                        => 'hand-pointer',
        'fad fa-hand-receiving'                      => 'hand-receiving',
        'fad fa-hand-rock'                           => 'hand-rock',
        'fad fa-hand-scissors'                       => 'hand-scissors',
        'fad fa-hand-spock'                          => 'hand-spock',
        'fad fa-hands'                               => 'hands',
        'fad fa-hands-heart'                         => 'hands-heart',
        'fad fa-hands-helping'                       => 'hands-helping',
        'fad fa-hands-usd'                           => 'hands-usd',
        'fad fa-handshake'                           => 'handshake',
        'fad fa-handshake-alt'                       => 'handshake-alt',
        'fad fa-hanukiah'                            => 'hanukiah',
        'fad fa-hard-hat'                            => 'hard-hat',
        'fad fa-hashtag'                             => 'hashtag',
        'fad fa-hat-chef'                            => 'hat-chef',
        'fad fa-hat-santa'                           => 'hat-santa',
        'fad fa-hat-winter'                          => 'hat-winter',
        'fad fa-hat-witch'                           => 'hat-witch',
        'fad fa-hat-wizard'                          => 'hat-wizard',
        'fad fa-haykal'                              => 'haykal',
        'fad fa-hdd'                                 => 'hdd',
        'fad fa-head-side'                           => 'head-side',
        'fad fa-head-side-brain'                     => 'head-side-brain',
        'fad fa-head-side-medical'                   => 'head-side-medical',
        'fad fa-head-vr'                             => 'head-vr',
        'fad fa-heading'                             => 'heading',
        'fad fa-headphones'                          => 'headphones',
        'fad fa-headphones-alt'                      => 'headphones-alt',
        'fad fa-headset'                             => 'headset',
        'fad fa-heart'                               => 'heart',
        'fad fa-heart-broken'                        => 'heart-broken',
        'fad fa-heart-circle'                        => 'heart-circle',
        'fad fa-heart-rate'                          => 'heart-rate',
        'fad fa-heart-square'                        => 'heart-square',
        'fad fa-heartbeat'                           => 'heartbeat',
        'fad fa-helicopter'                          => 'helicopter',
        'fad fa-helmet-battle'                       => 'helmet-battle',
        'fad fa-hexagon'                             => 'hexagon',
        'fad fa-highlighter'                         => 'highlighter',
        'fad fa-hiking'                              => 'hiking',
        'fad fa-hippo'                               => 'hippo',
        'fad fa-history'                             => 'history',
        'fad fa-hockey-mask'                         => 'hockey-mask',
        'fad fa-hockey-puck'                         => 'hockey-puck',
        'fad fa-hockey-sticks'                       => 'hockey-sticks',
        'fad fa-holly-berry'                         => 'holly-berry',
        'fad fa-home'                                => 'home',
        'fad fa-home-alt'                            => 'home-alt',
        'fad fa-home-heart'                          => 'home-heart',
        'fad fa-home-lg'                             => 'home-lg',
        'fad fa-home-lg-alt'                         => 'home-lg-alt',
        'fad fa-hood-cloak'                          => 'hood-cloak',
        'fad fa-horizontal-rule'                     => 'horizontal-rule',
        'fad fa-horse'                               => 'horse',
        'fad fa-horse-head'                          => 'horse-head',
        'fad fa-hospital'                            => 'hospital',
        'fad fa-hospital-alt'                        => 'hospital-alt',
        'fad fa-hospital-symbol'                     => 'hospital-symbol',
        'fad fa-hospital-user'                       => 'hospital-user',
        'fad fa-hospitals'                           => 'hospitals',
        'fad fa-hot-tub'                             => 'hot-tub',
        'fad fa-hotdog'                              => 'hotdog',
        'fad fa-hotel'                               => 'hotel',
        'fad fa-hourglass'                           => 'hourglass',
        'fad fa-hourglass-end'                       => 'hourglass-end',
        'fad fa-hourglass-half'                      => 'hourglass-half',
        'fad fa-hourglass-start'                     => 'hourglass-start',
        'fad fa-house-damage'                        => 'house-damage',
        'fad fa-house-flood'                         => 'house-flood',
        'fad fa-hryvnia'                             => 'hryvnia',
        'fad fa-humidity'                            => 'humidity',
        'fad fa-hurricane'                           => 'hurricane',
        'fad fa-i-cursor'                            => 'i-cursor',
        'fad fa-ice-cream'                           => 'ice-cream',
        'fad fa-ice-skate'                           => 'ice-skate',
        'fad fa-icicles'                             => 'icicles',
        'fad fa-icons'                               => 'icons',
        'fad fa-icons-alt'                           => 'icons-alt',
        'fad fa-id-badge'                            => 'id-badge',
        'fad fa-id-card'                             => 'id-card',
        'fad fa-id-card-alt'                         => 'id-card-alt',
        'fad fa-igloo'                               => 'igloo',
        'fad fa-image'                               => 'image',
        'fad fa-images'                              => 'images',
        'fad fa-inbox'                               => 'inbox',
        'fad fa-inbox-in'                            => 'inbox-in',
        'fad fa-inbox-out'                           => 'inbox-out',
        'fad fa-indent'                              => 'indent',
        'fad fa-industry'                            => 'industry',
        'fad fa-industry-alt'                        => 'industry-alt',
        'fad fa-infinity'                            => 'infinity',
        'fad fa-info'                                => 'info',
        'fad fa-info-circle'                         => 'info-circle',
        'fad fa-info-square'                         => 'info-square',
        'fad fa-inhaler'                             => 'inhaler',
        'fad fa-integral'                            => 'integral',
        'fad fa-intersection'                        => 'intersection',
        'fad fa-inventory'                           => 'inventory',
        'fad fa-island-tropical'                     => 'island-tropical',
        'fad fa-italic'                              => 'italic',
        'fad fa-jack-o-lantern'                      => 'jack-o-lantern',
        'fad fa-jedi'                                => 'jedi',
        'fad fa-joint'                               => 'joint',
        'fad fa-journal-whills'                      => 'journal-whills',
        'fad fa-kaaba'                               => 'kaaba',
        'fad fa-kerning'                             => 'kerning',
        'fad fa-key'                                 => 'key',
        'fad fa-key-skeleton'                        => 'key-skeleton',
        'fad fa-keyboard'                            => 'keyboard',
        'fad fa-keynote'                             => 'keynote',
        'fad fa-khanda'                              => 'khanda',
        'fad fa-kidneys'                             => 'kidneys',
        'fad fa-kiss'                                => 'kiss',
        'fad fa-kiss-beam'                           => 'kiss-beam',
        'fad fa-kiss-wink-heart'                     => 'kiss-wink-heart',
        'fad fa-kite'                                => 'kite',
        'fad fa-kiwi-bird'                           => 'kiwi-bird',
        'fad fa-knife-kitchen'                       => 'knife-kitchen',
        'fad fa-lambda'                              => 'lambda',
        'fad fa-lamp'                                => 'lamp',
        'fad fa-landmark'                            => 'landmark',
        'fad fa-landmark-alt'                        => 'landmark-alt',
        'fad fa-language'                            => 'language',
        'fad fa-laptop'                              => 'laptop',
        'fad fa-laptop-code'                         => 'laptop-code',
        'fad fa-laptop-medical'                      => 'laptop-medical',
        'fad fa-laugh'                               => 'laugh',
        'fad fa-laugh-beam'                          => 'laugh-beam',
        'fad fa-laugh-squint'                        => 'laugh-squint',
        'fad fa-laugh-wink'                          => 'laugh-wink',
        'fad fa-layer-group'                         => 'layer-group',
        'fad fa-layer-minus'                         => 'layer-minus',
        'fad fa-layer-plus'                          => 'layer-plus',
        'fad fa-leaf'                                => 'leaf',
        'fad fa-leaf-heart'                          => 'leaf-heart',
        'fad fa-leaf-maple'                          => 'leaf-maple',
        'fad fa-leaf-oak'                            => 'leaf-oak',
        'fad fa-lemon'                               => 'lemon',
        'fad fa-less-than'                           => 'less-than',
        'fad fa-less-than-equal'                     => 'less-than-equal',
        'fad fa-level-down'                          => 'level-down',
        'fad fa-level-down-alt'                      => 'level-down-alt',
        'fad fa-level-up'                            => 'level-up',
        'fad fa-level-up-alt'                        => 'level-up-alt',
        'fad fa-life-ring'                           => 'life-ring',
        'fad fa-lightbulb'                           => 'lightbulb',
        'fad fa-lightbulb-dollar'                    => 'lightbulb-dollar',
        'fad fa-lightbulb-exclamation'               => 'lightbulb-exclamation',
        'fad fa-lightbulb-on'                        => 'lightbulb-on',
        'fad fa-lightbulb-slash'                     => 'lightbulb-slash',
        'fad fa-lights-holiday'                      => 'lights-holiday',
        'fad fa-line-columns'                        => 'line-columns',
        'fad fa-line-height'                         => 'line-height',
        'fad fa-link'                                => 'link',
        'fad fa-lips'                                => 'lips',
        'fad fa-lira-sign'                           => 'lira-sign',
        'fad fa-list'                                => 'list',
        'fad fa-list-alt'                            => 'list-alt',
        'fad fa-list-ol'                             => 'list-ol',
        'fad fa-list-ul'                             => 'list-ul',
        'fad fa-location'                            => 'location',
        'fad fa-location-arrow'                      => 'location-arrow',
        'fad fa-location-circle'                     => 'location-circle',
        'fad fa-location-slash'                      => 'location-slash',
        'fad fa-lock'                                => 'lock',
        'fad fa-lock-alt'                            => 'lock-alt',
        'fad fa-lock-open'                           => 'lock-open',
        'fad fa-lock-open-alt'                       => 'lock-open-alt',
        'fad fa-long-arrow-alt-down'                 => 'long-arrow-alt-down',
        'fad fa-long-arrow-alt-left'                 => 'long-arrow-alt-left',
        'fad fa-long-arrow-alt-right'                => 'long-arrow-alt-right',
        'fad fa-long-arrow-alt-up'                   => 'long-arrow-alt-up',
        'fad fa-long-arrow-down'                     => 'long-arrow-down',
        'fad fa-long-arrow-left'                     => 'long-arrow-left',
        'fad fa-long-arrow-right'                    => 'long-arrow-right',
        'fad fa-long-arrow-up'                       => 'long-arrow-up',
        'fad fa-loveseat'                            => 'loveseat',
        'fad fa-low-vision'                          => 'low-vision',
        'fad fa-luchador'                            => 'luchador',
        'fad fa-luggage-cart'                        => 'luggage-cart',
        'fad fa-lungs'                               => 'lungs',
        'fad fa-mace'                                => 'mace',
        'fad fa-magic'                               => 'magic',
        'fad fa-magnet'                              => 'magnet',
        'fad fa-mail-bulk'                           => 'mail-bulk',
        'fad fa-mailbox'                             => 'mailbox',
        'fad fa-male'                                => 'male',
        'fad fa-mandolin'                            => 'mandolin',
        'fad fa-map'                                 => 'map',
        'fad fa-map-marked'                          => 'map-marked',
        'fad fa-map-marked-alt'                      => 'map-marked-alt',
        'fad fa-map-marker'                          => 'map-marker',
        'fad fa-map-marker-alt'                      => 'map-marker-alt',
        'fad fa-map-marker-alt-slash'                => 'map-marker-alt-slash',
        'fad fa-map-marker-check'                    => 'map-marker-check',
        'fad fa-map-marker-edit'                     => 'map-marker-edit',
        'fad fa-map-marker-exclamation'              => 'map-marker-exclamation',
        'fad fa-map-marker-minus'                    => 'map-marker-minus',
        'fad fa-map-marker-plus'                     => 'map-marker-plus',
        'fad fa-map-marker-question'                 => 'map-marker-question',
        'fad fa-map-marker-slash'                    => 'map-marker-slash',
        'fad fa-map-marker-smile'                    => 'map-marker-smile',
        'fad fa-map-marker-times'                    => 'map-marker-times',
        'fad fa-map-pin'                             => 'map-pin',
        'fad fa-map-signs'                           => 'map-signs',
        'fad fa-marker'                              => 'marker',
        'fad fa-mars'                                => 'mars',
        'fad fa-mars-double'                         => 'mars-double',
        'fad fa-mars-stroke'                         => 'mars-stroke',
        'fad fa-mars-stroke-h'                       => 'mars-stroke-h',
        'fad fa-mars-stroke-v'                       => 'mars-stroke-v',
        'fad fa-mask'                                => 'mask',
        'fad fa-meat'                                => 'meat',
        'fad fa-medal'                               => 'medal',
        'fad fa-medkit'                              => 'medkit',
        'fad fa-megaphone'                           => 'megaphone',
        'fad fa-meh'                                 => 'meh',
        'fad fa-meh-blank'                           => 'meh-blank',
        'fad fa-meh-rolling-eyes'                    => 'meh-rolling-eyes',
        'fad fa-memory'                              => 'memory',
        'fad fa-menorah'                             => 'menorah',
        'fad fa-mercury'                             => 'mercury',
        'fad fa-meteor'                              => 'meteor',
        'fad fa-microchip'                           => 'microchip',
        'fad fa-microphone'                          => 'microphone',
        'fad fa-microphone-alt'                      => 'microphone-alt',
        'fad fa-microphone-alt-slash'                => 'microphone-alt-slash',
        'fad fa-microphone-slash'                    => 'microphone-slash',
        'fad fa-microscope'                          => 'microscope',
        'fad fa-mind-share'                          => 'mind-share',
        'fad fa-minus'                               => 'minus',
        'fad fa-minus-circle'                        => 'minus-circle',
        'fad fa-minus-hexagon'                       => 'minus-hexagon',
        'fad fa-minus-octagon'                       => 'minus-octagon',
        'fad fa-minus-square'                        => 'minus-square',
        'fad fa-mistletoe'                           => 'mistletoe',
        'fad fa-mitten'                              => 'mitten',
        'fad fa-mobile'                              => 'mobile',
        'fad fa-mobile-alt'                          => 'mobile-alt',
        'fad fa-mobile-android'                      => 'mobile-android',
        'fad fa-mobile-android-alt'                  => 'mobile-android-alt',
        'fad fa-money-bill'                          => 'money-bill',
        'fad fa-money-bill-alt'                      => 'money-bill-alt',
        'fad fa-money-bill-wave'                     => 'money-bill-wave',
        'fad fa-money-bill-wave-alt'                 => 'money-bill-wave-alt',
        'fad fa-money-check'                         => 'money-check',
        'fad fa-money-check-alt'                     => 'money-check-alt',
        'fad fa-money-check-edit'                    => 'money-check-edit',
        'fad fa-money-check-edit-alt'                => 'money-check-edit-alt',
        'fad fa-monitor-heart-rate'                  => 'monitor-heart-rate',
        'fad fa-monkey'                              => 'monkey',
        'fad fa-monument'                            => 'monument',
        'fad fa-moon'                                => 'moon',
        'fad fa-moon-cloud'                          => 'moon-cloud',
        'fad fa-moon-stars'                          => 'moon-stars',
        'fad fa-mortar-pestle'                       => 'mortar-pestle',
        'fad fa-mosque'                              => 'mosque',
        'fad fa-motorcycle'                          => 'motorcycle',
        'fad fa-mountain'                            => 'mountain',
        'fad fa-mountains'                           => 'mountains',
        'fad fa-mouse-pointer'                       => 'mouse-pointer',
        'fad fa-mug'                                 => 'mug',
        'fad fa-mug-hot'                             => 'mug-hot',
        'fad fa-mug-marshmallows'                    => 'mug-marshmallows',
        'fad fa-mug-tea'                             => 'mug-tea',
        'fad fa-music'                               => 'music',
        'fad fa-narwhal'                             => 'narwhal',
        'fad fa-network-wired'                       => 'network-wired',
        'fad fa-neuter'                              => 'neuter',
        'fad fa-newspaper'                           => 'newspaper',
        'fad fa-not-equal'                           => 'not-equal',
        'fad fa-notes-medical'                       => 'notes-medical',
        'fad fa-object-group'                        => 'object-group',
        'fad fa-object-ungroup'                      => 'object-ungroup',
        'fad fa-octagon'                             => 'octagon',
        'fad fa-oil-can'                             => 'oil-can',
        'fad fa-oil-temp'                            => 'oil-temp',
        'fad fa-om'                                  => 'om',
        'fad fa-omega'                               => 'omega',
        'fad fa-ornament'                            => 'ornament',
        'fad fa-otter'                               => 'otter',
        'fad fa-outdent'                             => 'outdent',
        'fad fa-overline'                            => 'overline',
        'fad fa-page-break'                          => 'page-break',
        'fad fa-pager'                               => 'pager',
        'fad fa-paint-brush'                         => 'paint-brush',
        'fad fa-paint-brush-alt'                     => 'paint-brush-alt',
        'fad fa-paint-roller'                        => 'paint-roller',
        'fad fa-palette'                             => 'palette',
        'fad fa-pallet'                              => 'pallet',
        'fad fa-pallet-alt'                          => 'pallet-alt',
        'fad fa-paper-plane'                         => 'paper-plane',
        'fad fa-paperclip'                           => 'paperclip',
        'fad fa-parachute-box'                       => 'parachute-box',
        'fad fa-paragraph'                           => 'paragraph',
        'fad fa-paragraph-rtl'                       => 'paragraph-rtl',
        'fad fa-parking'                             => 'parking',
        'fad fa-parking-circle'                      => 'parking-circle',
        'fad fa-parking-circle-slash'                => 'parking-circle-slash',
        'fad fa-parking-slash'                       => 'parking-slash',
        'fad fa-passport'                            => 'passport',
        'fad fa-pastafarianism'                      => 'pastafarianism',
        'fad fa-paste'                               => 'paste',
        'fad fa-pause'                               => 'pause',
        'fad fa-pause-circle'                        => 'pause-circle',
        'fad fa-paw'                                 => 'paw',
        'fad fa-paw-alt'                             => 'paw-alt',
        'fad fa-paw-claws'                           => 'paw-claws',
        'fad fa-peace'                               => 'peace',
        'fad fa-pegasus'                             => 'pegasus',
        'fad fa-pen'                                 => 'pen',
        'fad fa-pen-alt'                             => 'pen-alt',
        'fad fa-pen-fancy'                           => 'pen-fancy',
        'fad fa-pen-nib'                             => 'pen-nib',
        'fad fa-pen-square'                          => 'pen-square',
        'fad fa-pencil'                              => 'pencil',
        'fad fa-pencil-alt'                          => 'pencil-alt',
        'fad fa-pencil-paintbrush'                   => 'pencil-paintbrush',
        'fad fa-pencil-ruler'                        => 'pencil-ruler',
        'fad fa-pennant'                             => 'pennant',
        'fad fa-people-carry'                        => 'people-carry',
        'fad fa-pepper-hot'                          => 'pepper-hot',
        'fad fa-percent'                             => 'percent',
        'fad fa-percentage'                          => 'percentage',
        'fad fa-person-booth'                        => 'person-booth',
        'fad fa-person-carry'                        => 'person-carry',
        'fad fa-person-dolly'                        => 'person-dolly',
        'fad fa-person-dolly-empty'                  => 'person-dolly-empty',
        'fad fa-person-sign'                         => 'person-sign',
        'fad fa-phone'                               => 'phone',
        'fad fa-phone-laptop'                        => 'phone-laptop',
        'fad fa-phone-office'                        => 'phone-office',
        'fad fa-phone-plus'                          => 'phone-plus',
        'fad fa-phone-slash'                         => 'phone-slash',
        'fad fa-phone-square'                        => 'phone-square',
        'fad fa-phone-volume'                        => 'phone-volume',
        'fad fa-photo-video'                         => 'photo-video',
        'fad fa-pi'                                  => 'pi',
        'fad fa-pie'                                 => 'pie',
        'fad fa-pig'                                 => 'pig',
        'fad fa-piggy-bank'                          => 'piggy-bank',
        'fad fa-pills'                               => 'pills',
        'fad fa-pizza'                               => 'pizza',
        'fad fa-pizza-slice'                         => 'pizza-slice',
        'fad fa-place-of-worship'                    => 'place-of-worship',
        'fad fa-plane'                               => 'plane',
        'fad fa-plane-alt'                           => 'plane-alt',
        'fad fa-plane-arrival'                       => 'plane-arrival',
        'fad fa-plane-departure'                     => 'plane-departure',
        'fad fa-play'                                => 'play',
        'fad fa-play-circle'                         => 'play-circle',
        'fad fa-plug'                                => 'plug',
        'fad fa-plus'                                => 'plus',
        'fad fa-plus-circle'                         => 'plus-circle',
        'fad fa-plus-hexagon'                        => 'plus-hexagon',
        'fad fa-plus-octagon'                        => 'plus-octagon',
        'fad fa-plus-square'                         => 'plus-square',
        'fad fa-podcast'                             => 'podcast',
        'fad fa-podium'                              => 'podium',
        'fad fa-podium-star'                         => 'podium-star',
        'fad fa-poll'                                => 'poll',
        'fad fa-poll-h'                              => 'poll-h',
        'fad fa-poll-people'                         => 'poll-people',
        'fad fa-poo'                                 => 'poo',
        'fad fa-poo-storm'                           => 'poo-storm',
        'fad fa-poop'                                => 'poop',
        'fad fa-popcorn'                             => 'popcorn',
        'fad fa-portrait'                            => 'portrait',
        'fad fa-pound-sign'                          => 'pound-sign',
        'fad fa-power-off'                           => 'power-off',
        'fad fa-pray'                                => 'pray',
        'fad fa-praying-hands'                       => 'praying-hands',
        'fad fa-prescription'                        => 'prescription',
        'fad fa-prescription-bottle'                 => 'prescription-bottle',
        'fad fa-prescription-bottle-alt'             => 'prescription-bottle-alt',
        'fad fa-presentation'                        => 'presentation',
        'fad fa-print'                               => 'print',
        'fad fa-print-search'                        => 'print-search',
        'fad fa-print-slash'                         => 'print-slash',
        'fad fa-procedures'                          => 'procedures',
        'fad fa-project-diagram'                     => 'project-diagram',
        'fad fa-pumpkin'                             => 'pumpkin',
        'fad fa-puzzle-piece'                        => 'puzzle-piece',
        'fad fa-qrcode'                              => 'qrcode',
        'fad fa-question'                            => 'question',
        'fad fa-question-circle'                     => 'question-circle',
        'fad fa-question-square'                     => 'question-square',
        'fad fa-quidditch'                           => 'quidditch',
        'fad fa-quote-left'                          => 'quote-left',
        'fad fa-quote-right'                         => 'quote-right',
        'fad fa-quran'                               => 'quran',
        'fad fa-rabbit'                              => 'rabbit',
        'fad fa-rabbit-fast'                         => 'rabbit-fast',
        'fad fa-racquet'                             => 'racquet',
        'fad fa-radiation'                           => 'radiation',
        'fad fa-radiation-alt'                       => 'radiation-alt',
        'fad fa-rainbow'                             => 'rainbow',
        'fad fa-raindrops'                           => 'raindrops',
        'fad fa-ram'                                 => 'ram',
        'fad fa-ramp-loading'                        => 'ramp-loading',
        'fad fa-random'                              => 'random',
        'fad fa-receipt'                             => 'receipt',
        'fad fa-rectangle-landscape'                 => 'rectangle-landscape',
        'fad fa-rectangle-portrait'                  => 'rectangle-portrait',
        'fad fa-rectangle-wide'                      => 'rectangle-wide',
        'fad fa-recycle'                             => 'recycle',
        'fad fa-redo'                                => 'redo',
        'fad fa-redo-alt'                            => 'redo-alt',
        'fad fa-registered'                          => 'registered',
        'fad fa-remove-format'                       => 'remove-format',
        'fad fa-repeat'                              => 'repeat',
        'fad fa-repeat-1'                            => 'repeat-1',
        'fad fa-repeat-1-alt'                        => 'repeat-1-alt',
        'fad fa-repeat-alt'                          => 'repeat-alt',
        'fad fa-reply'                               => 'reply',
        'fad fa-reply-all'                           => 'reply-all',
        'fad fa-republican'                          => 'republican',
        'fad fa-restroom'                            => 'restroom',
        'fad fa-retweet'                             => 'retweet',
        'fad fa-retweet-alt'                         => 'retweet-alt',
        'fad fa-ribbon'                              => 'ribbon',
        'fad fa-ring'                                => 'ring',
        'fad fa-rings-wedding'                       => 'rings-wedding',
        'fad fa-road'                                => 'road',
        'fad fa-robot'                               => 'robot',
        'fad fa-rocket'                              => 'rocket',
        'fad fa-route'                               => 'route',
        'fad fa-route-highway'                       => 'route-highway',
        'fad fa-route-interstate'                    => 'route-interstate',
        'fad fa-rss'                                 => 'rss',
        'fad fa-rss-square'                          => 'rss-square',
        'fad fa-ruble-sign'                          => 'ruble-sign',
        'fad fa-ruler'                               => 'ruler',
        'fad fa-ruler-combined'                      => 'ruler-combined',
        'fad fa-ruler-horizontal'                    => 'ruler-horizontal',
        'fad fa-ruler-triangle'                      => 'ruler-triangle',
        'fad fa-ruler-vertical'                      => 'ruler-vertical',
        'fad fa-running'                             => 'running',
        'fad fa-rupee-sign'                          => 'rupee-sign',
        'fad fa-rv'                                  => 'rv',
        'fad fa-sack'                                => 'sack',
        'fad fa-sack-dollar'                         => 'sack-dollar',
        'fad fa-sad-cry'                             => 'sad-cry',
        'fad fa-sad-tear'                            => 'sad-tear',
        'fad fa-salad'                               => 'salad',
        'fad fa-sandwich'                            => 'sandwich',
        'fad fa-satellite'                           => 'satellite',
        'fad fa-satellite-dish'                      => 'satellite-dish',
        'fad fa-sausage'                             => 'sausage',
        'fad fa-save'                                => 'save',
        'fad fa-scalpel'                             => 'scalpel',
        'fad fa-scalpel-path'                        => 'scalpel-path',
        'fad fa-scanner'                             => 'scanner',
        'fad fa-scanner-keyboard'                    => 'scanner-keyboard',
        'fad fa-scanner-touchscreen'                 => 'scanner-touchscreen',
        'fad fa-scarecrow'                           => 'scarecrow',
        'fad fa-scarf'                               => 'scarf',
        'fad fa-school'                              => 'school',
        'fad fa-screwdriver'                         => 'screwdriver',
        'fad fa-scroll'                              => 'scroll',
        'fad fa-scroll-old'                          => 'scroll-old',
        'fad fa-scrubber'                            => 'scrubber',
        'fad fa-scythe'                              => 'scythe',
        'fad fa-sd-card'                             => 'sd-card',
        'fad fa-search'                              => 'search',
        'fad fa-search-dollar'                       => 'search-dollar',
        'fad fa-search-location'                     => 'search-location',
        'fad fa-search-minus'                        => 'search-minus',
        'fad fa-search-plus'                         => 'search-plus',
        'fad fa-seedling'                            => 'seedling',
        'fad fa-send-back'                           => 'send-back',
        'fad fa-send-backward'                       => 'send-backward',
        'fad fa-server'                              => 'server',
        'fad fa-shapes'                              => 'shapes',
        'fad fa-share'                               => 'share',
        'fad fa-share-all'                           => 'share-all',
        'fad fa-share-alt'                           => 'share-alt',
        'fad fa-share-alt-square'                    => 'share-alt-square',
        'fad fa-share-square'                        => 'share-square',
        'fad fa-sheep'                               => 'sheep',
        'fad fa-shekel-sign'                         => 'shekel-sign',
        'fad fa-shield'                              => 'shield',
        'fad fa-shield-alt'                          => 'shield-alt',
        'fad fa-shield-check'                        => 'shield-check',
        'fad fa-shield-cross'                        => 'shield-cross',
        'fad fa-ship'                                => 'ship',
        'fad fa-shipping-fast'                       => 'shipping-fast',
        'fad fa-shipping-timed'                      => 'shipping-timed',
        'fad fa-shish-kebab'                         => 'shish-kebab',
        'fad fa-shoe-prints'                         => 'shoe-prints',
        'fad fa-shopping-bag'                        => 'shopping-bag',
        'fad fa-shopping-basket'                     => 'shopping-basket',
        'fad fa-shopping-cart'                       => 'shopping-cart',
        'fad fa-shovel'                              => 'shovel',
        'fad fa-shovel-snow'                         => 'shovel-snow',
        'fad fa-shower'                              => 'shower',
        'fad fa-shredder'                            => 'shredder',
        'fad fa-shuttle-van'                         => 'shuttle-van',
        'fad fa-shuttlecock'                         => 'shuttlecock',
        'fad fa-sickle'                              => 'sickle',
        'fad fa-sigma'                               => 'sigma',
        'fad fa-sign'                                => 'sign',
        'fad fa-sign-in'                             => 'sign-in',
        'fad fa-sign-in-alt'                         => 'sign-in-alt',
        'fad fa-sign-language'                       => 'sign-language',
        'fad fa-sign-out'                            => 'sign-out',
        'fad fa-sign-out-alt'                        => 'sign-out-alt',
        'fad fa-signal'                              => 'signal',
        'fad fa-signal-1'                            => 'signal-1',
        'fad fa-signal-2'                            => 'signal-2',
        'fad fa-signal-3'                            => 'signal-3',
        'fad fa-signal-4'                            => 'signal-4',
        'fad fa-signal-alt'                          => 'signal-alt',
        'fad fa-signal-alt-1'                        => 'signal-alt-1',
        'fad fa-signal-alt-2'                        => 'signal-alt-2',
        'fad fa-signal-alt-3'                        => 'signal-alt-3',
        'fad fa-signal-alt-slash'                    => 'signal-alt-slash',
        'fad fa-signal-slash'                        => 'signal-slash',
        'fad fa-signature'                           => 'signature',
        'fad fa-sim-card'                            => 'sim-card',
        'fad fa-sitemap'                             => 'sitemap',
        'fad fa-skating'                             => 'skating',
        'fad fa-skeleton'                            => 'skeleton',
        'fad fa-ski-jump'                            => 'ski-jump',
        'fad fa-ski-lift'                            => 'ski-lift',
        'fad fa-skiing'                              => 'skiing',
        'fad fa-skiing-nordic'                       => 'skiing-nordic',
        'fad fa-skull'                               => 'skull',
        'fad fa-skull-crossbones'                    => 'skull-crossbones',
        'fad fa-slash'                               => 'slash',
        'fad fa-sledding'                            => 'sledding',
        'fad fa-sleigh'                              => 'sleigh',
        'fad fa-sliders-h'                           => 'sliders-h',
        'fad fa-sliders-h-square'                    => 'sliders-h-square',
        'fad fa-sliders-v'                           => 'sliders-v',
        'fad fa-sliders-v-square'                    => 'sliders-v-square',
        'fad fa-smile'                               => 'smile',
        'fad fa-smile-beam'                          => 'smile-beam',
        'fad fa-smile-plus'                          => 'smile-plus',
        'fad fa-smile-wink'                          => 'smile-wink',
        'fad fa-smog'                                => 'smog',
        'fad fa-smoke'                               => 'smoke',
        'fad fa-smoking'                             => 'smoking',
        'fad fa-smoking-ban'                         => 'smoking-ban',
        'fad fa-sms'                                 => 'sms',
        'fad fa-snake'                               => 'snake',
        'fad fa-snooze'                              => 'snooze',
        'fad fa-snow-blowing'                        => 'snow-blowing',
        'fad fa-snowboarding'                        => 'snowboarding',
        'fad fa-snowflake'                           => 'snowflake',
        'fad fa-snowflakes'                          => 'snowflakes',
        'fad fa-snowman'                             => 'snowman',
        'fad fa-snowmobile'                          => 'snowmobile',
        'fad fa-snowplow'                            => 'snowplow',
        'fad fa-socks'                               => 'socks',
        'fad fa-solar-panel'                         => 'solar-panel',
        'fad fa-sort'                                => 'sort',
        'fad fa-sort-alpha-down'                     => 'sort-alpha-down',
        'fad fa-sort-alpha-down-alt'                 => 'sort-alpha-down-alt',
        'fad fa-sort-alpha-up'                       => 'sort-alpha-up',
        'fad fa-sort-alpha-up-alt'                   => 'sort-alpha-up-alt',
        'fad fa-sort-alt'                            => 'sort-alt',
        'fad fa-sort-amount-down'                    => 'sort-amount-down',
        'fad fa-sort-amount-down-alt'                => 'sort-amount-down-alt',
        'fad fa-sort-amount-up'                      => 'sort-amount-up',
        'fad fa-sort-amount-up-alt'                  => 'sort-amount-up-alt',
        'fad fa-sort-down'                           => 'sort-down',
        'fad fa-sort-numeric-down'                   => 'sort-numeric-down',
        'fad fa-sort-numeric-down-alt'               => 'sort-numeric-down-alt',
        'fad fa-sort-numeric-up'                     => 'sort-numeric-up',
        'fad fa-sort-numeric-up-alt'                 => 'sort-numeric-up-alt',
        'fad fa-sort-shapes-down'                    => 'sort-shapes-down',
        'fad fa-sort-shapes-down-alt'                => 'sort-shapes-down-alt',
        'fad fa-sort-shapes-up'                      => 'sort-shapes-up',
        'fad fa-sort-shapes-up-alt'                  => 'sort-shapes-up-alt',
        'fad fa-sort-size-down'                      => 'sort-size-down',
        'fad fa-sort-size-down-alt'                  => 'sort-size-down-alt',
        'fad fa-sort-size-up'                        => 'sort-size-up',
        'fad fa-sort-size-up-alt'                    => 'sort-size-up-alt',
        'fad fa-sort-up'                             => 'sort-up',
        'fad fa-soup'                                => 'soup',
        'fad fa-spa'                                 => 'spa',
        'fad fa-space-shuttle'                       => 'space-shuttle',
        'fad fa-spade'                               => 'spade',
        'fad fa-sparkles'                            => 'sparkles',
        'fad fa-spell-check'                         => 'spell-check',
        'fad fa-spider'                              => 'spider',
        'fad fa-spider-black-widow'                  => 'spider-black-widow',
        'fad fa-spider-web'                          => 'spider-web',
        'fad fa-spinner'                             => 'spinner',
        'fad fa-spinner-third'                       => 'spinner-third',
        'fad fa-splotch'                             => 'splotch',
        'fad fa-spray-can'                           => 'spray-can',
        'fad fa-square'                              => 'square',
        'fad fa-square-full'                         => 'square-full',
        'fad fa-square-root'                         => 'square-root',
        'fad fa-square-root-alt'                     => 'square-root-alt',
        'fad fa-squirrel'                            => 'squirrel',
        'fad fa-staff'                               => 'staff',
        'fad fa-stamp'                               => 'stamp',
        'fad fa-star'                                => 'star',
        'fad fa-star-and-crescent'                   => 'star-and-crescent',
        'fad fa-star-christmas'                      => 'star-christmas',
        'fad fa-star-exclamation'                    => 'star-exclamation',
        'fad fa-star-half'                           => 'star-half',
        'fad fa-star-half-alt'                       => 'star-half-alt',
        'fad fa-star-of-david'                       => 'star-of-david',
        'fad fa-star-of-life'                        => 'star-of-life',
        'fad fa-stars'                               => 'stars',
        'fad fa-steak'                               => 'steak',
        'fad fa-steering-wheel'                      => 'steering-wheel',
        'fad fa-step-backward'                       => 'step-backward',
        'fad fa-step-forward'                        => 'step-forward',
        'fad fa-stethoscope'                         => 'stethoscope',
        'fad fa-sticky-note'                         => 'sticky-note',
        'fad fa-stocking'                            => 'stocking',
        'fad fa-stomach'                             => 'stomach',
        'fad fa-stop'                                => 'stop',
        'fad fa-stop-circle'                         => 'stop-circle',
        'fad fa-stopwatch'                           => 'stopwatch',
        'fad fa-store'                               => 'store',
        'fad fa-store-alt'                           => 'store-alt',
        'fad fa-stream'                              => 'stream',
        'fad fa-street-view'                         => 'street-view',
        'fad fa-stretcher'                           => 'stretcher',
        'fad fa-strikethrough'                       => 'strikethrough',
        'fad fa-stroopwafel'                         => 'stroopwafel',
        'fad fa-subscript'                           => 'subscript',
        'fad fa-subway'                              => 'subway',
        'fad fa-suitcase'                            => 'suitcase',
        'fad fa-suitcase-rolling'                    => 'suitcase-rolling',
        'fad fa-sun'                                 => 'sun',
        'fad fa-sun-cloud'                           => 'sun-cloud',
        'fad fa-sun-dust'                            => 'sun-dust',
        'fad fa-sun-haze'                            => 'sun-haze',
        'fad fa-sunglasses'                          => 'sunglasses',
        'fad fa-sunrise'                             => 'sunrise',
        'fad fa-sunset'                              => 'sunset',
        'fad fa-superscript'                         => 'superscript',
        'fad fa-surprise'                            => 'surprise',
        'fad fa-swatchbook'                          => 'swatchbook',
        'fad fa-swimmer'                             => 'swimmer',
        'fad fa-swimming-pool'                       => 'swimming-pool',
        'fad fa-sword'                               => 'sword',
        'fad fa-swords'                              => 'swords',
        'fad fa-synagogue'                           => 'synagogue',
        'fad fa-sync'                                => 'sync',
        'fad fa-sync-alt'                            => 'sync-alt',
        'fad fa-syringe'                             => 'syringe',
        'fad fa-table'                               => 'table',
        'fad fa-table-tennis'                        => 'table-tennis',
        'fad fa-tablet'                              => 'tablet',
        'fad fa-tablet-alt'                          => 'tablet-alt',
        'fad fa-tablet-android'                      => 'tablet-android',
        'fad fa-tablet-android-alt'                  => 'tablet-android-alt',
        'fad fa-tablet-rugged'                       => 'tablet-rugged',
        'fad fa-tablets'                             => 'tablets',
        'fad fa-tachometer'                          => 'tachometer',
        'fad fa-tachometer-alt'                      => 'tachometer-alt',
        'fad fa-tachometer-alt-average'              => 'tachometer-alt-average',
        'fad fa-tachometer-alt-fast'                 => 'tachometer-alt-fast',
        'fad fa-tachometer-alt-fastest'              => 'tachometer-alt-fastest',
        'fad fa-tachometer-alt-slow'                 => 'tachometer-alt-slow',
        'fad fa-tachometer-alt-slowest'              => 'tachometer-alt-slowest',
        'fad fa-tachometer-average'                  => 'tachometer-average',
        'fad fa-tachometer-fast'                     => 'tachometer-fast',
        'fad fa-tachometer-fastest'                  => 'tachometer-fastest',
        'fad fa-tachometer-slow'                     => 'tachometer-slow',
        'fad fa-tachometer-slowest'                  => 'tachometer-slowest',
        'fad fa-taco'                                => 'taco',
        'fad fa-tag'                                 => 'tag',
        'fad fa-tags'                                => 'tags',
        'fad fa-tally'                               => 'tally',
        'fad fa-tanakh'                              => 'tanakh',
        'fad fa-tape'                                => 'tape',
        'fad fa-tasks'                               => 'tasks',
        'fad fa-tasks-alt'                           => 'tasks-alt',
        'fad fa-taxi'                                => 'taxi',
        'fad fa-teeth'                               => 'teeth',
        'fad fa-teeth-open'                          => 'teeth-open',
        'fad fa-temperature-frigid'                  => 'temperature-frigid',
        'fad fa-temperature-high'                    => 'temperature-high',
        'fad fa-temperature-hot'                     => 'temperature-hot',
        'fad fa-temperature-low'                     => 'temperature-low',
        'fad fa-tenge'                               => 'tenge',
        'fad fa-tennis-ball'                         => 'tennis-ball',
        'fad fa-terminal'                            => 'terminal',
        'fad fa-text'                                => 'text',
        'fad fa-text-height'                         => 'text-height',
        'fad fa-text-size'                           => 'text-size',
        'fad fa-text-width'                          => 'text-width',
        'fad fa-th'                                  => 'th',
        'fad fa-th-large'                            => 'th-large',
        'fad fa-th-list'                             => 'th-list',
        'fad fa-theater-masks'                       => 'theater-masks',
        'fad fa-thermometer'                         => 'thermometer',
        'fad fa-thermometer-empty'                   => 'thermometer-empty',
        'fad fa-thermometer-full'                    => 'thermometer-full',
        'fad fa-thermometer-half'                    => 'thermometer-half',
        'fad fa-thermometer-quarter'                 => 'thermometer-quarter',
        'fad fa-thermometer-three-quarters'          => 'thermometer-three-quarters',
        'fad fa-theta'                               => 'theta',
        'fad fa-thumbs-down'                         => 'thumbs-down',
        'fad fa-thumbs-up'                           => 'thumbs-up',
        'fad fa-thumbtack'                           => 'thumbtack',
        'fad fa-thunderstorm'                        => 'thunderstorm',
        'fad fa-thunderstorm-moon'                   => 'thunderstorm-moon',
        'fad fa-thunderstorm-sun'                    => 'thunderstorm-sun',
        'fad fa-ticket'                              => 'ticket',
        'fad fa-ticket-alt'                          => 'ticket-alt',
        'fad fa-tilde'                               => 'tilde',
        'fad fa-times'                               => 'times',
        'fad fa-times-circle'                        => 'times-circle',
        'fad fa-times-hexagon'                       => 'times-hexagon',
        'fad fa-times-octagon'                       => 'times-octagon',
        'fad fa-times-square'                        => 'times-square',
        'fad fa-tint'                                => 'tint',
        'fad fa-tint-slash'                          => 'tint-slash',
        'fad fa-tire'                                => 'tire',
        'fad fa-tire-flat'                           => 'tire-flat',
        'fad fa-tire-pressure-warning'               => 'tire-pressure-warning',
        'fad fa-tire-rugged'                         => 'tire-rugged',
        'fad fa-tired'                               => 'tired',
        'fad fa-toggle-off'                          => 'toggle-off',
        'fad fa-toggle-on'                           => 'toggle-on',
        'fad fa-toilet'                              => 'toilet',
        'fad fa-toilet-paper'                        => 'toilet-paper',
        'fad fa-toilet-paper-alt'                    => 'toilet-paper-alt',
        'fad fa-tombstone'                           => 'tombstone',
        'fad fa-tombstone-alt'                       => 'tombstone-alt',
        'fad fa-toolbox'                             => 'toolbox',
        'fad fa-tools'                               => 'tools',
        'fad fa-tooth'                               => 'tooth',
        'fad fa-toothbrush'                          => 'toothbrush',
        'fad fa-torah'                               => 'torah',
        'fad fa-torii-gate'                          => 'torii-gate',
        'fad fa-tornado'                             => 'tornado',
        'fad fa-tractor'                             => 'tractor',
        'fad fa-trademark'                           => 'trademark',
        'fad fa-traffic-cone'                        => 'traffic-cone',
        'fad fa-traffic-light'                       => 'traffic-light',
        'fad fa-traffic-light-go'                    => 'traffic-light-go',
        'fad fa-traffic-light-slow'                  => 'traffic-light-slow',
        'fad fa-traffic-light-stop'                  => 'traffic-light-stop',
        'fad fa-train'                               => 'train',
        'fad fa-tram'                                => 'tram',
        'fad fa-transgender'                         => 'transgender',
        'fad fa-transgender-alt'                     => 'transgender-alt',
        'fad fa-trash'                               => 'trash',
        'fad fa-trash-alt'                           => 'trash-alt',
        'fad fa-trash-restore'                       => 'trash-restore',
        'fad fa-trash-restore-alt'                   => 'trash-restore-alt',
        'fad fa-trash-undo'                          => 'trash-undo',
        'fad fa-trash-undo-alt'                      => 'trash-undo-alt',
        'fad fa-treasure-chest'                      => 'treasure-chest',
        'fad fa-tree'                                => 'tree',
        'fad fa-tree-alt'                            => 'tree-alt',
        'fad fa-tree-christmas'                      => 'tree-christmas',
        'fad fa-tree-decorated'                      => 'tree-decorated',
        'fad fa-tree-large'                          => 'tree-large',
        'fad fa-tree-palm'                           => 'tree-palm',
        'fad fa-trees'                               => 'trees',
        'fad fa-triangle'                            => 'triangle',
        'fad fa-trophy'                              => 'trophy',
        'fad fa-trophy-alt'                          => 'trophy-alt',
        'fad fa-truck'                               => 'truck',
        'fad fa-truck-container'                     => 'truck-container',
        'fad fa-truck-couch'                         => 'truck-couch',
        'fad fa-truck-loading'                       => 'truck-loading',
        'fad fa-truck-monster'                       => 'truck-monster',
        'fad fa-truck-moving'                        => 'truck-moving',
        'fad fa-truck-pickup'                        => 'truck-pickup',
        'fad fa-truck-plow'                          => 'truck-plow',
        'fad fa-truck-ramp'                          => 'truck-ramp',
        'fad fa-tshirt'                              => 'tshirt',
        'fad fa-tty'                                 => 'tty',
        'fad fa-turkey'                              => 'turkey',
        'fad fa-turtle'                              => 'turtle',
        'fad fa-tv'                                  => 'tv',
        'fad fa-tv-retro'                            => 'tv-retro',
        'fad fa-umbrella'                            => 'umbrella',
        'fad fa-umbrella-beach'                      => 'umbrella-beach',
        'fad fa-underline'                           => 'underline',
        'fad fa-undo'                                => 'undo',
        'fad fa-undo-alt'                            => 'undo-alt',
        'fad fa-unicorn'                             => 'unicorn',
        'fad fa-union'                               => 'union',
        'fad fa-universal-access'                    => 'universal-access',
        'fad fa-university'                          => 'university',
        'fad fa-unlink'                              => 'unlink',
        'fad fa-unlock'                              => 'unlock',
        'fad fa-unlock-alt'                          => 'unlock-alt',
        'fad fa-upload'                              => 'upload',
        'fad fa-usd-circle'                          => 'usd-circle',
        'fad fa-usd-square'                          => 'usd-square',
        'fad fa-user'                                => 'user',
        'fad fa-user-alt'                            => 'user-alt',
        'fad fa-user-alt-slash'                      => 'user-alt-slash',
        'fad fa-user-astronaut'                      => 'user-astronaut',
        'fad fa-user-chart'                          => 'user-chart',
        'fad fa-user-check'                          => 'user-check',
        'fad fa-user-circle'                         => 'user-circle',
        'fad fa-user-clock'                          => 'user-clock',
        'fad fa-user-cog'                            => 'user-cog',
        'fad fa-user-crown'                          => 'user-crown',
        'fad fa-user-edit'                           => 'user-edit',
        'fad fa-user-friends'                        => 'user-friends',
        'fad fa-user-graduate'                       => 'user-graduate',
        'fad fa-user-hard-hat'                       => 'user-hard-hat',
        'fad fa-user-headset'                        => 'user-headset',
        'fad fa-user-injured'                        => 'user-injured',
        'fad fa-user-lock'                           => 'user-lock',
        'fad fa-user-md'                             => 'user-md',
        'fad fa-user-md-chat'                        => 'user-md-chat',
        'fad fa-user-minus'                          => 'user-minus',
        'fad fa-user-ninja'                          => 'user-ninja',
        'fad fa-user-nurse'                          => 'user-nurse',
        'fad fa-user-plus'                           => 'user-plus',
        'fad fa-user-secret'                         => 'user-secret',
        'fad fa-user-shield'                         => 'user-shield',
        'fad fa-user-slash'                          => 'user-slash',
        'fad fa-user-tag'                            => 'user-tag',
        'fad fa-user-tie'                            => 'user-tie',
        'fad fa-user-times'                          => 'user-times',
        'fad fa-users'                               => 'users',
        'fad fa-users-class'                         => 'users-class',
        'fad fa-users-cog'                           => 'users-cog',
        'fad fa-users-crown'                         => 'users-crown',
        'fad fa-users-medical'                       => 'users-medical',
        'fad fa-utensil-fork'                        => 'utensil-fork',
        'fad fa-utensil-knife'                       => 'utensil-knife',
        'fad fa-utensil-spoon'                       => 'utensil-spoon',
        'fad fa-utensils'                            => 'utensils',
        'fad fa-utensils-alt'                        => 'utensils-alt',
        'fad fa-value-absolute'                      => 'value-absolute',
        'fad fa-vector-square'                       => 'vector-square',
        'fad fa-venus'                               => 'venus',
        'fad fa-venus-double'                        => 'venus-double',
        'fad fa-venus-mars'                          => 'venus-mars',
        'fad fa-vial'                                => 'vial',
        'fad fa-vials'                               => 'vials',
        'fad fa-video'                               => 'video',
        'fad fa-video-plus'                          => 'video-plus',
        'fad fa-video-slash'                         => 'video-slash',
        'fad fa-vihara'                              => 'vihara',
        'fad fa-voicemail'                           => 'voicemail',
        'fad fa-volcano'                             => 'volcano',
        'fad fa-volleyball-ball'                     => 'volleyball-ball',
        'fad fa-volume'                              => 'volume',
        'fad fa-volume-down'                         => 'volume-down',
        'fad fa-volume-mute'                         => 'volume-mute',
        'fad fa-volume-off'                          => 'volume-off',
        'fad fa-volume-slash'                        => 'volume-slash',
        'fad fa-volume-up'                           => 'volume-up',
        'fad fa-vote-nay'                            => 'vote-nay',
        'fad fa-vote-yea'                            => 'vote-yea',
        'fad fa-vr-cardboard'                        => 'vr-cardboard',
        'fad fa-walker'                              => 'walker',
        'fad fa-walking'                             => 'walking',
        'fad fa-wallet'                              => 'wallet',
        'fad fa-wand'                                => 'wand',
        'fad fa-wand-magic'                          => 'wand-magic',
        'fad fa-warehouse'                           => 'warehouse',
        'fad fa-warehouse-alt'                       => 'warehouse-alt',
        'fad fa-washer'                              => 'washer',
        'fad fa-watch'                               => 'watch',
        'fad fa-watch-fitness'                       => 'watch-fitness',
        'fad fa-water'                               => 'water',
        'fad fa-water-lower'                         => 'water-lower',
        'fad fa-water-rise'                          => 'water-rise',
        'fad fa-wave-sine'                           => 'wave-sine',
        'fad fa-wave-square'                         => 'wave-square',
        'fad fa-wave-triangle'                       => 'wave-triangle',
        'fad fa-webcam'                              => 'webcam',
        'fad fa-webcam-slash'                        => 'webcam-slash',
        'fad fa-weight'                              => 'weight',
        'fad fa-weight-hanging'                      => 'weight-hanging',
        'fad fa-whale'                               => 'whale',
        'fad fa-wheat'                               => 'wheat',
        'fad fa-wheelchair'                          => 'wheelchair',
        'fad fa-whistle'                             => 'whistle',
        'fad fa-wifi'                                => 'wifi',
        'fad fa-wifi-1'                              => 'wifi-1',
        'fad fa-wifi-2'                              => 'wifi-2',
        'fad fa-wifi-slash'                          => 'wifi-slash',
        'fad fa-wind'                                => 'wind',
        'fad fa-wind-turbine'                        => 'wind-turbine',
        'fad fa-wind-warning'                        => 'wind-warning',
        'fad fa-window'                              => 'window',
        'fad fa-window-alt'                          => 'window-alt',
        'fad fa-window-close'                        => 'window-close',
        'fad fa-window-maximize'                     => 'window-maximize',
        'fad fa-window-minimize'                     => 'window-minimize',
        'fad fa-window-restore'                      => 'window-restore',
        'fad fa-windsock'                            => 'windsock',
        'fad fa-wine-bottle'                         => 'wine-bottle',
        'fad fa-wine-glass'                          => 'wine-glass',
        'fad fa-wine-glass-alt'                      => 'wine-glass-alt',
        'fad fa-won-sign'                            => 'won-sign',
        'fad fa-wreath'                              => 'wreath',
        'fad fa-wrench'                              => 'wrench',
        'fad fa-x-ray'                               => 'x-ray',
        'fad fa-yen-sign'                            => 'yen-sign',
        'fad fa-yin-yang'                            => 'yin-yang',
        'fal fa-abacus'                              => 'abacus',
        'fal fa-acorn'                               => 'acorn',
        'fal fa-ad'                                  => 'ad',
        'fal fa-address-book'                        => 'address-book',
        'fal fa-address-card'                        => 'address-card',
        'fal fa-adjust'                              => 'adjust',
        'fal fa-air-freshener'                       => 'air-freshener',
        'fal fa-alarm-clock'                         => 'alarm-clock',
        'fal fa-alarm-exclamation'                   => 'alarm-exclamation',
        'fal fa-alarm-plus'                          => 'alarm-plus',
        'fal fa-alarm-snooze'                        => 'alarm-snooze',
        'fal fa-alicorn'                             => 'alicorn',
        'fal fa-align-center'                        => 'align-center',
        'fal fa-align-justify'                       => 'align-justify',
        'fal fa-align-left'                          => 'align-left',
        'fal fa-align-right'                         => 'align-right',
        'fal fa-align-slash'                         => 'align-slash',
        'fal fa-allergies'                           => 'allergies',
        'fal fa-ambulance'                           => 'ambulance',
        'fal fa-american-sign-language-interpreting' => 'american-sign-language-interpreting',
        'fal fa-analytics'                           => 'analytics',
        'fal fa-anchor'                              => 'anchor',
        'fal fa-angel'                               => 'angel',
        'fal fa-angle-double-down'                   => 'angle-double-down',
        'fal fa-angle-double-left'                   => 'angle-double-left',
        'fal fa-angle-double-right'                  => 'angle-double-right',
        'fal fa-angle-double-up'                     => 'angle-double-up',
        'fal fa-angle-down'                          => 'angle-down',
        'fal fa-angle-left'                          => 'angle-left',
        'fal fa-angle-right'                         => 'angle-right',
        'fal fa-angle-up'                            => 'angle-up',
        'fal fa-angry'                               => 'angry',
        'fal fa-ankh'                                => 'ankh',
        'fal fa-apple-alt'                           => 'apple-alt',
        'fal fa-apple-crate'                         => 'apple-crate',
        'fal fa-archive'                             => 'archive',
        'fal fa-archway'                             => 'archway',
        'fal fa-arrow-alt-circle-down'               => 'arrow-alt-circle-down',
        'fal fa-arrow-alt-circle-left'               => 'arrow-alt-circle-left',
        'fal fa-arrow-alt-circle-right'              => 'arrow-alt-circle-right',
        'fal fa-arrow-alt-circle-up'                 => 'arrow-alt-circle-up',
        'fal fa-arrow-alt-down'                      => 'arrow-alt-down',
        'fal fa-arrow-alt-from-bottom'               => 'arrow-alt-from-bottom',
        'fal fa-arrow-alt-from-left'                 => 'arrow-alt-from-left',
        'fal fa-arrow-alt-from-right'                => 'arrow-alt-from-right',
        'fal fa-arrow-alt-from-top'                  => 'arrow-alt-from-top',
        'fal fa-arrow-alt-left'                      => 'arrow-alt-left',
        'fal fa-arrow-alt-right'                     => 'arrow-alt-right',
        'fal fa-arrow-alt-square-down'               => 'arrow-alt-square-down',
        'fal fa-arrow-alt-square-left'               => 'arrow-alt-square-left',
        'fal fa-arrow-alt-square-right'              => 'arrow-alt-square-right',
        'fal fa-arrow-alt-square-up'                 => 'arrow-alt-square-up',
        'fal fa-arrow-alt-to-bottom'                 => 'arrow-alt-to-bottom',
        'fal fa-arrow-alt-to-left'                   => 'arrow-alt-to-left',
        'fal fa-arrow-alt-to-right'                  => 'arrow-alt-to-right',
        'fal fa-arrow-alt-to-top'                    => 'arrow-alt-to-top',
        'fal fa-arrow-alt-up'                        => 'arrow-alt-up',
        'fal fa-arrow-circle-down'                   => 'arrow-circle-down',
        'fal fa-arrow-circle-left'                   => 'arrow-circle-left',
        'fal fa-arrow-circle-right'                  => 'arrow-circle-right',
        'fal fa-arrow-circle-up'                     => 'arrow-circle-up',
        'fal fa-arrow-down'                          => 'arrow-down',
        'fal fa-arrow-from-bottom'                   => 'arrow-from-bottom',
        'fal fa-arrow-from-left'                     => 'arrow-from-left',
        'fal fa-arrow-from-right'                    => 'arrow-from-right',
        'fal fa-arrow-from-top'                      => 'arrow-from-top',
        'fal fa-arrow-left'                          => 'arrow-left',
        'fal fa-arrow-right'                         => 'arrow-right',
        'fal fa-arrow-square-down'                   => 'arrow-square-down',
        'fal fa-arrow-square-left'                   => 'arrow-square-left',
        'fal fa-arrow-square-right'                  => 'arrow-square-right',
        'fal fa-arrow-square-up'                     => 'arrow-square-up',
        'fal fa-arrow-to-bottom'                     => 'arrow-to-bottom',
        'fal fa-arrow-to-left'                       => 'arrow-to-left',
        'fal fa-arrow-to-right'                      => 'arrow-to-right',
        'fal fa-arrow-to-top'                        => 'arrow-to-top',
        'fal fa-arrow-up'                            => 'arrow-up',
        'fal fa-arrows'                              => 'arrows',
        'fal fa-arrows-alt'                          => 'arrows-alt',
        'fal fa-arrows-alt-h'                        => 'arrows-alt-h',
        'fal fa-arrows-alt-v'                        => 'arrows-alt-v',
        'fal fa-arrows-h'                            => 'arrows-h',
        'fal fa-arrows-v'                            => 'arrows-v',
        'fal fa-assistive-listening-systems'         => 'assistive-listening-systems',
        'fal fa-asterisk'                            => 'asterisk',
        'fal fa-at'                                  => 'at',
        'fal fa-atlas'                               => 'atlas',
        'fal fa-atom'                                => 'atom',
        'fal fa-atom-alt'                            => 'atom-alt',
        'fal fa-audio-description'                   => 'audio-description',
        'fal fa-award'                               => 'award',
        'fal fa-axe'                                 => 'axe',
        'fal fa-axe-battle'                          => 'axe-battle',
        'fal fa-baby'                                => 'baby',
        'fal fa-baby-carriage'                       => 'baby-carriage',
        'fal fa-backpack'                            => 'backpack',
        'fal fa-backspace'                           => 'backspace',
        'fal fa-backward'                            => 'backward',
        'fal fa-bacon'                               => 'bacon',
        'fal fa-badge'                               => 'badge',
        'fal fa-badge-check'                         => 'badge-check',
        'fal fa-badge-dollar'                        => 'badge-dollar',
        'fal fa-badge-percent'                       => 'badge-percent',
        'fal fa-badger-honey'                        => 'badger-honey',
        'fal fa-bags-shopping'                       => 'bags-shopping',
        'fal fa-balance-scale'                       => 'balance-scale',
        'fal fa-balance-scale-left'                  => 'balance-scale-left',
        'fal fa-balance-scale-right'                 => 'balance-scale-right',
        'fal fa-ball-pile'                           => 'ball-pile',
        'fal fa-ballot'                              => 'ballot',
        'fal fa-ballot-check'                        => 'ballot-check',
        'fal fa-ban'                                 => 'ban',
        'fal fa-band-aid'                            => 'band-aid',
        'fal fa-barcode'                             => 'barcode',
        'fal fa-barcode-alt'                         => 'barcode-alt',
        'fal fa-barcode-read'                        => 'barcode-read',
        'fal fa-barcode-scan'                        => 'barcode-scan',
        'fal fa-bars'                                => 'bars',
        'fal fa-baseball'                            => 'baseball',
        'fal fa-baseball-ball'                       => 'baseball-ball',
        'fal fa-basketball-ball'                     => 'basketball-ball',
        'fal fa-basketball-hoop'                     => 'basketball-hoop',
        'fal fa-bat'                                 => 'bat',
        'fal fa-bath'                                => 'bath',
        'fal fa-battery-bolt'                        => 'battery-bolt',
        'fal fa-battery-empty'                       => 'battery-empty',
        'fal fa-battery-full'                        => 'battery-full',
        'fal fa-battery-half'                        => 'battery-half',
        'fal fa-battery-quarter'                     => 'battery-quarter',
        'fal fa-battery-slash'                       => 'battery-slash',
        'fal fa-battery-three-quarters'              => 'battery-three-quarters',
        'fal fa-bed'                                 => 'bed',
        'fal fa-beer'                                => 'beer',
        'fal fa-bell'                                => 'bell',
        'fal fa-bell-exclamation'                    => 'bell-exclamation',
        'fal fa-bell-plus'                           => 'bell-plus',
        'fal fa-bell-school'                         => 'bell-school',
        'fal fa-bell-school-slash'                   => 'bell-school-slash',
        'fal fa-bell-slash'                          => 'bell-slash',
        'fal fa-bells'                               => 'bells',
        'fal fa-bezier-curve'                        => 'bezier-curve',
        'fal fa-bible'                               => 'bible',
        'fal fa-bicycle'                             => 'bicycle',
        'fal fa-biking'                              => 'biking',
        'fal fa-biking-mountain'                     => 'biking-mountain',
        'fal fa-binoculars'                          => 'binoculars',
        'fal fa-biohazard'                           => 'biohazard',
        'fal fa-birthday-cake'                       => 'birthday-cake',
        'fal fa-blanket'                             => 'blanket',
        'fal fa-blender'                             => 'blender',
        'fal fa-blender-phone'                       => 'blender-phone',
        'fal fa-blind'                               => 'blind',
        'fal fa-blog'                                => 'blog',
        'fal fa-bold'                                => 'bold',
        'fal fa-bolt'                                => 'bolt',
        'fal fa-bomb'                                => 'bomb',
        'fal fa-bone'                                => 'bone',
        'fal fa-bone-break'                          => 'bone-break',
        'fal fa-bong'                                => 'bong',
        'fal fa-book'                                => 'book',
        'fal fa-book-alt'                            => 'book-alt',
        'fal fa-book-dead'                           => 'book-dead',
        'fal fa-book-heart'                          => 'book-heart',
        'fal fa-book-medical'                        => 'book-medical',
        'fal fa-book-open'                           => 'book-open',
        'fal fa-book-reader'                         => 'book-reader',
        'fal fa-book-spells'                         => 'book-spells',
        'fal fa-book-user'                           => 'book-user',
        'fal fa-bookmark'                            => 'bookmark',
        'fal fa-books'                               => 'books',
        'fal fa-books-medical'                       => 'books-medical',
        'fal fa-boot'                                => 'boot',
        'fal fa-booth-curtain'                       => 'booth-curtain',
        'fal fa-border-all'                          => 'border-all',
        'fal fa-border-bottom'                       => 'border-bottom',
        'fal fa-border-center-h'                     => 'border-center-h',
        'fal fa-border-center-v'                     => 'border-center-v',
        'fal fa-border-inner'                        => 'border-inner',
        'fal fa-border-left'                         => 'border-left',
        'fal fa-border-none'                         => 'border-none',
        'fal fa-border-outer'                        => 'border-outer',
        'fal fa-border-right'                        => 'border-right',
        'fal fa-border-style'                        => 'border-style',
        'fal fa-border-style-alt'                    => 'border-style-alt',
        'fal fa-border-top'                          => 'border-top',
        'fal fa-bow-arrow'                           => 'bow-arrow',
        'fal fa-bowling-ball'                        => 'bowling-ball',
        'fal fa-bowling-pins'                        => 'bowling-pins',
        'fal fa-box'                                 => 'box',
        'fal fa-box-alt'                             => 'box-alt',
        'fal fa-box-ballot'                          => 'box-ballot',
        'fal fa-box-check'                           => 'box-check',
        'fal fa-box-fragile'                         => 'box-fragile',
        'fal fa-box-full'                            => 'box-full',
        'fal fa-box-heart'                           => 'box-heart',
        'fal fa-box-open'                            => 'box-open',
        'fal fa-box-up'                              => 'box-up',
        'fal fa-box-usd'                             => 'box-usd',
        'fal fa-boxes'                               => 'boxes',
        'fal fa-boxes-alt'                           => 'boxes-alt',
        'fal fa-boxing-glove'                        => 'boxing-glove',
        'fal fa-brackets'                            => 'brackets',
        'fal fa-brackets-curly'                      => 'brackets-curly',
        'fal fa-braille'                             => 'braille',
        'fal fa-brain'                               => 'brain',
        'fal fa-bread-loaf'                          => 'bread-loaf',
        'fal fa-bread-slice'                         => 'bread-slice',
        'fal fa-briefcase'                           => 'briefcase',
        'fal fa-briefcase-medical'                   => 'briefcase-medical',
        'fal fa-bring-forward'                       => 'bring-forward',
        'fal fa-bring-front'                         => 'bring-front',
        'fal fa-broadcast-tower'                     => 'broadcast-tower',
        'fal fa-broom'                               => 'broom',
        'fal fa-browser'                             => 'browser',
        'fal fa-brush'                               => 'brush',
        'fal fa-bug'                                 => 'bug',
        'fal fa-building'                            => 'building',
        'fal fa-bullhorn'                            => 'bullhorn',
        'fal fa-bullseye'                            => 'bullseye',
        'fal fa-bullseye-arrow'                      => 'bullseye-arrow',
        'fal fa-bullseye-pointer'                    => 'bullseye-pointer',
        'fal fa-burger-soda'                         => 'burger-soda',
        'fal fa-burn'                                => 'burn',
        'fal fa-burrito'                             => 'burrito',
        'fal fa-bus'                                 => 'bus',
        'fal fa-bus-alt'                             => 'bus-alt',
        'fal fa-bus-school'                          => 'bus-school',
        'fal fa-business-time'                       => 'business-time',
        'fal fa-cabinet-filing'                      => 'cabinet-filing',
        'fal fa-calculator'                          => 'calculator',
        'fal fa-calculator-alt'                      => 'calculator-alt',
        'fal fa-calendar'                            => 'calendar',
        'fal fa-calendar-alt'                        => 'calendar-alt',
        'fal fa-calendar-check'                      => 'calendar-check',
        'fal fa-calendar-day'                        => 'calendar-day',
        'fal fa-calendar-edit'                       => 'calendar-edit',
        'fal fa-calendar-exclamation'                => 'calendar-exclamation',
        'fal fa-calendar-minus'                      => 'calendar-minus',
        'fal fa-calendar-plus'                       => 'calendar-plus',
        'fal fa-calendar-star'                       => 'calendar-star',
        'fal fa-calendar-times'                      => 'calendar-times',
        'fal fa-calendar-week'                       => 'calendar-week',
        'fal fa-camera'                              => 'camera',
        'fal fa-camera-alt'                          => 'camera-alt',
        'fal fa-camera-retro'                        => 'camera-retro',
        'fal fa-campfire'                            => 'campfire',
        'fal fa-campground'                          => 'campground',
        'fal fa-candle-holder'                       => 'candle-holder',
        'fal fa-candy-cane'                          => 'candy-cane',
        'fal fa-candy-corn'                          => 'candy-corn',
        'fal fa-cannabis'                            => 'cannabis',
        'fal fa-capsules'                            => 'capsules',
        'fal fa-car'                                 => 'car',
        'fal fa-car-alt'                             => 'car-alt',
        'fal fa-car-battery'                         => 'car-battery',
        'fal fa-car-building'                        => 'car-building',
        'fal fa-car-bump'                            => 'car-bump',
        'fal fa-car-bus'                             => 'car-bus',
        'fal fa-car-crash'                           => 'car-crash',
        'fal fa-car-garage'                          => 'car-garage',
        'fal fa-car-mechanic'                        => 'car-mechanic',
        'fal fa-car-side'                            => 'car-side',
        'fal fa-car-tilt'                            => 'car-tilt',
        'fal fa-car-wash'                            => 'car-wash',
        'fal fa-caret-circle-down'                   => 'caret-circle-down',
        'fal fa-caret-circle-left'                   => 'caret-circle-left',
        'fal fa-caret-circle-right'                  => 'caret-circle-right',
        'fal fa-caret-circle-up'                     => 'caret-circle-up',
        'fal fa-caret-down'                          => 'caret-down',
        'fal fa-caret-left'                          => 'caret-left',
        'fal fa-caret-right'                         => 'caret-right',
        'fal fa-caret-square-down'                   => 'caret-square-down',
        'fal fa-caret-square-left'                   => 'caret-square-left',
        'fal fa-caret-square-right'                  => 'caret-square-right',
        'fal fa-caret-square-up'                     => 'caret-square-up',
        'fal fa-caret-up'                            => 'caret-up',
        'fal fa-carrot'                              => 'carrot',
        'fal fa-cars'                                => 'cars',
        'fal fa-cart-arrow-down'                     => 'cart-arrow-down',
        'fal fa-cart-plus'                           => 'cart-plus',
        'fal fa-cash-register'                       => 'cash-register',
        'fal fa-cat'                                 => 'cat',
        'fal fa-cauldron'                            => 'cauldron',
        'fal fa-certificate'                         => 'certificate',
        'fal fa-chair'                               => 'chair',
        'fal fa-chair-office'                        => 'chair-office',
        'fal fa-chalkboard'                          => 'chalkboard',
        'fal fa-chalkboard-teacher'                  => 'chalkboard-teacher',
        'fal fa-charging-station'                    => 'charging-station',
        'fal fa-chart-area'                          => 'chart-area',
        'fal fa-chart-bar'                           => 'chart-bar',
        'fal fa-chart-line'                          => 'chart-line',
        'fal fa-chart-line-down'                     => 'chart-line-down',
        'fal fa-chart-network'                       => 'chart-network',
        'fal fa-chart-pie'                           => 'chart-pie',
        'fal fa-chart-pie-alt'                       => 'chart-pie-alt',
        'fal fa-chart-scatter'                       => 'chart-scatter',
        'fal fa-check'                               => 'check',
        'fal fa-check-circle'                        => 'check-circle',
        'fal fa-check-double'                        => 'check-double',
        'fal fa-check-square'                        => 'check-square',
        'fal fa-cheese'                              => 'cheese',
        'fal fa-cheese-swiss'                        => 'cheese-swiss',
        'fal fa-cheeseburger'                        => 'cheeseburger',
        'fal fa-chess'                               => 'chess',
        'fal fa-chess-bishop'                        => 'chess-bishop',
        'fal fa-chess-bishop-alt'                    => 'chess-bishop-alt',
        'fal fa-chess-board'                         => 'chess-board',
        'fal fa-chess-clock'                         => 'chess-clock',
        'fal fa-chess-clock-alt'                     => 'chess-clock-alt',
        'fal fa-chess-king'                          => 'chess-king',
        'fal fa-chess-king-alt'                      => 'chess-king-alt',
        'fal fa-chess-knight'                        => 'chess-knight',
        'fal fa-chess-knight-alt'                    => 'chess-knight-alt',
        'fal fa-chess-pawn'                          => 'chess-pawn',
        'fal fa-chess-pawn-alt'                      => 'chess-pawn-alt',
        'fal fa-chess-queen'                         => 'chess-queen',
        'fal fa-chess-queen-alt'                     => 'chess-queen-alt',
        'fal fa-chess-rook'                          => 'chess-rook',
        'fal fa-chess-rook-alt'                      => 'chess-rook-alt',
        'fal fa-chevron-circle-down'                 => 'chevron-circle-down',
        'fal fa-chevron-circle-left'                 => 'chevron-circle-left',
        'fal fa-chevron-circle-right'                => 'chevron-circle-right',
        'fal fa-chevron-circle-up'                   => 'chevron-circle-up',
        'fal fa-chevron-double-down'                 => 'chevron-double-down',
        'fal fa-chevron-double-left'                 => 'chevron-double-left',
        'fal fa-chevron-double-right'                => 'chevron-double-right',
        'fal fa-chevron-double-up'                   => 'chevron-double-up',
        'fal fa-chevron-down'                        => 'chevron-down',
        'fal fa-chevron-left'                        => 'chevron-left',
        'fal fa-chevron-right'                       => 'chevron-right',
        'fal fa-chevron-square-down'                 => 'chevron-square-down',
        'fal fa-chevron-square-left'                 => 'chevron-square-left',
        'fal fa-chevron-square-right'                => 'chevron-square-right',
        'fal fa-chevron-square-up'                   => 'chevron-square-up',
        'fal fa-chevron-up'                          => 'chevron-up',
        'fal fa-child'                               => 'child',
        'fal fa-chimney'                             => 'chimney',
        'fal fa-church'                              => 'church',
        'fal fa-circle'                              => 'circle',
        'fal fa-circle-notch'                        => 'circle-notch',
        'fal fa-city'                                => 'city',
        'fal fa-claw-marks'                          => 'claw-marks',
        'fal fa-clinic-medical'                      => 'clinic-medical',
        'fal fa-clipboard'                           => 'clipboard',
        'fal fa-clipboard-check'                     => 'clipboard-check',
        'fal fa-clipboard-list'                      => 'clipboard-list',
        'fal fa-clipboard-list-check'                => 'clipboard-list-check',
        'fal fa-clipboard-prescription'              => 'clipboard-prescription',
        'fal fa-clipboard-user'                      => 'clipboard-user',
        'fal fa-clock'                               => 'clock',
        'fal fa-clone'                               => 'clone',
        'fal fa-closed-captioning'                   => 'closed-captioning',
        'fal fa-cloud'                               => 'cloud',
        'fal fa-cloud-download'                      => 'cloud-download',
        'fal fa-cloud-download-alt'                  => 'cloud-download-alt',
        'fal fa-cloud-drizzle'                       => 'cloud-drizzle',
        'fal fa-cloud-hail'                          => 'cloud-hail',
        'fal fa-cloud-hail-mixed'                    => 'cloud-hail-mixed',
        'fal fa-cloud-meatball'                      => 'cloud-meatball',
        'fal fa-cloud-moon'                          => 'cloud-moon',
        'fal fa-cloud-moon-rain'                     => 'cloud-moon-rain',
        'fal fa-cloud-rain'                          => 'cloud-rain',
        'fal fa-cloud-rainbow'                       => 'cloud-rainbow',
        'fal fa-cloud-showers'                       => 'cloud-showers',
        'fal fa-cloud-showers-heavy'                 => 'cloud-showers-heavy',
        'fal fa-cloud-sleet'                         => 'cloud-sleet',
        'fal fa-cloud-snow'                          => 'cloud-snow',
        'fal fa-cloud-sun'                           => 'cloud-sun',
        'fal fa-cloud-sun-rain'                      => 'cloud-sun-rain',
        'fal fa-cloud-upload'                        => 'cloud-upload',
        'fal fa-cloud-upload-alt'                    => 'cloud-upload-alt',
        'fal fa-clouds'                              => 'clouds',
        'fal fa-clouds-moon'                         => 'clouds-moon',
        'fal fa-clouds-sun'                          => 'clouds-sun',
        'fal fa-club'                                => 'club',
        'fal fa-cocktail'                            => 'cocktail',
        'fal fa-code'                                => 'code',
        'fal fa-code-branch'                         => 'code-branch',
        'fal fa-code-commit'                         => 'code-commit',
        'fal fa-code-merge'                          => 'code-merge',
        'fal fa-coffee'                              => 'coffee',
        'fal fa-coffee-togo'                         => 'coffee-togo',
        'fal fa-coffin'                              => 'coffin',
        'fal fa-cog'                                 => 'cog',
        'fal fa-cogs'                                => 'cogs',
        'fal fa-coin'                                => 'coin',
        'fal fa-coins'                               => 'coins',
        'fal fa-columns'                             => 'columns',
        'fal fa-comment'                             => 'comment',
        'fal fa-comment-alt'                         => 'comment-alt',
        'fal fa-comment-alt-check'                   => 'comment-alt-check',
        'fal fa-comment-alt-dollar'                  => 'comment-alt-dollar',
        'fal fa-comment-alt-dots'                    => 'comment-alt-dots',
        'fal fa-comment-alt-edit'                    => 'comment-alt-edit',
        'fal fa-comment-alt-exclamation'             => 'comment-alt-exclamation',
        'fal fa-comment-alt-lines'                   => 'comment-alt-lines',
        'fal fa-comment-alt-medical'                 => 'comment-alt-medical',
        'fal fa-comment-alt-minus'                   => 'comment-alt-minus',
        'fal fa-comment-alt-plus'                    => 'comment-alt-plus',
        'fal fa-comment-alt-slash'                   => 'comment-alt-slash',
        'fal fa-comment-alt-smile'                   => 'comment-alt-smile',
        'fal fa-comment-alt-times'                   => 'comment-alt-times',
        'fal fa-comment-check'                       => 'comment-check',
        'fal fa-comment-dollar'                      => 'comment-dollar',
        'fal fa-comment-dots'                        => 'comment-dots',
        'fal fa-comment-edit'                        => 'comment-edit',
        'fal fa-comment-exclamation'                 => 'comment-exclamation',
        'fal fa-comment-lines'                       => 'comment-lines',
        'fal fa-comment-medical'                     => 'comment-medical',
        'fal fa-comment-minus'                       => 'comment-minus',
        'fal fa-comment-plus'                        => 'comment-plus',
        'fal fa-comment-slash'                       => 'comment-slash',
        'fal fa-comment-smile'                       => 'comment-smile',
        'fal fa-comment-times'                       => 'comment-times',
        'fal fa-comments'                            => 'comments',
        'fal fa-comments-alt'                        => 'comments-alt',
        'fal fa-comments-alt-dollar'                 => 'comments-alt-dollar',
        'fal fa-comments-dollar'                     => 'comments-dollar',
        'fal fa-compact-disc'                        => 'compact-disc',
        'fal fa-compass'                             => 'compass',
        'fal fa-compass-slash'                       => 'compass-slash',
        'fal fa-compress'                            => 'compress',
        'fal fa-compress-alt'                        => 'compress-alt',
        'fal fa-compress-arrows-alt'                 => 'compress-arrows-alt',
        'fal fa-compress-wide'                       => 'compress-wide',
        'fal fa-concierge-bell'                      => 'concierge-bell',
        'fal fa-construction'                        => 'construction',
        'fal fa-container-storage'                   => 'container-storage',
        'fal fa-conveyor-belt'                       => 'conveyor-belt',
        'fal fa-conveyor-belt-alt'                   => 'conveyor-belt-alt',
        'fal fa-cookie'                              => 'cookie',
        'fal fa-cookie-bite'                         => 'cookie-bite',
        'fal fa-copy'                                => 'copy',
        'fal fa-copyright'                           => 'copyright',
        'fal fa-corn'                                => 'corn',
        'fal fa-couch'                               => 'couch',
        'fal fa-cow'                                 => 'cow',
        'fal fa-credit-card'                         => 'credit-card',
        'fal fa-credit-card-blank'                   => 'credit-card-blank',
        'fal fa-credit-card-front'                   => 'credit-card-front',
        'fal fa-cricket'                             => 'cricket',
        'fal fa-croissant'                           => 'croissant',
        'fal fa-crop'                                => 'crop',
        'fal fa-crop-alt'                            => 'crop-alt',
        'fal fa-cross'                               => 'cross',
        'fal fa-crosshairs'                          => 'crosshairs',
        'fal fa-crow'                                => 'crow',
        'fal fa-crown'                               => 'crown',
        'fal fa-crutch'                              => 'crutch',
        'fal fa-crutches'                            => 'crutches',
        'fal fa-cube'                                => 'cube',
        'fal fa-cubes'                               => 'cubes',
        'fal fa-curling'                             => 'curling',
        'fal fa-cut'                                 => 'cut',
        'fal fa-dagger'                              => 'dagger',
        'fal fa-database'                            => 'database',
        'fal fa-deaf'                                => 'deaf',
        'fal fa-debug'                               => 'debug',
        'fal fa-deer'                                => 'deer',
        'fal fa-deer-rudolph'                        => 'deer-rudolph',
        'fal fa-democrat'                            => 'democrat',
        'fal fa-desktop'                             => 'desktop',
        'fal fa-desktop-alt'                         => 'desktop-alt',
        'fal fa-dewpoint'                            => 'dewpoint',
        'fal fa-dharmachakra'                        => 'dharmachakra',
        'fal fa-diagnoses'                           => 'diagnoses',
        'fal fa-diamond'                             => 'diamond',
        'fal fa-dice'                                => 'dice',
        'fal fa-dice-d10'                            => 'dice-d10',
        'fal fa-dice-d12'                            => 'dice-d12',
        'fal fa-dice-d20'                            => 'dice-d20',
        'fal fa-dice-d4'                             => 'dice-d4',
        'fal fa-dice-d6'                             => 'dice-d6',
        'fal fa-dice-d8'                             => 'dice-d8',
        'fal fa-dice-five'                           => 'dice-five',
        'fal fa-dice-four'                           => 'dice-four',
        'fal fa-dice-one'                            => 'dice-one',
        'fal fa-dice-six'                            => 'dice-six',
        'fal fa-dice-three'                          => 'dice-three',
        'fal fa-dice-two'                            => 'dice-two',
        'fal fa-digging'                             => 'digging',
        'fal fa-digital-tachograph'                  => 'digital-tachograph',
        'fal fa-diploma'                             => 'diploma',
        'fal fa-directions'                          => 'directions',
        'fal fa-disease'                             => 'disease',
        'fal fa-divide'                              => 'divide',
        'fal fa-dizzy'                               => 'dizzy',
        'fal fa-dna'                                 => 'dna',
        'fal fa-do-not-enter'                        => 'do-not-enter',
        'fal fa-dog'                                 => 'dog',
        'fal fa-dog-leashed'                         => 'dog-leashed',
        'fal fa-dollar-sign'                         => 'dollar-sign',
        'fal fa-dolly'                               => 'dolly',
        'fal fa-dolly-empty'                         => 'dolly-empty',
        'fal fa-dolly-flatbed'                       => 'dolly-flatbed',
        'fal fa-dolly-flatbed-alt'                   => 'dolly-flatbed-alt',
        'fal fa-dolly-flatbed-empty'                 => 'dolly-flatbed-empty',
        'fal fa-donate'                              => 'donate',
        'fal fa-door-closed'                         => 'door-closed',
        'fal fa-door-open'                           => 'door-open',
        'fal fa-dot-circle'                          => 'dot-circle',
        'fal fa-dove'                                => 'dove',
        'fal fa-download'                            => 'download',
        'fal fa-drafting-compass'                    => 'drafting-compass',
        'fal fa-dragon'                              => 'dragon',
        'fal fa-draw-circle'                         => 'draw-circle',
        'fal fa-draw-polygon'                        => 'draw-polygon',
        'fal fa-draw-square'                         => 'draw-square',
        'fal fa-dreidel'                             => 'dreidel',
        'fal fa-drone'                               => 'drone',
        'fal fa-drone-alt'                           => 'drone-alt',
        'fal fa-drum'                                => 'drum',
        'fal fa-drum-steelpan'                       => 'drum-steelpan',
        'fal fa-drumstick'                           => 'drumstick',
        'fal fa-drumstick-bite'                      => 'drumstick-bite',
        'fal fa-dryer'                               => 'dryer',
        'fal fa-dryer-alt'                           => 'dryer-alt',
        'fal fa-duck'                                => 'duck',
        'fal fa-dumbbell'                            => 'dumbbell',
        'fal fa-dumpster'                            => 'dumpster',
        'fal fa-dumpster-fire'                       => 'dumpster-fire',
        'fal fa-dungeon'                             => 'dungeon',
        'fal fa-ear'                                 => 'ear',
        'fal fa-ear-muffs'                           => 'ear-muffs',
        'fal fa-eclipse'                             => 'eclipse',
        'fal fa-eclipse-alt'                         => 'eclipse-alt',
        'fal fa-edit'                                => 'edit',
        'fal fa-egg'                                 => 'egg',
        'fal fa-egg-fried'                           => 'egg-fried',
        'fal fa-eject'                               => 'eject',
        'fal fa-elephant'                            => 'elephant',
        'fal fa-ellipsis-h'                          => 'ellipsis-h',
        'fal fa-ellipsis-h-alt'                      => 'ellipsis-h-alt',
        'fal fa-ellipsis-v'                          => 'ellipsis-v',
        'fal fa-ellipsis-v-alt'                      => 'ellipsis-v-alt',
        'fal fa-empty-set'                           => 'empty-set',
        'fal fa-engine-warning'                      => 'engine-warning',
        'fal fa-envelope'                            => 'envelope',
        'fal fa-envelope-open'                       => 'envelope-open',
        'fal fa-envelope-open-dollar'                => 'envelope-open-dollar',
        'fal fa-envelope-open-text'                  => 'envelope-open-text',
        'fal fa-envelope-square'                     => 'envelope-square',
        'fal fa-equals'                              => 'equals',
        'fal fa-eraser'                              => 'eraser',
        'fal fa-ethernet'                            => 'ethernet',
        'fal fa-euro-sign'                           => 'euro-sign',
        'fal fa-exchange'                            => 'exchange',
        'fal fa-exchange-alt'                        => 'exchange-alt',
        'fal fa-exclamation'                         => 'exclamation',
        'fal fa-exclamation-circle'                  => 'exclamation-circle',
        'fal fa-exclamation-square'                  => 'exclamation-square',
        'fal fa-exclamation-triangle'                => 'exclamation-triangle',
        'fal fa-expand'                              => 'expand',
        'fal fa-expand-alt'                          => 'expand-alt',
        'fal fa-expand-arrows'                       => 'expand-arrows',
        'fal fa-expand-arrows-alt'                   => 'expand-arrows-alt',
        'fal fa-expand-wide'                         => 'expand-wide',
        'fal fa-external-link'                       => 'external-link',
        'fal fa-external-link-alt'                   => 'external-link-alt',
        'fal fa-external-link-square'                => 'external-link-square',
        'fal fa-external-link-square-alt'            => 'external-link-square-alt',
        'fal fa-eye'                                 => 'eye',
        'fal fa-eye-dropper'                         => 'eye-dropper',
        'fal fa-eye-evil'                            => 'eye-evil',
        'fal fa-eye-slash'                           => 'eye-slash',
        'fal fa-fan'                                 => 'fan',
        'fal fa-farm'                                => 'farm',
        'fal fa-fast-backward'                       => 'fast-backward',
        'fal fa-fast-forward'                        => 'fast-forward',
        'fal fa-fax'                                 => 'fax',
        'fal fa-feather'                             => 'feather',
        'fal fa-feather-alt'                         => 'feather-alt',
        'fal fa-female'                              => 'female',
        'fal fa-field-hockey'                        => 'field-hockey',
        'fal fa-fighter-jet'                         => 'fighter-jet',
        'fal fa-file'                                => 'file',
        'fal fa-file-alt'                            => 'file-alt',
        'fal fa-file-archive'                        => 'file-archive',
        'fal fa-file-audio'                          => 'file-audio',
        'fal fa-file-certificate'                    => 'file-certificate',
        'fal fa-file-chart-line'                     => 'file-chart-line',
        'fal fa-file-chart-pie'                      => 'file-chart-pie',
        'fal fa-file-check'                          => 'file-check',
        'fal fa-file-code'                           => 'file-code',
        'fal fa-file-contract'                       => 'file-contract',
        'fal fa-file-csv'                            => 'file-csv',
        'fal fa-file-download'                       => 'file-download',
        'fal fa-file-edit'                           => 'file-edit',
        'fal fa-file-excel'                          => 'file-excel',
        'fal fa-file-exclamation'                    => 'file-exclamation',
        'fal fa-file-export'                         => 'file-export',
        'fal fa-file-image'                          => 'file-image',
        'fal fa-file-import'                         => 'file-import',
        'fal fa-file-invoice'                        => 'file-invoice',
        'fal fa-file-invoice-dollar'                 => 'file-invoice-dollar',
        'fal fa-file-medical'                        => 'file-medical',
        'fal fa-file-medical-alt'                    => 'file-medical-alt',
        'fal fa-file-minus'                          => 'file-minus',
        'fal fa-file-pdf'                            => 'file-pdf',
        'fal fa-file-plus'                           => 'file-plus',
        'fal fa-file-powerpoint'                     => 'file-powerpoint',
        'fal fa-file-prescription'                   => 'file-prescription',
        'fal fa-file-search'                         => 'file-search',
        'fal fa-file-signature'                      => 'file-signature',
        'fal fa-file-spreadsheet'                    => 'file-spreadsheet',
        'fal fa-file-times'                          => 'file-times',
        'fal fa-file-upload'                         => 'file-upload',
        'fal fa-file-user'                           => 'file-user',
        'fal fa-file-video'                          => 'file-video',
        'fal fa-file-word'                           => 'file-word',
        'fal fa-files-medical'                       => 'files-medical',
        'fal fa-fill'                                => 'fill',
        'fal fa-fill-drip'                           => 'fill-drip',
        'fal fa-film'                                => 'film',
        'fal fa-film-alt'                            => 'film-alt',
        'fal fa-filter'                              => 'filter',
        'fal fa-fingerprint'                         => 'fingerprint',
        'fal fa-fire'                                => 'fire',
        'fal fa-fire-alt'                            => 'fire-alt',
        'fal fa-fire-extinguisher'                   => 'fire-extinguisher',
        'fal fa-fire-smoke'                          => 'fire-smoke',
        'fal fa-fireplace'                           => 'fireplace',
        'fal fa-first-aid'                           => 'first-aid',
        'fal fa-fish'                                => 'fish',
        'fal fa-fish-cooked'                         => 'fish-cooked',
        'fal fa-fist-raised'                         => 'fist-raised',
        'fal fa-flag'                                => 'flag',
        'fal fa-flag-alt'                            => 'flag-alt',
        'fal fa-flag-checkered'                      => 'flag-checkered',
        'fal fa-flag-usa'                            => 'flag-usa',
        'fal fa-flame'                               => 'flame',
        'fal fa-flask'                               => 'flask',
        'fal fa-flask-poison'                        => 'flask-poison',
        'fal fa-flask-potion'                        => 'flask-potion',
        'fal fa-flower'                              => 'flower',
        'fal fa-flower-daffodil'                     => 'flower-daffodil',
        'fal fa-flower-tulip'                        => 'flower-tulip',
        'fal fa-flushed'                             => 'flushed',
        'fal fa-fog'                                 => 'fog',
        'fal fa-folder'                              => 'folder',
        'fal fa-folder-minus'                        => 'folder-minus',
        'fal fa-folder-open'                         => 'folder-open',
        'fal fa-folder-plus'                         => 'folder-plus',
        'fal fa-folder-times'                        => 'folder-times',
        'fal fa-folder-tree'                         => 'folder-tree',
        'fal fa-folders'                             => 'folders',
        'fal fa-font'                                => 'font',
        'fal fa-font-awesome-logo-full'              => 'font-awesome-logo-full',
        'fal fa-font-case'                           => 'font-case',
        'fal fa-football-ball'                       => 'football-ball',
        'fal fa-football-helmet'                     => 'football-helmet',
        'fal fa-forklift'                            => 'forklift',
        'fal fa-forward'                             => 'forward',
        'fal fa-fragile'                             => 'fragile',
        'fal fa-french-fries'                        => 'french-fries',
        'fal fa-frog'                                => 'frog',
        'fal fa-frosty-head'                         => 'frosty-head',
        'fal fa-frown'                               => 'frown',
        'fal fa-frown-open'                          => 'frown-open',
        'fal fa-function'                            => 'function',
        'fal fa-funnel-dollar'                       => 'funnel-dollar',
        'fal fa-futbol'                              => 'futbol',
        'fal fa-game-board'                          => 'game-board',
        'fal fa-game-board-alt'                      => 'game-board-alt',
        'fal fa-gamepad'                             => 'gamepad',
        'fal fa-gas-pump'                            => 'gas-pump',
        'fal fa-gas-pump-slash'                      => 'gas-pump-slash',
        'fal fa-gavel'                               => 'gavel',
        'fal fa-gem'                                 => 'gem',
        'fal fa-genderless'                          => 'genderless',
        'fal fa-ghost'                               => 'ghost',
        'fal fa-gift'                                => 'gift',
        'fal fa-gift-card'                           => 'gift-card',
        'fal fa-gifts'                               => 'gifts',
        'fal fa-gingerbread-man'                     => 'gingerbread-man',
        'fal fa-glass'                               => 'glass',
        'fal fa-glass-champagne'                     => 'glass-champagne',
        'fal fa-glass-cheers'                        => 'glass-cheers',
        'fal fa-glass-citrus'                        => 'glass-citrus',
        'fal fa-glass-martini'                       => 'glass-martini',
        'fal fa-glass-martini-alt'                   => 'glass-martini-alt',
        'fal fa-glass-whiskey'                       => 'glass-whiskey',
        'fal fa-glass-whiskey-rocks'                 => 'glass-whiskey-rocks',
        'fal fa-glasses'                             => 'glasses',
        'fal fa-glasses-alt'                         => 'glasses-alt',
        'fal fa-globe'                               => 'globe',
        'fal fa-globe-africa'                        => 'globe-africa',
        'fal fa-globe-americas'                      => 'globe-americas',
        'fal fa-globe-asia'                          => 'globe-asia',
        'fal fa-globe-europe'                        => 'globe-europe',
        'fal fa-globe-snow'                          => 'globe-snow',
        'fal fa-globe-stand'                         => 'globe-stand',
        'fal fa-golf-ball'                           => 'golf-ball',
        'fal fa-golf-club'                           => 'golf-club',
        'fal fa-gopuram'                             => 'gopuram',
        'fal fa-graduation-cap'                      => 'graduation-cap',
        'fal fa-greater-than'                        => 'greater-than',
        'fal fa-greater-than-equal'                  => 'greater-than-equal',
        'fal fa-grimace'                             => 'grimace',
        'fal fa-grin'                                => 'grin',
        'fal fa-grin-alt'                            => 'grin-alt',
        'fal fa-grin-beam'                           => 'grin-beam',
        'fal fa-grin-beam-sweat'                     => 'grin-beam-sweat',
        'fal fa-grin-hearts'                         => 'grin-hearts',
        'fal fa-grin-squint'                         => 'grin-squint',
        'fal fa-grin-squint-tears'                   => 'grin-squint-tears',
        'fal fa-grin-stars'                          => 'grin-stars',
        'fal fa-grin-tears'                          => 'grin-tears',
        'fal fa-grin-tongue'                         => 'grin-tongue',
        'fal fa-grin-tongue-squint'                  => 'grin-tongue-squint',
        'fal fa-grin-tongue-wink'                    => 'grin-tongue-wink',
        'fal fa-grin-wink'                           => 'grin-wink',
        'fal fa-grip-horizontal'                     => 'grip-horizontal',
        'fal fa-grip-lines'                          => 'grip-lines',
        'fal fa-grip-lines-vertical'                 => 'grip-lines-vertical',
        'fal fa-grip-vertical'                       => 'grip-vertical',
        'fal fa-guitar'                              => 'guitar',
        'fal fa-h-square'                            => 'h-square',
        'fal fa-h1'                                  => 'h1',
        'fal fa-h2'                                  => 'h2',
        'fal fa-h3'                                  => 'h3',
        'fal fa-h4'                                  => 'h4',
        'fal fa-hamburger'                           => 'hamburger',
        'fal fa-hammer'                              => 'hammer',
        'fal fa-hammer-war'                          => 'hammer-war',
        'fal fa-hamsa'                               => 'hamsa',
        'fal fa-hand-heart'                          => 'hand-heart',
        'fal fa-hand-holding'                        => 'hand-holding',
        'fal fa-hand-holding-box'                    => 'hand-holding-box',
        'fal fa-hand-holding-heart'                  => 'hand-holding-heart',
        'fal fa-hand-holding-magic'                  => 'hand-holding-magic',
        'fal fa-hand-holding-seedling'               => 'hand-holding-seedling',
        'fal fa-hand-holding-usd'                    => 'hand-holding-usd',
        'fal fa-hand-holding-water'                  => 'hand-holding-water',
        'fal fa-hand-lizard'                         => 'hand-lizard',
        'fal fa-hand-middle-finger'                  => 'hand-middle-finger',
        'fal fa-hand-paper'                          => 'hand-paper',
        'fal fa-hand-peace'                          => 'hand-peace',
        'fal fa-hand-point-down'                     => 'hand-point-down',
        'fal fa-hand-point-left'                     => 'hand-point-left',
        'fal fa-hand-point-right'                    => 'hand-point-right',
        'fal fa-hand-point-up'                       => 'hand-point-up',
        'fal fa-hand-pointer'                        => 'hand-pointer',
        'fal fa-hand-receiving'                      => 'hand-receiving',
        'fal fa-hand-rock'                           => 'hand-rock',
        'fal fa-hand-scissors'                       => 'hand-scissors',
        'fal fa-hand-spock'                          => 'hand-spock',
        'fal fa-hands'                               => 'hands',
        'fal fa-hands-heart'                         => 'hands-heart',
        'fal fa-hands-helping'                       => 'hands-helping',
        'fal fa-hands-usd'                           => 'hands-usd',
        'fal fa-handshake'                           => 'handshake',
        'fal fa-handshake-alt'                       => 'handshake-alt',
        'fal fa-hanukiah'                            => 'hanukiah',
        'fal fa-hard-hat'                            => 'hard-hat',
        'fal fa-hashtag'                             => 'hashtag',
        'fal fa-hat-chef'                            => 'hat-chef',
        'fal fa-hat-santa'                           => 'hat-santa',
        'fal fa-hat-winter'                          => 'hat-winter',
        'fal fa-hat-witch'                           => 'hat-witch',
        'fal fa-hat-wizard'                          => 'hat-wizard',
        'fal fa-haykal'                              => 'haykal',
        'fal fa-hdd'                                 => 'hdd',
        'fal fa-head-side'                           => 'head-side',
        'fal fa-head-side-brain'                     => 'head-side-brain',
        'fal fa-head-side-medical'                   => 'head-side-medical',
        'fal fa-head-vr'                             => 'head-vr',
        'fal fa-heading'                             => 'heading',
        'fal fa-headphones'                          => 'headphones',
        'fal fa-headphones-alt'                      => 'headphones-alt',
        'fal fa-headset'                             => 'headset',
        'fal fa-heart'                               => 'heart',
        'fal fa-heart-broken'                        => 'heart-broken',
        'fal fa-heart-circle'                        => 'heart-circle',
        'fal fa-heart-rate'                          => 'heart-rate',
        'fal fa-heart-square'                        => 'heart-square',
        'fal fa-heartbeat'                           => 'heartbeat',
        'fal fa-helicopter'                          => 'helicopter',
        'fal fa-helmet-battle'                       => 'helmet-battle',
        'fal fa-hexagon'                             => 'hexagon',
        'fal fa-highlighter'                         => 'highlighter',
        'fal fa-hiking'                              => 'hiking',
        'fal fa-hippo'                               => 'hippo',
        'fal fa-history'                             => 'history',
        'fal fa-hockey-mask'                         => 'hockey-mask',
        'fal fa-hockey-puck'                         => 'hockey-puck',
        'fal fa-hockey-sticks'                       => 'hockey-sticks',
        'fal fa-holly-berry'                         => 'holly-berry',
        'fal fa-home'                                => 'home',
        'fal fa-home-alt'                            => 'home-alt',
        'fal fa-home-heart'                          => 'home-heart',
        'fal fa-home-lg'                             => 'home-lg',
        'fal fa-home-lg-alt'                         => 'home-lg-alt',
        'fal fa-hood-cloak'                          => 'hood-cloak',
        'fal fa-horizontal-rule'                     => 'horizontal-rule',
        'fal fa-horse'                               => 'horse',
        'fal fa-horse-head'                          => 'horse-head',
        'fal fa-hospital'                            => 'hospital',
        'fal fa-hospital-alt'                        => 'hospital-alt',
        'fal fa-hospital-symbol'                     => 'hospital-symbol',
        'fal fa-hospital-user'                       => 'hospital-user',
        'fal fa-hospitals'                           => 'hospitals',
        'fal fa-hot-tub'                             => 'hot-tub',
        'fal fa-hotdog'                              => 'hotdog',
        'fal fa-hotel'                               => 'hotel',
        'fal fa-hourglass'                           => 'hourglass',
        'fal fa-hourglass-end'                       => 'hourglass-end',
        'fal fa-hourglass-half'                      => 'hourglass-half',
        'fal fa-hourglass-start'                     => 'hourglass-start',
        'fal fa-house-damage'                        => 'house-damage',
        'fal fa-house-flood'                         => 'house-flood',
        'fal fa-hryvnia'                             => 'hryvnia',
        'fal fa-humidity'                            => 'humidity',
        'fal fa-hurricane'                           => 'hurricane',
        'fal fa-i-cursor'                            => 'i-cursor',
        'fal fa-ice-cream'                           => 'ice-cream',
        'fal fa-ice-skate'                           => 'ice-skate',
        'fal fa-icicles'                             => 'icicles',
        'fal fa-icons'                               => 'icons',
        'fal fa-icons-alt'                           => 'icons-alt',
        'fal fa-id-badge'                            => 'id-badge',
        'fal fa-id-card'                             => 'id-card',
        'fal fa-id-card-alt'                         => 'id-card-alt',
        'fal fa-igloo'                               => 'igloo',
        'fal fa-image'                               => 'image',
        'fal fa-images'                              => 'images',
        'fal fa-inbox'                               => 'inbox',
        'fal fa-inbox-in'                            => 'inbox-in',
        'fal fa-inbox-out'                           => 'inbox-out',
        'fal fa-indent'                              => 'indent',
        'fal fa-industry'                            => 'industry',
        'fal fa-industry-alt'                        => 'industry-alt',
        'fal fa-infinity'                            => 'infinity',
        'fal fa-info'                                => 'info',
        'fal fa-info-circle'                         => 'info-circle',
        'fal fa-info-square'                         => 'info-square',
        'fal fa-inhaler'                             => 'inhaler',
        'fal fa-integral'                            => 'integral',
        'fal fa-intersection'                        => 'intersection',
        'fal fa-inventory'                           => 'inventory',
        'fal fa-island-tropical'                     => 'island-tropical',
        'fal fa-italic'                              => 'italic',
        'fal fa-jack-o-lantern'                      => 'jack-o-lantern',
        'fal fa-jedi'                                => 'jedi',
        'fal fa-joint'                               => 'joint',
        'fal fa-journal-whills'                      => 'journal-whills',
        'fal fa-kaaba'                               => 'kaaba',
        'fal fa-kerning'                             => 'kerning',
        'fal fa-key'                                 => 'key',
        'fal fa-key-skeleton'                        => 'key-skeleton',
        'fal fa-keyboard'                            => 'keyboard',
        'fal fa-keynote'                             => 'keynote',
        'fal fa-khanda'                              => 'khanda',
        'fal fa-kidneys'                             => 'kidneys',
        'fal fa-kiss'                                => 'kiss',
        'fal fa-kiss-beam'                           => 'kiss-beam',
        'fal fa-kiss-wink-heart'                     => 'kiss-wink-heart',
        'fal fa-kite'                                => 'kite',
        'fal fa-kiwi-bird'                           => 'kiwi-bird',
        'fal fa-knife-kitchen'                       => 'knife-kitchen',
        'fal fa-lambda'                              => 'lambda',
        'fal fa-lamp'                                => 'lamp',
        'fal fa-landmark'                            => 'landmark',
        'fal fa-landmark-alt'                        => 'landmark-alt',
        'fal fa-language'                            => 'language',
        'fal fa-laptop'                              => 'laptop',
        'fal fa-laptop-code'                         => 'laptop-code',
        'fal fa-laptop-medical'                      => 'laptop-medical',
        'fal fa-laugh'                               => 'laugh',
        'fal fa-laugh-beam'                          => 'laugh-beam',
        'fal fa-laugh-squint'                        => 'laugh-squint',
        'fal fa-laugh-wink'                          => 'laugh-wink',
        'fal fa-layer-group'                         => 'layer-group',
        'fal fa-layer-minus'                         => 'layer-minus',
        'fal fa-layer-plus'                          => 'layer-plus',
        'fal fa-leaf'                                => 'leaf',
        'fal fa-leaf-heart'                          => 'leaf-heart',
        'fal fa-leaf-maple'                          => 'leaf-maple',
        'fal fa-leaf-oak'                            => 'leaf-oak',
        'fal fa-lemon'                               => 'lemon',
        'fal fa-less-than'                           => 'less-than',
        'fal fa-less-than-equal'                     => 'less-than-equal',
        'fal fa-level-down'                          => 'level-down',
        'fal fa-level-down-alt'                      => 'level-down-alt',
        'fal fa-level-up'                            => 'level-up',
        'fal fa-level-up-alt'                        => 'level-up-alt',
        'fal fa-life-ring'                           => 'life-ring',
        'fal fa-lightbulb'                           => 'lightbulb',
        'fal fa-lightbulb-dollar'                    => 'lightbulb-dollar',
        'fal fa-lightbulb-exclamation'               => 'lightbulb-exclamation',
        'fal fa-lightbulb-on'                        => 'lightbulb-on',
        'fal fa-lightbulb-slash'                     => 'lightbulb-slash',
        'fal fa-lights-holiday'                      => 'lights-holiday',
        'fal fa-line-columns'                        => 'line-columns',
        'fal fa-line-height'                         => 'line-height',
        'fal fa-link'                                => 'link',
        'fal fa-lips'                                => 'lips',
        'fal fa-lira-sign'                           => 'lira-sign',
        'fal fa-list'                                => 'list',
        'fal fa-list-alt'                            => 'list-alt',
        'fal fa-list-ol'                             => 'list-ol',
        'fal fa-list-ul'                             => 'list-ul',
        'fal fa-location'                            => 'location',
        'fal fa-location-arrow'                      => 'location-arrow',
        'fal fa-location-circle'                     => 'location-circle',
        'fal fa-location-slash'                      => 'location-slash',
        'fal fa-lock'                                => 'lock',
        'fal fa-lock-alt'                            => 'lock-alt',
        'fal fa-lock-open'                           => 'lock-open',
        'fal fa-lock-open-alt'                       => 'lock-open-alt',
        'fal fa-long-arrow-alt-down'                 => 'long-arrow-alt-down',
        'fal fa-long-arrow-alt-left'                 => 'long-arrow-alt-left',
        'fal fa-long-arrow-alt-right'                => 'long-arrow-alt-right',
        'fal fa-long-arrow-alt-up'                   => 'long-arrow-alt-up',
        'fal fa-long-arrow-down'                     => 'long-arrow-down',
        'fal fa-long-arrow-left'                     => 'long-arrow-left',
        'fal fa-long-arrow-right'                    => 'long-arrow-right',
        'fal fa-long-arrow-up'                       => 'long-arrow-up',
        'fal fa-loveseat'                            => 'loveseat',
        'fal fa-low-vision'                          => 'low-vision',
        'fal fa-luchador'                            => 'luchador',
        'fal fa-luggage-cart'                        => 'luggage-cart',
        'fal fa-lungs'                               => 'lungs',
        'fal fa-mace'                                => 'mace',
        'fal fa-magic'                               => 'magic',
        'fal fa-magnet'                              => 'magnet',
        'fal fa-mail-bulk'                           => 'mail-bulk',
        'fal fa-mailbox'                             => 'mailbox',
        'fal fa-male'                                => 'male',
        'fal fa-mandolin'                            => 'mandolin',
        'fal fa-map'                                 => 'map',
        'fal fa-map-marked'                          => 'map-marked',
        'fal fa-map-marked-alt'                      => 'map-marked-alt',
        'fal fa-map-marker'                          => 'map-marker',
        'fal fa-map-marker-alt'                      => 'map-marker-alt',
        'fal fa-map-marker-alt-slash'                => 'map-marker-alt-slash',
        'fal fa-map-marker-check'                    => 'map-marker-check',
        'fal fa-map-marker-edit'                     => 'map-marker-edit',
        'fal fa-map-marker-exclamation'              => 'map-marker-exclamation',
        'fal fa-map-marker-minus'                    => 'map-marker-minus',
        'fal fa-map-marker-plus'                     => 'map-marker-plus',
        'fal fa-map-marker-question'                 => 'map-marker-question',
        'fal fa-map-marker-slash'                    => 'map-marker-slash',
        'fal fa-map-marker-smile'                    => 'map-marker-smile',
        'fal fa-map-marker-times'                    => 'map-marker-times',
        'fal fa-map-pin'                             => 'map-pin',
        'fal fa-map-signs'                           => 'map-signs',
        'fal fa-marker'                              => 'marker',
        'fal fa-mars'                                => 'mars',
        'fal fa-mars-double'                         => 'mars-double',
        'fal fa-mars-stroke'                         => 'mars-stroke',
        'fal fa-mars-stroke-h'                       => 'mars-stroke-h',
        'fal fa-mars-stroke-v'                       => 'mars-stroke-v',
        'fal fa-mask'                                => 'mask',
        'fal fa-meat'                                => 'meat',
        'fal fa-medal'                               => 'medal',
        'fal fa-medkit'                              => 'medkit',
        'fal fa-megaphone'                           => 'megaphone',
        'fal fa-meh'                                 => 'meh',
        'fal fa-meh-blank'                           => 'meh-blank',
        'fal fa-meh-rolling-eyes'                    => 'meh-rolling-eyes',
        'fal fa-memory'                              => 'memory',
        'fal fa-menorah'                             => 'menorah',
        'fal fa-mercury'                             => 'mercury',
        'fal fa-meteor'                              => 'meteor',
        'fal fa-microchip'                           => 'microchip',
        'fal fa-microphone'                          => 'microphone',
        'fal fa-microphone-alt'                      => 'microphone-alt',
        'fal fa-microphone-alt-slash'                => 'microphone-alt-slash',
        'fal fa-microphone-slash'                    => 'microphone-slash',
        'fal fa-microscope'                          => 'microscope',
        'fal fa-mind-share'                          => 'mind-share',
        'fal fa-minus'                               => 'minus',
        'fal fa-minus-circle'                        => 'minus-circle',
        'fal fa-minus-hexagon'                       => 'minus-hexagon',
        'fal fa-minus-octagon'                       => 'minus-octagon',
        'fal fa-minus-square'                        => 'minus-square',
        'fal fa-mistletoe'                           => 'mistletoe',
        'fal fa-mitten'                              => 'mitten',
        'fal fa-mobile'                              => 'mobile',
        'fal fa-mobile-alt'                          => 'mobile-alt',
        'fal fa-mobile-android'                      => 'mobile-android',
        'fal fa-mobile-android-alt'                  => 'mobile-android-alt',
        'fal fa-money-bill'                          => 'money-bill',
        'fal fa-money-bill-alt'                      => 'money-bill-alt',
        'fal fa-money-bill-wave'                     => 'money-bill-wave',
        'fal fa-money-bill-wave-alt'                 => 'money-bill-wave-alt',
        'fal fa-money-check'                         => 'money-check',
        'fal fa-money-check-alt'                     => 'money-check-alt',
        'fal fa-money-check-edit'                    => 'money-check-edit',
        'fal fa-money-check-edit-alt'                => 'money-check-edit-alt',
        'fal fa-monitor-heart-rate'                  => 'monitor-heart-rate',
        'fal fa-monkey'                              => 'monkey',
        'fal fa-monument'                            => 'monument',
        'fal fa-moon'                                => 'moon',
        'fal fa-moon-cloud'                          => 'moon-cloud',
        'fal fa-moon-stars'                          => 'moon-stars',
        'fal fa-mortar-pestle'                       => 'mortar-pestle',
        'fal fa-mosque'                              => 'mosque',
        'fal fa-motorcycle'                          => 'motorcycle',
        'fal fa-mountain'                            => 'mountain',
        'fal fa-mountains'                           => 'mountains',
        'fal fa-mouse-pointer'                       => 'mouse-pointer',
        'fal fa-mug'                                 => 'mug',
        'fal fa-mug-hot'                             => 'mug-hot',
        'fal fa-mug-marshmallows'                    => 'mug-marshmallows',
        'fal fa-mug-tea'                             => 'mug-tea',
        'fal fa-music'                               => 'music',
        'fal fa-narwhal'                             => 'narwhal',
        'fal fa-network-wired'                       => 'network-wired',
        'fal fa-neuter'                              => 'neuter',
        'fal fa-newspaper'                           => 'newspaper',
        'fal fa-not-equal'                           => 'not-equal',
        'fal fa-notes-medical'                       => 'notes-medical',
        'fal fa-object-group'                        => 'object-group',
        'fal fa-object-ungroup'                      => 'object-ungroup',
        'fal fa-octagon'                             => 'octagon',
        'fal fa-oil-can'                             => 'oil-can',
        'fal fa-oil-temp'                            => 'oil-temp',
        'fal fa-om'                                  => 'om',
        'fal fa-omega'                               => 'omega',
        'fal fa-ornament'                            => 'ornament',
        'fal fa-otter'                               => 'otter',
        'fal fa-outdent'                             => 'outdent',
        'fal fa-overline'                            => 'overline',
        'fal fa-page-break'                          => 'page-break',
        'fal fa-pager'                               => 'pager',
        'fal fa-paint-brush'                         => 'paint-brush',
        'fal fa-paint-brush-alt'                     => 'paint-brush-alt',
        'fal fa-paint-roller'                        => 'paint-roller',
        'fal fa-palette'                             => 'palette',
        'fal fa-pallet'                              => 'pallet',
        'fal fa-pallet-alt'                          => 'pallet-alt',
        'fal fa-paper-plane'                         => 'paper-plane',
        'fal fa-paperclip'                           => 'paperclip',
        'fal fa-parachute-box'                       => 'parachute-box',
        'fal fa-paragraph'                           => 'paragraph',
        'fal fa-paragraph-rtl'                       => 'paragraph-rtl',
        'fal fa-parking'                             => 'parking',
        'fal fa-parking-circle'                      => 'parking-circle',
        'fal fa-parking-circle-slash'                => 'parking-circle-slash',
        'fal fa-parking-slash'                       => 'parking-slash',
        'fal fa-passport'                            => 'passport',
        'fal fa-pastafarianism'                      => 'pastafarianism',
        'fal fa-paste'                               => 'paste',
        'fal fa-pause'                               => 'pause',
        'fal fa-pause-circle'                        => 'pause-circle',
        'fal fa-paw'                                 => 'paw',
        'fal fa-paw-alt'                             => 'paw-alt',
        'fal fa-paw-claws'                           => 'paw-claws',
        'fal fa-peace'                               => 'peace',
        'fal fa-pegasus'                             => 'pegasus',
        'fal fa-pen'                                 => 'pen',
        'fal fa-pen-alt'                             => 'pen-alt',
        'fal fa-pen-fancy'                           => 'pen-fancy',
        'fal fa-pen-nib'                             => 'pen-nib',
        'fal fa-pen-square'                          => 'pen-square',
        'fal fa-pencil'                              => 'pencil',
        'fal fa-pencil-alt'                          => 'pencil-alt',
        'fal fa-pencil-paintbrush'                   => 'pencil-paintbrush',
        'fal fa-pencil-ruler'                        => 'pencil-ruler',
        'fal fa-pennant'                             => 'pennant',
        'fal fa-people-carry'                        => 'people-carry',
        'fal fa-pepper-hot'                          => 'pepper-hot',
        'fal fa-percent'                             => 'percent',
        'fal fa-percentage'                          => 'percentage',
        'fal fa-person-booth'                        => 'person-booth',
        'fal fa-person-carry'                        => 'person-carry',
        'fal fa-person-dolly'                        => 'person-dolly',
        'fal fa-person-dolly-empty'                  => 'person-dolly-empty',
        'fal fa-person-sign'                         => 'person-sign',
        'fal fa-phone'                               => 'phone',
        'fal fa-phone-alt'                           => 'phone-alt',
        'fal fa-phone-laptop'                        => 'phone-laptop',
        'fal fa-phone-office'                        => 'phone-office',
        'fal fa-phone-plus'                          => 'phone-plus',
        'fal fa-phone-slash'                         => 'phone-slash',
        'fal fa-phone-square'                        => 'phone-square',
        'fal fa-phone-square-alt'                    => 'phone-square-alt',
        'fal fa-phone-volume'                        => 'phone-volume',
        'fal fa-photo-video'                         => 'photo-video',
        'fal fa-pi'                                  => 'pi',
        'fal fa-pie'                                 => 'pie',
        'fal fa-pig'                                 => 'pig',
        'fal fa-piggy-bank'                          => 'piggy-bank',
        'fal fa-pills'                               => 'pills',
        'fal fa-pizza'                               => 'pizza',
        'fal fa-pizza-slice'                         => 'pizza-slice',
        'fal fa-place-of-worship'                    => 'place-of-worship',
        'fal fa-plane'                               => 'plane',
        'fal fa-plane-alt'                           => 'plane-alt',
        'fal fa-plane-arrival'                       => 'plane-arrival',
        'fal fa-plane-departure'                     => 'plane-departure',
        'fal fa-play'                                => 'play',
        'fal fa-play-circle'                         => 'play-circle',
        'fal fa-plug'                                => 'plug',
        'fal fa-plus'                                => 'plus',
        'fal fa-plus-circle'                         => 'plus-circle',
        'fal fa-plus-hexagon'                        => 'plus-hexagon',
        'fal fa-plus-octagon'                        => 'plus-octagon',
        'fal fa-plus-square'                         => 'plus-square',
        'fal fa-podcast'                             => 'podcast',
        'fal fa-podium'                              => 'podium',
        'fal fa-podium-star'                         => 'podium-star',
        'fal fa-poll'                                => 'poll',
        'fal fa-poll-h'                              => 'poll-h',
        'fal fa-poll-people'                         => 'poll-people',
        'fal fa-poo'                                 => 'poo',
        'fal fa-poo-storm'                           => 'poo-storm',
        'fal fa-poop'                                => 'poop',
        'fal fa-popcorn'                             => 'popcorn',
        'fal fa-portrait'                            => 'portrait',
        'fal fa-pound-sign'                          => 'pound-sign',
        'fal fa-power-off'                           => 'power-off',
        'fal fa-pray'                                => 'pray',
        'fal fa-praying-hands'                       => 'praying-hands',
        'fal fa-prescription'                        => 'prescription',
        'fal fa-prescription-bottle'                 => 'prescription-bottle',
        'fal fa-prescription-bottle-alt'             => 'prescription-bottle-alt',
        'fal fa-presentation'                        => 'presentation',
        'fal fa-print'                               => 'print',
        'fal fa-print-search'                        => 'print-search',
        'fal fa-print-slash'                         => 'print-slash',
        'fal fa-procedures'                          => 'procedures',
        'fal fa-project-diagram'                     => 'project-diagram',
        'fal fa-pumpkin'                             => 'pumpkin',
        'fal fa-puzzle-piece'                        => 'puzzle-piece',
        'fal fa-qrcode'                              => 'qrcode',
        'fal fa-question'                            => 'question',
        'fal fa-question-circle'                     => 'question-circle',
        'fal fa-question-square'                     => 'question-square',
        'fal fa-quidditch'                           => 'quidditch',
        'fal fa-quote-left'                          => 'quote-left',
        'fal fa-quote-right'                         => 'quote-right',
        'fal fa-quran'                               => 'quran',
        'fal fa-rabbit'                              => 'rabbit',
        'fal fa-rabbit-fast'                         => 'rabbit-fast',
        'fal fa-racquet'                             => 'racquet',
        'fal fa-radiation'                           => 'radiation',
        'fal fa-radiation-alt'                       => 'radiation-alt',
        'fal fa-rainbow'                             => 'rainbow',
        'fal fa-raindrops'                           => 'raindrops',
        'fal fa-ram'                                 => 'ram',
        'fal fa-ramp-loading'                        => 'ramp-loading',
        'fal fa-random'                              => 'random',
        'fal fa-receipt'                             => 'receipt',
        'fal fa-rectangle-landscape'                 => 'rectangle-landscape',
        'fal fa-rectangle-portrait'                  => 'rectangle-portrait',
        'fal fa-rectangle-wide'                      => 'rectangle-wide',
        'fal fa-recycle'                             => 'recycle',
        'fal fa-redo'                                => 'redo',
        'fal fa-redo-alt'                            => 'redo-alt',
        'fal fa-registered'                          => 'registered',
        'fal fa-remove-format'                       => 'remove-format',
        'fal fa-repeat'                              => 'repeat',
        'fal fa-repeat-1'                            => 'repeat-1',
        'fal fa-repeat-1-alt'                        => 'repeat-1-alt',
        'fal fa-repeat-alt'                          => 'repeat-alt',
        'fal fa-reply'                               => 'reply',
        'fal fa-reply-all'                           => 'reply-all',
        'fal fa-republican'                          => 'republican',
        'fal fa-restroom'                            => 'restroom',
        'fal fa-retweet'                             => 'retweet',
        'fal fa-retweet-alt'                         => 'retweet-alt',
        'fal fa-ribbon'                              => 'ribbon',
        'fal fa-ring'                                => 'ring',
        'fal fa-rings-wedding'                       => 'rings-wedding',
        'fal fa-road'                                => 'road',
        'fal fa-robot'                               => 'robot',
        'fal fa-rocket'                              => 'rocket',
        'fal fa-route'                               => 'route',
        'fal fa-route-highway'                       => 'route-highway',
        'fal fa-route-interstate'                    => 'route-interstate',
        'fal fa-rss'                                 => 'rss',
        'fal fa-rss-square'                          => 'rss-square',
        'fal fa-ruble-sign'                          => 'ruble-sign',
        'fal fa-ruler'                               => 'ruler',
        'fal fa-ruler-combined'                      => 'ruler-combined',
        'fal fa-ruler-horizontal'                    => 'ruler-horizontal',
        'fal fa-ruler-triangle'                      => 'ruler-triangle',
        'fal fa-ruler-vertical'                      => 'ruler-vertical',
        'fal fa-running'                             => 'running',
        'fal fa-rupee-sign'                          => 'rupee-sign',
        'fal fa-rv'                                  => 'rv',
        'fal fa-sack'                                => 'sack',
        'fal fa-sack-dollar'                         => 'sack-dollar',
        'fal fa-sad-cry'                             => 'sad-cry',
        'fal fa-sad-tear'                            => 'sad-tear',
        'fal fa-salad'                               => 'salad',
        'fal fa-sandwich'                            => 'sandwich',
        'fal fa-satellite'                           => 'satellite',
        'fal fa-satellite-dish'                      => 'satellite-dish',
        'fal fa-sausage'                             => 'sausage',
        'fal fa-save'                                => 'save',
        'fal fa-scalpel'                             => 'scalpel',
        'fal fa-scalpel-path'                        => 'scalpel-path',
        'fal fa-scanner'                             => 'scanner',
        'fal fa-scanner-keyboard'                    => 'scanner-keyboard',
        'fal fa-scanner-touchscreen'                 => 'scanner-touchscreen',
        'fal fa-scarecrow'                           => 'scarecrow',
        'fal fa-scarf'                               => 'scarf',
        'fal fa-school'                              => 'school',
        'fal fa-screwdriver'                         => 'screwdriver',
        'fal fa-scroll'                              => 'scroll',
        'fal fa-scroll-old'                          => 'scroll-old',
        'fal fa-scrubber'                            => 'scrubber',
        'fal fa-scythe'                              => 'scythe',
        'fal fa-sd-card'                             => 'sd-card',
        'fal fa-search'                              => 'search',
        'fal fa-search-dollar'                       => 'search-dollar',
        'fal fa-search-location'                     => 'search-location',
        'fal fa-search-minus'                        => 'search-minus',
        'fal fa-search-plus'                         => 'search-plus',
        'fal fa-seedling'                            => 'seedling',
        'fal fa-send-back'                           => 'send-back',
        'fal fa-send-backward'                       => 'send-backward',
        'fal fa-server'                              => 'server',
        'fal fa-shapes'                              => 'shapes',
        'fal fa-share'                               => 'share',
        'fal fa-share-all'                           => 'share-all',
        'fal fa-share-alt'                           => 'share-alt',
        'fal fa-share-alt-square'                    => 'share-alt-square',
        'fal fa-share-square'                        => 'share-square',
        'fal fa-sheep'                               => 'sheep',
        'fal fa-shekel-sign'                         => 'shekel-sign',
        'fal fa-shield'                              => 'shield',
        'fal fa-shield-alt'                          => 'shield-alt',
        'fal fa-shield-check'                        => 'shield-check',
        'fal fa-shield-cross'                        => 'shield-cross',
        'fal fa-ship'                                => 'ship',
        'fal fa-shipping-fast'                       => 'shipping-fast',
        'fal fa-shipping-timed'                      => 'shipping-timed',
        'fal fa-shish-kebab'                         => 'shish-kebab',
        'fal fa-shoe-prints'                         => 'shoe-prints',
        'fal fa-shopping-bag'                        => 'shopping-bag',
        'fal fa-shopping-basket'                     => 'shopping-basket',
        'fal fa-shopping-cart'                       => 'shopping-cart',
        'fal fa-shovel'                              => 'shovel',
        'fal fa-shovel-snow'                         => 'shovel-snow',
        'fal fa-shower'                              => 'shower',
        'fal fa-shredder'                            => 'shredder',
        'fal fa-shuttle-van'                         => 'shuttle-van',
        'fal fa-shuttlecock'                         => 'shuttlecock',
        'fal fa-sickle'                              => 'sickle',
        'fal fa-sigma'                               => 'sigma',
        'fal fa-sign'                                => 'sign',
        'fal fa-sign-in'                             => 'sign-in',
        'fal fa-sign-in-alt'                         => 'sign-in-alt',
        'fal fa-sign-language'                       => 'sign-language',
        'fal fa-sign-out'                            => 'sign-out',
        'fal fa-sign-out-alt'                        => 'sign-out-alt',
        'fal fa-signal'                              => 'signal',
        'fal fa-signal-1'                            => 'signal-1',
        'fal fa-signal-2'                            => 'signal-2',
        'fal fa-signal-3'                            => 'signal-3',
        'fal fa-signal-4'                            => 'signal-4',
        'fal fa-signal-alt'                          => 'signal-alt',
        'fal fa-signal-alt-1'                        => 'signal-alt-1',
        'fal fa-signal-alt-2'                        => 'signal-alt-2',
        'fal fa-signal-alt-3'                        => 'signal-alt-3',
        'fal fa-signal-alt-slash'                    => 'signal-alt-slash',
        'fal fa-signal-slash'                        => 'signal-slash',
        'fal fa-signature'                           => 'signature',
        'fal fa-sim-card'                            => 'sim-card',
        'fal fa-sitemap'                             => 'sitemap',
        'fal fa-skating'                             => 'skating',
        'fal fa-skeleton'                            => 'skeleton',
        'fal fa-ski-jump'                            => 'ski-jump',
        'fal fa-ski-lift'                            => 'ski-lift',
        'fal fa-skiing'                              => 'skiing',
        'fal fa-skiing-nordic'                       => 'skiing-nordic',
        'fal fa-skull'                               => 'skull',
        'fal fa-skull-crossbones'                    => 'skull-crossbones',
        'fal fa-slash'                               => 'slash',
        'fal fa-sledding'                            => 'sledding',
        'fal fa-sleigh'                              => 'sleigh',
        'fal fa-sliders-h'                           => 'sliders-h',
        'fal fa-sliders-h-square'                    => 'sliders-h-square',
        'fal fa-sliders-v'                           => 'sliders-v',
        'fal fa-sliders-v-square'                    => 'sliders-v-square',
        'fal fa-smile'                               => 'smile',
        'fal fa-smile-beam'                          => 'smile-beam',
        'fal fa-smile-plus'                          => 'smile-plus',
        'fal fa-smile-wink'                          => 'smile-wink',
        'fal fa-smog'                                => 'smog',
        'fal fa-smoke'                               => 'smoke',
        'fal fa-smoking'                             => 'smoking',
        'fal fa-smoking-ban'                         => 'smoking-ban',
        'fal fa-sms'                                 => 'sms',
        'fal fa-snake'                               => 'snake',
        'fal fa-snooze'                              => 'snooze',
        'fal fa-snow-blowing'                        => 'snow-blowing',
        'fal fa-snowboarding'                        => 'snowboarding',
        'fal fa-snowflake'                           => 'snowflake',
        'fal fa-snowflakes'                          => 'snowflakes',
        'fal fa-snowman'                             => 'snowman',
        'fal fa-snowmobile'                          => 'snowmobile',
        'fal fa-snowplow'                            => 'snowplow',
        'fal fa-socks'                               => 'socks',
        'fal fa-solar-panel'                         => 'solar-panel',
        'fal fa-sort'                                => 'sort',
        'fal fa-sort-alpha-down'                     => 'sort-alpha-down',
        'fal fa-sort-alpha-down-alt'                 => 'sort-alpha-down-alt',
        'fal fa-sort-alpha-up'                       => 'sort-alpha-up',
        'fal fa-sort-alpha-up-alt'                   => 'sort-alpha-up-alt',
        'fal fa-sort-alt'                            => 'sort-alt',
        'fal fa-sort-amount-down'                    => 'sort-amount-down',
        'fal fa-sort-amount-down-alt'                => 'sort-amount-down-alt',
        'fal fa-sort-amount-up'                      => 'sort-amount-up',
        'fal fa-sort-amount-up-alt'                  => 'sort-amount-up-alt',
        'fal fa-sort-down'                           => 'sort-down',
        'fal fa-sort-numeric-down'                   => 'sort-numeric-down',
        'fal fa-sort-numeric-down-alt'               => 'sort-numeric-down-alt',
        'fal fa-sort-numeric-up'                     => 'sort-numeric-up',
        'fal fa-sort-numeric-up-alt'                 => 'sort-numeric-up-alt',
        'fal fa-sort-shapes-down'                    => 'sort-shapes-down',
        'fal fa-sort-shapes-down-alt'                => 'sort-shapes-down-alt',
        'fal fa-sort-shapes-up'                      => 'sort-shapes-up',
        'fal fa-sort-shapes-up-alt'                  => 'sort-shapes-up-alt',
        'fal fa-sort-size-down'                      => 'sort-size-down',
        'fal fa-sort-size-down-alt'                  => 'sort-size-down-alt',
        'fal fa-sort-size-up'                        => 'sort-size-up',
        'fal fa-sort-size-up-alt'                    => 'sort-size-up-alt',
        'fal fa-sort-up'                             => 'sort-up',
        'fal fa-soup'                                => 'soup',
        'fal fa-spa'                                 => 'spa',
        'fal fa-space-shuttle'                       => 'space-shuttle',
        'fal fa-spade'                               => 'spade',
        'fal fa-sparkles'                            => 'sparkles',
        'fal fa-spell-check'                         => 'spell-check',
        'fal fa-spider'                              => 'spider',
        'fal fa-spider-black-widow'                  => 'spider-black-widow',
        'fal fa-spider-web'                          => 'spider-web',
        'fal fa-spinner'                             => 'spinner',
        'fal fa-spinner-third'                       => 'spinner-third',
        'fal fa-splotch'                             => 'splotch',
        'fal fa-spray-can'                           => 'spray-can',
        'fal fa-square'                              => 'square',
        'fal fa-square-full'                         => 'square-full',
        'fal fa-square-root'                         => 'square-root',
        'fal fa-square-root-alt'                     => 'square-root-alt',
        'fal fa-squirrel'                            => 'squirrel',
        'fal fa-staff'                               => 'staff',
        'fal fa-stamp'                               => 'stamp',
        'fal fa-star'                                => 'star',
        'fal fa-star-and-crescent'                   => 'star-and-crescent',
        'fal fa-star-christmas'                      => 'star-christmas',
        'fal fa-star-exclamation'                    => 'star-exclamation',
        'fal fa-star-half'                           => 'star-half',
        'fal fa-star-half-alt'                       => 'star-half-alt',
        'fal fa-star-of-david'                       => 'star-of-david',
        'fal fa-star-of-life'                        => 'star-of-life',
        'fal fa-stars'                               => 'stars',
        'fal fa-steak'                               => 'steak',
        'fal fa-steering-wheel'                      => 'steering-wheel',
        'fal fa-step-backward'                       => 'step-backward',
        'fal fa-step-forward'                        => 'step-forward',
        'fal fa-stethoscope'                         => 'stethoscope',
        'fal fa-sticky-note'                         => 'sticky-note',
        'fal fa-stocking'                            => 'stocking',
        'fal fa-stomach'                             => 'stomach',
        'fal fa-stop'                                => 'stop',
        'fal fa-stop-circle'                         => 'stop-circle',
        'fal fa-stopwatch'                           => 'stopwatch',
        'fal fa-store'                               => 'store',
        'fal fa-store-alt'                           => 'store-alt',
        'fal fa-stream'                              => 'stream',
        'fal fa-street-view'                         => 'street-view',
        'fal fa-stretcher'                           => 'stretcher',
        'fal fa-strikethrough'                       => 'strikethrough',
        'fal fa-stroopwafel'                         => 'stroopwafel',
        'fal fa-subscript'                           => 'subscript',
        'fal fa-subway'                              => 'subway',
        'fal fa-suitcase'                            => 'suitcase',
        'fal fa-suitcase-rolling'                    => 'suitcase-rolling',
        'fal fa-sun'                                 => 'sun',
        'fal fa-sun-cloud'                           => 'sun-cloud',
        'fal fa-sun-dust'                            => 'sun-dust',
        'fal fa-sun-haze'                            => 'sun-haze',
        'fal fa-sunglasses'                          => 'sunglasses',
        'fal fa-sunrise'                             => 'sunrise',
        'fal fa-sunset'                              => 'sunset',
        'fal fa-superscript'                         => 'superscript',
        'fal fa-surprise'                            => 'surprise',
        'fal fa-swatchbook'                          => 'swatchbook',
        'fal fa-swimmer'                             => 'swimmer',
        'fal fa-swimming-pool'                       => 'swimming-pool',
        'fal fa-sword'                               => 'sword',
        'fal fa-swords'                              => 'swords',
        'fal fa-synagogue'                           => 'synagogue',
        'fal fa-sync'                                => 'sync',
        'fal fa-sync-alt'                            => 'sync-alt',
        'fal fa-syringe'                             => 'syringe',
        'fal fa-table'                               => 'table',
        'fal fa-table-tennis'                        => 'table-tennis',
        'fal fa-tablet'                              => 'tablet',
        'fal fa-tablet-alt'                          => 'tablet-alt',
        'fal fa-tablet-android'                      => 'tablet-android',
        'fal fa-tablet-android-alt'                  => 'tablet-android-alt',
        'fal fa-tablet-rugged'                       => 'tablet-rugged',
        'fal fa-tablets'                             => 'tablets',
        'fal fa-tachometer'                          => 'tachometer',
        'fal fa-tachometer-alt'                      => 'tachometer-alt',
        'fal fa-tachometer-alt-average'              => 'tachometer-alt-average',
        'fal fa-tachometer-alt-fast'                 => 'tachometer-alt-fast',
        'fal fa-tachometer-alt-fastest'              => 'tachometer-alt-fastest',
        'fal fa-tachometer-alt-slow'                 => 'tachometer-alt-slow',
        'fal fa-tachometer-alt-slowest'              => 'tachometer-alt-slowest',
        'fal fa-tachometer-average'                  => 'tachometer-average',
        'fal fa-tachometer-fast'                     => 'tachometer-fast',
        'fal fa-tachometer-fastest'                  => 'tachometer-fastest',
        'fal fa-tachometer-slow'                     => 'tachometer-slow',
        'fal fa-tachometer-slowest'                  => 'tachometer-slowest',
        'fal fa-taco'                                => 'taco',
        'fal fa-tag'                                 => 'tag',
        'fal fa-tags'                                => 'tags',
        'fal fa-tally'                               => 'tally',
        'fal fa-tanakh'                              => 'tanakh',
        'fal fa-tape'                                => 'tape',
        'fal fa-tasks'                               => 'tasks',
        'fal fa-tasks-alt'                           => 'tasks-alt',
        'fal fa-taxi'                                => 'taxi',
        'fal fa-teeth'                               => 'teeth',
        'fal fa-teeth-open'                          => 'teeth-open',
        'fal fa-temperature-frigid'                  => 'temperature-frigid',
        'fal fa-temperature-high'                    => 'temperature-high',
        'fal fa-temperature-hot'                     => 'temperature-hot',
        'fal fa-temperature-low'                     => 'temperature-low',
        'fal fa-tenge'                               => 'tenge',
        'fal fa-tennis-ball'                         => 'tennis-ball',
        'fal fa-terminal'                            => 'terminal',
        'fal fa-text'                                => 'text',
        'fal fa-text-height'                         => 'text-height',
        'fal fa-text-size'                           => 'text-size',
        'fal fa-text-width'                          => 'text-width',
        'fal fa-th'                                  => 'th',
        'fal fa-th-large'                            => 'th-large',
        'fal fa-th-list'                             => 'th-list',
        'fal fa-theater-masks'                       => 'theater-masks',
        'fal fa-thermometer'                         => 'thermometer',
        'fal fa-thermometer-empty'                   => 'thermometer-empty',
        'fal fa-thermometer-full'                    => 'thermometer-full',
        'fal fa-thermometer-half'                    => 'thermometer-half',
        'fal fa-thermometer-quarter'                 => 'thermometer-quarter',
        'fal fa-thermometer-three-quarters'          => 'thermometer-three-quarters',
        'fal fa-theta'                               => 'theta',
        'fal fa-thumbs-down'                         => 'thumbs-down',
        'fal fa-thumbs-up'                           => 'thumbs-up',
        'fal fa-thumbtack'                           => 'thumbtack',
        'fal fa-thunderstorm'                        => 'thunderstorm',
        'fal fa-thunderstorm-moon'                   => 'thunderstorm-moon',
        'fal fa-thunderstorm-sun'                    => 'thunderstorm-sun',
        'fal fa-ticket'                              => 'ticket',
        'fal fa-ticket-alt'                          => 'ticket-alt',
        'fal fa-tilde'                               => 'tilde',
        'fal fa-times'                               => 'times',
        'fal fa-times-circle'                        => 'times-circle',
        'fal fa-times-hexagon'                       => 'times-hexagon',
        'fal fa-times-octagon'                       => 'times-octagon',
        'fal fa-times-square'                        => 'times-square',
        'fal fa-tint'                                => 'tint',
        'fal fa-tint-slash'                          => 'tint-slash',
        'fal fa-tire'                                => 'tire',
        'fal fa-tire-flat'                           => 'tire-flat',
        'fal fa-tire-pressure-warning'               => 'tire-pressure-warning',
        'fal fa-tire-rugged'                         => 'tire-rugged',
        'fal fa-tired'                               => 'tired',
        'fal fa-toggle-off'                          => 'toggle-off',
        'fal fa-toggle-on'                           => 'toggle-on',
        'fal fa-toilet'                              => 'toilet',
        'fal fa-toilet-paper'                        => 'toilet-paper',
        'fal fa-toilet-paper-alt'                    => 'toilet-paper-alt',
        'fal fa-tombstone'                           => 'tombstone',
        'fal fa-tombstone-alt'                       => 'tombstone-alt',
        'fal fa-toolbox'                             => 'toolbox',
        'fal fa-tools'                               => 'tools',
        'fal fa-tooth'                               => 'tooth',
        'fal fa-toothbrush'                          => 'toothbrush',
        'fal fa-torah'                               => 'torah',
        'fal fa-torii-gate'                          => 'torii-gate',
        'fal fa-tornado'                             => 'tornado',
        'fal fa-tractor'                             => 'tractor',
        'fal fa-trademark'                           => 'trademark',
        'fal fa-traffic-cone'                        => 'traffic-cone',
        'fal fa-traffic-light'                       => 'traffic-light',
        'fal fa-traffic-light-go'                    => 'traffic-light-go',
        'fal fa-traffic-light-slow'                  => 'traffic-light-slow',
        'fal fa-traffic-light-stop'                  => 'traffic-light-stop',
        'fal fa-train'                               => 'train',
        'fal fa-tram'                                => 'tram',
        'fal fa-transgender'                         => 'transgender',
        'fal fa-transgender-alt'                     => 'transgender-alt',
        'fal fa-trash'                               => 'trash',
        'fal fa-trash-alt'                           => 'trash-alt',
        'fal fa-trash-restore'                       => 'trash-restore',
        'fal fa-trash-restore-alt'                   => 'trash-restore-alt',
        'fal fa-trash-undo'                          => 'trash-undo',
        'fal fa-trash-undo-alt'                      => 'trash-undo-alt',
        'fal fa-treasure-chest'                      => 'treasure-chest',
        'fal fa-tree'                                => 'tree',
        'fal fa-tree-alt'                            => 'tree-alt',
        'fal fa-tree-christmas'                      => 'tree-christmas',
        'fal fa-tree-decorated'                      => 'tree-decorated',
        'fal fa-tree-large'                          => 'tree-large',
        'fal fa-tree-palm'                           => 'tree-palm',
        'fal fa-trees'                               => 'trees',
        'fal fa-triangle'                            => 'triangle',
        'fal fa-trophy'                              => 'trophy',
        'fal fa-trophy-alt'                          => 'trophy-alt',
        'fal fa-truck'                               => 'truck',
        'fal fa-truck-container'                     => 'truck-container',
        'fal fa-truck-couch'                         => 'truck-couch',
        'fal fa-truck-loading'                       => 'truck-loading',
        'fal fa-truck-monster'                       => 'truck-monster',
        'fal fa-truck-moving'                        => 'truck-moving',
        'fal fa-truck-pickup'                        => 'truck-pickup',
        'fal fa-truck-plow'                          => 'truck-plow',
        'fal fa-truck-ramp'                          => 'truck-ramp',
        'fal fa-tshirt'                              => 'tshirt',
        'fal fa-tty'                                 => 'tty',
        'fal fa-turkey'                              => 'turkey',
        'fal fa-turtle'                              => 'turtle',
        'fal fa-tv'                                  => 'tv',
        'fal fa-tv-retro'                            => 'tv-retro',
        'fal fa-umbrella'                            => 'umbrella',
        'fal fa-umbrella-beach'                      => 'umbrella-beach',
        'fal fa-underline'                           => 'underline',
        'fal fa-undo'                                => 'undo',
        'fal fa-undo-alt'                            => 'undo-alt',
        'fal fa-unicorn'                             => 'unicorn',
        'fal fa-union'                               => 'union',
        'fal fa-universal-access'                    => 'universal-access',
        'fal fa-university'                          => 'university',
        'fal fa-unlink'                              => 'unlink',
        'fal fa-unlock'                              => 'unlock',
        'fal fa-unlock-alt'                          => 'unlock-alt',
        'fal fa-upload'                              => 'upload',
        'fal fa-usd-circle'                          => 'usd-circle',
        'fal fa-usd-square'                          => 'usd-square',
        'fal fa-user'                                => 'user',
        'fal fa-user-alt'                            => 'user-alt',
        'fal fa-user-alt-slash'                      => 'user-alt-slash',
        'fal fa-user-astronaut'                      => 'user-astronaut',
        'fal fa-user-chart'                          => 'user-chart',
        'fal fa-user-check'                          => 'user-check',
        'fal fa-user-circle'                         => 'user-circle',
        'fal fa-user-clock'                          => 'user-clock',
        'fal fa-user-cog'                            => 'user-cog',
        'fal fa-user-crown'                          => 'user-crown',
        'fal fa-user-edit'                           => 'user-edit',
        'fal fa-user-friends'                        => 'user-friends',
        'fal fa-user-graduate'                       => 'user-graduate',
        'fal fa-user-hard-hat'                       => 'user-hard-hat',
        'fal fa-user-headset'                        => 'user-headset',
        'fal fa-user-injured'                        => 'user-injured',
        'fal fa-user-lock'                           => 'user-lock',
        'fal fa-user-md'                             => 'user-md',
        'fal fa-user-md-chat'                        => 'user-md-chat',
        'fal fa-user-minus'                          => 'user-minus',
        'fal fa-user-ninja'                          => 'user-ninja',
        'fal fa-user-nurse'                          => 'user-nurse',
        'fal fa-user-plus'                           => 'user-plus',
        'fal fa-user-secret'                         => 'user-secret',
        'fal fa-user-shield'                         => 'user-shield',
        'fal fa-user-slash'                          => 'user-slash',
        'fal fa-user-tag'                            => 'user-tag',
        'fal fa-user-tie'                            => 'user-tie',
        'fal fa-user-times'                          => 'user-times',
        'fal fa-users'                               => 'users',
        'fal fa-users-class'                         => 'users-class',
        'fal fa-users-cog'                           => 'users-cog',
        'fal fa-users-crown'                         => 'users-crown',
        'fal fa-users-medical'                       => 'users-medical',
        'fal fa-utensil-fork'                        => 'utensil-fork',
        'fal fa-utensil-knife'                       => 'utensil-knife',
        'fal fa-utensil-spoon'                       => 'utensil-spoon',
        'fal fa-utensils'                            => 'utensils',
        'fal fa-utensils-alt'                        => 'utensils-alt',
        'fal fa-value-absolute'                      => 'value-absolute',
        'fal fa-vector-square'                       => 'vector-square',
        'fal fa-venus'                               => 'venus',
        'fal fa-venus-double'                        => 'venus-double',
        'fal fa-venus-mars'                          => 'venus-mars',
        'fal fa-vial'                                => 'vial',
        'fal fa-vials'                               => 'vials',
        'fal fa-video'                               => 'video',
        'fal fa-video-plus'                          => 'video-plus',
        'fal fa-video-slash'                         => 'video-slash',
        'fal fa-vihara'                              => 'vihara',
        'fal fa-voicemail'                           => 'voicemail',
        'fal fa-volcano'                             => 'volcano',
        'fal fa-volleyball-ball'                     => 'volleyball-ball',
        'fal fa-volume'                              => 'volume',
        'fal fa-volume-down'                         => 'volume-down',
        'fal fa-volume-mute'                         => 'volume-mute',
        'fal fa-volume-off'                          => 'volume-off',
        'fal fa-volume-slash'                        => 'volume-slash',
        'fal fa-volume-up'                           => 'volume-up',
        'fal fa-vote-nay'                            => 'vote-nay',
        'fal fa-vote-yea'                            => 'vote-yea',
        'fal fa-vr-cardboard'                        => 'vr-cardboard',
        'fal fa-walker'                              => 'walker',
        'fal fa-walking'                             => 'walking',
        'fal fa-wallet'                              => 'wallet',
        'fal fa-wand'                                => 'wand',
        'fal fa-wand-magic'                          => 'wand-magic',
        'fal fa-warehouse'                           => 'warehouse',
        'fal fa-warehouse-alt'                       => 'warehouse-alt',
        'fal fa-washer'                              => 'washer',
        'fal fa-watch'                               => 'watch',
        'fal fa-watch-fitness'                       => 'watch-fitness',
        'fal fa-water'                               => 'water',
        'fal fa-water-lower'                         => 'water-lower',
        'fal fa-water-rise'                          => 'water-rise',
        'fal fa-wave-sine'                           => 'wave-sine',
        'fal fa-wave-square'                         => 'wave-square',
        'fal fa-wave-triangle'                       => 'wave-triangle',
        'fal fa-webcam'                              => 'webcam',
        'fal fa-webcam-slash'                        => 'webcam-slash',
        'fal fa-weight'                              => 'weight',
        'fal fa-weight-hanging'                      => 'weight-hanging',
        'fal fa-whale'                               => 'whale',
        'fal fa-wheat'                               => 'wheat',
        'fal fa-wheelchair'                          => 'wheelchair',
        'fal fa-whistle'                             => 'whistle',
        'fal fa-wifi'                                => 'wifi',
        'fal fa-wifi-1'                              => 'wifi-1',
        'fal fa-wifi-2'                              => 'wifi-2',
        'fal fa-wifi-slash'                          => 'wifi-slash',
        'fal fa-wind'                                => 'wind',
        'fal fa-wind-turbine'                        => 'wind-turbine',
        'fal fa-wind-warning'                        => 'wind-warning',
        'fal fa-window'                              => 'window',
        'fal fa-window-alt'                          => 'window-alt',
        'fal fa-window-close'                        => 'window-close',
        'fal fa-window-maximize'                     => 'window-maximize',
        'fal fa-window-minimize'                     => 'window-minimize',
        'fal fa-window-restore'                      => 'window-restore',
        'fal fa-windsock'                            => 'windsock',
        'fal fa-wine-bottle'                         => 'wine-bottle',
        'fal fa-wine-glass'                          => 'wine-glass',
        'fal fa-wine-glass-alt'                      => 'wine-glass-alt',
        'fal fa-won-sign'                            => 'won-sign',
        'fal fa-wreath'                              => 'wreath',
        'fal fa-wrench'                              => 'wrench',
        'fal fa-x-ray'                               => 'x-ray',
        'fal fa-yen-sign'                            => 'yen-sign',
        'fal fa-yin-yang'                            => 'yin-yang',
        'far fa-abacus'                              => 'abacus',
        'far fa-acorn'                               => 'acorn',
        'far fa-ad'                                  => 'ad',
        'far fa-address-book'                        => 'address-book',
        'far fa-address-card'                        => 'address-card',
        'far fa-adjust'                              => 'adjust',
        'far fa-air-freshener'                       => 'air-freshener',
        'far fa-alarm-clock'                         => 'alarm-clock',
        'far fa-alarm-exclamation'                   => 'alarm-exclamation',
        'far fa-alarm-plus'                          => 'alarm-plus',
        'far fa-alarm-snooze'                        => 'alarm-snooze',
        'far fa-alicorn'                             => 'alicorn',
        'far fa-align-center'                        => 'align-center',
        'far fa-align-justify'                       => 'align-justify',
        'far fa-align-left'                          => 'align-left',
        'far fa-align-right'                         => 'align-right',
        'far fa-align-slash'                         => 'align-slash',
        'far fa-allergies'                           => 'allergies',
        'far fa-ambulance'                           => 'ambulance',
        'far fa-american-sign-language-interpreting' => 'american-sign-language-interpreting',
        'far fa-analytics'                           => 'analytics',
        'far fa-anchor'                              => 'anchor',
        'far fa-angel'                               => 'angel',
        'far fa-angle-double-down'                   => 'angle-double-down',
        'far fa-angle-double-left'                   => 'angle-double-left',
        'far fa-angle-double-right'                  => 'angle-double-right',
        'far fa-angle-double-up'                     => 'angle-double-up',
        'far fa-angle-down'                          => 'angle-down',
        'far fa-angle-left'                          => 'angle-left',
        'far fa-angle-right'                         => 'angle-right',
        'far fa-angle-up'                            => 'angle-up',
        'far fa-angry'                               => 'angry',
        'far fa-ankh'                                => 'ankh',
        'far fa-apple-alt'                           => 'apple-alt',
        'far fa-apple-crate'                         => 'apple-crate',
        'far fa-archive'                             => 'archive',
        'far fa-archway'                             => 'archway',
        'far fa-arrow-alt-circle-down'               => 'arrow-alt-circle-down',
        'far fa-arrow-alt-circle-left'               => 'arrow-alt-circle-left',
        'far fa-arrow-alt-circle-right'              => 'arrow-alt-circle-right',
        'far fa-arrow-alt-circle-up'                 => 'arrow-alt-circle-up',
        'far fa-arrow-alt-down'                      => 'arrow-alt-down',
        'far fa-arrow-alt-from-bottom'               => 'arrow-alt-from-bottom',
        'far fa-arrow-alt-from-left'                 => 'arrow-alt-from-left',
        'far fa-arrow-alt-from-right'                => 'arrow-alt-from-right',
        'far fa-arrow-alt-from-top'                  => 'arrow-alt-from-top',
        'far fa-arrow-alt-left'                      => 'arrow-alt-left',
        'far fa-arrow-alt-right'                     => 'arrow-alt-right',
        'far fa-arrow-alt-square-down'               => 'arrow-alt-square-down',
        'far fa-arrow-alt-square-left'               => 'arrow-alt-square-left',
        'far fa-arrow-alt-square-right'              => 'arrow-alt-square-right',
        'far fa-arrow-alt-square-up'                 => 'arrow-alt-square-up',
        'far fa-arrow-alt-to-bottom'                 => 'arrow-alt-to-bottom',
        'far fa-arrow-alt-to-left'                   => 'arrow-alt-to-left',
        'far fa-arrow-alt-to-right'                  => 'arrow-alt-to-right',
        'far fa-arrow-alt-to-top'                    => 'arrow-alt-to-top',
        'far fa-arrow-alt-up'                        => 'arrow-alt-up',
        'far fa-arrow-circle-down'                   => 'arrow-circle-down',
        'far fa-arrow-circle-left'                   => 'arrow-circle-left',
        'far fa-arrow-circle-right'                  => 'arrow-circle-right',
        'far fa-arrow-circle-up'                     => 'arrow-circle-up',
        'far fa-arrow-down'                          => 'arrow-down',
        'far fa-arrow-from-bottom'                   => 'arrow-from-bottom',
        'far fa-arrow-from-left'                     => 'arrow-from-left',
        'far fa-arrow-from-right'                    => 'arrow-from-right',
        'far fa-arrow-from-top'                      => 'arrow-from-top',
        'far fa-arrow-left'                          => 'arrow-left',
        'far fa-arrow-right'                         => 'arrow-right',
        'far fa-arrow-square-down'                   => 'arrow-square-down',
        'far fa-arrow-square-left'                   => 'arrow-square-left',
        'far fa-arrow-square-right'                  => 'arrow-square-right',
        'far fa-arrow-square-up'                     => 'arrow-square-up',
        'far fa-arrow-to-bottom'                     => 'arrow-to-bottom',
        'far fa-arrow-to-left'                       => 'arrow-to-left',
        'far fa-arrow-to-right'                      => 'arrow-to-right',
        'far fa-arrow-to-top'                        => 'arrow-to-top',
        'far fa-arrow-up'                            => 'arrow-up',
        'far fa-arrows'                              => 'arrows',
        'far fa-arrows-alt'                          => 'arrows-alt',
        'far fa-arrows-alt-h'                        => 'arrows-alt-h',
        'far fa-arrows-alt-v'                        => 'arrows-alt-v',
        'far fa-arrows-h'                            => 'arrows-h',
        'far fa-arrows-v'                            => 'arrows-v',
        'far fa-assistive-listening-systems'         => 'assistive-listening-systems',
        'far fa-asterisk'                            => 'asterisk',
        'far fa-at'                                  => 'at',
        'far fa-atlas'                               => 'atlas',
        'far fa-atom'                                => 'atom',
        'far fa-atom-alt'                            => 'atom-alt',
        'far fa-audio-description'                   => 'audio-description',
        'far fa-award'                               => 'award',
        'far fa-axe'                                 => 'axe',
        'far fa-axe-battle'                          => 'axe-battle',
        'far fa-baby'                                => 'baby',
        'far fa-baby-carriage'                       => 'baby-carriage',
        'far fa-backpack'                            => 'backpack',
        'far fa-backspace'                           => 'backspace',
        'far fa-backward'                            => 'backward',
        'far fa-bacon'                               => 'bacon',
        'far fa-badge'                               => 'badge',
        'far fa-badge-check'                         => 'badge-check',
        'far fa-badge-dollar'                        => 'badge-dollar',
        'far fa-badge-percent'                       => 'badge-percent',
        'far fa-badger-honey'                        => 'badger-honey',
        'far fa-bags-shopping'                       => 'bags-shopping',
        'far fa-balance-scale'                       => 'balance-scale',
        'far fa-balance-scale-left'                  => 'balance-scale-left',
        'far fa-balance-scale-right'                 => 'balance-scale-right',
        'far fa-ball-pile'                           => 'ball-pile',
        'far fa-ballot'                              => 'ballot',
        'far fa-ballot-check'                        => 'ballot-check',
        'far fa-ban'                                 => 'ban',
        'far fa-band-aid'                            => 'band-aid',
        'far fa-barcode'                             => 'barcode',
        'far fa-barcode-alt'                         => 'barcode-alt',
        'far fa-barcode-read'                        => 'barcode-read',
        'far fa-barcode-scan'                        => 'barcode-scan',
        'far fa-bars'                                => 'bars',
        'far fa-baseball'                            => 'baseball',
        'far fa-baseball-ball'                       => 'baseball-ball',
        'far fa-basketball-ball'                     => 'basketball-ball',
        'far fa-basketball-hoop'                     => 'basketball-hoop',
        'far fa-bat'                                 => 'bat',
        'far fa-bath'                                => 'bath',
        'far fa-battery-bolt'                        => 'battery-bolt',
        'far fa-battery-empty'                       => 'battery-empty',
        'far fa-battery-full'                        => 'battery-full',
        'far fa-battery-half'                        => 'battery-half',
        'far fa-battery-quarter'                     => 'battery-quarter',
        'far fa-battery-slash'                       => 'battery-slash',
        'far fa-battery-three-quarters'              => 'battery-three-quarters',
        'far fa-bed'                                 => 'bed',
        'far fa-beer'                                => 'beer',
        'far fa-bell'                                => 'bell',
        'far fa-bell-exclamation'                    => 'bell-exclamation',
        'far fa-bell-plus'                           => 'bell-plus',
        'far fa-bell-school'                         => 'bell-school',
        'far fa-bell-school-slash'                   => 'bell-school-slash',
        'far fa-bell-slash'                          => 'bell-slash',
        'far fa-bells'                               => 'bells',
        'far fa-bezier-curve'                        => 'bezier-curve',
        'far fa-bible'                               => 'bible',
        'far fa-bicycle'                             => 'bicycle',
        'far fa-biking'                              => 'biking',
        'far fa-biking-mountain'                     => 'biking-mountain',
        'far fa-binoculars'                          => 'binoculars',
        'far fa-biohazard'                           => 'biohazard',
        'far fa-birthday-cake'                       => 'birthday-cake',
        'far fa-blanket'                             => 'blanket',
        'far fa-blender'                             => 'blender',
        'far fa-blender-phone'                       => 'blender-phone',
        'far fa-blind'                               => 'blind',
        'far fa-blog'                                => 'blog',
        'far fa-bold'                                => 'bold',
        'far fa-bolt'                                => 'bolt',
        'far fa-bomb'                                => 'bomb',
        'far fa-bone'                                => 'bone',
        'far fa-bone-break'                          => 'bone-break',
        'far fa-bong'                                => 'bong',
        'far fa-book'                                => 'book',
        'far fa-book-alt'                            => 'book-alt',
        'far fa-book-dead'                           => 'book-dead',
        'far fa-book-heart'                          => 'book-heart',
        'far fa-book-medical'                        => 'book-medical',
        'far fa-book-open'                           => 'book-open',
        'far fa-book-reader'                         => 'book-reader',
        'far fa-book-spells'                         => 'book-spells',
        'far fa-book-user'                           => 'book-user',
        'far fa-bookmark'                            => 'bookmark',
        'far fa-books'                               => 'books',
        'far fa-books-medical'                       => 'books-medical',
        'far fa-boot'                                => 'boot',
        'far fa-booth-curtain'                       => 'booth-curtain',
        'far fa-border-all'                          => 'border-all',
        'far fa-border-bottom'                       => 'border-bottom',
        'far fa-border-center-h'                     => 'border-center-h',
        'far fa-border-center-v'                     => 'border-center-v',
        'far fa-border-inner'                        => 'border-inner',
        'far fa-border-left'                         => 'border-left',
        'far fa-border-none'                         => 'border-none',
        'far fa-border-outer'                        => 'border-outer',
        'far fa-border-right'                        => 'border-right',
        'far fa-border-style'                        => 'border-style',
        'far fa-border-style-alt'                    => 'border-style-alt',
        'far fa-border-top'                          => 'border-top',
        'far fa-bow-arrow'                           => 'bow-arrow',
        'far fa-bowling-ball'                        => 'bowling-ball',
        'far fa-bowling-pins'                        => 'bowling-pins',
        'far fa-box'                                 => 'box',
        'far fa-box-alt'                             => 'box-alt',
        'far fa-box-ballot'                          => 'box-ballot',
        'far fa-box-check'                           => 'box-check',
        'far fa-box-fragile'                         => 'box-fragile',
        'far fa-box-full'                            => 'box-full',
        'far fa-box-heart'                           => 'box-heart',
        'far fa-box-open'                            => 'box-open',
        'far fa-box-up'                              => 'box-up',
        'far fa-box-usd'                             => 'box-usd',
        'far fa-boxes'                               => 'boxes',
        'far fa-boxes-alt'                           => 'boxes-alt',
        'far fa-boxing-glove'                        => 'boxing-glove',
        'far fa-brackets'                            => 'brackets',
        'far fa-brackets-curly'                      => 'brackets-curly',
        'far fa-braille'                             => 'braille',
        'far fa-brain'                               => 'brain',
        'far fa-bread-loaf'                          => 'bread-loaf',
        'far fa-bread-slice'                         => 'bread-slice',
        'far fa-briefcase'                           => 'briefcase',
        'far fa-briefcase-medical'                   => 'briefcase-medical',
        'far fa-bring-forward'                       => 'bring-forward',
        'far fa-bring-front'                         => 'bring-front',
        'far fa-broadcast-tower'                     => 'broadcast-tower',
        'far fa-broom'                               => 'broom',
        'far fa-browser'                             => 'browser',
        'far fa-brush'                               => 'brush',
        'far fa-bug'                                 => 'bug',
        'far fa-building'                            => 'building',
        'far fa-bullhorn'                            => 'bullhorn',
        'far fa-bullseye'                            => 'bullseye',
        'far fa-bullseye-arrow'                      => 'bullseye-arrow',
        'far fa-bullseye-pointer'                    => 'bullseye-pointer',
        'far fa-burger-soda'                         => 'burger-soda',
        'far fa-burn'                                => 'burn',
        'far fa-burrito'                             => 'burrito',
        'far fa-bus'                                 => 'bus',
        'far fa-bus-alt'                             => 'bus-alt',
        'far fa-bus-school'                          => 'bus-school',
        'far fa-business-time'                       => 'business-time',
        'far fa-cabinet-filing'                      => 'cabinet-filing',
        'far fa-calculator'                          => 'calculator',
        'far fa-calculator-alt'                      => 'calculator-alt',
        'far fa-calendar'                            => 'calendar',
        'far fa-calendar-alt'                        => 'calendar-alt',
        'far fa-calendar-check'                      => 'calendar-check',
        'far fa-calendar-day'                        => 'calendar-day',
        'far fa-calendar-edit'                       => 'calendar-edit',
        'far fa-calendar-exclamation'                => 'calendar-exclamation',
        'far fa-calendar-minus'                      => 'calendar-minus',
        'far fa-calendar-plus'                       => 'calendar-plus',
        'far fa-calendar-star'                       => 'calendar-star',
        'far fa-calendar-times'                      => 'calendar-times',
        'far fa-calendar-week'                       => 'calendar-week',
        'far fa-camera'                              => 'camera',
        'far fa-camera-alt'                          => 'camera-alt',
        'far fa-camera-retro'                        => 'camera-retro',
        'far fa-campfire'                            => 'campfire',
        'far fa-campground'                          => 'campground',
        'far fa-candle-holder'                       => 'candle-holder',
        'far fa-candy-cane'                          => 'candy-cane',
        'far fa-candy-corn'                          => 'candy-corn',
        'far fa-cannabis'                            => 'cannabis',
        'far fa-capsules'                            => 'capsules',
        'far fa-car'                                 => 'car',
        'far fa-car-alt'                             => 'car-alt',
        'far fa-car-battery'                         => 'car-battery',
        'far fa-car-building'                        => 'car-building',
        'far fa-car-bump'                            => 'car-bump',
        'far fa-car-bus'                             => 'car-bus',
        'far fa-car-crash'                           => 'car-crash',
        'far fa-car-garage'                          => 'car-garage',
        'far fa-car-mechanic'                        => 'car-mechanic',
        'far fa-car-side'                            => 'car-side',
        'far fa-car-tilt'                            => 'car-tilt',
        'far fa-car-wash'                            => 'car-wash',
        'far fa-caret-circle-down'                   => 'caret-circle-down',
        'far fa-caret-circle-left'                   => 'caret-circle-left',
        'far fa-caret-circle-right'                  => 'caret-circle-right',
        'far fa-caret-circle-up'                     => 'caret-circle-up',
        'far fa-caret-down'                          => 'caret-down',
        'far fa-caret-left'                          => 'caret-left',
        'far fa-caret-right'                         => 'caret-right',
        'far fa-caret-square-down'                   => 'caret-square-down',
        'far fa-caret-square-left'                   => 'caret-square-left',
        'far fa-caret-square-right'                  => 'caret-square-right',
        'far fa-caret-square-up'                     => 'caret-square-up',
        'far fa-caret-up'                            => 'caret-up',
        'far fa-carrot'                              => 'carrot',
        'far fa-cars'                                => 'cars',
        'far fa-cart-arrow-down'                     => 'cart-arrow-down',
        'far fa-cart-plus'                           => 'cart-plus',
        'far fa-cash-register'                       => 'cash-register',
        'far fa-cat'                                 => 'cat',
        'far fa-cauldron'                            => 'cauldron',
        'far fa-certificate'                         => 'certificate',
        'far fa-chair'                               => 'chair',
        'far fa-chair-office'                        => 'chair-office',
        'far fa-chalkboard'                          => 'chalkboard',
        'far fa-chalkboard-teacher'                  => 'chalkboard-teacher',
        'far fa-charging-station'                    => 'charging-station',
        'far fa-chart-area'                          => 'chart-area',
        'far fa-chart-bar'                           => 'chart-bar',
        'far fa-chart-line'                          => 'chart-line',
        'far fa-chart-line-down'                     => 'chart-line-down',
        'far fa-chart-network'                       => 'chart-network',
        'far fa-chart-pie'                           => 'chart-pie',
        'far fa-chart-pie-alt'                       => 'chart-pie-alt',
        'far fa-chart-scatter'                       => 'chart-scatter',
        'far fa-check'                               => 'check',
        'far fa-check-circle'                        => 'check-circle',
        'far fa-check-double'                        => 'check-double',
        'far fa-check-square'                        => 'check-square',
        'far fa-cheese'                              => 'cheese',
        'far fa-cheese-swiss'                        => 'cheese-swiss',
        'far fa-cheeseburger'                        => 'cheeseburger',
        'far fa-chess'                               => 'chess',
        'far fa-chess-bishop'                        => 'chess-bishop',
        'far fa-chess-bishop-alt'                    => 'chess-bishop-alt',
        'far fa-chess-board'                         => 'chess-board',
        'far fa-chess-clock'                         => 'chess-clock',
        'far fa-chess-clock-alt'                     => 'chess-clock-alt',
        'far fa-chess-king'                          => 'chess-king',
        'far fa-chess-king-alt'                      => 'chess-king-alt',
        'far fa-chess-knight'                        => 'chess-knight',
        'far fa-chess-knight-alt'                    => 'chess-knight-alt',
        'far fa-chess-pawn'                          => 'chess-pawn',
        'far fa-chess-pawn-alt'                      => 'chess-pawn-alt',
        'far fa-chess-queen'                         => 'chess-queen',
        'far fa-chess-queen-alt'                     => 'chess-queen-alt',
        'far fa-chess-rook'                          => 'chess-rook',
        'far fa-chess-rook-alt'                      => 'chess-rook-alt',
        'far fa-chevron-circle-down'                 => 'chevron-circle-down',
        'far fa-chevron-circle-left'                 => 'chevron-circle-left',
        'far fa-chevron-circle-right'                => 'chevron-circle-right',
        'far fa-chevron-circle-up'                   => 'chevron-circle-up',
        'far fa-chevron-double-down'                 => 'chevron-double-down',
        'far fa-chevron-double-left'                 => 'chevron-double-left',
        'far fa-chevron-double-right'                => 'chevron-double-right',
        'far fa-chevron-double-up'                   => 'chevron-double-up',
        'far fa-chevron-down'                        => 'chevron-down',
        'far fa-chevron-left'                        => 'chevron-left',
        'far fa-chevron-right'                       => 'chevron-right',
        'far fa-chevron-square-down'                 => 'chevron-square-down',
        'far fa-chevron-square-left'                 => 'chevron-square-left',
        'far fa-chevron-square-right'                => 'chevron-square-right',
        'far fa-chevron-square-up'                   => 'chevron-square-up',
        'far fa-chevron-up'                          => 'chevron-up',
        'far fa-child'                               => 'child',
        'far fa-chimney'                             => 'chimney',
        'far fa-church'                              => 'church',
        'far fa-circle'                              => 'circle',
        'far fa-circle-notch'                        => 'circle-notch',
        'far fa-city'                                => 'city',
        'far fa-claw-marks'                          => 'claw-marks',
        'far fa-clinic-medical'                      => 'clinic-medical',
        'far fa-clipboard'                           => 'clipboard',
        'far fa-clipboard-check'                     => 'clipboard-check',
        'far fa-clipboard-list'                      => 'clipboard-list',
        'far fa-clipboard-list-check'                => 'clipboard-list-check',
        'far fa-clipboard-prescription'              => 'clipboard-prescription',
        'far fa-clipboard-user'                      => 'clipboard-user',
        'far fa-clock'                               => 'clock',
        'far fa-clone'                               => 'clone',
        'far fa-closed-captioning'                   => 'closed-captioning',
        'far fa-cloud'                               => 'cloud',
        'far fa-cloud-download'                      => 'cloud-download',
        'far fa-cloud-download-alt'                  => 'cloud-download-alt',
        'far fa-cloud-drizzle'                       => 'cloud-drizzle',
        'far fa-cloud-hail'                          => 'cloud-hail',
        'far fa-cloud-hail-mixed'                    => 'cloud-hail-mixed',
        'far fa-cloud-meatball'                      => 'cloud-meatball',
        'far fa-cloud-moon'                          => 'cloud-moon',
        'far fa-cloud-moon-rain'                     => 'cloud-moon-rain',
        'far fa-cloud-rain'                          => 'cloud-rain',
        'far fa-cloud-rainbow'                       => 'cloud-rainbow',
        'far fa-cloud-showers'                       => 'cloud-showers',
        'far fa-cloud-showers-heavy'                 => 'cloud-showers-heavy',
        'far fa-cloud-sleet'                         => 'cloud-sleet',
        'far fa-cloud-snow'                          => 'cloud-snow',
        'far fa-cloud-sun'                           => 'cloud-sun',
        'far fa-cloud-sun-rain'                      => 'cloud-sun-rain',
        'far fa-cloud-upload'                        => 'cloud-upload',
        'far fa-cloud-upload-alt'                    => 'cloud-upload-alt',
        'far fa-clouds'                              => 'clouds',
        'far fa-clouds-moon'                         => 'clouds-moon',
        'far fa-clouds-sun'                          => 'clouds-sun',
        'far fa-club'                                => 'club',
        'far fa-cocktail'                            => 'cocktail',
        'far fa-code'                                => 'code',
        'far fa-code-branch'                         => 'code-branch',
        'far fa-code-commit'                         => 'code-commit',
        'far fa-code-merge'                          => 'code-merge',
        'far fa-coffee'                              => 'coffee',
        'far fa-coffee-togo'                         => 'coffee-togo',
        'far fa-coffin'                              => 'coffin',
        'far fa-cog'                                 => 'cog',
        'far fa-cogs'                                => 'cogs',
        'far fa-coin'                                => 'coin',
        'far fa-coins'                               => 'coins',
        'far fa-columns'                             => 'columns',
        'far fa-comment'                             => 'comment',
        'far fa-comment-alt'                         => 'comment-alt',
        'far fa-comment-alt-check'                   => 'comment-alt-check',
        'far fa-comment-alt-dollar'                  => 'comment-alt-dollar',
        'far fa-comment-alt-dots'                    => 'comment-alt-dots',
        'far fa-comment-alt-edit'                    => 'comment-alt-edit',
        'far fa-comment-alt-exclamation'             => 'comment-alt-exclamation',
        'far fa-comment-alt-lines'                   => 'comment-alt-lines',
        'far fa-comment-alt-medical'                 => 'comment-alt-medical',
        'far fa-comment-alt-minus'                   => 'comment-alt-minus',
        'far fa-comment-alt-plus'                    => 'comment-alt-plus',
        'far fa-comment-alt-slash'                   => 'comment-alt-slash',
        'far fa-comment-alt-smile'                   => 'comment-alt-smile',
        'far fa-comment-alt-times'                   => 'comment-alt-times',
        'far fa-comment-check'                       => 'comment-check',
        'far fa-comment-dollar'                      => 'comment-dollar',
        'far fa-comment-dots'                        => 'comment-dots',
        'far fa-comment-edit'                        => 'comment-edit',
        'far fa-comment-exclamation'                 => 'comment-exclamation',
        'far fa-comment-lines'                       => 'comment-lines',
        'far fa-comment-medical'                     => 'comment-medical',
        'far fa-comment-minus'                       => 'comment-minus',
        'far fa-comment-plus'                        => 'comment-plus',
        'far fa-comment-slash'                       => 'comment-slash',
        'far fa-comment-smile'                       => 'comment-smile',
        'far fa-comment-times'                       => 'comment-times',
        'far fa-comments'                            => 'comments',
        'far fa-comments-alt'                        => 'comments-alt',
        'far fa-comments-alt-dollar'                 => 'comments-alt-dollar',
        'far fa-comments-dollar'                     => 'comments-dollar',
        'far fa-compact-disc'                        => 'compact-disc',
        'far fa-compass'                             => 'compass',
        'far fa-compass-slash'                       => 'compass-slash',
        'far fa-compress'                            => 'compress',
        'far fa-compress-alt'                        => 'compress-alt',
        'far fa-compress-arrows-alt'                 => 'compress-arrows-alt',
        'far fa-compress-wide'                       => 'compress-wide',
        'far fa-concierge-bell'                      => 'concierge-bell',
        'far fa-construction'                        => 'construction',
        'far fa-container-storage'                   => 'container-storage',
        'far fa-conveyor-belt'                       => 'conveyor-belt',
        'far fa-conveyor-belt-alt'                   => 'conveyor-belt-alt',
        'far fa-cookie'                              => 'cookie',
        'far fa-cookie-bite'                         => 'cookie-bite',
        'far fa-copy'                                => 'copy',
        'far fa-copyright'                           => 'copyright',
        'far fa-corn'                                => 'corn',
        'far fa-couch'                               => 'couch',
        'far fa-cow'                                 => 'cow',
        'far fa-credit-card'                         => 'credit-card',
        'far fa-credit-card-blank'                   => 'credit-card-blank',
        'far fa-credit-card-front'                   => 'credit-card-front',
        'far fa-cricket'                             => 'cricket',
        'far fa-croissant'                           => 'croissant',
        'far fa-crop'                                => 'crop',
        'far fa-crop-alt'                            => 'crop-alt',
        'far fa-cross'                               => 'cross',
        'far fa-crosshairs'                          => 'crosshairs',
        'far fa-crow'                                => 'crow',
        'far fa-crown'                               => 'crown',
        'far fa-crutch'                              => 'crutch',
        'far fa-crutches'                            => 'crutches',
        'far fa-cube'                                => 'cube',
        'far fa-cubes'                               => 'cubes',
        'far fa-curling'                             => 'curling',
        'far fa-cut'                                 => 'cut',
        'far fa-dagger'                              => 'dagger',
        'far fa-database'                            => 'database',
        'far fa-deaf'                                => 'deaf',
        'far fa-debug'                               => 'debug',
        'far fa-deer'                                => 'deer',
        'far fa-deer-rudolph'                        => 'deer-rudolph',
        'far fa-democrat'                            => 'democrat',
        'far fa-desktop'                             => 'desktop',
        'far fa-desktop-alt'                         => 'desktop-alt',
        'far fa-dewpoint'                            => 'dewpoint',
        'far fa-dharmachakra'                        => 'dharmachakra',
        'far fa-diagnoses'                           => 'diagnoses',
        'far fa-diamond'                             => 'diamond',
        'far fa-dice'                                => 'dice',
        'far fa-dice-d10'                            => 'dice-d10',
        'far fa-dice-d12'                            => 'dice-d12',
        'far fa-dice-d20'                            => 'dice-d20',
        'far fa-dice-d4'                             => 'dice-d4',
        'far fa-dice-d6'                             => 'dice-d6',
        'far fa-dice-d8'                             => 'dice-d8',
        'far fa-dice-five'                           => 'dice-five',
        'far fa-dice-four'                           => 'dice-four',
        'far fa-dice-one'                            => 'dice-one',
        'far fa-dice-six'                            => 'dice-six',
        'far fa-dice-three'                          => 'dice-three',
        'far fa-dice-two'                            => 'dice-two',
        'far fa-digging'                             => 'digging',
        'far fa-digital-tachograph'                  => 'digital-tachograph',
        'far fa-diploma'                             => 'diploma',
        'far fa-directions'                          => 'directions',
        'far fa-disease'                             => 'disease',
        'far fa-divide'                              => 'divide',
        'far fa-dizzy'                               => 'dizzy',
        'far fa-dna'                                 => 'dna',
        'far fa-do-not-enter'                        => 'do-not-enter',
        'far fa-dog'                                 => 'dog',
        'far fa-dog-leashed'                         => 'dog-leashed',
        'far fa-dollar-sign'                         => 'dollar-sign',
        'far fa-dolly'                               => 'dolly',
        'far fa-dolly-empty'                         => 'dolly-empty',
        'far fa-dolly-flatbed'                       => 'dolly-flatbed',
        'far fa-dolly-flatbed-alt'                   => 'dolly-flatbed-alt',
        'far fa-dolly-flatbed-empty'                 => 'dolly-flatbed-empty',
        'far fa-donate'                              => 'donate',
        'far fa-door-closed'                         => 'door-closed',
        'far fa-door-open'                           => 'door-open',
        'far fa-dot-circle'                          => 'dot-circle',
        'far fa-dove'                                => 'dove',
        'far fa-download'                            => 'download',
        'far fa-drafting-compass'                    => 'drafting-compass',
        'far fa-dragon'                              => 'dragon',
        'far fa-draw-circle'                         => 'draw-circle',
        'far fa-draw-polygon'                        => 'draw-polygon',
        'far fa-draw-square'                         => 'draw-square',
        'far fa-dreidel'                             => 'dreidel',
        'far fa-drone'                               => 'drone',
        'far fa-drone-alt'                           => 'drone-alt',
        'far fa-drum'                                => 'drum',
        'far fa-drum-steelpan'                       => 'drum-steelpan',
        'far fa-drumstick'                           => 'drumstick',
        'far fa-drumstick-bite'                      => 'drumstick-bite',
        'far fa-dryer'                               => 'dryer',
        'far fa-dryer-alt'                           => 'dryer-alt',
        'far fa-duck'                                => 'duck',
        'far fa-dumbbell'                            => 'dumbbell',
        'far fa-dumpster'                            => 'dumpster',
        'far fa-dumpster-fire'                       => 'dumpster-fire',
        'far fa-dungeon'                             => 'dungeon',
        'far fa-ear'                                 => 'ear',
        'far fa-ear-muffs'                           => 'ear-muffs',
        'far fa-eclipse'                             => 'eclipse',
        'far fa-eclipse-alt'                         => 'eclipse-alt',
        'far fa-edit'                                => 'edit',
        'far fa-egg'                                 => 'egg',
        'far fa-egg-fried'                           => 'egg-fried',
        'far fa-eject'                               => 'eject',
        'far fa-elephant'                            => 'elephant',
        'far fa-ellipsis-h'                          => 'ellipsis-h',
        'far fa-ellipsis-h-alt'                      => 'ellipsis-h-alt',
        'far fa-ellipsis-v'                          => 'ellipsis-v',
        'far fa-ellipsis-v-alt'                      => 'ellipsis-v-alt',
        'far fa-empty-set'                           => 'empty-set',
        'far fa-engine-warning'                      => 'engine-warning',
        'far fa-envelope'                            => 'envelope',
        'far fa-envelope-open'                       => 'envelope-open',
        'far fa-envelope-open-dollar'                => 'envelope-open-dollar',
        'far fa-envelope-open-text'                  => 'envelope-open-text',
        'far fa-envelope-square'                     => 'envelope-square',
        'far fa-equals'                              => 'equals',
        'far fa-eraser'                              => 'eraser',
        'far fa-ethernet'                            => 'ethernet',
        'far fa-euro-sign'                           => 'euro-sign',
        'far fa-exchange'                            => 'exchange',
        'far fa-exchange-alt'                        => 'exchange-alt',
        'far fa-exclamation'                         => 'exclamation',
        'far fa-exclamation-circle'                  => 'exclamation-circle',
        'far fa-exclamation-square'                  => 'exclamation-square',
        'far fa-exclamation-triangle'                => 'exclamation-triangle',
        'far fa-expand'                              => 'expand',
        'far fa-expand-alt'                          => 'expand-alt',
        'far fa-expand-arrows'                       => 'expand-arrows',
        'far fa-expand-arrows-alt'                   => 'expand-arrows-alt',
        'far fa-expand-wide'                         => 'expand-wide',
        'far fa-external-link'                       => 'external-link',
        'far fa-external-link-alt'                   => 'external-link-alt',
        'far fa-external-link-square'                => 'external-link-square',
        'far fa-external-link-square-alt'            => 'external-link-square-alt',
        'far fa-eye'                                 => 'eye',
        'far fa-eye-dropper'                         => 'eye-dropper',
        'far fa-eye-evil'                            => 'eye-evil',
        'far fa-eye-slash'                           => 'eye-slash',
        'far fa-fan'                                 => 'fan',
        'far fa-farm'                                => 'farm',
        'far fa-fast-backward'                       => 'fast-backward',
        'far fa-fast-forward'                        => 'fast-forward',
        'far fa-fax'                                 => 'fax',
        'far fa-feather'                             => 'feather',
        'far fa-feather-alt'                         => 'feather-alt',
        'far fa-female'                              => 'female',
        'far fa-field-hockey'                        => 'field-hockey',
        'far fa-fighter-jet'                         => 'fighter-jet',
        'far fa-file'                                => 'file',
        'far fa-file-alt'                            => 'file-alt',
        'far fa-file-archive'                        => 'file-archive',
        'far fa-file-audio'                          => 'file-audio',
        'far fa-file-certificate'                    => 'file-certificate',
        'far fa-file-chart-line'                     => 'file-chart-line',
        'far fa-file-chart-pie'                      => 'file-chart-pie',
        'far fa-file-check'                          => 'file-check',
        'far fa-file-code'                           => 'file-code',
        'far fa-file-contract'                       => 'file-contract',
        'far fa-file-csv'                            => 'file-csv',
        'far fa-file-download'                       => 'file-download',
        'far fa-file-edit'                           => 'file-edit',
        'far fa-file-excel'                          => 'file-excel',
        'far fa-file-exclamation'                    => 'file-exclamation',
        'far fa-file-export'                         => 'file-export',
        'far fa-file-image'                          => 'file-image',
        'far fa-file-import'                         => 'file-import',
        'far fa-file-invoice'                        => 'file-invoice',
        'far fa-file-invoice-dollar'                 => 'file-invoice-dollar',
        'far fa-file-medical'                        => 'file-medical',
        'far fa-file-medical-alt'                    => 'file-medical-alt',
        'far fa-file-minus'                          => 'file-minus',
        'far fa-file-pdf'                            => 'file-pdf',
        'far fa-file-plus'                           => 'file-plus',
        'far fa-file-powerpoint'                     => 'file-powerpoint',
        'far fa-file-prescription'                   => 'file-prescription',
        'far fa-file-search'                         => 'file-search',
        'far fa-file-signature'                      => 'file-signature',
        'far fa-file-spreadsheet'                    => 'file-spreadsheet',
        'far fa-file-times'                          => 'file-times',
        'far fa-file-upload'                         => 'file-upload',
        'far fa-file-user'                           => 'file-user',
        'far fa-file-video'                          => 'file-video',
        'far fa-file-word'                           => 'file-word',
        'far fa-files-medical'                       => 'files-medical',
        'far fa-fill'                                => 'fill',
        'far fa-fill-drip'                           => 'fill-drip',
        'far fa-film'                                => 'film',
        'far fa-film-alt'                            => 'film-alt',
        'far fa-filter'                              => 'filter',
        'far fa-fingerprint'                         => 'fingerprint',
        'far fa-fire'                                => 'fire',
        'far fa-fire-alt'                            => 'fire-alt',
        'far fa-fire-extinguisher'                   => 'fire-extinguisher',
        'far fa-fire-smoke'                          => 'fire-smoke',
        'far fa-fireplace'                           => 'fireplace',
        'far fa-first-aid'                           => 'first-aid',
        'far fa-fish'                                => 'fish',
        'far fa-fish-cooked'                         => 'fish-cooked',
        'far fa-fist-raised'                         => 'fist-raised',
        'far fa-flag'                                => 'flag',
        'far fa-flag-alt'                            => 'flag-alt',
        'far fa-flag-checkered'                      => 'flag-checkered',
        'far fa-flag-usa'                            => 'flag-usa',
        'far fa-flame'                               => 'flame',
        'far fa-flask'                               => 'flask',
        'far fa-flask-poison'                        => 'flask-poison',
        'far fa-flask-potion'                        => 'flask-potion',
        'far fa-flower'                              => 'flower',
        'far fa-flower-daffodil'                     => 'flower-daffodil',
        'far fa-flower-tulip'                        => 'flower-tulip',
        'far fa-flushed'                             => 'flushed',
        'far fa-fog'                                 => 'fog',
        'far fa-folder'                              => 'folder',
        'far fa-folder-minus'                        => 'folder-minus',
        'far fa-folder-open'                         => 'folder-open',
        'far fa-folder-plus'                         => 'folder-plus',
        'far fa-folder-times'                        => 'folder-times',
        'far fa-folder-tree'                         => 'folder-tree',
        'far fa-folders'                             => 'folders',
        'far fa-font'                                => 'font',
        'far fa-font-awesome-logo-full'              => 'font-awesome-logo-full',
        'far fa-font-case'                           => 'font-case',
        'far fa-football-ball'                       => 'football-ball',
        'far fa-football-helmet'                     => 'football-helmet',
        'far fa-forklift'                            => 'forklift',
        'far fa-forward'                             => 'forward',
        'far fa-fragile'                             => 'fragile',
        'far fa-french-fries'                        => 'french-fries',
        'far fa-frog'                                => 'frog',
        'far fa-frosty-head'                         => 'frosty-head',
        'far fa-frown'                               => 'frown',
        'far fa-frown-open'                          => 'frown-open',
        'far fa-function'                            => 'function',
        'far fa-funnel-dollar'                       => 'funnel-dollar',
        'far fa-futbol'                              => 'futbol',
        'far fa-game-board'                          => 'game-board',
        'far fa-game-board-alt'                      => 'game-board-alt',
        'far fa-gamepad'                             => 'gamepad',
        'far fa-gas-pump'                            => 'gas-pump',
        'far fa-gas-pump-slash'                      => 'gas-pump-slash',
        'far fa-gavel'                               => 'gavel',
        'far fa-gem'                                 => 'gem',
        'far fa-genderless'                          => 'genderless',
        'far fa-ghost'                               => 'ghost',
        'far fa-gift'                                => 'gift',
        'far fa-gift-card'                           => 'gift-card',
        'far fa-gifts'                               => 'gifts',
        'far fa-gingerbread-man'                     => 'gingerbread-man',
        'far fa-glass'                               => 'glass',
        'far fa-glass-champagne'                     => 'glass-champagne',
        'far fa-glass-cheers'                        => 'glass-cheers',
        'far fa-glass-citrus'                        => 'glass-citrus',
        'far fa-glass-martini'                       => 'glass-martini',
        'far fa-glass-martini-alt'                   => 'glass-martini-alt',
        'far fa-glass-whiskey'                       => 'glass-whiskey',
        'far fa-glass-whiskey-rocks'                 => 'glass-whiskey-rocks',
        'far fa-glasses'                             => 'glasses',
        'far fa-glasses-alt'                         => 'glasses-alt',
        'far fa-globe'                               => 'globe',
        'far fa-globe-africa'                        => 'globe-africa',
        'far fa-globe-americas'                      => 'globe-americas',
        'far fa-globe-asia'                          => 'globe-asia',
        'far fa-globe-europe'                        => 'globe-europe',
        'far fa-globe-snow'                          => 'globe-snow',
        'far fa-globe-stand'                         => 'globe-stand',
        'far fa-golf-ball'                           => 'golf-ball',
        'far fa-golf-club'                           => 'golf-club',
        'far fa-gopuram'                             => 'gopuram',
        'far fa-graduation-cap'                      => 'graduation-cap',
        'far fa-greater-than'                        => 'greater-than',
        'far fa-greater-than-equal'                  => 'greater-than-equal',
        'far fa-grimace'                             => 'grimace',
        'far fa-grin'                                => 'grin',
        'far fa-grin-alt'                            => 'grin-alt',
        'far fa-grin-beam'                           => 'grin-beam',
        'far fa-grin-beam-sweat'                     => 'grin-beam-sweat',
        'far fa-grin-hearts'                         => 'grin-hearts',
        'far fa-grin-squint'                         => 'grin-squint',
        'far fa-grin-squint-tears'                   => 'grin-squint-tears',
        'far fa-grin-stars'                          => 'grin-stars',
        'far fa-grin-tears'                          => 'grin-tears',
        'far fa-grin-tongue'                         => 'grin-tongue',
        'far fa-grin-tongue-squint'                  => 'grin-tongue-squint',
        'far fa-grin-tongue-wink'                    => 'grin-tongue-wink',
        'far fa-grin-wink'                           => 'grin-wink',
        'far fa-grip-horizontal'                     => 'grip-horizontal',
        'far fa-grip-lines'                          => 'grip-lines',
        'far fa-grip-lines-vertical'                 => 'grip-lines-vertical',
        'far fa-grip-vertical'                       => 'grip-vertical',
        'far fa-guitar'                              => 'guitar',
        'far fa-h-square'                            => 'h-square',
        'far fa-h1'                                  => 'h1',
        'far fa-h2'                                  => 'h2',
        'far fa-h3'                                  => 'h3',
        'far fa-h4'                                  => 'h4',
        'far fa-hamburger'                           => 'hamburger',
        'far fa-hammer'                              => 'hammer',
        'far fa-hammer-war'                          => 'hammer-war',
        'far fa-hamsa'                               => 'hamsa',
        'far fa-hand-heart'                          => 'hand-heart',
        'far fa-hand-holding'                        => 'hand-holding',
        'far fa-hand-holding-box'                    => 'hand-holding-box',
        'far fa-hand-holding-heart'                  => 'hand-holding-heart',
        'far fa-hand-holding-magic'                  => 'hand-holding-magic',
        'far fa-hand-holding-seedling'               => 'hand-holding-seedling',
        'far fa-hand-holding-usd'                    => 'hand-holding-usd',
        'far fa-hand-holding-water'                  => 'hand-holding-water',
        'far fa-hand-lizard'                         => 'hand-lizard',
        'far fa-hand-middle-finger'                  => 'hand-middle-finger',
        'far fa-hand-paper'                          => 'hand-paper',
        'far fa-hand-peace'                          => 'hand-peace',
        'far fa-hand-point-down'                     => 'hand-point-down',
        'far fa-hand-point-left'                     => 'hand-point-left',
        'far fa-hand-point-right'                    => 'hand-point-right',
        'far fa-hand-point-up'                       => 'hand-point-up',
        'far fa-hand-pointer'                        => 'hand-pointer',
        'far fa-hand-receiving'                      => 'hand-receiving',
        'far fa-hand-rock'                           => 'hand-rock',
        'far fa-hand-scissors'                       => 'hand-scissors',
        'far fa-hand-spock'                          => 'hand-spock',
        'far fa-hands'                               => 'hands',
        'far fa-hands-heart'                         => 'hands-heart',
        'far fa-hands-helping'                       => 'hands-helping',
        'far fa-hands-usd'                           => 'hands-usd',
        'far fa-handshake'                           => 'handshake',
        'far fa-handshake-alt'                       => 'handshake-alt',
        'far fa-hanukiah'                            => 'hanukiah',
        'far fa-hard-hat'                            => 'hard-hat',
        'far fa-hashtag'                             => 'hashtag',
        'far fa-hat-chef'                            => 'hat-chef',
        'far fa-hat-santa'                           => 'hat-santa',
        'far fa-hat-winter'                          => 'hat-winter',
        'far fa-hat-witch'                           => 'hat-witch',
        'far fa-hat-wizard'                          => 'hat-wizard',
        'far fa-haykal'                              => 'haykal',
        'far fa-hdd'                                 => 'hdd',
        'far fa-head-side'                           => 'head-side',
        'far fa-head-side-brain'                     => 'head-side-brain',
        'far fa-head-side-medical'                   => 'head-side-medical',
        'far fa-head-vr'                             => 'head-vr',
        'far fa-heading'                             => 'heading',
        'far fa-headphones'                          => 'headphones',
        'far fa-headphones-alt'                      => 'headphones-alt',
        'far fa-headset'                             => 'headset',
        'far fa-heart'                               => 'heart',
        'far fa-heart-broken'                        => 'heart-broken',
        'far fa-heart-circle'                        => 'heart-circle',
        'far fa-heart-rate'                          => 'heart-rate',
        'far fa-heart-square'                        => 'heart-square',
        'far fa-heartbeat'                           => 'heartbeat',
        'far fa-helicopter'                          => 'helicopter',
        'far fa-helmet-battle'                       => 'helmet-battle',
        'far fa-hexagon'                             => 'hexagon',
        'far fa-highlighter'                         => 'highlighter',
        'far fa-hiking'                              => 'hiking',
        'far fa-hippo'                               => 'hippo',
        'far fa-history'                             => 'history',
        'far fa-hockey-mask'                         => 'hockey-mask',
        'far fa-hockey-puck'                         => 'hockey-puck',
        'far fa-hockey-sticks'                       => 'hockey-sticks',
        'far fa-holly-berry'                         => 'holly-berry',
        'far fa-home'                                => 'home',
        'far fa-home-alt'                            => 'home-alt',
        'far fa-home-heart'                          => 'home-heart',
        'far fa-home-lg'                             => 'home-lg',
        'far fa-home-lg-alt'                         => 'home-lg-alt',
        'far fa-hood-cloak'                          => 'hood-cloak',
        'far fa-horizontal-rule'                     => 'horizontal-rule',
        'far fa-horse'                               => 'horse',
        'far fa-horse-head'                          => 'horse-head',
        'far fa-hospital'                            => 'hospital',
        'far fa-hospital-alt'                        => 'hospital-alt',
        'far fa-hospital-symbol'                     => 'hospital-symbol',
        'far fa-hospital-user'                       => 'hospital-user',
        'far fa-hospitals'                           => 'hospitals',
        'far fa-hot-tub'                             => 'hot-tub',
        'far fa-hotdog'                              => 'hotdog',
        'far fa-hotel'                               => 'hotel',
        'far fa-hourglass'                           => 'hourglass',
        'far fa-hourglass-end'                       => 'hourglass-end',
        'far fa-hourglass-half'                      => 'hourglass-half',
        'far fa-hourglass-start'                     => 'hourglass-start',
        'far fa-house-damage'                        => 'house-damage',
        'far fa-house-flood'                         => 'house-flood',
        'far fa-hryvnia'                             => 'hryvnia',
        'far fa-humidity'                            => 'humidity',
        'far fa-hurricane'                           => 'hurricane',
        'far fa-i-cursor'                            => 'i-cursor',
        'far fa-ice-cream'                           => 'ice-cream',
        'far fa-ice-skate'                           => 'ice-skate',
        'far fa-icicles'                             => 'icicles',
        'far fa-icons'                               => 'icons',
        'far fa-icons-alt'                           => 'icons-alt',
        'far fa-id-badge'                            => 'id-badge',
        'far fa-id-card'                             => 'id-card',
        'far fa-id-card-alt'                         => 'id-card-alt',
        'far fa-igloo'                               => 'igloo',
        'far fa-image'                               => 'image',
        'far fa-images'                              => 'images',
        'far fa-inbox'                               => 'inbox',
        'far fa-inbox-in'                            => 'inbox-in',
        'far fa-inbox-out'                           => 'inbox-out',
        'far fa-indent'                              => 'indent',
        'far fa-industry'                            => 'industry',
        'far fa-industry-alt'                        => 'industry-alt',
        'far fa-infinity'                            => 'infinity',
        'far fa-info'                                => 'info',
        'far fa-info-circle'                         => 'info-circle',
        'far fa-info-square'                         => 'info-square',
        'far fa-inhaler'                             => 'inhaler',
        'far fa-integral'                            => 'integral',
        'far fa-intersection'                        => 'intersection',
        'far fa-inventory'                           => 'inventory',
        'far fa-island-tropical'                     => 'island-tropical',
        'far fa-italic'                              => 'italic',
        'far fa-jack-o-lantern'                      => 'jack-o-lantern',
        'far fa-jedi'                                => 'jedi',
        'far fa-joint'                               => 'joint',
        'far fa-journal-whills'                      => 'journal-whills',
        'far fa-kaaba'                               => 'kaaba',
        'far fa-kerning'                             => 'kerning',
        'far fa-key'                                 => 'key',
        'far fa-key-skeleton'                        => 'key-skeleton',
        'far fa-keyboard'                            => 'keyboard',
        'far fa-keynote'                             => 'keynote',
        'far fa-khanda'                              => 'khanda',
        'far fa-kidneys'                             => 'kidneys',
        'far fa-kiss'                                => 'kiss',
        'far fa-kiss-beam'                           => 'kiss-beam',
        'far fa-kiss-wink-heart'                     => 'kiss-wink-heart',
        'far fa-kite'                                => 'kite',
        'far fa-kiwi-bird'                           => 'kiwi-bird',
        'far fa-knife-kitchen'                       => 'knife-kitchen',
        'far fa-lambda'                              => 'lambda',
        'far fa-lamp'                                => 'lamp',
        'far fa-landmark'                            => 'landmark',
        'far fa-landmark-alt'                        => 'landmark-alt',
        'far fa-language'                            => 'language',
        'far fa-laptop'                              => 'laptop',
        'far fa-laptop-code'                         => 'laptop-code',
        'far fa-laptop-medical'                      => 'laptop-medical',
        'far fa-laugh'                               => 'laugh',
        'far fa-laugh-beam'                          => 'laugh-beam',
        'far fa-laugh-squint'                        => 'laugh-squint',
        'far fa-laugh-wink'                          => 'laugh-wink',
        'far fa-layer-group'                         => 'layer-group',
        'far fa-layer-minus'                         => 'layer-minus',
        'far fa-layer-plus'                          => 'layer-plus',
        'far fa-leaf'                                => 'leaf',
        'far fa-leaf-heart'                          => 'leaf-heart',
        'far fa-leaf-maple'                          => 'leaf-maple',
        'far fa-leaf-oak'                            => 'leaf-oak',
        'far fa-lemon'                               => 'lemon',
        'far fa-less-than'                           => 'less-than',
        'far fa-less-than-equal'                     => 'less-than-equal',
        'far fa-level-down'                          => 'level-down',
        'far fa-level-down-alt'                      => 'level-down-alt',
        'far fa-level-up'                            => 'level-up',
        'far fa-level-up-alt'                        => 'level-up-alt',
        'far fa-life-ring'                           => 'life-ring',
        'far fa-lightbulb'                           => 'lightbulb',
        'far fa-lightbulb-dollar'                    => 'lightbulb-dollar',
        'far fa-lightbulb-exclamation'               => 'lightbulb-exclamation',
        'far fa-lightbulb-on'                        => 'lightbulb-on',
        'far fa-lightbulb-slash'                     => 'lightbulb-slash',
        'far fa-lights-holiday'                      => 'lights-holiday',
        'far fa-line-columns'                        => 'line-columns',
        'far fa-line-height'                         => 'line-height',
        'far fa-link'                                => 'link',
        'far fa-lips'                                => 'lips',
        'far fa-lira-sign'                           => 'lira-sign',
        'far fa-list'                                => 'list',
        'far fa-list-alt'                            => 'list-alt',
        'far fa-list-ol'                             => 'list-ol',
        'far fa-list-ul'                             => 'list-ul',
        'far fa-location'                            => 'location',
        'far fa-location-arrow'                      => 'location-arrow',
        'far fa-location-circle'                     => 'location-circle',
        'far fa-location-slash'                      => 'location-slash',
        'far fa-lock'                                => 'lock',
        'far fa-lock-alt'                            => 'lock-alt',
        'far fa-lock-open'                           => 'lock-open',
        'far fa-lock-open-alt'                       => 'lock-open-alt',
        'far fa-long-arrow-alt-down'                 => 'long-arrow-alt-down',
        'far fa-long-arrow-alt-left'                 => 'long-arrow-alt-left',
        'far fa-long-arrow-alt-right'                => 'long-arrow-alt-right',
        'far fa-long-arrow-alt-up'                   => 'long-arrow-alt-up',
        'far fa-long-arrow-down'                     => 'long-arrow-down',
        'far fa-long-arrow-left'                     => 'long-arrow-left',
        'far fa-long-arrow-right'                    => 'long-arrow-right',
        'far fa-long-arrow-up'                       => 'long-arrow-up',
        'far fa-loveseat'                            => 'loveseat',
        'far fa-low-vision'                          => 'low-vision',
        'far fa-luchador'                            => 'luchador',
        'far fa-luggage-cart'                        => 'luggage-cart',
        'far fa-lungs'                               => 'lungs',
        'far fa-mace'                                => 'mace',
        'far fa-magic'                               => 'magic',
        'far fa-magnet'                              => 'magnet',
        'far fa-mail-bulk'                           => 'mail-bulk',
        'far fa-mailbox'                             => 'mailbox',
        'far fa-male'                                => 'male',
        'far fa-mandolin'                            => 'mandolin',
        'far fa-map'                                 => 'map',
        'far fa-map-marked'                          => 'map-marked',
        'far fa-map-marked-alt'                      => 'map-marked-alt',
        'far fa-map-marker'                          => 'map-marker',
        'far fa-map-marker-alt'                      => 'map-marker-alt',
        'far fa-map-marker-alt-slash'                => 'map-marker-alt-slash',
        'far fa-map-marker-check'                    => 'map-marker-check',
        'far fa-map-marker-edit'                     => 'map-marker-edit',
        'far fa-map-marker-exclamation'              => 'map-marker-exclamation',
        'far fa-map-marker-minus'                    => 'map-marker-minus',
        'far fa-map-marker-plus'                     => 'map-marker-plus',
        'far fa-map-marker-question'                 => 'map-marker-question',
        'far fa-map-marker-slash'                    => 'map-marker-slash',
        'far fa-map-marker-smile'                    => 'map-marker-smile',
        'far fa-map-marker-times'                    => 'map-marker-times',
        'far fa-map-pin'                             => 'map-pin',
        'far fa-map-signs'                           => 'map-signs',
        'far fa-marker'                              => 'marker',
        'far fa-mars'                                => 'mars',
        'far fa-mars-double'                         => 'mars-double',
        'far fa-mars-stroke'                         => 'mars-stroke',
        'far fa-mars-stroke-h'                       => 'mars-stroke-h',
        'far fa-mars-stroke-v'                       => 'mars-stroke-v',
        'far fa-mask'                                => 'mask',
        'far fa-meat'                                => 'meat',
        'far fa-medal'                               => 'medal',
        'far fa-medkit'                              => 'medkit',
        'far fa-megaphone'                           => 'megaphone',
        'far fa-meh'                                 => 'meh',
        'far fa-meh-blank'                           => 'meh-blank',
        'far fa-meh-rolling-eyes'                    => 'meh-rolling-eyes',
        'far fa-memory'                              => 'memory',
        'far fa-menorah'                             => 'menorah',
        'far fa-mercury'                             => 'mercury',
        'far fa-meteor'                              => 'meteor',
        'far fa-microchip'                           => 'microchip',
        'far fa-microphone'                          => 'microphone',
        'far fa-microphone-alt'                      => 'microphone-alt',
        'far fa-microphone-alt-slash'                => 'microphone-alt-slash',
        'far fa-microphone-slash'                    => 'microphone-slash',
        'far fa-microscope'                          => 'microscope',
        'far fa-mind-share'                          => 'mind-share',
        'far fa-minus'                               => 'minus',
        'far fa-minus-circle'                        => 'minus-circle',
        'far fa-minus-hexagon'                       => 'minus-hexagon',
        'far fa-minus-octagon'                       => 'minus-octagon',
        'far fa-minus-square'                        => 'minus-square',
        'far fa-mistletoe'                           => 'mistletoe',
        'far fa-mitten'                              => 'mitten',
        'far fa-mobile'                              => 'mobile',
        'far fa-mobile-alt'                          => 'mobile-alt',
        'far fa-mobile-android'                      => 'mobile-android',
        'far fa-mobile-android-alt'                  => 'mobile-android-alt',
        'far fa-money-bill'                          => 'money-bill',
        'far fa-money-bill-alt'                      => 'money-bill-alt',
        'far fa-money-bill-wave'                     => 'money-bill-wave',
        'far fa-money-bill-wave-alt'                 => 'money-bill-wave-alt',
        'far fa-money-check'                         => 'money-check',
        'far fa-money-check-alt'                     => 'money-check-alt',
        'far fa-money-check-edit'                    => 'money-check-edit',
        'far fa-money-check-edit-alt'                => 'money-check-edit-alt',
        'far fa-monitor-heart-rate'                  => 'monitor-heart-rate',
        'far fa-monkey'                              => 'monkey',
        'far fa-monument'                            => 'monument',
        'far fa-moon'                                => 'moon',
        'far fa-moon-cloud'                          => 'moon-cloud',
        'far fa-moon-stars'                          => 'moon-stars',
        'far fa-mortar-pestle'                       => 'mortar-pestle',
        'far fa-mosque'                              => 'mosque',
        'far fa-motorcycle'                          => 'motorcycle',
        'far fa-mountain'                            => 'mountain',
        'far fa-mountains'                           => 'mountains',
        'far fa-mouse-pointer'                       => 'mouse-pointer',
        'far fa-mug'                                 => 'mug',
        'far fa-mug-hot'                             => 'mug-hot',
        'far fa-mug-marshmallows'                    => 'mug-marshmallows',
        'far fa-mug-tea'                             => 'mug-tea',
        'far fa-music'                               => 'music',
        'far fa-narwhal'                             => 'narwhal',
        'far fa-network-wired'                       => 'network-wired',
        'far fa-neuter'                              => 'neuter',
        'far fa-newspaper'                           => 'newspaper',
        'far fa-not-equal'                           => 'not-equal',
        'far fa-notes-medical'                       => 'notes-medical',
        'far fa-object-group'                        => 'object-group',
        'far fa-object-ungroup'                      => 'object-ungroup',
        'far fa-octagon'                             => 'octagon',
        'far fa-oil-can'                             => 'oil-can',
        'far fa-oil-temp'                            => 'oil-temp',
        'far fa-om'                                  => 'om',
        'far fa-omega'                               => 'omega',
        'far fa-ornament'                            => 'ornament',
        'far fa-otter'                               => 'otter',
        'far fa-outdent'                             => 'outdent',
        'far fa-overline'                            => 'overline',
        'far fa-page-break'                          => 'page-break',
        'far fa-pager'                               => 'pager',
        'far fa-paint-brush'                         => 'paint-brush',
        'far fa-paint-brush-alt'                     => 'paint-brush-alt',
        'far fa-paint-roller'                        => 'paint-roller',
        'far fa-palette'                             => 'palette',
        'far fa-pallet'                              => 'pallet',
        'far fa-pallet-alt'                          => 'pallet-alt',
        'far fa-paper-plane'                         => 'paper-plane',
        'far fa-paperclip'                           => 'paperclip',
        'far fa-parachute-box'                       => 'parachute-box',
        'far fa-paragraph'                           => 'paragraph',
        'far fa-paragraph-rtl'                       => 'paragraph-rtl',
        'far fa-parking'                             => 'parking',
        'far fa-parking-circle'                      => 'parking-circle',
        'far fa-parking-circle-slash'                => 'parking-circle-slash',
        'far fa-parking-slash'                       => 'parking-slash',
        'far fa-passport'                            => 'passport',
        'far fa-pastafarianism'                      => 'pastafarianism',
        'far fa-paste'                               => 'paste',
        'far fa-pause'                               => 'pause',
        'far fa-pause-circle'                        => 'pause-circle',
        'far fa-paw'                                 => 'paw',
        'far fa-paw-alt'                             => 'paw-alt',
        'far fa-paw-claws'                           => 'paw-claws',
        'far fa-peace'                               => 'peace',
        'far fa-pegasus'                             => 'pegasus',
        'far fa-pen'                                 => 'pen',
        'far fa-pen-alt'                             => 'pen-alt',
        'far fa-pen-fancy'                           => 'pen-fancy',
        'far fa-pen-nib'                             => 'pen-nib',
        'far fa-pen-square'                          => 'pen-square',
        'far fa-pencil'                              => 'pencil',
        'far fa-pencil-alt'                          => 'pencil-alt',
        'far fa-pencil-paintbrush'                   => 'pencil-paintbrush',
        'far fa-pencil-ruler'                        => 'pencil-ruler',
        'far fa-pennant'                             => 'pennant',
        'far fa-people-carry'                        => 'people-carry',
        'far fa-pepper-hot'                          => 'pepper-hot',
        'far fa-percent'                             => 'percent',
        'far fa-percentage'                          => 'percentage',
        'far fa-person-booth'                        => 'person-booth',
        'far fa-person-carry'                        => 'person-carry',
        'far fa-person-dolly'                        => 'person-dolly',
        'far fa-person-dolly-empty'                  => 'person-dolly-empty',
        'far fa-person-sign'                         => 'person-sign',
        'far fa-phone'                               => 'phone',
        'far fa-phone-alt'                           => 'phone-alt',
        'far fa-phone-laptop'                        => 'phone-laptop',
        'far fa-phone-office'                        => 'phone-office',
        'far fa-phone-plus'                          => 'phone-plus',
        'far fa-phone-slash'                         => 'phone-slash',
        'far fa-phone-square'                        => 'phone-square',
        'far fa-phone-square-alt'                    => 'phone-square-alt',
        'far fa-phone-volume'                        => 'phone-volume',
        'far fa-photo-video'                         => 'photo-video',
        'far fa-pi'                                  => 'pi',
        'far fa-pie'                                 => 'pie',
        'far fa-pig'                                 => 'pig',
        'far fa-piggy-bank'                          => 'piggy-bank',
        'far fa-pills'                               => 'pills',
        'far fa-pizza'                               => 'pizza',
        'far fa-pizza-slice'                         => 'pizza-slice',
        'far fa-place-of-worship'                    => 'place-of-worship',
        'far fa-plane'                               => 'plane',
        'far fa-plane-alt'                           => 'plane-alt',
        'far fa-plane-arrival'                       => 'plane-arrival',
        'far fa-plane-departure'                     => 'plane-departure',
        'far fa-play'                                => 'play',
        'far fa-play-circle'                         => 'play-circle',
        'far fa-plug'                                => 'plug',
        'far fa-plus'                                => 'plus',
        'far fa-plus-circle'                         => 'plus-circle',
        'far fa-plus-hexagon'                        => 'plus-hexagon',
        'far fa-plus-octagon'                        => 'plus-octagon',
        'far fa-plus-square'                         => 'plus-square',
        'far fa-podcast'                             => 'podcast',
        'far fa-podium'                              => 'podium',
        'far fa-podium-star'                         => 'podium-star',
        'far fa-poll'                                => 'poll',
        'far fa-poll-h'                              => 'poll-h',
        'far fa-poll-people'                         => 'poll-people',
        'far fa-poo'                                 => 'poo',
        'far fa-poo-storm'                           => 'poo-storm',
        'far fa-poop'                                => 'poop',
        'far fa-popcorn'                             => 'popcorn',
        'far fa-portrait'                            => 'portrait',
        'far fa-pound-sign'                          => 'pound-sign',
        'far fa-power-off'                           => 'power-off',
        'far fa-pray'                                => 'pray',
        'far fa-praying-hands'                       => 'praying-hands',
        'far fa-prescription'                        => 'prescription',
        'far fa-prescription-bottle'                 => 'prescription-bottle',
        'far fa-prescription-bottle-alt'             => 'prescription-bottle-alt',
        'far fa-presentation'                        => 'presentation',
        'far fa-print'                               => 'print',
        'far fa-print-search'                        => 'print-search',
        'far fa-print-slash'                         => 'print-slash',
        'far fa-procedures'                          => 'procedures',
        'far fa-project-diagram'                     => 'project-diagram',
        'far fa-pumpkin'                             => 'pumpkin',
        'far fa-puzzle-piece'                        => 'puzzle-piece',
        'far fa-qrcode'                              => 'qrcode',
        'far fa-question'                            => 'question',
        'far fa-question-circle'                     => 'question-circle',
        'far fa-question-square'                     => 'question-square',
        'far fa-quidditch'                           => 'quidditch',
        'far fa-quote-left'                          => 'quote-left',
        'far fa-quote-right'                         => 'quote-right',
        'far fa-quran'                               => 'quran',
        'far fa-rabbit'                              => 'rabbit',
        'far fa-rabbit-fast'                         => 'rabbit-fast',
        'far fa-racquet'                             => 'racquet',
        'far fa-radiation'                           => 'radiation',
        'far fa-radiation-alt'                       => 'radiation-alt',
        'far fa-rainbow'                             => 'rainbow',
        'far fa-raindrops'                           => 'raindrops',
        'far fa-ram'                                 => 'ram',
        'far fa-ramp-loading'                        => 'ramp-loading',
        'far fa-random'                              => 'random',
        'far fa-receipt'                             => 'receipt',
        'far fa-rectangle-landscape'                 => 'rectangle-landscape',
        'far fa-rectangle-portrait'                  => 'rectangle-portrait',
        'far fa-rectangle-wide'                      => 'rectangle-wide',
        'far fa-recycle'                             => 'recycle',
        'far fa-redo'                                => 'redo',
        'far fa-redo-alt'                            => 'redo-alt',
        'far fa-registered'                          => 'registered',
        'far fa-remove-format'                       => 'remove-format',
        'far fa-repeat'                              => 'repeat',
        'far fa-repeat-1'                            => 'repeat-1',
        'far fa-repeat-1-alt'                        => 'repeat-1-alt',
        'far fa-repeat-alt'                          => 'repeat-alt',
        'far fa-reply'                               => 'reply',
        'far fa-reply-all'                           => 'reply-all',
        'far fa-republican'                          => 'republican',
        'far fa-restroom'                            => 'restroom',
        'far fa-retweet'                             => 'retweet',
        'far fa-retweet-alt'                         => 'retweet-alt',
        'far fa-ribbon'                              => 'ribbon',
        'far fa-ring'                                => 'ring',
        'far fa-rings-wedding'                       => 'rings-wedding',
        'far fa-road'                                => 'road',
        'far fa-robot'                               => 'robot',
        'far fa-rocket'                              => 'rocket',
        'far fa-route'                               => 'route',
        'far fa-route-highway'                       => 'route-highway',
        'far fa-route-interstate'                    => 'route-interstate',
        'far fa-rss'                                 => 'rss',
        'far fa-rss-square'                          => 'rss-square',
        'far fa-ruble-sign'                          => 'ruble-sign',
        'far fa-ruler'                               => 'ruler',
        'far fa-ruler-combined'                      => 'ruler-combined',
        'far fa-ruler-horizontal'                    => 'ruler-horizontal',
        'far fa-ruler-triangle'                      => 'ruler-triangle',
        'far fa-ruler-vertical'                      => 'ruler-vertical',
        'far fa-running'                             => 'running',
        'far fa-rupee-sign'                          => 'rupee-sign',
        'far fa-rv'                                  => 'rv',
        'far fa-sack'                                => 'sack',
        'far fa-sack-dollar'                         => 'sack-dollar',
        'far fa-sad-cry'                             => 'sad-cry',
        'far fa-sad-tear'                            => 'sad-tear',
        'far fa-salad'                               => 'salad',
        'far fa-sandwich'                            => 'sandwich',
        'far fa-satellite'                           => 'satellite',
        'far fa-satellite-dish'                      => 'satellite-dish',
        'far fa-sausage'                             => 'sausage',
        'far fa-save'                                => 'save',
        'far fa-scalpel'                             => 'scalpel',
        'far fa-scalpel-path'                        => 'scalpel-path',
        'far fa-scanner'                             => 'scanner',
        'far fa-scanner-keyboard'                    => 'scanner-keyboard',
        'far fa-scanner-touchscreen'                 => 'scanner-touchscreen',
        'far fa-scarecrow'                           => 'scarecrow',
        'far fa-scarf'                               => 'scarf',
        'far fa-school'                              => 'school',
        'far fa-screwdriver'                         => 'screwdriver',
        'far fa-scroll'                              => 'scroll',
        'far fa-scroll-old'                          => 'scroll-old',
        'far fa-scrubber'                            => 'scrubber',
        'far fa-scythe'                              => 'scythe',
        'far fa-sd-card'                             => 'sd-card',
        'far fa-search'                              => 'search',
        'far fa-search-dollar'                       => 'search-dollar',
        'far fa-search-location'                     => 'search-location',
        'far fa-search-minus'                        => 'search-minus',
        'far fa-search-plus'                         => 'search-plus',
        'far fa-seedling'                            => 'seedling',
        'far fa-send-back'                           => 'send-back',
        'far fa-send-backward'                       => 'send-backward',
        'far fa-server'                              => 'server',
        'far fa-shapes'                              => 'shapes',
        'far fa-share'                               => 'share',
        'far fa-share-all'                           => 'share-all',
        'far fa-share-alt'                           => 'share-alt',
        'far fa-share-alt-square'                    => 'share-alt-square',
        'far fa-share-square'                        => 'share-square',
        'far fa-sheep'                               => 'sheep',
        'far fa-shekel-sign'                         => 'shekel-sign',
        'far fa-shield'                              => 'shield',
        'far fa-shield-alt'                          => 'shield-alt',
        'far fa-shield-check'                        => 'shield-check',
        'far fa-shield-cross'                        => 'shield-cross',
        'far fa-ship'                                => 'ship',
        'far fa-shipping-fast'                       => 'shipping-fast',
        'far fa-shipping-timed'                      => 'shipping-timed',
        'far fa-shish-kebab'                         => 'shish-kebab',
        'far fa-shoe-prints'                         => 'shoe-prints',
        'far fa-shopping-bag'                        => 'shopping-bag',
        'far fa-shopping-basket'                     => 'shopping-basket',
        'far fa-shopping-cart'                       => 'shopping-cart',
        'far fa-shovel'                              => 'shovel',
        'far fa-shovel-snow'                         => 'shovel-snow',
        'far fa-shower'                              => 'shower',
        'far fa-shredder'                            => 'shredder',
        'far fa-shuttle-van'                         => 'shuttle-van',
        'far fa-shuttlecock'                         => 'shuttlecock',
        'far fa-sickle'                              => 'sickle',
        'far fa-sigma'                               => 'sigma',
        'far fa-sign'                                => 'sign',
        'far fa-sign-in'                             => 'sign-in',
        'far fa-sign-in-alt'                         => 'sign-in-alt',
        'far fa-sign-language'                       => 'sign-language',
        'far fa-sign-out'                            => 'sign-out',
        'far fa-sign-out-alt'                        => 'sign-out-alt',
        'far fa-signal'                              => 'signal',
        'far fa-signal-1'                            => 'signal-1',
        'far fa-signal-2'                            => 'signal-2',
        'far fa-signal-3'                            => 'signal-3',
        'far fa-signal-4'                            => 'signal-4',
        'far fa-signal-alt'                          => 'signal-alt',
        'far fa-signal-alt-1'                        => 'signal-alt-1',
        'far fa-signal-alt-2'                        => 'signal-alt-2',
        'far fa-signal-alt-3'                        => 'signal-alt-3',
        'far fa-signal-alt-slash'                    => 'signal-alt-slash',
        'far fa-signal-slash'                        => 'signal-slash',
        'far fa-signature'                           => 'signature',
        'far fa-sim-card'                            => 'sim-card',
        'far fa-sitemap'                             => 'sitemap',
        'far fa-skating'                             => 'skating',
        'far fa-skeleton'                            => 'skeleton',
        'far fa-ski-jump'                            => 'ski-jump',
        'far fa-ski-lift'                            => 'ski-lift',
        'far fa-skiing'                              => 'skiing',
        'far fa-skiing-nordic'                       => 'skiing-nordic',
        'far fa-skull'                               => 'skull',
        'far fa-skull-crossbones'                    => 'skull-crossbones',
        'far fa-slash'                               => 'slash',
        'far fa-sledding'                            => 'sledding',
        'far fa-sleigh'                              => 'sleigh',
        'far fa-sliders-h'                           => 'sliders-h',
        'far fa-sliders-h-square'                    => 'sliders-h-square',
        'far fa-sliders-v'                           => 'sliders-v',
        'far fa-sliders-v-square'                    => 'sliders-v-square',
        'far fa-smile'                               => 'smile',
        'far fa-smile-beam'                          => 'smile-beam',
        'far fa-smile-plus'                          => 'smile-plus',
        'far fa-smile-wink'                          => 'smile-wink',
        'far fa-smog'                                => 'smog',
        'far fa-smoke'                               => 'smoke',
        'far fa-smoking'                             => 'smoking',
        'far fa-smoking-ban'                         => 'smoking-ban',
        'far fa-sms'                                 => 'sms',
        'far fa-snake'                               => 'snake',
        'far fa-snooze'                              => 'snooze',
        'far fa-snow-blowing'                        => 'snow-blowing',
        'far fa-snowboarding'                        => 'snowboarding',
        'far fa-snowflake'                           => 'snowflake',
        'far fa-snowflakes'                          => 'snowflakes',
        'far fa-snowman'                             => 'snowman',
        'far fa-snowmobile'                          => 'snowmobile',
        'far fa-snowplow'                            => 'snowplow',
        'far fa-socks'                               => 'socks',
        'far fa-solar-panel'                         => 'solar-panel',
        'far fa-sort'                                => 'sort',
        'far fa-sort-alpha-down'                     => 'sort-alpha-down',
        'far fa-sort-alpha-down-alt'                 => 'sort-alpha-down-alt',
        'far fa-sort-alpha-up'                       => 'sort-alpha-up',
        'far fa-sort-alpha-up-alt'                   => 'sort-alpha-up-alt',
        'far fa-sort-alt'                            => 'sort-alt',
        'far fa-sort-amount-down'                    => 'sort-amount-down',
        'far fa-sort-amount-down-alt'                => 'sort-amount-down-alt',
        'far fa-sort-amount-up'                      => 'sort-amount-up',
        'far fa-sort-amount-up-alt'                  => 'sort-amount-up-alt',
        'far fa-sort-down'                           => 'sort-down',
        'far fa-sort-numeric-down'                   => 'sort-numeric-down',
        'far fa-sort-numeric-down-alt'               => 'sort-numeric-down-alt',
        'far fa-sort-numeric-up'                     => 'sort-numeric-up',
        'far fa-sort-numeric-up-alt'                 => 'sort-numeric-up-alt',
        'far fa-sort-shapes-down'                    => 'sort-shapes-down',
        'far fa-sort-shapes-down-alt'                => 'sort-shapes-down-alt',
        'far fa-sort-shapes-up'                      => 'sort-shapes-up',
        'far fa-sort-shapes-up-alt'                  => 'sort-shapes-up-alt',
        'far fa-sort-size-down'                      => 'sort-size-down',
        'far fa-sort-size-down-alt'                  => 'sort-size-down-alt',
        'far fa-sort-size-up'                        => 'sort-size-up',
        'far fa-sort-size-up-alt'                    => 'sort-size-up-alt',
        'far fa-sort-up'                             => 'sort-up',
        'far fa-soup'                                => 'soup',
        'far fa-spa'                                 => 'spa',
        'far fa-space-shuttle'                       => 'space-shuttle',
        'far fa-spade'                               => 'spade',
        'far fa-sparkles'                            => 'sparkles',
        'far fa-spell-check'                         => 'spell-check',
        'far fa-spider'                              => 'spider',
        'far fa-spider-black-widow'                  => 'spider-black-widow',
        'far fa-spider-web'                          => 'spider-web',
        'far fa-spinner'                             => 'spinner',
        'far fa-spinner-third'                       => 'spinner-third',
        'far fa-splotch'                             => 'splotch',
        'far fa-spray-can'                           => 'spray-can',
        'far fa-square'                              => 'square',
        'far fa-square-full'                         => 'square-full',
        'far fa-square-root'                         => 'square-root',
        'far fa-square-root-alt'                     => 'square-root-alt',
        'far fa-squirrel'                            => 'squirrel',
        'far fa-staff'                               => 'staff',
        'far fa-stamp'                               => 'stamp',
        'far fa-star'                                => 'star',
        'far fa-star-and-crescent'                   => 'star-and-crescent',
        'far fa-star-christmas'                      => 'star-christmas',
        'far fa-star-exclamation'                    => 'star-exclamation',
        'far fa-star-half'                           => 'star-half',
        'far fa-star-half-alt'                       => 'star-half-alt',
        'far fa-star-of-david'                       => 'star-of-david',
        'far fa-star-of-life'                        => 'star-of-life',
        'far fa-stars'                               => 'stars',
        'far fa-steak'                               => 'steak',
        'far fa-steering-wheel'                      => 'steering-wheel',
        'far fa-step-backward'                       => 'step-backward',
        'far fa-step-forward'                        => 'step-forward',
        'far fa-stethoscope'                         => 'stethoscope',
        'far fa-sticky-note'                         => 'sticky-note',
        'far fa-stocking'                            => 'stocking',
        'far fa-stomach'                             => 'stomach',
        'far fa-stop'                                => 'stop',
        'far fa-stop-circle'                         => 'stop-circle',
        'far fa-stopwatch'                           => 'stopwatch',
        'far fa-store'                               => 'store',
        'far fa-store-alt'                           => 'store-alt',
        'far fa-stream'                              => 'stream',
        'far fa-street-view'                         => 'street-view',
        'far fa-stretcher'                           => 'stretcher',
        'far fa-strikethrough'                       => 'strikethrough',
        'far fa-stroopwafel'                         => 'stroopwafel',
        'far fa-subscript'                           => 'subscript',
        'far fa-subway'                              => 'subway',
        'far fa-suitcase'                            => 'suitcase',
        'far fa-suitcase-rolling'                    => 'suitcase-rolling',
        'far fa-sun'                                 => 'sun',
        'far fa-sun-cloud'                           => 'sun-cloud',
        'far fa-sun-dust'                            => 'sun-dust',
        'far fa-sun-haze'                            => 'sun-haze',
        'far fa-sunglasses'                          => 'sunglasses',
        'far fa-sunrise'                             => 'sunrise',
        'far fa-sunset'                              => 'sunset',
        'far fa-superscript'                         => 'superscript',
        'far fa-surprise'                            => 'surprise',
        'far fa-swatchbook'                          => 'swatchbook',
        'far fa-swimmer'                             => 'swimmer',
        'far fa-swimming-pool'                       => 'swimming-pool',
        'far fa-sword'                               => 'sword',
        'far fa-swords'                              => 'swords',
        'far fa-synagogue'                           => 'synagogue',
        'far fa-sync'                                => 'sync',
        'far fa-sync-alt'                            => 'sync-alt',
        'far fa-syringe'                             => 'syringe',
        'far fa-table'                               => 'table',
        'far fa-table-tennis'                        => 'table-tennis',
        'far fa-tablet'                              => 'tablet',
        'far fa-tablet-alt'                          => 'tablet-alt',
        'far fa-tablet-android'                      => 'tablet-android',
        'far fa-tablet-android-alt'                  => 'tablet-android-alt',
        'far fa-tablet-rugged'                       => 'tablet-rugged',
        'far fa-tablets'                             => 'tablets',
        'far fa-tachometer'                          => 'tachometer',
        'far fa-tachometer-alt'                      => 'tachometer-alt',
        'far fa-tachometer-alt-average'              => 'tachometer-alt-average',
        'far fa-tachometer-alt-fast'                 => 'tachometer-alt-fast',
        'far fa-tachometer-alt-fastest'              => 'tachometer-alt-fastest',
        'far fa-tachometer-alt-slow'                 => 'tachometer-alt-slow',
        'far fa-tachometer-alt-slowest'              => 'tachometer-alt-slowest',
        'far fa-tachometer-average'                  => 'tachometer-average',
        'far fa-tachometer-fast'                     => 'tachometer-fast',
        'far fa-tachometer-fastest'                  => 'tachometer-fastest',
        'far fa-tachometer-slow'                     => 'tachometer-slow',
        'far fa-tachometer-slowest'                  => 'tachometer-slowest',
        'far fa-taco'                                => 'taco',
        'far fa-tag'                                 => 'tag',
        'far fa-tags'                                => 'tags',
        'far fa-tally'                               => 'tally',
        'far fa-tanakh'                              => 'tanakh',
        'far fa-tape'                                => 'tape',
        'far fa-tasks'                               => 'tasks',
        'far fa-tasks-alt'                           => 'tasks-alt',
        'far fa-taxi'                                => 'taxi',
        'far fa-teeth'                               => 'teeth',
        'far fa-teeth-open'                          => 'teeth-open',
        'far fa-temperature-frigid'                  => 'temperature-frigid',
        'far fa-temperature-high'                    => 'temperature-high',
        'far fa-temperature-hot'                     => 'temperature-hot',
        'far fa-temperature-low'                     => 'temperature-low',
        'far fa-tenge'                               => 'tenge',
        'far fa-tennis-ball'                         => 'tennis-ball',
        'far fa-terminal'                            => 'terminal',
        'far fa-text'                                => 'text',
        'far fa-text-height'                         => 'text-height',
        'far fa-text-size'                           => 'text-size',
        'far fa-text-width'                          => 'text-width',
        'far fa-th'                                  => 'th',
        'far fa-th-large'                            => 'th-large',
        'far fa-th-list'                             => 'th-list',
        'far fa-theater-masks'                       => 'theater-masks',
        'far fa-thermometer'                         => 'thermometer',
        'far fa-thermometer-empty'                   => 'thermometer-empty',
        'far fa-thermometer-full'                    => 'thermometer-full',
        'far fa-thermometer-half'                    => 'thermometer-half',
        'far fa-thermometer-quarter'                 => 'thermometer-quarter',
        'far fa-thermometer-three-quarters'          => 'thermometer-three-quarters',
        'far fa-theta'                               => 'theta',
        'far fa-thumbs-down'                         => 'thumbs-down',
        'far fa-thumbs-up'                           => 'thumbs-up',
        'far fa-thumbtack'                           => 'thumbtack',
        'far fa-thunderstorm'                        => 'thunderstorm',
        'far fa-thunderstorm-moon'                   => 'thunderstorm-moon',
        'far fa-thunderstorm-sun'                    => 'thunderstorm-sun',
        'far fa-ticket'                              => 'ticket',
        'far fa-ticket-alt'                          => 'ticket-alt',
        'far fa-tilde'                               => 'tilde',
        'far fa-times'                               => 'times',
        'far fa-times-circle'                        => 'times-circle',
        'far fa-times-hexagon'                       => 'times-hexagon',
        'far fa-times-octagon'                       => 'times-octagon',
        'far fa-times-square'                        => 'times-square',
        'far fa-tint'                                => 'tint',
        'far fa-tint-slash'                          => 'tint-slash',
        'far fa-tire'                                => 'tire',
        'far fa-tire-flat'                           => 'tire-flat',
        'far fa-tire-pressure-warning'               => 'tire-pressure-warning',
        'far fa-tire-rugged'                         => 'tire-rugged',
        'far fa-tired'                               => 'tired',
        'far fa-toggle-off'                          => 'toggle-off',
        'far fa-toggle-on'                           => 'toggle-on',
        'far fa-toilet'                              => 'toilet',
        'far fa-toilet-paper'                        => 'toilet-paper',
        'far fa-toilet-paper-alt'                    => 'toilet-paper-alt',
        'far fa-tombstone'                           => 'tombstone',
        'far fa-tombstone-alt'                       => 'tombstone-alt',
        'far fa-toolbox'                             => 'toolbox',
        'far fa-tools'                               => 'tools',
        'far fa-tooth'                               => 'tooth',
        'far fa-toothbrush'                          => 'toothbrush',
        'far fa-torah'                               => 'torah',
        'far fa-torii-gate'                          => 'torii-gate',
        'far fa-tornado'                             => 'tornado',
        'far fa-tractor'                             => 'tractor',
        'far fa-trademark'                           => 'trademark',
        'far fa-traffic-cone'                        => 'traffic-cone',
        'far fa-traffic-light'                       => 'traffic-light',
        'far fa-traffic-light-go'                    => 'traffic-light-go',
        'far fa-traffic-light-slow'                  => 'traffic-light-slow',
        'far fa-traffic-light-stop'                  => 'traffic-light-stop',
        'far fa-train'                               => 'train',
        'far fa-tram'                                => 'tram',
        'far fa-transgender'                         => 'transgender',
        'far fa-transgender-alt'                     => 'transgender-alt',
        'far fa-trash'                               => 'trash',
        'far fa-trash-alt'                           => 'trash-alt',
        'far fa-trash-restore'                       => 'trash-restore',
        'far fa-trash-restore-alt'                   => 'trash-restore-alt',
        'far fa-trash-undo'                          => 'trash-undo',
        'far fa-trash-undo-alt'                      => 'trash-undo-alt',
        'far fa-treasure-chest'                      => 'treasure-chest',
        'far fa-tree'                                => 'tree',
        'far fa-tree-alt'                            => 'tree-alt',
        'far fa-tree-christmas'                      => 'tree-christmas',
        'far fa-tree-decorated'                      => 'tree-decorated',
        'far fa-tree-large'                          => 'tree-large',
        'far fa-tree-palm'                           => 'tree-palm',
        'far fa-trees'                               => 'trees',
        'far fa-triangle'                            => 'triangle',
        'far fa-trophy'                              => 'trophy',
        'far fa-trophy-alt'                          => 'trophy-alt',
        'far fa-truck'                               => 'truck',
        'far fa-truck-container'                     => 'truck-container',
        'far fa-truck-couch'                         => 'truck-couch',
        'far fa-truck-loading'                       => 'truck-loading',
        'far fa-truck-monster'                       => 'truck-monster',
        'far fa-truck-moving'                        => 'truck-moving',
        'far fa-truck-pickup'                        => 'truck-pickup',
        'far fa-truck-plow'                          => 'truck-plow',
        'far fa-truck-ramp'                          => 'truck-ramp',
        'far fa-tshirt'                              => 'tshirt',
        'far fa-tty'                                 => 'tty',
        'far fa-turkey'                              => 'turkey',
        'far fa-turtle'                              => 'turtle',
        'far fa-tv'                                  => 'tv',
        'far fa-tv-retro'                            => 'tv-retro',
        'far fa-umbrella'                            => 'umbrella',
        'far fa-umbrella-beach'                      => 'umbrella-beach',
        'far fa-underline'                           => 'underline',
        'far fa-undo'                                => 'undo',
        'far fa-undo-alt'                            => 'undo-alt',
        'far fa-unicorn'                             => 'unicorn',
        'far fa-union'                               => 'union',
        'far fa-universal-access'                    => 'universal-access',
        'far fa-university'                          => 'university',
        'far fa-unlink'                              => 'unlink',
        'far fa-unlock'                              => 'unlock',
        'far fa-unlock-alt'                          => 'unlock-alt',
        'far fa-upload'                              => 'upload',
        'far fa-usd-circle'                          => 'usd-circle',
        'far fa-usd-square'                          => 'usd-square',
        'far fa-user'                                => 'user',
        'far fa-user-alt'                            => 'user-alt',
        'far fa-user-alt-slash'                      => 'user-alt-slash',
        'far fa-user-astronaut'                      => 'user-astronaut',
        'far fa-user-chart'                          => 'user-chart',
        'far fa-user-check'                          => 'user-check',
        'far fa-user-circle'                         => 'user-circle',
        'far fa-user-clock'                          => 'user-clock',
        'far fa-user-cog'                            => 'user-cog',
        'far fa-user-crown'                          => 'user-crown',
        'far fa-user-edit'                           => 'user-edit',
        'far fa-user-friends'                        => 'user-friends',
        'far fa-user-graduate'                       => 'user-graduate',
        'far fa-user-hard-hat'                       => 'user-hard-hat',
        'far fa-user-headset'                        => 'user-headset',
        'far fa-user-injured'                        => 'user-injured',
        'far fa-user-lock'                           => 'user-lock',
        'far fa-user-md'                             => 'user-md',
        'far fa-user-md-chat'                        => 'user-md-chat',
        'far fa-user-minus'                          => 'user-minus',
        'far fa-user-ninja'                          => 'user-ninja',
        'far fa-user-nurse'                          => 'user-nurse',
        'far fa-user-plus'                           => 'user-plus',
        'far fa-user-secret'                         => 'user-secret',
        'far fa-user-shield'                         => 'user-shield',
        'far fa-user-slash'                          => 'user-slash',
        'far fa-user-tag'                            => 'user-tag',
        'far fa-user-tie'                            => 'user-tie',
        'far fa-user-times'                          => 'user-times',
        'far fa-users'                               => 'users',
        'far fa-users-class'                         => 'users-class',
        'far fa-users-cog'                           => 'users-cog',
        'far fa-users-crown'                         => 'users-crown',
        'far fa-users-medical'                       => 'users-medical',
        'far fa-utensil-fork'                        => 'utensil-fork',
        'far fa-utensil-knife'                       => 'utensil-knife',
        'far fa-utensil-spoon'                       => 'utensil-spoon',
        'far fa-utensils'                            => 'utensils',
        'far fa-utensils-alt'                        => 'utensils-alt',
        'far fa-value-absolute'                      => 'value-absolute',
        'far fa-vector-square'                       => 'vector-square',
        'far fa-venus'                               => 'venus',
        'far fa-venus-double'                        => 'venus-double',
        'far fa-venus-mars'                          => 'venus-mars',
        'far fa-vial'                                => 'vial',
        'far fa-vials'                               => 'vials',
        'far fa-video'                               => 'video',
        'far fa-video-plus'                          => 'video-plus',
        'far fa-video-slash'                         => 'video-slash',
        'far fa-vihara'                              => 'vihara',
        'far fa-voicemail'                           => 'voicemail',
        'far fa-volcano'                             => 'volcano',
        'far fa-volleyball-ball'                     => 'volleyball-ball',
        'far fa-volume'                              => 'volume',
        'far fa-volume-down'                         => 'volume-down',
        'far fa-volume-mute'                         => 'volume-mute',
        'far fa-volume-off'                          => 'volume-off',
        'far fa-volume-slash'                        => 'volume-slash',
        'far fa-volume-up'                           => 'volume-up',
        'far fa-vote-nay'                            => 'vote-nay',
        'far fa-vote-yea'                            => 'vote-yea',
        'far fa-vr-cardboard'                        => 'vr-cardboard',
        'far fa-walker'                              => 'walker',
        'far fa-walking'                             => 'walking',
        'far fa-wallet'                              => 'wallet',
        'far fa-wand'                                => 'wand',
        'far fa-wand-magic'                          => 'wand-magic',
        'far fa-warehouse'                           => 'warehouse',
        'far fa-warehouse-alt'                       => 'warehouse-alt',
        'far fa-washer'                              => 'washer',
        'far fa-watch'                               => 'watch',
        'far fa-watch-fitness'                       => 'watch-fitness',
        'far fa-water'                               => 'water',
        'far fa-water-lower'                         => 'water-lower',
        'far fa-water-rise'                          => 'water-rise',
        'far fa-wave-sine'                           => 'wave-sine',
        'far fa-wave-square'                         => 'wave-square',
        'far fa-wave-triangle'                       => 'wave-triangle',
        'far fa-webcam'                              => 'webcam',
        'far fa-webcam-slash'                        => 'webcam-slash',
        'far fa-weight'                              => 'weight',
        'far fa-weight-hanging'                      => 'weight-hanging',
        'far fa-whale'                               => 'whale',
        'far fa-wheat'                               => 'wheat',
        'far fa-wheelchair'                          => 'wheelchair',
        'far fa-whistle'                             => 'whistle',
        'far fa-wifi'                                => 'wifi',
        'far fa-wifi-1'                              => 'wifi-1',
        'far fa-wifi-2'                              => 'wifi-2',
        'far fa-wifi-slash'                          => 'wifi-slash',
        'far fa-wind'                                => 'wind',
        'far fa-wind-turbine'                        => 'wind-turbine',
        'far fa-wind-warning'                        => 'wind-warning',
        'far fa-window'                              => 'window',
        'far fa-window-alt'                          => 'window-alt',
        'far fa-window-close'                        => 'window-close',
        'far fa-window-maximize'                     => 'window-maximize',
        'far fa-window-minimize'                     => 'window-minimize',
        'far fa-window-restore'                      => 'window-restore',
        'far fa-windsock'                            => 'windsock',
        'far fa-wine-bottle'                         => 'wine-bottle',
        'far fa-wine-glass'                          => 'wine-glass',
        'far fa-wine-glass-alt'                      => 'wine-glass-alt',
        'far fa-won-sign'                            => 'won-sign',
        'far fa-wreath'                              => 'wreath',
        'far fa-wrench'                              => 'wrench',
        'far fa-x-ray'                               => 'x-ray',
        'far fa-yen-sign'                            => 'yen-sign',
        'far fa-yin-yang'                            => 'yin-yang',
        'fas fa-abacus'                              => 'abacus',
        'fas fa-acorn'                               => 'acorn',
        'fas fa-ad'                                  => 'ad',
        'fas fa-address-book'                        => 'address-book',
        'fas fa-address-card'                        => 'address-card',
        'fas fa-adjust'                              => 'adjust',
        'fas fa-air-freshener'                       => 'air-freshener',
        'fas fa-alarm-clock'                         => 'alarm-clock',
        'fas fa-alarm-exclamation'                   => 'alarm-exclamation',
        'fas fa-alarm-plus'                          => 'alarm-plus',
        'fas fa-alarm-snooze'                        => 'alarm-snooze',
        'fas fa-alicorn'                             => 'alicorn',
        'fas fa-align-center'                        => 'align-center',
        'fas fa-align-justify'                       => 'align-justify',
        'fas fa-align-left'                          => 'align-left',
        'fas fa-align-right'                         => 'align-right',
        'fas fa-align-slash'                         => 'align-slash',
        'fas fa-allergies'                           => 'allergies',
        'fas fa-ambulance'                           => 'ambulance',
        'fas fa-american-sign-language-interpreting' => 'american-sign-language-interpreting',
        'fas fa-analytics'                           => 'analytics',
        'fas fa-anchor'                              => 'anchor',
        'fas fa-angel'                               => 'angel',
        'fas fa-angle-double-down'                   => 'angle-double-down',
        'fas fa-angle-double-left'                   => 'angle-double-left',
        'fas fa-angle-double-right'                  => 'angle-double-right',
        'fas fa-angle-double-up'                     => 'angle-double-up',
        'fas fa-angle-down'                          => 'angle-down',
        'fas fa-angle-left'                          => 'angle-left',
        'fas fa-angle-right'                         => 'angle-right',
        'fas fa-angle-up'                            => 'angle-up',
        'fas fa-angry'                               => 'angry',
        'fas fa-ankh'                                => 'ankh',
        'fas fa-apple-alt'                           => 'apple-alt',
        'fas fa-apple-crate'                         => 'apple-crate',
        'fas fa-archive'                             => 'archive',
        'fas fa-archway'                             => 'archway',
        'fas fa-arrow-alt-circle-down'               => 'arrow-alt-circle-down',
        'fas fa-arrow-alt-circle-left'               => 'arrow-alt-circle-left',
        'fas fa-arrow-alt-circle-right'              => 'arrow-alt-circle-right',
        'fas fa-arrow-alt-circle-up'                 => 'arrow-alt-circle-up',
        'fas fa-arrow-alt-down'                      => 'arrow-alt-down',
        'fas fa-arrow-alt-from-bottom'               => 'arrow-alt-from-bottom',
        'fas fa-arrow-alt-from-left'                 => 'arrow-alt-from-left',
        'fas fa-arrow-alt-from-right'                => 'arrow-alt-from-right',
        'fas fa-arrow-alt-from-top'                  => 'arrow-alt-from-top',
        'fas fa-arrow-alt-left'                      => 'arrow-alt-left',
        'fas fa-arrow-alt-right'                     => 'arrow-alt-right',
        'fas fa-arrow-alt-square-down'               => 'arrow-alt-square-down',
        'fas fa-arrow-alt-square-left'               => 'arrow-alt-square-left',
        'fas fa-arrow-alt-square-right'              => 'arrow-alt-square-right',
        'fas fa-arrow-alt-square-up'                 => 'arrow-alt-square-up',
        'fas fa-arrow-alt-to-bottom'                 => 'arrow-alt-to-bottom',
        'fas fa-arrow-alt-to-left'                   => 'arrow-alt-to-left',
        'fas fa-arrow-alt-to-right'                  => 'arrow-alt-to-right',
        'fas fa-arrow-alt-to-top'                    => 'arrow-alt-to-top',
        'fas fa-arrow-alt-up'                        => 'arrow-alt-up',
        'fas fa-arrow-circle-down'                   => 'arrow-circle-down',
        'fas fa-arrow-circle-left'                   => 'arrow-circle-left',
        'fas fa-arrow-circle-right'                  => 'arrow-circle-right',
        'fas fa-arrow-circle-up'                     => 'arrow-circle-up',
        'fas fa-arrow-down'                          => 'arrow-down',
        'fas fa-arrow-from-bottom'                   => 'arrow-from-bottom',
        'fas fa-arrow-from-left'                     => 'arrow-from-left',
        'fas fa-arrow-from-right'                    => 'arrow-from-right',
        'fas fa-arrow-from-top'                      => 'arrow-from-top',
        'fas fa-arrow-left'                          => 'arrow-left',
        'fas fa-arrow-right'                         => 'arrow-right',
        'fas fa-arrow-square-down'                   => 'arrow-square-down',
        'fas fa-arrow-square-left'                   => 'arrow-square-left',
        'fas fa-arrow-square-right'                  => 'arrow-square-right',
        'fas fa-arrow-square-up'                     => 'arrow-square-up',
        'fas fa-arrow-to-bottom'                     => 'arrow-to-bottom',
        'fas fa-arrow-to-left'                       => 'arrow-to-left',
        'fas fa-arrow-to-right'                      => 'arrow-to-right',
        'fas fa-arrow-to-top'                        => 'arrow-to-top',
        'fas fa-arrow-up'                            => 'arrow-up',
        'fas fa-arrows'                              => 'arrows',
        'fas fa-arrows-alt'                          => 'arrows-alt',
        'fas fa-arrows-alt-h'                        => 'arrows-alt-h',
        'fas fa-arrows-alt-v'                        => 'arrows-alt-v',
        'fas fa-arrows-h'                            => 'arrows-h',
        'fas fa-arrows-v'                            => 'arrows-v',
        'fas fa-assistive-listening-systems'         => 'assistive-listening-systems',
        'fas fa-asterisk'                            => 'asterisk',
        'fas fa-at'                                  => 'at',
        'fas fa-atlas'                               => 'atlas',
        'fas fa-atom'                                => 'atom',
        'fas fa-atom-alt'                            => 'atom-alt',
        'fas fa-audio-description'                   => 'audio-description',
        'fas fa-award'                               => 'award',
        'fas fa-axe'                                 => 'axe',
        'fas fa-axe-battle'                          => 'axe-battle',
        'fas fa-baby'                                => 'baby',
        'fas fa-baby-carriage'                       => 'baby-carriage',
        'fas fa-backpack'                            => 'backpack',
        'fas fa-backspace'                           => 'backspace',
        'fas fa-backward'                            => 'backward',
        'fas fa-bacon'                               => 'bacon',
        'fas fa-badge'                               => 'badge',
        'fas fa-badge-check'                         => 'badge-check',
        'fas fa-badge-dollar'                        => 'badge-dollar',
        'fas fa-badge-percent'                       => 'badge-percent',
        'fas fa-badger-honey'                        => 'badger-honey',
        'fas fa-bags-shopping'                       => 'bags-shopping',
        'fas fa-balance-scale'                       => 'balance-scale',
        'fas fa-balance-scale-left'                  => 'balance-scale-left',
        'fas fa-balance-scale-right'                 => 'balance-scale-right',
        'fas fa-ball-pile'                           => 'ball-pile',
        'fas fa-ballot'                              => 'ballot',
        'fas fa-ballot-check'                        => 'ballot-check',
        'fas fa-ban'                                 => 'ban',
        'fas fa-band-aid'                            => 'band-aid',
        'fas fa-barcode'                             => 'barcode',
        'fas fa-barcode-alt'                         => 'barcode-alt',
        'fas fa-barcode-read'                        => 'barcode-read',
        'fas fa-barcode-scan'                        => 'barcode-scan',
        'fas fa-bars'                                => 'bars',
        'fas fa-baseball'                            => 'baseball',
        'fas fa-baseball-ball'                       => 'baseball-ball',
        'fas fa-basketball-ball'                     => 'basketball-ball',
        'fas fa-basketball-hoop'                     => 'basketball-hoop',
        'fas fa-bat'                                 => 'bat',
        'fas fa-bath'                                => 'bath',
        'fas fa-battery-bolt'                        => 'battery-bolt',
        'fas fa-battery-empty'                       => 'battery-empty',
        'fas fa-battery-full'                        => 'battery-full',
        'fas fa-battery-half'                        => 'battery-half',
        'fas fa-battery-quarter'                     => 'battery-quarter',
        'fas fa-battery-slash'                       => 'battery-slash',
        'fas fa-battery-three-quarters'              => 'battery-three-quarters',
        'fas fa-bed'                                 => 'bed',
        'fas fa-beer'                                => 'beer',
        'fas fa-bell'                                => 'bell',
        'fas fa-bell-exclamation'                    => 'bell-exclamation',
        'fas fa-bell-plus'                           => 'bell-plus',
        'fas fa-bell-school'                         => 'bell-school',
        'fas fa-bell-school-slash'                   => 'bell-school-slash',
        'fas fa-bell-slash'                          => 'bell-slash',
        'fas fa-bells'                               => 'bells',
        'fas fa-bezier-curve'                        => 'bezier-curve',
        'fas fa-bible'                               => 'bible',
        'fas fa-bicycle'                             => 'bicycle',
        'fas fa-biking'                              => 'biking',
        'fas fa-biking-mountain'                     => 'biking-mountain',
        'fas fa-binoculars'                          => 'binoculars',
        'fas fa-biohazard'                           => 'biohazard',
        'fas fa-birthday-cake'                       => 'birthday-cake',
        'fas fa-blanket'                             => 'blanket',
        'fas fa-blender'                             => 'blender',
        'fas fa-blender-phone'                       => 'blender-phone',
        'fas fa-blind'                               => 'blind',
        'fas fa-blog'                                => 'blog',
        'fas fa-bold'                                => 'bold',
        'fas fa-bolt'                                => 'bolt',
        'fas fa-bomb'                                => 'bomb',
        'fas fa-bone'                                => 'bone',
        'fas fa-bone-break'                          => 'bone-break',
        'fas fa-bong'                                => 'bong',
        'fas fa-book'                                => 'book',
        'fas fa-book-alt'                            => 'book-alt',
        'fas fa-book-dead'                           => 'book-dead',
        'fas fa-book-heart'                          => 'book-heart',
        'fas fa-book-medical'                        => 'book-medical',
        'fas fa-book-open'                           => 'book-open',
        'fas fa-book-reader'                         => 'book-reader',
        'fas fa-book-spells'                         => 'book-spells',
        'fas fa-book-user'                           => 'book-user',
        'fas fa-bookmark'                            => 'bookmark',
        'fas fa-books'                               => 'books',
        'fas fa-books-medical'                       => 'books-medical',
        'fas fa-boot'                                => 'boot',
        'fas fa-booth-curtain'                       => 'booth-curtain',
        'fas fa-border-all'                          => 'border-all',
        'fas fa-border-bottom'                       => 'border-bottom',
        'fas fa-border-center-h'                     => 'border-center-h',
        'fas fa-border-center-v'                     => 'border-center-v',
        'fas fa-border-inner'                        => 'border-inner',
        'fas fa-border-left'                         => 'border-left',
        'fas fa-border-none'                         => 'border-none',
        'fas fa-border-outer'                        => 'border-outer',
        'fas fa-border-right'                        => 'border-right',
        'fas fa-border-style'                        => 'border-style',
        'fas fa-border-style-alt'                    => 'border-style-alt',
        'fas fa-border-top'                          => 'border-top',
        'fas fa-bow-arrow'                           => 'bow-arrow',
        'fas fa-bowling-ball'                        => 'bowling-ball',
        'fas fa-bowling-pins'                        => 'bowling-pins',
        'fas fa-box'                                 => 'box',
        'fas fa-box-alt'                             => 'box-alt',
        'fas fa-box-ballot'                          => 'box-ballot',
        'fas fa-box-check'                           => 'box-check',
        'fas fa-box-fragile'                         => 'box-fragile',
        'fas fa-box-full'                            => 'box-full',
        'fas fa-box-heart'                           => 'box-heart',
        'fas fa-box-open'                            => 'box-open',
        'fas fa-box-up'                              => 'box-up',
        'fas fa-box-usd'                             => 'box-usd',
        'fas fa-boxes'                               => 'boxes',
        'fas fa-boxes-alt'                           => 'boxes-alt',
        'fas fa-boxing-glove'                        => 'boxing-glove',
        'fas fa-brackets'                            => 'brackets',
        'fas fa-brackets-curly'                      => 'brackets-curly',
        'fas fa-braille'                             => 'braille',
        'fas fa-brain'                               => 'brain',
        'fas fa-bread-loaf'                          => 'bread-loaf',
        'fas fa-bread-slice'                         => 'bread-slice',
        'fas fa-briefcase'                           => 'briefcase',
        'fas fa-briefcase-medical'                   => 'briefcase-medical',
        'fas fa-bring-forward'                       => 'bring-forward',
        'fas fa-bring-front'                         => 'bring-front',
        'fas fa-broadcast-tower'                     => 'broadcast-tower',
        'fas fa-broom'                               => 'broom',
        'fas fa-browser'                             => 'browser',
        'fas fa-brush'                               => 'brush',
        'fas fa-bug'                                 => 'bug',
        'fas fa-building'                            => 'building',
        'fas fa-bullhorn'                            => 'bullhorn',
        'fas fa-bullseye'                            => 'bullseye',
        'fas fa-bullseye-arrow'                      => 'bullseye-arrow',
        'fas fa-bullseye-pointer'                    => 'bullseye-pointer',
        'fas fa-burger-soda'                         => 'burger-soda',
        'fas fa-burn'                                => 'burn',
        'fas fa-burrito'                             => 'burrito',
        'fas fa-bus'                                 => 'bus',
        'fas fa-bus-alt'                             => 'bus-alt',
        'fas fa-bus-school'                          => 'bus-school',
        'fas fa-business-time'                       => 'business-time',
        'fas fa-cabinet-filing'                      => 'cabinet-filing',
        'fas fa-calculator'                          => 'calculator',
        'fas fa-calculator-alt'                      => 'calculator-alt',
        'fas fa-calendar'                            => 'calendar',
        'fas fa-calendar-alt'                        => 'calendar-alt',
        'fas fa-calendar-check'                      => 'calendar-check',
        'fas fa-calendar-day'                        => 'calendar-day',
        'fas fa-calendar-edit'                       => 'calendar-edit',
        'fas fa-calendar-exclamation'                => 'calendar-exclamation',
        'fas fa-calendar-minus'                      => 'calendar-minus',
        'fas fa-calendar-plus'                       => 'calendar-plus',
        'fas fa-calendar-star'                       => 'calendar-star',
        'fas fa-calendar-times'                      => 'calendar-times',
        'fas fa-calendar-week'                       => 'calendar-week',
        'fas fa-camera'                              => 'camera',
        'fas fa-camera-alt'                          => 'camera-alt',
        'fas fa-camera-retro'                        => 'camera-retro',
        'fas fa-campfire'                            => 'campfire',
        'fas fa-campground'                          => 'campground',
        'fas fa-candle-holder'                       => 'candle-holder',
        'fas fa-candy-cane'                          => 'candy-cane',
        'fas fa-candy-corn'                          => 'candy-corn',
        'fas fa-cannabis'                            => 'cannabis',
        'fas fa-capsules'                            => 'capsules',
        'fas fa-car'                                 => 'car',
        'fas fa-car-alt'                             => 'car-alt',
        'fas fa-car-battery'                         => 'car-battery',
        'fas fa-car-building'                        => 'car-building',
        'fas fa-car-bump'                            => 'car-bump',
        'fas fa-car-bus'                             => 'car-bus',
        'fas fa-car-crash'                           => 'car-crash',
        'fas fa-car-garage'                          => 'car-garage',
        'fas fa-car-mechanic'                        => 'car-mechanic',
        'fas fa-car-side'                            => 'car-side',
        'fas fa-car-tilt'                            => 'car-tilt',
        'fas fa-car-wash'                            => 'car-wash',
        'fas fa-caret-circle-down'                   => 'caret-circle-down',
        'fas fa-caret-circle-left'                   => 'caret-circle-left',
        'fas fa-caret-circle-right'                  => 'caret-circle-right',
        'fas fa-caret-circle-up'                     => 'caret-circle-up',
        'fas fa-caret-down'                          => 'caret-down',
        'fas fa-caret-left'                          => 'caret-left',
        'fas fa-caret-right'                         => 'caret-right',
        'fas fa-caret-square-down'                   => 'caret-square-down',
        'fas fa-caret-square-left'                   => 'caret-square-left',
        'fas fa-caret-square-right'                  => 'caret-square-right',
        'fas fa-caret-square-up'                     => 'caret-square-up',
        'fas fa-caret-up'                            => 'caret-up',
        'fas fa-carrot'                              => 'carrot',
        'fas fa-cars'                                => 'cars',
        'fas fa-cart-arrow-down'                     => 'cart-arrow-down',
        'fas fa-cart-plus'                           => 'cart-plus',
        'fas fa-cash-register'                       => 'cash-register',
        'fas fa-cat'                                 => 'cat',
        'fas fa-cauldron'                            => 'cauldron',
        'fas fa-certificate'                         => 'certificate',
        'fas fa-chair'                               => 'chair',
        'fas fa-chair-office'                        => 'chair-office',
        'fas fa-chalkboard'                          => 'chalkboard',
        'fas fa-chalkboard-teacher'                  => 'chalkboard-teacher',
        'fas fa-charging-station'                    => 'charging-station',
        'fas fa-chart-area'                          => 'chart-area',
        'fas fa-chart-bar'                           => 'chart-bar',
        'fas fa-chart-line'                          => 'chart-line',
        'fas fa-chart-line-down'                     => 'chart-line-down',
        'fas fa-chart-network'                       => 'chart-network',
        'fas fa-chart-pie'                           => 'chart-pie',
        'fas fa-chart-pie-alt'                       => 'chart-pie-alt',
        'fas fa-chart-scatter'                       => 'chart-scatter',
        'fas fa-check'                               => 'check',
        'fas fa-check-circle'                        => 'check-circle',
        'fas fa-check-double'                        => 'check-double',
        'fas fa-check-square'                        => 'check-square',
        'fas fa-cheese'                              => 'cheese',
        'fas fa-cheese-swiss'                        => 'cheese-swiss',
        'fas fa-cheeseburger'                        => 'cheeseburger',
        'fas fa-chess'                               => 'chess',
        'fas fa-chess-bishop'                        => 'chess-bishop',
        'fas fa-chess-bishop-alt'                    => 'chess-bishop-alt',
        'fas fa-chess-board'                         => 'chess-board',
        'fas fa-chess-clock'                         => 'chess-clock',
        'fas fa-chess-clock-alt'                     => 'chess-clock-alt',
        'fas fa-chess-king'                          => 'chess-king',
        'fas fa-chess-king-alt'                      => 'chess-king-alt',
        'fas fa-chess-knight'                        => 'chess-knight',
        'fas fa-chess-knight-alt'                    => 'chess-knight-alt',
        'fas fa-chess-pawn'                          => 'chess-pawn',
        'fas fa-chess-pawn-alt'                      => 'chess-pawn-alt',
        'fas fa-chess-queen'                         => 'chess-queen',
        'fas fa-chess-queen-alt'                     => 'chess-queen-alt',
        'fas fa-chess-rook'                          => 'chess-rook',
        'fas fa-chess-rook-alt'                      => 'chess-rook-alt',
        'fas fa-chevron-circle-down'                 => 'chevron-circle-down',
        'fas fa-chevron-circle-left'                 => 'chevron-circle-left',
        'fas fa-chevron-circle-right'                => 'chevron-circle-right',
        'fas fa-chevron-circle-up'                   => 'chevron-circle-up',
        'fas fa-chevron-double-down'                 => 'chevron-double-down',
        'fas fa-chevron-double-left'                 => 'chevron-double-left',
        'fas fa-chevron-double-right'                => 'chevron-double-right',
        'fas fa-chevron-double-up'                   => 'chevron-double-up',
        'fas fa-chevron-down'                        => 'chevron-down',
        'fas fa-chevron-left'                        => 'chevron-left',
        'fas fa-chevron-right'                       => 'chevron-right',
        'fas fa-chevron-square-down'                 => 'chevron-square-down',
        'fas fa-chevron-square-left'                 => 'chevron-square-left',
        'fas fa-chevron-square-right'                => 'chevron-square-right',
        'fas fa-chevron-square-up'                   => 'chevron-square-up',
        'fas fa-chevron-up'                          => 'chevron-up',
        'fas fa-child'                               => 'child',
        'fas fa-chimney'                             => 'chimney',
        'fas fa-church'                              => 'church',
        'fas fa-circle'                              => 'circle',
        'fas fa-circle-notch'                        => 'circle-notch',
        'fas fa-city'                                => 'city',
        'fas fa-claw-marks'                          => 'claw-marks',
        'fas fa-clinic-medical'                      => 'clinic-medical',
        'fas fa-clipboard'                           => 'clipboard',
        'fas fa-clipboard-check'                     => 'clipboard-check',
        'fas fa-clipboard-list'                      => 'clipboard-list',
        'fas fa-clipboard-list-check'                => 'clipboard-list-check',
        'fas fa-clipboard-prescription'              => 'clipboard-prescription',
        'fas fa-clipboard-user'                      => 'clipboard-user',
        'fas fa-clock'                               => 'clock',
        'fas fa-clone'                               => 'clone',
        'fas fa-closed-captioning'                   => 'closed-captioning',
        'fas fa-cloud'                               => 'cloud',
        'fas fa-cloud-download'                      => 'cloud-download',
        'fas fa-cloud-download-alt'                  => 'cloud-download-alt',
        'fas fa-cloud-drizzle'                       => 'cloud-drizzle',
        'fas fa-cloud-hail'                          => 'cloud-hail',
        'fas fa-cloud-hail-mixed'                    => 'cloud-hail-mixed',
        'fas fa-cloud-meatball'                      => 'cloud-meatball',
        'fas fa-cloud-moon'                          => 'cloud-moon',
        'fas fa-cloud-moon-rain'                     => 'cloud-moon-rain',
        'fas fa-cloud-rain'                          => 'cloud-rain',
        'fas fa-cloud-rainbow'                       => 'cloud-rainbow',
        'fas fa-cloud-showers'                       => 'cloud-showers',
        'fas fa-cloud-showers-heavy'                 => 'cloud-showers-heavy',
        'fas fa-cloud-sleet'                         => 'cloud-sleet',
        'fas fa-cloud-snow'                          => 'cloud-snow',
        'fas fa-cloud-sun'                           => 'cloud-sun',
        'fas fa-cloud-sun-rain'                      => 'cloud-sun-rain',
        'fas fa-cloud-upload'                        => 'cloud-upload',
        'fas fa-cloud-upload-alt'                    => 'cloud-upload-alt',
        'fas fa-clouds'                              => 'clouds',
        'fas fa-clouds-moon'                         => 'clouds-moon',
        'fas fa-clouds-sun'                          => 'clouds-sun',
        'fas fa-club'                                => 'club',
        'fas fa-cocktail'                            => 'cocktail',
        'fas fa-code'                                => 'code',
        'fas fa-code-branch'                         => 'code-branch',
        'fas fa-code-commit'                         => 'code-commit',
        'fas fa-code-merge'                          => 'code-merge',
        'fas fa-coffee'                              => 'coffee',
        'fas fa-coffee-togo'                         => 'coffee-togo',
        'fas fa-coffin'                              => 'coffin',
        'fas fa-cog'                                 => 'cog',
        'fas fa-cogs'                                => 'cogs',
        'fas fa-coin'                                => 'coin',
        'fas fa-coins'                               => 'coins',
        'fas fa-columns'                             => 'columns',
        'fas fa-comment'                             => 'comment',
        'fas fa-comment-alt'                         => 'comment-alt',
        'fas fa-comment-alt-check'                   => 'comment-alt-check',
        'fas fa-comment-alt-dollar'                  => 'comment-alt-dollar',
        'fas fa-comment-alt-dots'                    => 'comment-alt-dots',
        'fas fa-comment-alt-edit'                    => 'comment-alt-edit',
        'fas fa-comment-alt-exclamation'             => 'comment-alt-exclamation',
        'fas fa-comment-alt-lines'                   => 'comment-alt-lines',
        'fas fa-comment-alt-medical'                 => 'comment-alt-medical',
        'fas fa-comment-alt-minus'                   => 'comment-alt-minus',
        'fas fa-comment-alt-plus'                    => 'comment-alt-plus',
        'fas fa-comment-alt-slash'                   => 'comment-alt-slash',
        'fas fa-comment-alt-smile'                   => 'comment-alt-smile',
        'fas fa-comment-alt-times'                   => 'comment-alt-times',
        'fas fa-comment-check'                       => 'comment-check',
        'fas fa-comment-dollar'                      => 'comment-dollar',
        'fas fa-comment-dots'                        => 'comment-dots',
        'fas fa-comment-edit'                        => 'comment-edit',
        'fas fa-comment-exclamation'                 => 'comment-exclamation',
        'fas fa-comment-lines'                       => 'comment-lines',
        'fas fa-comment-medical'                     => 'comment-medical',
        'fas fa-comment-minus'                       => 'comment-minus',
        'fas fa-comment-plus'                        => 'comment-plus',
        'fas fa-comment-slash'                       => 'comment-slash',
        'fas fa-comment-smile'                       => 'comment-smile',
        'fas fa-comment-times'                       => 'comment-times',
        'fas fa-comments'                            => 'comments',
        'fas fa-comments-alt'                        => 'comments-alt',
        'fas fa-comments-alt-dollar'                 => 'comments-alt-dollar',
        'fas fa-comments-dollar'                     => 'comments-dollar',
        'fas fa-compact-disc'                        => 'compact-disc',
        'fas fa-compass'                             => 'compass',
        'fas fa-compass-slash'                       => 'compass-slash',
        'fas fa-compress'                            => 'compress',
        'fas fa-compress-alt'                        => 'compress-alt',
        'fas fa-compress-arrows-alt'                 => 'compress-arrows-alt',
        'fas fa-compress-wide'                       => 'compress-wide',
        'fas fa-concierge-bell'                      => 'concierge-bell',
        'fas fa-construction'                        => 'construction',
        'fas fa-container-storage'                   => 'container-storage',
        'fas fa-conveyor-belt'                       => 'conveyor-belt',
        'fas fa-conveyor-belt-alt'                   => 'conveyor-belt-alt',
        'fas fa-cookie'                              => 'cookie',
        'fas fa-cookie-bite'                         => 'cookie-bite',
        'fas fa-copy'                                => 'copy',
        'fas fa-copyright'                           => 'copyright',
        'fas fa-corn'                                => 'corn',
        'fas fa-couch'                               => 'couch',
        'fas fa-cow'                                 => 'cow',
        'fas fa-credit-card'                         => 'credit-card',
        'fas fa-credit-card-blank'                   => 'credit-card-blank',
        'fas fa-credit-card-front'                   => 'credit-card-front',
        'fas fa-cricket'                             => 'cricket',
        'fas fa-croissant'                           => 'croissant',
        'fas fa-crop'                                => 'crop',
        'fas fa-crop-alt'                            => 'crop-alt',
        'fas fa-cross'                               => 'cross',
        'fas fa-crosshairs'                          => 'crosshairs',
        'fas fa-crow'                                => 'crow',
        'fas fa-crown'                               => 'crown',
        'fas fa-crutch'                              => 'crutch',
        'fas fa-crutches'                            => 'crutches',
        'fas fa-cube'                                => 'cube',
        'fas fa-cubes'                               => 'cubes',
        'fas fa-curling'                             => 'curling',
        'fas fa-cut'                                 => 'cut',
        'fas fa-dagger'                              => 'dagger',
        'fas fa-database'                            => 'database',
        'fas fa-deaf'                                => 'deaf',
        'fas fa-debug'                               => 'debug',
        'fas fa-deer'                                => 'deer',
        'fas fa-deer-rudolph'                        => 'deer-rudolph',
        'fas fa-democrat'                            => 'democrat',
        'fas fa-desktop'                             => 'desktop',
        'fas fa-desktop-alt'                         => 'desktop-alt',
        'fas fa-dewpoint'                            => 'dewpoint',
        'fas fa-dharmachakra'                        => 'dharmachakra',
        'fas fa-diagnoses'                           => 'diagnoses',
        'fas fa-diamond'                             => 'diamond',
        'fas fa-dice'                                => 'dice',
        'fas fa-dice-d10'                            => 'dice-d10',
        'fas fa-dice-d12'                            => 'dice-d12',
        'fas fa-dice-d20'                            => 'dice-d20',
        'fas fa-dice-d4'                             => 'dice-d4',
        'fas fa-dice-d6'                             => 'dice-d6',
        'fas fa-dice-d8'                             => 'dice-d8',
        'fas fa-dice-five'                           => 'dice-five',
        'fas fa-dice-four'                           => 'dice-four',
        'fas fa-dice-one'                            => 'dice-one',
        'fas fa-dice-six'                            => 'dice-six',
        'fas fa-dice-three'                          => 'dice-three',
        'fas fa-dice-two'                            => 'dice-two',
        'fas fa-digging'                             => 'digging',
        'fas fa-digital-tachograph'                  => 'digital-tachograph',
        'fas fa-diploma'                             => 'diploma',
        'fas fa-directions'                          => 'directions',
        'fas fa-disease'                             => 'disease',
        'fas fa-divide'                              => 'divide',
        'fas fa-dizzy'                               => 'dizzy',
        'fas fa-dna'                                 => 'dna',
        'fas fa-do-not-enter'                        => 'do-not-enter',
        'fas fa-dog'                                 => 'dog',
        'fas fa-dog-leashed'                         => 'dog-leashed',
        'fas fa-dollar-sign'                         => 'dollar-sign',
        'fas fa-dolly'                               => 'dolly',
        'fas fa-dolly-empty'                         => 'dolly-empty',
        'fas fa-dolly-flatbed'                       => 'dolly-flatbed',
        'fas fa-dolly-flatbed-alt'                   => 'dolly-flatbed-alt',
        'fas fa-dolly-flatbed-empty'                 => 'dolly-flatbed-empty',
        'fas fa-donate'                              => 'donate',
        'fas fa-door-closed'                         => 'door-closed',
        'fas fa-door-open'                           => 'door-open',
        'fas fa-dot-circle'                          => 'dot-circle',
        'fas fa-dove'                                => 'dove',
        'fas fa-download'                            => 'download',
        'fas fa-drafting-compass'                    => 'drafting-compass',
        'fas fa-dragon'                              => 'dragon',
        'fas fa-draw-circle'                         => 'draw-circle',
        'fas fa-draw-polygon'                        => 'draw-polygon',
        'fas fa-draw-square'                         => 'draw-square',
        'fas fa-dreidel'                             => 'dreidel',
        'fas fa-drone'                               => 'drone',
        'fas fa-drone-alt'                           => 'drone-alt',
        'fas fa-drum'                                => 'drum',
        'fas fa-drum-steelpan'                       => 'drum-steelpan',
        'fas fa-drumstick'                           => 'drumstick',
        'fas fa-drumstick-bite'                      => 'drumstick-bite',
        'fas fa-dryer'                               => 'dryer',
        'fas fa-dryer-alt'                           => 'dryer-alt',
        'fas fa-duck'                                => 'duck',
        'fas fa-dumbbell'                            => 'dumbbell',
        'fas fa-dumpster'                            => 'dumpster',
        'fas fa-dumpster-fire'                       => 'dumpster-fire',
        'fas fa-dungeon'                             => 'dungeon',
        'fas fa-ear'                                 => 'ear',
        'fas fa-ear-muffs'                           => 'ear-muffs',
        'fas fa-eclipse'                             => 'eclipse',
        'fas fa-eclipse-alt'                         => 'eclipse-alt',
        'fas fa-edit'                                => 'edit',
        'fas fa-egg'                                 => 'egg',
        'fas fa-egg-fried'                           => 'egg-fried',
        'fas fa-eject'                               => 'eject',
        'fas fa-elephant'                            => 'elephant',
        'fas fa-ellipsis-h'                          => 'ellipsis-h',
        'fas fa-ellipsis-h-alt'                      => 'ellipsis-h-alt',
        'fas fa-ellipsis-v'                          => 'ellipsis-v',
        'fas fa-ellipsis-v-alt'                      => 'ellipsis-v-alt',
        'fas fa-empty-set'                           => 'empty-set',
        'fas fa-engine-warning'                      => 'engine-warning',
        'fas fa-envelope'                            => 'envelope',
        'fas fa-envelope-open'                       => 'envelope-open',
        'fas fa-envelope-open-dollar'                => 'envelope-open-dollar',
        'fas fa-envelope-open-text'                  => 'envelope-open-text',
        'fas fa-envelope-square'                     => 'envelope-square',
        'fas fa-equals'                              => 'equals',
        'fas fa-eraser'                              => 'eraser',
        'fas fa-ethernet'                            => 'ethernet',
        'fas fa-euro-sign'                           => 'euro-sign',
        'fas fa-exchange'                            => 'exchange',
        'fas fa-exchange-alt'                        => 'exchange-alt',
        'fas fa-exclamation'                         => 'exclamation',
        'fas fa-exclamation-circle'                  => 'exclamation-circle',
        'fas fa-exclamation-square'                  => 'exclamation-square',
        'fas fa-exclamation-triangle'                => 'exclamation-triangle',
        'fas fa-expand'                              => 'expand',
        'fas fa-expand-alt'                          => 'expand-alt',
        'fas fa-expand-arrows'                       => 'expand-arrows',
        'fas fa-expand-arrows-alt'                   => 'expand-arrows-alt',
        'fas fa-expand-wide'                         => 'expand-wide',
        'fas fa-external-link'                       => 'external-link',
        'fas fa-external-link-alt'                   => 'external-link-alt',
        'fas fa-external-link-square'                => 'external-link-square',
        'fas fa-external-link-square-alt'            => 'external-link-square-alt',
        'fas fa-eye'                                 => 'eye',
        'fas fa-eye-dropper'                         => 'eye-dropper',
        'fas fa-eye-evil'                            => 'eye-evil',
        'fas fa-eye-slash'                           => 'eye-slash',
        'fas fa-fan'                                 => 'fan',
        'fas fa-farm'                                => 'farm',
        'fas fa-fast-backward'                       => 'fast-backward',
        'fas fa-fast-forward'                        => 'fast-forward',
        'fas fa-fax'                                 => 'fax',
        'fas fa-feather'                             => 'feather',
        'fas fa-feather-alt'                         => 'feather-alt',
        'fas fa-female'                              => 'female',
        'fas fa-field-hockey'                        => 'field-hockey',
        'fas fa-fighter-jet'                         => 'fighter-jet',
        'fas fa-file'                                => 'file',
        'fas fa-file-alt'                            => 'file-alt',
        'fas fa-file-archive'                        => 'file-archive',
        'fas fa-file-audio'                          => 'file-audio',
        'fas fa-file-certificate'                    => 'file-certificate',
        'fas fa-file-chart-line'                     => 'file-chart-line',
        'fas fa-file-chart-pie'                      => 'file-chart-pie',
        'fas fa-file-check'                          => 'file-check',
        'fas fa-file-code'                           => 'file-code',
        'fas fa-file-contract'                       => 'file-contract',
        'fas fa-file-csv'                            => 'file-csv',
        'fas fa-file-download'                       => 'file-download',
        'fas fa-file-edit'                           => 'file-edit',
        'fas fa-file-excel'                          => 'file-excel',
        'fas fa-file-exclamation'                    => 'file-exclamation',
        'fas fa-file-export'                         => 'file-export',
        'fas fa-file-image'                          => 'file-image',
        'fas fa-file-import'                         => 'file-import',
        'fas fa-file-invoice'                        => 'file-invoice',
        'fas fa-file-invoice-dollar'                 => 'file-invoice-dollar',
        'fas fa-file-medical'                        => 'file-medical',
        'fas fa-file-medical-alt'                    => 'file-medical-alt',
        'fas fa-file-minus'                          => 'file-minus',
        'fas fa-file-pdf'                            => 'file-pdf',
        'fas fa-file-plus'                           => 'file-plus',
        'fas fa-file-powerpoint'                     => 'file-powerpoint',
        'fas fa-file-prescription'                   => 'file-prescription',
        'fas fa-file-search'                         => 'file-search',
        'fas fa-file-signature'                      => 'file-signature',
        'fas fa-file-spreadsheet'                    => 'file-spreadsheet',
        'fas fa-file-times'                          => 'file-times',
        'fas fa-file-upload'                         => 'file-upload',
        'fas fa-file-user'                           => 'file-user',
        'fas fa-file-video'                          => 'file-video',
        'fas fa-file-word'                           => 'file-word',
        'fas fa-files-medical'                       => 'files-medical',
        'fas fa-fill'                                => 'fill',
        'fas fa-fill-drip'                           => 'fill-drip',
        'fas fa-film'                                => 'film',
        'fas fa-film-alt'                            => 'film-alt',
        'fas fa-filter'                              => 'filter',
        'fas fa-fingerprint'                         => 'fingerprint',
        'fas fa-fire'                                => 'fire',
        'fas fa-fire-alt'                            => 'fire-alt',
        'fas fa-fire-extinguisher'                   => 'fire-extinguisher',
        'fas fa-fire-smoke'                          => 'fire-smoke',
        'fas fa-fireplace'                           => 'fireplace',
        'fas fa-first-aid'                           => 'first-aid',
        'fas fa-fish'                                => 'fish',
        'fas fa-fish-cooked'                         => 'fish-cooked',
        'fas fa-fist-raised'                         => 'fist-raised',
        'fas fa-flag'                                => 'flag',
        'fas fa-flag-alt'                            => 'flag-alt',
        'fas fa-flag-checkered'                      => 'flag-checkered',
        'fas fa-flag-usa'                            => 'flag-usa',
        'fas fa-flame'                               => 'flame',
        'fas fa-flask'                               => 'flask',
        'fas fa-flask-poison'                        => 'flask-poison',
        'fas fa-flask-potion'                        => 'flask-potion',
        'fas fa-flower'                              => 'flower',
        'fas fa-flower-daffodil'                     => 'flower-daffodil',
        'fas fa-flower-tulip'                        => 'flower-tulip',
        'fas fa-flushed'                             => 'flushed',
        'fas fa-fog'                                 => 'fog',
        'fas fa-folder'                              => 'folder',
        'fas fa-folder-minus'                        => 'folder-minus',
        'fas fa-folder-open'                         => 'folder-open',
        'fas fa-folder-plus'                         => 'folder-plus',
        'fas fa-folder-times'                        => 'folder-times',
        'fas fa-folder-tree'                         => 'folder-tree',
        'fas fa-folders'                             => 'folders',
        'fas fa-font'                                => 'font',
        'fas fa-font-awesome-logo-full'              => 'font-awesome-logo-full',
        'fas fa-font-case'                           => 'font-case',
        'fas fa-football-ball'                       => 'football-ball',
        'fas fa-football-helmet'                     => 'football-helmet',
        'fas fa-forklift'                            => 'forklift',
        'fas fa-forward'                             => 'forward',
        'fas fa-fragile'                             => 'fragile',
        'fas fa-french-fries'                        => 'french-fries',
        'fas fa-frog'                                => 'frog',
        'fas fa-frosty-head'                         => 'frosty-head',
        'fas fa-frown'                               => 'frown',
        'fas fa-frown-open'                          => 'frown-open',
        'fas fa-function'                            => 'function',
        'fas fa-funnel-dollar'                       => 'funnel-dollar',
        'fas fa-futbol'                              => 'futbol',
        'fas fa-game-board'                          => 'game-board',
        'fas fa-game-board-alt'                      => 'game-board-alt',
        'fas fa-gamepad'                             => 'gamepad',
        'fas fa-gas-pump'                            => 'gas-pump',
        'fas fa-gas-pump-slash'                      => 'gas-pump-slash',
        'fas fa-gavel'                               => 'gavel',
        'fas fa-gem'                                 => 'gem',
        'fas fa-genderless'                          => 'genderless',
        'fas fa-ghost'                               => 'ghost',
        'fas fa-gift'                                => 'gift',
        'fas fa-gift-card'                           => 'gift-card',
        'fas fa-gifts'                               => 'gifts',
        'fas fa-gingerbread-man'                     => 'gingerbread-man',
        'fas fa-glass'                               => 'glass',
        'fas fa-glass-champagne'                     => 'glass-champagne',
        'fas fa-glass-cheers'                        => 'glass-cheers',
        'fas fa-glass-citrus'                        => 'glass-citrus',
        'fas fa-glass-martini'                       => 'glass-martini',
        'fas fa-glass-martini-alt'                   => 'glass-martini-alt',
        'fas fa-glass-whiskey'                       => 'glass-whiskey',
        'fas fa-glass-whiskey-rocks'                 => 'glass-whiskey-rocks',
        'fas fa-glasses'                             => 'glasses',
        'fas fa-glasses-alt'                         => 'glasses-alt',
        'fas fa-globe'                               => 'globe',
        'fas fa-globe-africa'                        => 'globe-africa',
        'fas fa-globe-americas'                      => 'globe-americas',
        'fas fa-globe-asia'                          => 'globe-asia',
        'fas fa-globe-europe'                        => 'globe-europe',
        'fas fa-globe-snow'                          => 'globe-snow',
        'fas fa-globe-stand'                         => 'globe-stand',
        'fas fa-golf-ball'                           => 'golf-ball',
        'fas fa-golf-club'                           => 'golf-club',
        'fas fa-gopuram'                             => 'gopuram',
        'fas fa-graduation-cap'                      => 'graduation-cap',
        'fas fa-greater-than'                        => 'greater-than',
        'fas fa-greater-than-equal'                  => 'greater-than-equal',
        'fas fa-grimace'                             => 'grimace',
        'fas fa-grin'                                => 'grin',
        'fas fa-grin-alt'                            => 'grin-alt',
        'fas fa-grin-beam'                           => 'grin-beam',
        'fas fa-grin-beam-sweat'                     => 'grin-beam-sweat',
        'fas fa-grin-hearts'                         => 'grin-hearts',
        'fas fa-grin-squint'                         => 'grin-squint',
        'fas fa-grin-squint-tears'                   => 'grin-squint-tears',
        'fas fa-grin-stars'                          => 'grin-stars',
        'fas fa-grin-tears'                          => 'grin-tears',
        'fas fa-grin-tongue'                         => 'grin-tongue',
        'fas fa-grin-tongue-squint'                  => 'grin-tongue-squint',
        'fas fa-grin-tongue-wink'                    => 'grin-tongue-wink',
        'fas fa-grin-wink'                           => 'grin-wink',
        'fas fa-grip-horizontal'                     => 'grip-horizontal',
        'fas fa-grip-lines'                          => 'grip-lines',
        'fas fa-grip-lines-vertical'                 => 'grip-lines-vertical',
        'fas fa-grip-vertical'                       => 'grip-vertical',
        'fas fa-guitar'                              => 'guitar',
        'fas fa-h-square'                            => 'h-square',
        'fas fa-h1'                                  => 'h1',
        'fas fa-h2'                                  => 'h2',
        'fas fa-h3'                                  => 'h3',
        'fas fa-h4'                                  => 'h4',
        'fas fa-hamburger'                           => 'hamburger',
        'fas fa-hammer'                              => 'hammer',
        'fas fa-hammer-war'                          => 'hammer-war',
        'fas fa-hamsa'                               => 'hamsa',
        'fas fa-hand-heart'                          => 'hand-heart',
        'fas fa-hand-holding'                        => 'hand-holding',
        'fas fa-hand-holding-box'                    => 'hand-holding-box',
        'fas fa-hand-holding-heart'                  => 'hand-holding-heart',
        'fas fa-hand-holding-magic'                  => 'hand-holding-magic',
        'fas fa-hand-holding-seedling'               => 'hand-holding-seedling',
        'fas fa-hand-holding-usd'                    => 'hand-holding-usd',
        'fas fa-hand-holding-water'                  => 'hand-holding-water',
        'fas fa-hand-lizard'                         => 'hand-lizard',
        'fas fa-hand-middle-finger'                  => 'hand-middle-finger',
        'fas fa-hand-paper'                          => 'hand-paper',
        'fas fa-hand-peace'                          => 'hand-peace',
        'fas fa-hand-point-down'                     => 'hand-point-down',
        'fas fa-hand-point-left'                     => 'hand-point-left',
        'fas fa-hand-point-right'                    => 'hand-point-right',
        'fas fa-hand-point-up'                       => 'hand-point-up',
        'fas fa-hand-pointer'                        => 'hand-pointer',
        'fas fa-hand-receiving'                      => 'hand-receiving',
        'fas fa-hand-rock'                           => 'hand-rock',
        'fas fa-hand-scissors'                       => 'hand-scissors',
        'fas fa-hand-spock'                          => 'hand-spock',
        'fas fa-hands'                               => 'hands',
        'fas fa-hands-heart'                         => 'hands-heart',
        'fas fa-hands-helping'                       => 'hands-helping',
        'fas fa-hands-usd'                           => 'hands-usd',
        'fas fa-handshake'                           => 'handshake',
        'fas fa-handshake-alt'                       => 'handshake-alt',
        'fas fa-hanukiah'                            => 'hanukiah',
        'fas fa-hard-hat'                            => 'hard-hat',
        'fas fa-hashtag'                             => 'hashtag',
        'fas fa-hat-chef'                            => 'hat-chef',
        'fas fa-hat-santa'                           => 'hat-santa',
        'fas fa-hat-winter'                          => 'hat-winter',
        'fas fa-hat-witch'                           => 'hat-witch',
        'fas fa-hat-wizard'                          => 'hat-wizard',
        'fas fa-haykal'                              => 'haykal',
        'fas fa-hdd'                                 => 'hdd',
        'fas fa-head-side'                           => 'head-side',
        'fas fa-head-side-brain'                     => 'head-side-brain',
        'fas fa-head-side-medical'                   => 'head-side-medical',
        'fas fa-head-vr'                             => 'head-vr',
        'fas fa-heading'                             => 'heading',
        'fas fa-headphones'                          => 'headphones',
        'fas fa-headphones-alt'                      => 'headphones-alt',
        'fas fa-headset'                             => 'headset',
        'fas fa-heart'                               => 'heart',
        'fas fa-heart-broken'                        => 'heart-broken',
        'fas fa-heart-circle'                        => 'heart-circle',
        'fas fa-heart-rate'                          => 'heart-rate',
        'fas fa-heart-square'                        => 'heart-square',
        'fas fa-heartbeat'                           => 'heartbeat',
        'fas fa-helicopter'                          => 'helicopter',
        'fas fa-helmet-battle'                       => 'helmet-battle',
        'fas fa-hexagon'                             => 'hexagon',
        'fas fa-highlighter'                         => 'highlighter',
        'fas fa-hiking'                              => 'hiking',
        'fas fa-hippo'                               => 'hippo',
        'fas fa-history'                             => 'history',
        'fas fa-hockey-mask'                         => 'hockey-mask',
        'fas fa-hockey-puck'                         => 'hockey-puck',
        'fas fa-hockey-sticks'                       => 'hockey-sticks',
        'fas fa-holly-berry'                         => 'holly-berry',
        'fas fa-home'                                => 'home',
        'fas fa-home-alt'                            => 'home-alt',
        'fas fa-home-heart'                          => 'home-heart',
        'fas fa-home-lg'                             => 'home-lg',
        'fas fa-home-lg-alt'                         => 'home-lg-alt',
        'fas fa-hood-cloak'                          => 'hood-cloak',
        'fas fa-horizontal-rule'                     => 'horizontal-rule',
        'fas fa-horse'                               => 'horse',
        'fas fa-horse-head'                          => 'horse-head',
        'fas fa-hospital'                            => 'hospital',
        'fas fa-hospital-alt'                        => 'hospital-alt',
        'fas fa-hospital-symbol'                     => 'hospital-symbol',
        'fas fa-hospital-user'                       => 'hospital-user',
        'fas fa-hospitals'                           => 'hospitals',
        'fas fa-hot-tub'                             => 'hot-tub',
        'fas fa-hotdog'                              => 'hotdog',
        'fas fa-hotel'                               => 'hotel',
        'fas fa-hourglass'                           => 'hourglass',
        'fas fa-hourglass-end'                       => 'hourglass-end',
        'fas fa-hourglass-half'                      => 'hourglass-half',
        'fas fa-hourglass-start'                     => 'hourglass-start',
        'fas fa-house-damage'                        => 'house-damage',
        'fas fa-house-flood'                         => 'house-flood',
        'fas fa-hryvnia'                             => 'hryvnia',
        'fas fa-humidity'                            => 'humidity',
        'fas fa-hurricane'                           => 'hurricane',
        'fas fa-i-cursor'                            => 'i-cursor',
        'fas fa-ice-cream'                           => 'ice-cream',
        'fas fa-ice-skate'                           => 'ice-skate',
        'fas fa-icicles'                             => 'icicles',
        'fas fa-icons'                               => 'icons',
        'fas fa-icons-alt'                           => 'icons-alt',
        'fas fa-id-badge'                            => 'id-badge',
        'fas fa-id-card'                             => 'id-card',
        'fas fa-id-card-alt'                         => 'id-card-alt',
        'fas fa-igloo'                               => 'igloo',
        'fas fa-image'                               => 'image',
        'fas fa-images'                              => 'images',
        'fas fa-inbox'                               => 'inbox',
        'fas fa-inbox-in'                            => 'inbox-in',
        'fas fa-inbox-out'                           => 'inbox-out',
        'fas fa-indent'                              => 'indent',
        'fas fa-industry'                            => 'industry',
        'fas fa-industry-alt'                        => 'industry-alt',
        'fas fa-infinity'                            => 'infinity',
        'fas fa-info'                                => 'info',
        'fas fa-info-circle'                         => 'info-circle',
        'fas fa-info-square'                         => 'info-square',
        'fas fa-inhaler'                             => 'inhaler',
        'fas fa-integral'                            => 'integral',
        'fas fa-intersection'                        => 'intersection',
        'fas fa-inventory'                           => 'inventory',
        'fas fa-island-tropical'                     => 'island-tropical',
        'fas fa-italic'                              => 'italic',
        'fas fa-jack-o-lantern'                      => 'jack-o-lantern',
        'fas fa-jedi'                                => 'jedi',
        'fas fa-joint'                               => 'joint',
        'fas fa-journal-whills'                      => 'journal-whills',
        'fas fa-kaaba'                               => 'kaaba',
        'fas fa-kerning'                             => 'kerning',
        'fas fa-key'                                 => 'key',
        'fas fa-key-skeleton'                        => 'key-skeleton',
        'fas fa-keyboard'                            => 'keyboard',
        'fas fa-keynote'                             => 'keynote',
        'fas fa-khanda'                              => 'khanda',
        'fas fa-kidneys'                             => 'kidneys',
        'fas fa-kiss'                                => 'kiss',
        'fas fa-kiss-beam'                           => 'kiss-beam',
        'fas fa-kiss-wink-heart'                     => 'kiss-wink-heart',
        'fas fa-kite'                                => 'kite',
        'fas fa-kiwi-bird'                           => 'kiwi-bird',
        'fas fa-knife-kitchen'                       => 'knife-kitchen',
        'fas fa-lambda'                              => 'lambda',
        'fas fa-lamp'                                => 'lamp',
        'fas fa-landmark'                            => 'landmark',
        'fas fa-landmark-alt'                        => 'landmark-alt',
        'fas fa-language'                            => 'language',
        'fas fa-laptop'                              => 'laptop',
        'fas fa-laptop-code'                         => 'laptop-code',
        'fas fa-laptop-medical'                      => 'laptop-medical',
        'fas fa-laugh'                               => 'laugh',
        'fas fa-laugh-beam'                          => 'laugh-beam',
        'fas fa-laugh-squint'                        => 'laugh-squint',
        'fas fa-laugh-wink'                          => 'laugh-wink',
        'fas fa-layer-group'                         => 'layer-group',
        'fas fa-layer-minus'                         => 'layer-minus',
        'fas fa-layer-plus'                          => 'layer-plus',
        'fas fa-leaf'                                => 'leaf',
        'fas fa-leaf-heart'                          => 'leaf-heart',
        'fas fa-leaf-maple'                          => 'leaf-maple',
        'fas fa-leaf-oak'                            => 'leaf-oak',
        'fas fa-lemon'                               => 'lemon',
        'fas fa-less-than'                           => 'less-than',
        'fas fa-less-than-equal'                     => 'less-than-equal',
        'fas fa-level-down'                          => 'level-down',
        'fas fa-level-down-alt'                      => 'level-down-alt',
        'fas fa-level-up'                            => 'level-up',
        'fas fa-level-up-alt'                        => 'level-up-alt',
        'fas fa-life-ring'                           => 'life-ring',
        'fas fa-lightbulb'                           => 'lightbulb',
        'fas fa-lightbulb-dollar'                    => 'lightbulb-dollar',
        'fas fa-lightbulb-exclamation'               => 'lightbulb-exclamation',
        'fas fa-lightbulb-on'                        => 'lightbulb-on',
        'fas fa-lightbulb-slash'                     => 'lightbulb-slash',
        'fas fa-lights-holiday'                      => 'lights-holiday',
        'fas fa-line-columns'                        => 'line-columns',
        'fas fa-line-height'                         => 'line-height',
        'fas fa-link'                                => 'link',
        'fas fa-lips'                                => 'lips',
        'fas fa-lira-sign'                           => 'lira-sign',
        'fas fa-list'                                => 'list',
        'fas fa-list-alt'                            => 'list-alt',
        'fas fa-list-ol'                             => 'list-ol',
        'fas fa-list-ul'                             => 'list-ul',
        'fas fa-location'                            => 'location',
        'fas fa-location-arrow'                      => 'location-arrow',
        'fas fa-location-circle'                     => 'location-circle',
        'fas fa-location-slash'                      => 'location-slash',
        'fas fa-lock'                                => 'lock',
        'fas fa-lock-alt'                            => 'lock-alt',
        'fas fa-lock-open'                           => 'lock-open',
        'fas fa-lock-open-alt'                       => 'lock-open-alt',
        'fas fa-long-arrow-alt-down'                 => 'long-arrow-alt-down',
        'fas fa-long-arrow-alt-left'                 => 'long-arrow-alt-left',
        'fas fa-long-arrow-alt-right'                => 'long-arrow-alt-right',
        'fas fa-long-arrow-alt-up'                   => 'long-arrow-alt-up',
        'fas fa-long-arrow-down'                     => 'long-arrow-down',
        'fas fa-long-arrow-left'                     => 'long-arrow-left',
        'fas fa-long-arrow-right'                    => 'long-arrow-right',
        'fas fa-long-arrow-up'                       => 'long-arrow-up',
        'fas fa-loveseat'                            => 'loveseat',
        'fas fa-low-vision'                          => 'low-vision',
        'fas fa-luchador'                            => 'luchador',
        'fas fa-luggage-cart'                        => 'luggage-cart',
        'fas fa-lungs'                               => 'lungs',
        'fas fa-mace'                                => 'mace',
        'fas fa-magic'                               => 'magic',
        'fas fa-magnet'                              => 'magnet',
        'fas fa-mail-bulk'                           => 'mail-bulk',
        'fas fa-mailbox'                             => 'mailbox',
        'fas fa-male'                                => 'male',
        'fas fa-mandolin'                            => 'mandolin',
        'fas fa-map'                                 => 'map',
        'fas fa-map-marked'                          => 'map-marked',
        'fas fa-map-marked-alt'                      => 'map-marked-alt',
        'fas fa-map-marker'                          => 'map-marker',
        'fas fa-map-marker-alt'                      => 'map-marker-alt',
        'fas fa-map-marker-alt-slash'                => 'map-marker-alt-slash',
        'fas fa-map-marker-check'                    => 'map-marker-check',
        'fas fa-map-marker-edit'                     => 'map-marker-edit',
        'fas fa-map-marker-exclamation'              => 'map-marker-exclamation',
        'fas fa-map-marker-minus'                    => 'map-marker-minus',
        'fas fa-map-marker-plus'                     => 'map-marker-plus',
        'fas fa-map-marker-question'                 => 'map-marker-question',
        'fas fa-map-marker-slash'                    => 'map-marker-slash',
        'fas fa-map-marker-smile'                    => 'map-marker-smile',
        'fas fa-map-marker-times'                    => 'map-marker-times',
        'fas fa-map-pin'                             => 'map-pin',
        'fas fa-map-signs'                           => 'map-signs',
        'fas fa-marker'                              => 'marker',
        'fas fa-mars'                                => 'mars',
        'fas fa-mars-double'                         => 'mars-double',
        'fas fa-mars-stroke'                         => 'mars-stroke',
        'fas fa-mars-stroke-h'                       => 'mars-stroke-h',
        'fas fa-mars-stroke-v'                       => 'mars-stroke-v',
        'fas fa-mask'                                => 'mask',
        'fas fa-meat'                                => 'meat',
        'fas fa-medal'                               => 'medal',
        'fas fa-medkit'                              => 'medkit',
        'fas fa-megaphone'                           => 'megaphone',
        'fas fa-meh'                                 => 'meh',
        'fas fa-meh-blank'                           => 'meh-blank',
        'fas fa-meh-rolling-eyes'                    => 'meh-rolling-eyes',
        'fas fa-memory'                              => 'memory',
        'fas fa-menorah'                             => 'menorah',
        'fas fa-mercury'                             => 'mercury',
        'fas fa-meteor'                              => 'meteor',
        'fas fa-microchip'                           => 'microchip',
        'fas fa-microphone'                          => 'microphone',
        'fas fa-microphone-alt'                      => 'microphone-alt',
        'fas fa-microphone-alt-slash'                => 'microphone-alt-slash',
        'fas fa-microphone-slash'                    => 'microphone-slash',
        'fas fa-microscope'                          => 'microscope',
        'fas fa-mind-share'                          => 'mind-share',
        'fas fa-minus'                               => 'minus',
        'fas fa-minus-circle'                        => 'minus-circle',
        'fas fa-minus-hexagon'                       => 'minus-hexagon',
        'fas fa-minus-octagon'                       => 'minus-octagon',
        'fas fa-minus-square'                        => 'minus-square',
        'fas fa-mistletoe'                           => 'mistletoe',
        'fas fa-mitten'                              => 'mitten',
        'fas fa-mobile'                              => 'mobile',
        'fas fa-mobile-alt'                          => 'mobile-alt',
        'fas fa-mobile-android'                      => 'mobile-android',
        'fas fa-mobile-android-alt'                  => 'mobile-android-alt',
        'fas fa-money-bill'                          => 'money-bill',
        'fas fa-money-bill-alt'                      => 'money-bill-alt',
        'fas fa-money-bill-wave'                     => 'money-bill-wave',
        'fas fa-money-bill-wave-alt'                 => 'money-bill-wave-alt',
        'fas fa-money-check'                         => 'money-check',
        'fas fa-money-check-alt'                     => 'money-check-alt',
        'fas fa-money-check-edit'                    => 'money-check-edit',
        'fas fa-money-check-edit-alt'                => 'money-check-edit-alt',
        'fas fa-monitor-heart-rate'                  => 'monitor-heart-rate',
        'fas fa-monkey'                              => 'monkey',
        'fas fa-monument'                            => 'monument',
        'fas fa-moon'                                => 'moon',
        'fas fa-moon-cloud'                          => 'moon-cloud',
        'fas fa-moon-stars'                          => 'moon-stars',
        'fas fa-mortar-pestle'                       => 'mortar-pestle',
        'fas fa-mosque'                              => 'mosque',
        'fas fa-motorcycle'                          => 'motorcycle',
        'fas fa-mountain'                            => 'mountain',
        'fas fa-mountains'                           => 'mountains',
        'fas fa-mouse-pointer'                       => 'mouse-pointer',
        'fas fa-mug'                                 => 'mug',
        'fas fa-mug-hot'                             => 'mug-hot',
        'fas fa-mug-marshmallows'                    => 'mug-marshmallows',
        'fas fa-mug-tea'                             => 'mug-tea',
        'fas fa-music'                               => 'music',
        'fas fa-narwhal'                             => 'narwhal',
        'fas fa-network-wired'                       => 'network-wired',
        'fas fa-neuter'                              => 'neuter',
        'fas fa-newspaper'                           => 'newspaper',
        'fas fa-not-equal'                           => 'not-equal',
        'fas fa-notes-medical'                       => 'notes-medical',
        'fas fa-object-group'                        => 'object-group',
        'fas fa-object-ungroup'                      => 'object-ungroup',
        'fas fa-octagon'                             => 'octagon',
        'fas fa-oil-can'                             => 'oil-can',
        'fas fa-oil-temp'                            => 'oil-temp',
        'fas fa-om'                                  => 'om',
        'fas fa-omega'                               => 'omega',
        'fas fa-ornament'                            => 'ornament',
        'fas fa-otter'                               => 'otter',
        'fas fa-outdent'                             => 'outdent',
        'fas fa-overline'                            => 'overline',
        'fas fa-page-break'                          => 'page-break',
        'fas fa-pager'                               => 'pager',
        'fas fa-paint-brush'                         => 'paint-brush',
        'fas fa-paint-brush-alt'                     => 'paint-brush-alt',
        'fas fa-paint-roller'                        => 'paint-roller',
        'fas fa-palette'                             => 'palette',
        'fas fa-pallet'                              => 'pallet',
        'fas fa-pallet-alt'                          => 'pallet-alt',
        'fas fa-paper-plane'                         => 'paper-plane',
        'fas fa-paperclip'                           => 'paperclip',
        'fas fa-parachute-box'                       => 'parachute-box',
        'fas fa-paragraph'                           => 'paragraph',
        'fas fa-paragraph-rtl'                       => 'paragraph-rtl',
        'fas fa-parking'                             => 'parking',
        'fas fa-parking-circle'                      => 'parking-circle',
        'fas fa-parking-circle-slash'                => 'parking-circle-slash',
        'fas fa-parking-slash'                       => 'parking-slash',
        'fas fa-passport'                            => 'passport',
        'fas fa-pastafarianism'                      => 'pastafarianism',
        'fas fa-paste'                               => 'paste',
        'fas fa-pause'                               => 'pause',
        'fas fa-pause-circle'                        => 'pause-circle',
        'fas fa-paw'                                 => 'paw',
        'fas fa-paw-alt'                             => 'paw-alt',
        'fas fa-paw-claws'                           => 'paw-claws',
        'fas fa-peace'                               => 'peace',
        'fas fa-pegasus'                             => 'pegasus',
        'fas fa-pen'                                 => 'pen',
        'fas fa-pen-alt'                             => 'pen-alt',
        'fas fa-pen-fancy'                           => 'pen-fancy',
        'fas fa-pen-nib'                             => 'pen-nib',
        'fas fa-pen-square'                          => 'pen-square',
        'fas fa-pencil'                              => 'pencil',
        'fas fa-pencil-alt'                          => 'pencil-alt',
        'fas fa-pencil-paintbrush'                   => 'pencil-paintbrush',
        'fas fa-pencil-ruler'                        => 'pencil-ruler',
        'fas fa-pennant'                             => 'pennant',
        'fas fa-people-carry'                        => 'people-carry',
        'fas fa-pepper-hot'                          => 'pepper-hot',
        'fas fa-percent'                             => 'percent',
        'fas fa-percentage'                          => 'percentage',
        'fas fa-person-booth'                        => 'person-booth',
        'fas fa-person-carry'                        => 'person-carry',
        'fas fa-person-dolly'                        => 'person-dolly',
        'fas fa-person-dolly-empty'                  => 'person-dolly-empty',
        'fas fa-person-sign'                         => 'person-sign',
        'fas fa-phone'                               => 'phone',
        'fas fa-phone-alt'                           => 'phone-alt',
        'fas fa-phone-laptop'                        => 'phone-laptop',
        'fas fa-phone-office'                        => 'phone-office',
        'fas fa-phone-plus'                          => 'phone-plus',
        'fas fa-phone-slash'                         => 'phone-slash',
        'fas fa-phone-square'                        => 'phone-square',
        'fas fa-phone-square-alt'                    => 'phone-square-alt',
        'fas fa-phone-volume'                        => 'phone-volume',
        'fas fa-photo-video'                         => 'photo-video',
        'fas fa-pi'                                  => 'pi',
        'fas fa-pie'                                 => 'pie',
        'fas fa-pig'                                 => 'pig',
        'fas fa-piggy-bank'                          => 'piggy-bank',
        'fas fa-pills'                               => 'pills',
        'fas fa-pizza'                               => 'pizza',
        'fas fa-pizza-slice'                         => 'pizza-slice',
        'fas fa-place-of-worship'                    => 'place-of-worship',
        'fas fa-plane'                               => 'plane',
        'fas fa-plane-alt'                           => 'plane-alt',
        'fas fa-plane-arrival'                       => 'plane-arrival',
        'fas fa-plane-departure'                     => 'plane-departure',
        'fas fa-play'                                => 'play',
        'fas fa-play-circle'                         => 'play-circle',
        'fas fa-plug'                                => 'plug',
        'fas fa-plus'                                => 'plus',
        'fas fa-plus-circle'                         => 'plus-circle',
        'fas fa-plus-hexagon'                        => 'plus-hexagon',
        'fas fa-plus-octagon'                        => 'plus-octagon',
        'fas fa-plus-square'                         => 'plus-square',
        'fas fa-podcast'                             => 'podcast',
        'fas fa-podium'                              => 'podium',
        'fas fa-podium-star'                         => 'podium-star',
        'fas fa-poll'                                => 'poll',
        'fas fa-poll-h'                              => 'poll-h',
        'fas fa-poll-people'                         => 'poll-people',
        'fas fa-poo'                                 => 'poo',
        'fas fa-poo-storm'                           => 'poo-storm',
        'fas fa-poop'                                => 'poop',
        'fas fa-popcorn'                             => 'popcorn',
        'fas fa-portrait'                            => 'portrait',
        'fas fa-pound-sign'                          => 'pound-sign',
        'fas fa-power-off'                           => 'power-off',
        'fas fa-pray'                                => 'pray',
        'fas fa-praying-hands'                       => 'praying-hands',
        'fas fa-prescription'                        => 'prescription',
        'fas fa-prescription-bottle'                 => 'prescription-bottle',
        'fas fa-prescription-bottle-alt'             => 'prescription-bottle-alt',
        'fas fa-presentation'                        => 'presentation',
        'fas fa-print'                               => 'print',
        'fas fa-print-search'                        => 'print-search',
        'fas fa-print-slash'                         => 'print-slash',
        'fas fa-procedures'                          => 'procedures',
        'fas fa-project-diagram'                     => 'project-diagram',
        'fas fa-pumpkin'                             => 'pumpkin',
        'fas fa-puzzle-piece'                        => 'puzzle-piece',
        'fas fa-qrcode'                              => 'qrcode',
        'fas fa-question'                            => 'question',
        'fas fa-question-circle'                     => 'question-circle',
        'fas fa-question-square'                     => 'question-square',
        'fas fa-quidditch'                           => 'quidditch',
        'fas fa-quote-left'                          => 'quote-left',
        'fas fa-quote-right'                         => 'quote-right',
        'fas fa-quran'                               => 'quran',
        'fas fa-rabbit'                              => 'rabbit',
        'fas fa-rabbit-fast'                         => 'rabbit-fast',
        'fas fa-racquet'                             => 'racquet',
        'fas fa-radiation'                           => 'radiation',
        'fas fa-radiation-alt'                       => 'radiation-alt',
        'fas fa-rainbow'                             => 'rainbow',
        'fas fa-raindrops'                           => 'raindrops',
        'fas fa-ram'                                 => 'ram',
        'fas fa-ramp-loading'                        => 'ramp-loading',
        'fas fa-random'                              => 'random',
        'fas fa-receipt'                             => 'receipt',
        'fas fa-rectangle-landscape'                 => 'rectangle-landscape',
        'fas fa-rectangle-portrait'                  => 'rectangle-portrait',
        'fas fa-rectangle-wide'                      => 'rectangle-wide',
        'fas fa-recycle'                             => 'recycle',
        'fas fa-redo'                                => 'redo',
        'fas fa-redo-alt'                            => 'redo-alt',
        'fas fa-registered'                          => 'registered',
        'fas fa-remove-format'                       => 'remove-format',
        'fas fa-repeat'                              => 'repeat',
        'fas fa-repeat-1'                            => 'repeat-1',
        'fas fa-repeat-1-alt'                        => 'repeat-1-alt',
        'fas fa-repeat-alt'                          => 'repeat-alt',
        'fas fa-reply'                               => 'reply',
        'fas fa-reply-all'                           => 'reply-all',
        'fas fa-republican'                          => 'republican',
        'fas fa-restroom'                            => 'restroom',
        'fas fa-retweet'                             => 'retweet',
        'fas fa-retweet-alt'                         => 'retweet-alt',
        'fas fa-ribbon'                              => 'ribbon',
        'fas fa-ring'                                => 'ring',
        'fas fa-rings-wedding'                       => 'rings-wedding',
        'fas fa-road'                                => 'road',
        'fas fa-robot'                               => 'robot',
        'fas fa-rocket'                              => 'rocket',
        'fas fa-route'                               => 'route',
        'fas fa-route-highway'                       => 'route-highway',
        'fas fa-route-interstate'                    => 'route-interstate',
        'fas fa-rss'                                 => 'rss',
        'fas fa-rss-square'                          => 'rss-square',
        'fas fa-ruble-sign'                          => 'ruble-sign',
        'fas fa-ruler'                               => 'ruler',
        'fas fa-ruler-combined'                      => 'ruler-combined',
        'fas fa-ruler-horizontal'                    => 'ruler-horizontal',
        'fas fa-ruler-triangle'                      => 'ruler-triangle',
        'fas fa-ruler-vertical'                      => 'ruler-vertical',
        'fas fa-running'                             => 'running',
        'fas fa-rupee-sign'                          => 'rupee-sign',
        'fas fa-rv'                                  => 'rv',
        'fas fa-sack'                                => 'sack',
        'fas fa-sack-dollar'                         => 'sack-dollar',
        'fas fa-sad-cry'                             => 'sad-cry',
        'fas fa-sad-tear'                            => 'sad-tear',
        'fas fa-salad'                               => 'salad',
        'fas fa-sandwich'                            => 'sandwich',
        'fas fa-satellite'                           => 'satellite',
        'fas fa-satellite-dish'                      => 'satellite-dish',
        'fas fa-sausage'                             => 'sausage',
        'fas fa-save'                                => 'save',
        'fas fa-scalpel'                             => 'scalpel',
        'fas fa-scalpel-path'                        => 'scalpel-path',
        'fas fa-scanner'                             => 'scanner',
        'fas fa-scanner-keyboard'                    => 'scanner-keyboard',
        'fas fa-scanner-touchscreen'                 => 'scanner-touchscreen',
        'fas fa-scarecrow'                           => 'scarecrow',
        'fas fa-scarf'                               => 'scarf',
        'fas fa-school'                              => 'school',
        'fas fa-screwdriver'                         => 'screwdriver',
        'fas fa-scroll'                              => 'scroll',
        'fas fa-scroll-old'                          => 'scroll-old',
        'fas fa-scrubber'                            => 'scrubber',
        'fas fa-scythe'                              => 'scythe',
        'fas fa-sd-card'                             => 'sd-card',
        'fas fa-search'                              => 'search',
        'fas fa-search-dollar'                       => 'search-dollar',
        'fas fa-search-location'                     => 'search-location',
        'fas fa-search-minus'                        => 'search-minus',
        'fas fa-search-plus'                         => 'search-plus',
        'fas fa-seedling'                            => 'seedling',
        'fas fa-send-back'                           => 'send-back',
        'fas fa-send-backward'                       => 'send-backward',
        'fas fa-server'                              => 'server',
        'fas fa-shapes'                              => 'shapes',
        'fas fa-share'                               => 'share',
        'fas fa-share-all'                           => 'share-all',
        'fas fa-share-alt'                           => 'share-alt',
        'fas fa-share-alt-square'                    => 'share-alt-square',
        'fas fa-share-square'                        => 'share-square',
        'fas fa-sheep'                               => 'sheep',
        'fas fa-shekel-sign'                         => 'shekel-sign',
        'fas fa-shield'                              => 'shield',
        'fas fa-shield-alt'                          => 'shield-alt',
        'fas fa-shield-check'                        => 'shield-check',
        'fas fa-shield-cross'                        => 'shield-cross',
        'fas fa-ship'                                => 'ship',
        'fas fa-shipping-fast'                       => 'shipping-fast',
        'fas fa-shipping-timed'                      => 'shipping-timed',
        'fas fa-shish-kebab'                         => 'shish-kebab',
        'fas fa-shoe-prints'                         => 'shoe-prints',
        'fas fa-shopping-bag'                        => 'shopping-bag',
        'fas fa-shopping-basket'                     => 'shopping-basket',
        'fas fa-shopping-cart'                       => 'shopping-cart',
        'fas fa-shovel'                              => 'shovel',
        'fas fa-shovel-snow'                         => 'shovel-snow',
        'fas fa-shower'                              => 'shower',
        'fas fa-shredder'                            => 'shredder',
        'fas fa-shuttle-van'                         => 'shuttle-van',
        'fas fa-shuttlecock'                         => 'shuttlecock',
        'fas fa-sickle'                              => 'sickle',
        'fas fa-sigma'                               => 'sigma',
        'fas fa-sign'                                => 'sign',
        'fas fa-sign-in'                             => 'sign-in',
        'fas fa-sign-in-alt'                         => 'sign-in-alt',
        'fas fa-sign-language'                       => 'sign-language',
        'fas fa-sign-out'                            => 'sign-out',
        'fas fa-sign-out-alt'                        => 'sign-out-alt',
        'fas fa-signal'                              => 'signal',
        'fas fa-signal-1'                            => 'signal-1',
        'fas fa-signal-2'                            => 'signal-2',
        'fas fa-signal-3'                            => 'signal-3',
        'fas fa-signal-4'                            => 'signal-4',
        'fas fa-signal-alt'                          => 'signal-alt',
        'fas fa-signal-alt-1'                        => 'signal-alt-1',
        'fas fa-signal-alt-2'                        => 'signal-alt-2',
        'fas fa-signal-alt-3'                        => 'signal-alt-3',
        'fas fa-signal-alt-slash'                    => 'signal-alt-slash',
        'fas fa-signal-slash'                        => 'signal-slash',
        'fas fa-signature'                           => 'signature',
        'fas fa-sim-card'                            => 'sim-card',
        'fas fa-sitemap'                             => 'sitemap',
        'fas fa-skating'                             => 'skating',
        'fas fa-skeleton'                            => 'skeleton',
        'fas fa-ski-jump'                            => 'ski-jump',
        'fas fa-ski-lift'                            => 'ski-lift',
        'fas fa-skiing'                              => 'skiing',
        'fas fa-skiing-nordic'                       => 'skiing-nordic',
        'fas fa-skull'                               => 'skull',
        'fas fa-skull-crossbones'                    => 'skull-crossbones',
        'fas fa-slash'                               => 'slash',
        'fas fa-sledding'                            => 'sledding',
        'fas fa-sleigh'                              => 'sleigh',
        'fas fa-sliders-h'                           => 'sliders-h',
        'fas fa-sliders-h-square'                    => 'sliders-h-square',
        'fas fa-sliders-v'                           => 'sliders-v',
        'fas fa-sliders-v-square'                    => 'sliders-v-square',
        'fas fa-smile'                               => 'smile',
        'fas fa-smile-beam'                          => 'smile-beam',
        'fas fa-smile-plus'                          => 'smile-plus',
        'fas fa-smile-wink'                          => 'smile-wink',
        'fas fa-smog'                                => 'smog',
        'fas fa-smoke'                               => 'smoke',
        'fas fa-smoking'                             => 'smoking',
        'fas fa-smoking-ban'                         => 'smoking-ban',
        'fas fa-sms'                                 => 'sms',
        'fas fa-snake'                               => 'snake',
        'fas fa-snooze'                              => 'snooze',
        'fas fa-snow-blowing'                        => 'snow-blowing',
        'fas fa-snowboarding'                        => 'snowboarding',
        'fas fa-snowflake'                           => 'snowflake',
        'fas fa-snowflakes'                          => 'snowflakes',
        'fas fa-snowman'                             => 'snowman',
        'fas fa-snowmobile'                          => 'snowmobile',
        'fas fa-snowplow'                            => 'snowplow',
        'fas fa-socks'                               => 'socks',
        'fas fa-solar-panel'                         => 'solar-panel',
        'fas fa-sort'                                => 'sort',
        'fas fa-sort-alpha-down'                     => 'sort-alpha-down',
        'fas fa-sort-alpha-down-alt'                 => 'sort-alpha-down-alt',
        'fas fa-sort-alpha-up'                       => 'sort-alpha-up',
        'fas fa-sort-alpha-up-alt'                   => 'sort-alpha-up-alt',
        'fas fa-sort-alt'                            => 'sort-alt',
        'fas fa-sort-amount-down'                    => 'sort-amount-down',
        'fas fa-sort-amount-down-alt'                => 'sort-amount-down-alt',
        'fas fa-sort-amount-up'                      => 'sort-amount-up',
        'fas fa-sort-amount-up-alt'                  => 'sort-amount-up-alt',
        'fas fa-sort-down'                           => 'sort-down',
        'fas fa-sort-numeric-down'                   => 'sort-numeric-down',
        'fas fa-sort-numeric-down-alt'               => 'sort-numeric-down-alt',
        'fas fa-sort-numeric-up'                     => 'sort-numeric-up',
        'fas fa-sort-numeric-up-alt'                 => 'sort-numeric-up-alt',
        'fas fa-sort-shapes-down'                    => 'sort-shapes-down',
        'fas fa-sort-shapes-down-alt'                => 'sort-shapes-down-alt',
        'fas fa-sort-shapes-up'                      => 'sort-shapes-up',
        'fas fa-sort-shapes-up-alt'                  => 'sort-shapes-up-alt',
        'fas fa-sort-size-down'                      => 'sort-size-down',
        'fas fa-sort-size-down-alt'                  => 'sort-size-down-alt',
        'fas fa-sort-size-up'                        => 'sort-size-up',
        'fas fa-sort-size-up-alt'                    => 'sort-size-up-alt',
        'fas fa-sort-up'                             => 'sort-up',
        'fas fa-soup'                                => 'soup',
        'fas fa-spa'                                 => 'spa',
        'fas fa-space-shuttle'                       => 'space-shuttle',
        'fas fa-spade'                               => 'spade',
        'fas fa-sparkles'                            => 'sparkles',
        'fas fa-spell-check'                         => 'spell-check',
        'fas fa-spider'                              => 'spider',
        'fas fa-spider-black-widow'                  => 'spider-black-widow',
        'fas fa-spider-web'                          => 'spider-web',
        'fas fa-spinner'                             => 'spinner',
        'fas fa-spinner-third'                       => 'spinner-third',
        'fas fa-splotch'                             => 'splotch',
        'fas fa-spray-can'                           => 'spray-can',
        'fas fa-square'                              => 'square',
        'fas fa-square-full'                         => 'square-full',
        'fas fa-square-root'                         => 'square-root',
        'fas fa-square-root-alt'                     => 'square-root-alt',
        'fas fa-squirrel'                            => 'squirrel',
        'fas fa-staff'                               => 'staff',
        'fas fa-stamp'                               => 'stamp',
        'fas fa-star'                                => 'star',
        'fas fa-star-and-crescent'                   => 'star-and-crescent',
        'fas fa-star-christmas'                      => 'star-christmas',
        'fas fa-star-exclamation'                    => 'star-exclamation',
        'fas fa-star-half'                           => 'star-half',
        'fas fa-star-half-alt'                       => 'star-half-alt',
        'fas fa-star-of-david'                       => 'star-of-david',
        'fas fa-star-of-life'                        => 'star-of-life',
        'fas fa-stars'                               => 'stars',
        'fas fa-steak'                               => 'steak',
        'fas fa-steering-wheel'                      => 'steering-wheel',
        'fas fa-step-backward'                       => 'step-backward',
        'fas fa-step-forward'                        => 'step-forward',
        'fas fa-stethoscope'                         => 'stethoscope',
        'fas fa-sticky-note'                         => 'sticky-note',
        'fas fa-stocking'                            => 'stocking',
        'fas fa-stomach'                             => 'stomach',
        'fas fa-stop'                                => 'stop',
        'fas fa-stop-circle'                         => 'stop-circle',
        'fas fa-stopwatch'                           => 'stopwatch',
        'fas fa-store'                               => 'store',
        'fas fa-store-alt'                           => 'store-alt',
        'fas fa-stream'                              => 'stream',
        'fas fa-street-view'                         => 'street-view',
        'fas fa-stretcher'                           => 'stretcher',
        'fas fa-strikethrough'                       => 'strikethrough',
        'fas fa-stroopwafel'                         => 'stroopwafel',
        'fas fa-subscript'                           => 'subscript',
        'fas fa-subway'                              => 'subway',
        'fas fa-suitcase'                            => 'suitcase',
        'fas fa-suitcase-rolling'                    => 'suitcase-rolling',
        'fas fa-sun'                                 => 'sun',
        'fas fa-sun-cloud'                           => 'sun-cloud',
        'fas fa-sun-dust'                            => 'sun-dust',
        'fas fa-sun-haze'                            => 'sun-haze',
        'fas fa-sunglasses'                          => 'sunglasses',
        'fas fa-sunrise'                             => 'sunrise',
        'fas fa-sunset'                              => 'sunset',
        'fas fa-superscript'                         => 'superscript',
        'fas fa-surprise'                            => 'surprise',
        'fas fa-swatchbook'                          => 'swatchbook',
        'fas fa-swimmer'                             => 'swimmer',
        'fas fa-swimming-pool'                       => 'swimming-pool',
        'fas fa-sword'                               => 'sword',
        'fas fa-swords'                              => 'swords',
        'fas fa-synagogue'                           => 'synagogue',
        'fas fa-sync'                                => 'sync',
        'fas fa-sync-alt'                            => 'sync-alt',
        'fas fa-syringe'                             => 'syringe',
        'fas fa-table'                               => 'table',
        'fas fa-table-tennis'                        => 'table-tennis',
        'fas fa-tablet'                              => 'tablet',
        'fas fa-tablet-alt'                          => 'tablet-alt',
        'fas fa-tablet-android'                      => 'tablet-android',
        'fas fa-tablet-android-alt'                  => 'tablet-android-alt',
        'fas fa-tablet-rugged'                       => 'tablet-rugged',
        'fas fa-tablets'                             => 'tablets',
        'fas fa-tachometer'                          => 'tachometer',
        'fas fa-tachometer-alt'                      => 'tachometer-alt',
        'fas fa-tachometer-alt-average'              => 'tachometer-alt-average',
        'fas fa-tachometer-alt-fast'                 => 'tachometer-alt-fast',
        'fas fa-tachometer-alt-fastest'              => 'tachometer-alt-fastest',
        'fas fa-tachometer-alt-slow'                 => 'tachometer-alt-slow',
        'fas fa-tachometer-alt-slowest'              => 'tachometer-alt-slowest',
        'fas fa-tachometer-average'                  => 'tachometer-average',
        'fas fa-tachometer-fast'                     => 'tachometer-fast',
        'fas fa-tachometer-fastest'                  => 'tachometer-fastest',
        'fas fa-tachometer-slow'                     => 'tachometer-slow',
        'fas fa-tachometer-slowest'                  => 'tachometer-slowest',
        'fas fa-taco'                                => 'taco',
        'fas fa-tag'                                 => 'tag',
        'fas fa-tags'                                => 'tags',
        'fas fa-tally'                               => 'tally',
        'fas fa-tanakh'                              => 'tanakh',
        'fas fa-tape'                                => 'tape',
        'fas fa-tasks'                               => 'tasks',
        'fas fa-tasks-alt'                           => 'tasks-alt',
        'fas fa-taxi'                                => 'taxi',
        'fas fa-teeth'                               => 'teeth',
        'fas fa-teeth-open'                          => 'teeth-open',
        'fas fa-temperature-frigid'                  => 'temperature-frigid',
        'fas fa-temperature-high'                    => 'temperature-high',
        'fas fa-temperature-hot'                     => 'temperature-hot',
        'fas fa-temperature-low'                     => 'temperature-low',
        'fas fa-tenge'                               => 'tenge',
        'fas fa-tennis-ball'                         => 'tennis-ball',
        'fas fa-terminal'                            => 'terminal',
        'fas fa-text'                                => 'text',
        'fas fa-text-height'                         => 'text-height',
        'fas fa-text-size'                           => 'text-size',
        'fas fa-text-width'                          => 'text-width',
        'fas fa-th'                                  => 'th',
        'fas fa-th-large'                            => 'th-large',
        'fas fa-th-list'                             => 'th-list',
        'fas fa-theater-masks'                       => 'theater-masks',
        'fas fa-thermometer'                         => 'thermometer',
        'fas fa-thermometer-empty'                   => 'thermometer-empty',
        'fas fa-thermometer-full'                    => 'thermometer-full',
        'fas fa-thermometer-half'                    => 'thermometer-half',
        'fas fa-thermometer-quarter'                 => 'thermometer-quarter',
        'fas fa-thermometer-three-quarters'          => 'thermometer-three-quarters',
        'fas fa-theta'                               => 'theta',
        'fas fa-thumbs-down'                         => 'thumbs-down',
        'fas fa-thumbs-up'                           => 'thumbs-up',
        'fas fa-thumbtack'                           => 'thumbtack',
        'fas fa-thunderstorm'                        => 'thunderstorm',
        'fas fa-thunderstorm-moon'                   => 'thunderstorm-moon',
        'fas fa-thunderstorm-sun'                    => 'thunderstorm-sun',
        'fas fa-ticket'                              => 'ticket',
        'fas fa-ticket-alt'                          => 'ticket-alt',
        'fas fa-tilde'                               => 'tilde',
        'fas fa-times'                               => 'times',
        'fas fa-times-circle'                        => 'times-circle',
        'fas fa-times-hexagon'                       => 'times-hexagon',
        'fas fa-times-octagon'                       => 'times-octagon',
        'fas fa-times-square'                        => 'times-square',
        'fas fa-tint'                                => 'tint',
        'fas fa-tint-slash'                          => 'tint-slash',
        'fas fa-tire'                                => 'tire',
        'fas fa-tire-flat'                           => 'tire-flat',
        'fas fa-tire-pressure-warning'               => 'tire-pressure-warning',
        'fas fa-tire-rugged'                         => 'tire-rugged',
        'fas fa-tired'                               => 'tired',
        'fas fa-toggle-off'                          => 'toggle-off',
        'fas fa-toggle-on'                           => 'toggle-on',
        'fas fa-toilet'                              => 'toilet',
        'fas fa-toilet-paper'                        => 'toilet-paper',
        'fas fa-toilet-paper-alt'                    => 'toilet-paper-alt',
        'fas fa-tombstone'                           => 'tombstone',
        'fas fa-tombstone-alt'                       => 'tombstone-alt',
        'fas fa-toolbox'                             => 'toolbox',
        'fas fa-tools'                               => 'tools',
        'fas fa-tooth'                               => 'tooth',
        'fas fa-toothbrush'                          => 'toothbrush',
        'fas fa-torah'                               => 'torah',
        'fas fa-torii-gate'                          => 'torii-gate',
        'fas fa-tornado'                             => 'tornado',
        'fas fa-tractor'                             => 'tractor',
        'fas fa-trademark'                           => 'trademark',
        'fas fa-traffic-cone'                        => 'traffic-cone',
        'fas fa-traffic-light'                       => 'traffic-light',
        'fas fa-traffic-light-go'                    => 'traffic-light-go',
        'fas fa-traffic-light-slow'                  => 'traffic-light-slow',
        'fas fa-traffic-light-stop'                  => 'traffic-light-stop',
        'fas fa-train'                               => 'train',
        'fas fa-tram'                                => 'tram',
        'fas fa-transgender'                         => 'transgender',
        'fas fa-transgender-alt'                     => 'transgender-alt',
        'fas fa-trash'                               => 'trash',
        'fas fa-trash-alt'                           => 'trash-alt',
        'fas fa-trash-restore'                       => 'trash-restore',
        'fas fa-trash-restore-alt'                   => 'trash-restore-alt',
        'fas fa-trash-undo'                          => 'trash-undo',
        'fas fa-trash-undo-alt'                      => 'trash-undo-alt',
        'fas fa-treasure-chest'                      => 'treasure-chest',
        'fas fa-tree'                                => 'tree',
        'fas fa-tree-alt'                            => 'tree-alt',
        'fas fa-tree-christmas'                      => 'tree-christmas',
        'fas fa-tree-decorated'                      => 'tree-decorated',
        'fas fa-tree-large'                          => 'tree-large',
        'fas fa-tree-palm'                           => 'tree-palm',
        'fas fa-trees'                               => 'trees',
        'fas fa-triangle'                            => 'triangle',
        'fas fa-trophy'                              => 'trophy',
        'fas fa-trophy-alt'                          => 'trophy-alt',
        'fas fa-truck'                               => 'truck',
        'fas fa-truck-container'                     => 'truck-container',
        'fas fa-truck-couch'                         => 'truck-couch',
        'fas fa-truck-loading'                       => 'truck-loading',
        'fas fa-truck-monster'                       => 'truck-monster',
        'fas fa-truck-moving'                        => 'truck-moving',
        'fas fa-truck-pickup'                        => 'truck-pickup',
        'fas fa-truck-plow'                          => 'truck-plow',
        'fas fa-truck-ramp'                          => 'truck-ramp',
        'fas fa-tshirt'                              => 'tshirt',
        'fas fa-tty'                                 => 'tty',
        'fas fa-turkey'                              => 'turkey',
        'fas fa-turtle'                              => 'turtle',
        'fas fa-tv'                                  => 'tv',
        'fas fa-tv-retro'                            => 'tv-retro',
        'fas fa-umbrella'                            => 'umbrella',
        'fas fa-umbrella-beach'                      => 'umbrella-beach',
        'fas fa-underline'                           => 'underline',
        'fas fa-undo'                                => 'undo',
        'fas fa-undo-alt'                            => 'undo-alt',
        'fas fa-unicorn'                             => 'unicorn',
        'fas fa-union'                               => 'union',
        'fas fa-universal-access'                    => 'universal-access',
        'fas fa-university'                          => 'university',
        'fas fa-unlink'                              => 'unlink',
        'fas fa-unlock'                              => 'unlock',
        'fas fa-unlock-alt'                          => 'unlock-alt',
        'fas fa-upload'                              => 'upload',
        'fas fa-usd-circle'                          => 'usd-circle',
        'fas fa-usd-square'                          => 'usd-square',
        'fas fa-user'                                => 'user',
        'fas fa-user-alt'                            => 'user-alt',
        'fas fa-user-alt-slash'                      => 'user-alt-slash',
        'fas fa-user-astronaut'                      => 'user-astronaut',
        'fas fa-user-chart'                          => 'user-chart',
        'fas fa-user-check'                          => 'user-check',
        'fas fa-user-circle'                         => 'user-circle',
        'fas fa-user-clock'                          => 'user-clock',
        'fas fa-user-cog'                            => 'user-cog',
        'fas fa-user-crown'                          => 'user-crown',
        'fas fa-user-edit'                           => 'user-edit',
        'fas fa-user-friends'                        => 'user-friends',
        'fas fa-user-graduate'                       => 'user-graduate',
        'fas fa-user-hard-hat'                       => 'user-hard-hat',
        'fas fa-user-headset'                        => 'user-headset',
        'fas fa-user-injured'                        => 'user-injured',
        'fas fa-user-lock'                           => 'user-lock',
        'fas fa-user-md'                             => 'user-md',
        'fas fa-user-md-chat'                        => 'user-md-chat',
        'fas fa-user-minus'                          => 'user-minus',
        'fas fa-user-ninja'                          => 'user-ninja',
        'fas fa-user-nurse'                          => 'user-nurse',
        'fas fa-user-plus'                           => 'user-plus',
        'fas fa-user-secret'                         => 'user-secret',
        'fas fa-user-shield'                         => 'user-shield',
        'fas fa-user-slash'                          => 'user-slash',
        'fas fa-user-tag'                            => 'user-tag',
        'fas fa-user-tie'                            => 'user-tie',
        'fas fa-user-times'                          => 'user-times',
        'fas fa-users'                               => 'users',
        'fas fa-users-class'                         => 'users-class',
        'fas fa-users-cog'                           => 'users-cog',
        'fas fa-users-crown'                         => 'users-crown',
        'fas fa-users-medical'                       => 'users-medical',
        'fas fa-utensil-fork'                        => 'utensil-fork',
        'fas fa-utensil-knife'                       => 'utensil-knife',
        'fas fa-utensil-spoon'                       => 'utensil-spoon',
        'fas fa-utensils'                            => 'utensils',
        'fas fa-utensils-alt'                        => 'utensils-alt',
        'fas fa-value-absolute'                      => 'value-absolute',
        'fas fa-vector-square'                       => 'vector-square',
        'fas fa-venus'                               => 'venus',
        'fas fa-venus-double'                        => 'venus-double',
        'fas fa-venus-mars'                          => 'venus-mars',
        'fas fa-vial'                                => 'vial',
        'fas fa-vials'                               => 'vials',
        'fas fa-video'                               => 'video',
        'fas fa-video-plus'                          => 'video-plus',
        'fas fa-video-slash'                         => 'video-slash',
        'fas fa-vihara'                              => 'vihara',
        'fas fa-voicemail'                           => 'voicemail',
        'fas fa-volcano'                             => 'volcano',
        'fas fa-volleyball-ball'                     => 'volleyball-ball',
        'fas fa-volume'                              => 'volume',
        'fas fa-volume-down'                         => 'volume-down',
        'fas fa-volume-mute'                         => 'volume-mute',
        'fas fa-volume-off'                          => 'volume-off',
        'fas fa-volume-slash'                        => 'volume-slash',
        'fas fa-volume-up'                           => 'volume-up',
        'fas fa-vote-nay'                            => 'vote-nay',
        'fas fa-vote-yea'                            => 'vote-yea',
        'fas fa-vr-cardboard'                        => 'vr-cardboard',
        'fas fa-walker'                              => 'walker',
        'fas fa-walking'                             => 'walking',
        'fas fa-wallet'                              => 'wallet',
        'fas fa-wand'                                => 'wand',
        'fas fa-wand-magic'                          => 'wand-magic',
        'fas fa-warehouse'                           => 'warehouse',
        'fas fa-warehouse-alt'                       => 'warehouse-alt',
        'fas fa-washer'                              => 'washer',
        'fas fa-watch'                               => 'watch',
        'fas fa-watch-fitness'                       => 'watch-fitness',
        'fas fa-water'                               => 'water',
        'fas fa-water-lower'                         => 'water-lower',
        'fas fa-water-rise'                          => 'water-rise',
        'fas fa-wave-sine'                           => 'wave-sine',
        'fas fa-wave-square'                         => 'wave-square',
        'fas fa-wave-triangle'                       => 'wave-triangle',
        'fas fa-webcam'                              => 'webcam',
        'fas fa-webcam-slash'                        => 'webcam-slash',
        'fas fa-weight'                              => 'weight',
        'fas fa-weight-hanging'                      => 'weight-hanging',
        'fas fa-whale'                               => 'whale',
        'fas fa-wheat'                               => 'wheat',
        'fas fa-wheelchair'                          => 'wheelchair',
        'fas fa-whistle'                             => 'whistle',
        'fas fa-wifi'                                => 'wifi',
        'fas fa-wifi-1'                              => 'wifi-1',
        'fas fa-wifi-2'                              => 'wifi-2',
        'fas fa-wifi-slash'                          => 'wifi-slash',
        'fas fa-wind'                                => 'wind',
        'fas fa-wind-turbine'                        => 'wind-turbine',
        'fas fa-wind-warning'                        => 'wind-warning',
        'fas fa-window'                              => 'window',
        'fas fa-window-alt'                          => 'window-alt',
        'fas fa-window-close'                        => 'window-close',
        'fas fa-window-maximize'                     => 'window-maximize',
        'fas fa-window-minimize'                     => 'window-minimize',
        'fas fa-window-restore'                      => 'window-restore',
        'fas fa-windsock'                            => 'windsock',
        'fas fa-wine-bottle'                         => 'wine-bottle',
        'fas fa-wine-glass'                          => 'wine-glass',
        'fas fa-wine-glass-alt'                      => 'wine-glass-alt',
        'fas fa-won-sign'                            => 'won-sign',
        'fas fa-wreath'                              => 'wreath',
        'fas fa-wrench'                              => 'wrench',
        'fas fa-x-ray'                               => 'x-ray',
        'fas fa-yen-sign'                            => 'yen-sign',
        'fas fa-yin-yang'                            => 'yin-yang',
    );
	
	if($lib != ''){
		return array_filter($extracted_icons, function($v, $k) use ($lib){
			return strpos($k, $lib .' ') === 0;
		},ARRAY_FILTER_USE_BOTH);
	}

	return $extracted_icons;



    $icons   = array();
    $jsonstr = file_get_contents(ESB_ABSPATH . 'assets/vendors/fontawesome-pro-5.10.0-web/metadata/icons.json');

    $json_icons = json_decode($jsonstr, true);

    foreach ($json_icons as $name => $attrs) {
        if (isset($attrs['styles']) && is_array($attrs['styles']) && !empty($attrs['styles'])) {
            foreach ($attrs['styles'] as $style) {
                // if($lib != ''){
                //     if($style === $lib)
                // }else{
                $prefix = str_replace(
                    array('brands', 'solid', 'regular', 'light', 'duotone'),
                    array('fab', 'fas', 'far', 'fal', 'fad'),
                    $style
                );
                $icons[$prefix . ' fa-' . $name] = $name;
                // }

            }
        }
    }

    ksort($icons);

    foreach ($icons as $key => $name) {
        echo "'$key' => '$name',\n";
    }
    die;

    return $icons;
}
function townhub_addons_extract_awesome_icon_array()
{
    $icons   = array();
    $pattern = '/\.(fa-(?:\w+(?:-)?)+):before\s+{\s*content:\s*"\\\\(.+)";\s+}/';
    $subject = file_get_contents(ESB_ABSPATH . 'inc/assets/font-awesome/font-awesome.css');
    preg_match_all($pattern, $subject, $matches, PREG_SET_ORDER);

    foreach ($matches as $match) {

        $icons['fa ' . $match[1]] = str_replace("fa-", "", $match[1]);
    }

    ksort($icons);

    return $icons;
}
