<?php
/**
 *  Template Name: Contact Page
 * 
 * @package Toranj
 * @author owwwlab
 */

?>

<?php get_header(); ?>
<!-- Page main wrapper -->
<div id="main-content" class="abs dark-template">
	<div class="page-wrapper">
		
		<!-- Sidebar -->
		<div class="page-side">
			<div class="inner-wrapper vcenter-wrapper">
				<div class="side-content vcenter">
					<h1 class="title">
						<?php the_title(); ?>
					</h1>

					<div>
					<?php while( have_posts() ) : the_post(); ?>
						
						<?php the_content(); ?>
					
					<?php endwhile; ?>
					</div>
					

					<div class="contact-detail">
						<h5 class="bordered-fine"><?php _e('Location','toranj'); ?></h5>
						<?php echo ot_get_option('contact_location','input your contact location at admin > appearance > theme options'); ?>
					</div>
						
					<div class="contact-detail">
						<h5 class="bordered-fine"><?php _e('Contact','toranj'); ?></h5>
						<ul class="list-iconed">
							<?php

							$contacts = ot_get_option('contact_contact','');
							if (!empty($contacts)){
								foreach (ot_get_option('contact_contact') as $contacts) {
									echo '<li><i class="fa '.$contacts['icon'].'"></i>'.$contacts['contact'].'</li>';
								}
							}
							?>
						</ul>
					</div>
					
					<?php 
					$socials = ot_get_option('social_icons');
					if (!empty($socials)){
					?>
					<div class="contact-detail">
						<h5 class="bordered-fine"><?php _e('Socials','toranj'); ?></h5>
						<ul class="social-icons">
							<?php toranj_social_icons();?>
						</ul>
					</div>
					<?php
					}
					?>
					
				</div>
			</div>
		</div>
		<!-- Sidebar -->

		<!-- Main Content -->
		<div class="page-main">
			<?php
				$center_address = ot_get_option('contact_address','');
				$address_array[]=$center_address;
				if ((ot_get_option('contact_multiple_markers','off')=='on')){
					$extra_addresses=ot_get_option('contact_extra_markers','');
					if (!empty($extra_addresses)){
						foreach ($extra_addresses as $address) {
							$address_array[]=$address['extra_address'];
						}
					}
				}

				$contact_fit_map=(ot_get_option('contact_fit_map')=="on")?"true":"false";

			?>
			<div id="gmap" class="gmap-full" data-address='<?php echo json_encode($address_array);?>' data-map-fit='<?php echo $contact_fit_map;?>'></div>
		</div>
		<!-- /Main Content -->

	</div>
</div>
<!-- /Page main wrapper -->

<?php get_footer(); ?>