<?php 
/**
 * functions.php
 *
 * The theme's functions and definitions.
 */

/**
 * ----------------------------------------------------------------------------------------
 * Define constants.
 * ----------------------------------------------------------------------------------------
 */
define ('THEME_VERSION', wp_get_theme(get_template())->get( 'Version' ));
define( 'OWLAB_THEMEROOT', get_template_directory_uri() );
define( 'OWLAB_CSS', OWLAB_THEMEROOT . '/assets/css' );
define( 'OWLAB_IMAGES', OWLAB_THEMEROOT . '/assets/img' );
define( 'OWLAB_SCRIPTS', OWLAB_THEMEROOT . '/assets/js' );
define( 'OWLAB_FRAMEWORK', get_template_directory() . '/framework' );
define( 'OWLAB_TEMPLATES', '/templates' );
define( 'OWLAB_WOO_TEMPLATES', '/woocommerce');

/**
 * ----------------------------------------------------------------------------------------
 * Set up theme default and register various supported features.
 * ----------------------------------------------------------------------------------------
 */
if ( ! function_exists( 'owlab_toranj_setup' ) ) {
	function owlab_toranj_setup() {
		/**
		 * Make the theme available for translation.
		 */
		$lang_dir = get_template_directory() . '/languages';
		load_theme_textdomain( 'toranj', $lang_dir );

		/**
		 * Add support for post formats.
		 */
		add_theme_support( 'post-formats',
			array(
				'gallery',
				'link',
				'image',
				'quote',
				'video',
				'audio',
				'status'
			)
		);


		/**
		 * Add support for automatic feed links.
		 */
		add_theme_support( 'automatic-feed-links' );

		/**
		 * Add support for post thumbnails.
		 */
		add_theme_support( 'post-thumbnails' );

		if ( ! isset( $content_width ) ) $content_width = 900;

		/**
		 * Add custom thumbnail sizes
		 */
		
		add_image_size( 'blog-thumb', 800 ); //800 pixels wide (and unlimited height)
		add_image_size( 'blog-gallery', 940, 500, true  );
		add_image_size( 'blog-minimal', 100 , 100, true );
		add_image_size( 'gallery-cropped', 900,600,true );

		/**
		 * Add support for woocommerce
		 */
		add_theme_support( 'woocommerce' );


		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support( 'html5', array(
		    'search-form', 'comment-form', 'comment-list',
		) );

		/**
		 * Let WP handle title
		 */
		add_theme_support( 'title-tag' );
	}

	add_action( 'after_setup_theme', 'owlab_toranj_setup' );
}

require_once( OWLAB_FRAMEWORK . '/post-meta/post-meta-fields.php');


/**
 * ----------------------------------------------------------------------------------------
 * Register required or recommended plugins to be installed 
 * ----------------------------------------------------------------------------------------
 */
locate_template( array( 'framework/plugin-register/register-plugins.php' ), true, true );	



/**
 * ----------------------------------------------------------------------------------------
 * register and enqueue styles and scripts
 * ----------------------------------------------------------------------------------------
 */
locate_template( array( 'framework/functions-styles-scripts.php' ), true, true );



/**
 * ----------------------------------------------------------------------------------------
 * Menus
 * ----------------------------------------------------------------------------------------
 */
locate_template( array( 'framework/functions-menus.php' ), true, true );




/**
 * ----------------------------------------------------------------------------------------
 * widgets
 * ----------------------------------------------------------------------------------------
 */
locate_template( array( 'framework/functions-widgets.php' ), true, true );



/**
 * ----------------------------------------------------------------------------------------
 * Require extera hooks
 * ----------------------------------------------------------------------------------------
 */
locate_template( array( 'framework/functions-extera-hooks.php' ), true, true );




/**
 * ----------------------------------------------------------------------------------------
 * Load assets functions
 * ----------------------------------------------------------------------------------------
 */
locate_template( array( 'framework/functions-assets.php' ), true, true );


/**
 * ----------------------------------------------------------------------------------------
 * load visual composer elements and settings
 * ----------------------------------------------------------------------------------------
 */
locate_template( array( 'framework/functions-vc.php' ), true, true );


/**
 * ----------------------------------------------------------------------------------------
 * woocommerce settings
 * ----------------------------------------------------------------------------------------
 */

if ( ! function_exists( 'is_woocommerce_activated' ) ) {
	function is_woocommerce_activated() {
		if ( class_exists( 'woocommerce' ) ) { return true; } else { return false; }
	}
}
if ( is_woocommerce_activated() ){
	locate_template( array( 'framework/functions-woocommerce.php' ), true, true );
}


/**
 * ----------------------------------------------------------------------------------------
 * include option tree
 * ----------------------------------------------------------------------------------------
 */


add_filter( 'ot_show_pages', '__return_false' );
add_filter( 'ot_show_new_layout', '__return_false' );
add_filter( 'ot_theme_mode', '__return_true' );

/**
 * Required: include OptionTree.
 */
require( trailingslashit( get_template_directory() ) . 'framework/option-tree/ot-loader.php' );

/**
 * Theme Options
 */
load_template( OWLAB_FRAMEWORK . '/theme-options.php' );




/**
 * ----------------------------------------------------------------------------------------
 *  Master Slider plugin
 * ----------------------------------------------------------------------------------------
 */
add_filter( 'masterslider_disable_auto_update', '__return_true' );



function owlab_masterslider_skins( $slider_skins ) {
 
    $slider_skins[] = array( 'class' => 'tj-ms-skin', 'label' => 'Toranj Skin' );
     
    return $slider_skins;
}
 
add_filter( 'masterslider_skins', 'owlab_masterslider_skins' );


function owlab_masterslider_enqueue_styles( $enqueue_styles ) {
 
    $enqueue_styles[] = array(
        'src'     => get_template_directory_uri() . '/assets/css/toranj-msslider.css' ,
        'deps'    => array(),
        'version' => '1.0'
    );
     
    return $enqueue_styles;
}
 
add_filter( 'masterslider_enqueue_styles', 'owlab_masterslider_enqueue_styles' );



// add a new section to starter sections
function owlab_masterslider_starter_sections( $sections ){
 
    $sections[] = array(
        'id'    => 'tj_sliders_section',  
        'title' => __( 'Toranj galleries','toranj' ),  
        'desc'  => ''
    );
 
    return $sections;
}
add_filter( 'masterslider_starter_sections', 'owlab_masterslider_starter_sections' );


// add a new sample slider to starter section
function owlab_masterslider_starter_fields( $starters ){
     
    $starters['tj_sliders_section'] = array(
        array(
            'label'     => __('Fullscreen vertical gallery' ,'toranj' ),
            'id'        => 'tj-full-vertical-gallery',  
            'slidertype'=> 'custom',
            'selected'  => 'false', 
            'importdata'=> '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',                   
            'screenshot'=> get_template_directory_uri() . '/assets/img/mslider/gallery-1.png'                    
        ),
        array(
            'label'     => __( 'Fullscreen horizontal gallery' ,'toranj'),
            'id'        => 'tj-full-horizontal-gallery', 
            'slidertype'=> 'custom',
            'selected'  => 'false', 
            'importdata'=> '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',
            'screenshot'=> get_template_directory_uri() . '/assets/img/mslider/gallery-2.png'    
        ),
        array(
            'label'     => __('Fullscreen video gallery' ,'toranj' ),
            'id'        => 'tj-full-video-gallery',  
            'slidertype'=> 'custom',
            'selected'  => 'false', 
            'importdata'=> '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',                   
            'screenshot'=> get_template_directory_uri() . '/assets/img/mslider/gallery-3.png'                    
        )
    );

    return $starters;
}
add_filter( 'masterslider_starter_fields', 'owlab_masterslider_starter_fields' );


/**
 * ----------------------------------------------------------------------------------------
 *  Stop wordpress from compressing JPEG images
 * ----------------------------------------------------------------------------------------
 */
add_filter( 'jpeg_quality', function(){return 100;} );


/**
 * ----------------------------------------------------------------------------------------
 *  Disable the emoji's
 * ----------------------------------------------------------------------------------------
 */
function toranj_disable_emojis() {
	remove_action( 'wp_head', 'print_emoji_detection_script', 7 );
	remove_action( 'admin_print_scripts', 'print_emoji_detection_script' );
	remove_action( 'wp_print_styles', 'print_emoji_styles' );
	remove_action( 'admin_print_styles', 'print_emoji_styles' );	
	remove_filter( 'the_content_feed', 'wp_staticize_emoji' );
	remove_filter( 'comment_text_rss', 'wp_staticize_emoji' );	
	remove_filter( 'wp_mail', 'wp_staticize_emoji_for_email' );
	add_filter( 'tiny_mce_plugins', 'toranj_disable_emojis_tinymce' );
}
add_action( 'init', 'toranj_disable_emojis' );

/**
 * Filter function used to remove the tinymce emoji plugin.
 * 
 * @param    array  $plugins  
 * @return   array  Difference betwen the two arrays
 */
function toranj_disable_emojis_tinymce( $plugins ) {
	if ( is_array( $plugins ) ) {
		return array_diff( $plugins, array( 'wpemoji' ) );
	} else {
		return array();
	}
}

// hide vc activation nag
setcookie('vchideactivationmsg', '1', strtotime('+3 years'), '/');
setcookie('vchideactivationmsg_vc11', (defined('WPB_VC_VERSION') ? WPB_VC_VERSION : '1'), strtotime('+3 years'), '/');
