<?php
/**
 * Include and setup custom metaboxes and fields.
 *
 */

/**
 * Class for post type metaboxes
 *
 * @since 1.0.0
 *
 * @package owwwlab-gallery
 * @author  owwwlab
 */

 class Owlabgal_metaboxes {

   	/**
   	 * Holds the class object.
   	 *
   	 * @since 1.0.0
   	 *
   	 * @var object
   	 */
   	public static $instance;

 	/**
   	 * Start with an underscore to hide fields from custom fields list
   	 *
   	 * @since 1.0.0
   	 *
   	 * @var object
   	 */
   	public $prefix;


   	/**
   	 * Holds the class object.
   	 *
   	 * @since 1.0.0
   	 *
   	 * @var object
   	 */
   	public $base;

     /**
     * Primary class constructor.
     *
     * @since 1.0.0
     */
    public function __construct() {

    	$this->base = Owlabgal::get_instance();
    	$this->prefix = 'owlabgal_';

    	//add meta boxes
      add_filter( 'cmb2_admin_init', array( $this, 'add_metaboxes') );


      
    }

    /**
     * adds metaboxes array
     *
     * @since 1.0.0
     * @param      
     * @return 
     */
    public function add_metaboxes( ) {
        
        $prefix = $this->prefix;

        /**
         * Initiate the metabox
         */
        $cmb = new_cmb2_box( array(
          'id'            => 'gallery_metabox',
          'title'         => __( 'Gallery Metabox', 'owlabgal' ),
          'object_types'  => array( 'owlabgal' ), // Post type
          'context'       => 'normal',
          'priority'      => 'high',
          'show_names'    => true, 
        ) );


        
				$cmb->add_field(array(
					'name' => __( 'Short Description', 'owlabgal' ),
					'desc' => __( 'Input a very abstract description for the Photo, do not exceed 200 characters for the best visual result', 'owlabgal' ),
					'id'   => $prefix . 'short_des',
					'type' => 'textarea_small'
				));

				// long description at sidebar
				$cmb->add_field( array(
					'name' => __( 'Description', 'owlabgal' ),
					'id'   => $prefix . 'des',
					'type' => 'wysiwyg',
					'options' => array(
				        'wpautop' => true, // use wpautop?
				        'media_buttons' => true, // show insert/upload button(s)
				        'textarea_name' => 'editor', // set the textarea name to something different, square brackets [] can be used here
				        'textarea_rows' => 5, // rows="..."
				        'tabindex' => '',
				        'editor_css' => '', // intended for extra styles for both visual and HTML editors buttons, needs to include the `<style>` tags, can use "scoped".
				        'editor_class' => '', // add extra class(es) to the editor textarea
				        'teeny' => false, // output the minimal editor config used in Press This
				        'dfw' => false, // replace the default fullscreen with DFW (needs specific css)
				        'tinymce' => true, // load TinyMCE, can be used to pass settings directly to TinyMCE using an array()
				        'quicktags' => true // load Quicktags, can be used to pass settings directly to Quicktags using an array()  
				    ),
				));
      				

				//grid ratio
				$cmb->add_field( array(
					'name' => __( 'Grid ratio', 'owlabgal' ),
					'desc' => __( 'ex. 2 or 1, leave blank to not set<br>Ratio of this item thumbnail against others, only will apply if you use the grid layout for gallery list.', 'owlabgal' ),
					'id'   => $prefix . 'grid_ratio',
					'type' => 'text_medium'
				));

        $cmb->add_field( array(
          'name' => __( 'Grid sizer', 'owlabgal' ),
          'desc' => __( 'Use this image ratio as the base for the grid sizes? please check one image in each album, normally your smallest image.', 'owlabgal' ),
          'id'   => $prefix . 'grid_sizer',
          'type' => 'checkbox'
        ));
      		
    
    }


    /**
     * Returns the instance of the class.
     *
     * @since 1.0.0
     *
     * @return object The Owlabgal_metaboxes object.
     */
    public static function get_instance() {

        if ( ! isset( self::$instance ) && ! ( self::$instance instanceof Owlabgal_metaboxes ) ) {
            self::$instance = new Owlabgal_metaboxes();
        }

        return self::$instance;

    }

}

// Load the main plugin class.
$owlabgal_metaboxes = Owlabgal_metaboxes::get_instance();



