/**
 * ----------------------------------------------------------------------------------------
 * Custom Media Upload Gallery Script 
 * by owwwlab
 * ----------------------------------------------------------------------------------------
 */
  jQuery(document).ready(function(){


        // media manager holder
        var owlab_media_manager;


        // when click on the upload button
        jQuery('.group_media_uploader_button').live('click' , function(e){


              // json field
              var field = jQuery(this).parent().find('.media_field_input');

              // gallery container
              var galleryWrapper = jQuery(this).parent().find('.image-container');


              e.preventDefault();

              // open the frame
              if(owlab_media_manager){

                  owlab_media_manager.open();
                  return ;
              }


              // create the media frame
              owlab_media_manager = wp.media.frames.owlab_media_manager = wp.media({

                    className : 'media-frame owlab-media-manager' ,
                    multiple: false,
                    title : 'Select Images' ,
                    button : {
                      text : 'Select'
                    }


              });


              owlab_media_manager.on('select', function(){
                      

                      //empty the field
                      galleryWrapper.html('');
                      field.val('');

                      var selection = owlab_media_manager.state().get('selection');
       
                        selection.map( function( attachment ) {
                       
                            attachment = attachment.toJSON();

                            // insert the images to the custom gallery interface
                            galleryWrapper.html(galleryWrapper.html()  +  '<div class="single-image"><span class="delete">X</span><img src="'+attachment.url+'" alt="'+attachment.id+'" /></div>');

                            // insert images to the hidden feild
                            if(field.val() != ''){

                                field.val(field.val() + ',' + attachment.url);
                            }
                            else{
                                field.val(attachment.url);
                            }
                      });

                      });

              // Now that everything has been set, let's open up the frame.
              owlab_media_manager.open();


        });
        // end upload script
        


       /* -------------------------------------------------------------- 
          Custom Gallery Interface 
          * this will grab the content from hidden meta field 
          * and convert it to gallery interface
          * Also will handle image delete process 
        -------------------------------------------------------------- */
        jQuery('.drop_meta_item_group .image-container').each(function(){

              var wrapper = jQuery(this);

              // get hidden field content
              var content = jQuery(this).parent().find('.media_field_input').val(function(index , value){
                      return value.replace(',,' , ',');
                    }).val();

              var contentArray = content.split(',');

              // map the content and create the gallery
              if(content != '') {

                    jQuery.map(contentArray , function(url){
                          
                          if(url !== '')
                          wrapper.html(wrapper.html() + '<div class="single-image"><span class="delete">X</span><img src="'+url+'" alt="" /></div>');

                    });

              }



              // delete image from gallery
              wrapper.find('.single-image span.delete').live('click' , function(){

                    // image url
                    var imageurl = jQuery(this).parent().find('img').attr('src');
                    wrapper.parent().find('.media_field_input').val(function(index , value){
                      return value.replace(imageurl + ',' , '').replace(imageurl , '');
                      
                    });


                    jQuery(this).parent().hide(400);

                    
                    
              });

        });






  });