<?php
namespace MasterlayerAddons\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Repeater;
use Elementor\Icons_Manager;
use Elementor\Scheme_Color;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Image_Size;
use Elementor\Modules\DynamicTags\Module as TagsModule;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

class MAE_Vertical_Lines_Widget extends Widget_Base {

    public function __construct($data = [], $args = null) {
        parent::__construct($data, $args);
    }

    // The get_name() method is a simple one, you just need to return a widget name that will be used in the code.
    public function get_name() {
        return 'mae-vertical-lines';
    }

    // The get_title() method, which again, is a very simple one, you need to return the widget title that will be displayed as the widget label.
    public function get_title() {
        return __( 'MAE - Vertical Lines', 'masterlayer' );
    }

    // The get_icon() method, is an optional but recommended method, it lets you set the widget icon. you can use any of the eicon or font-awesome icons, simply return the class name as a string.
    public function get_icon() {
        return 'eicon-lottie';
    }

    // The get_categories method, lets you set the category of the widget, return the category name as a string.
    public function get_categories() {
        return [ 'masterlayer-addons' ];
    }

    protected function register_controls() {
        // Content
            $this->start_controls_section( 'content_section',
                [
                    'label' => __( 'Lines', 'masterlayer' ),
                ]
            );

            $lines = new Repeater();

            $lines->add_responsive_control(
                'left_offset',
                [
                    'label'      => __( 'Left Offset', 'masterlayer' ),
                    'type'       => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 0,
                    ],
                    'selectors'  => [
                        '{{WRAPPER}} {{CURRENT_ITEM}}.line' => 'left: {{SIZE}}{{UNIT}};',
                    ],
                    50,
                    'render_type' => 'template'
                ]
            );

            $this->add_control(
                'lines',
                [
                    'type'        => Controls_Manager::REPEATER,
                    'fields'      => $lines->get_controls(),
                ]
            );

            $this->add_control(
                'line_color',
                [
                    'label' => __( 'Line Color', 'masterlayer' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .line' => 'background-color: {{VALUE}};',
                    ]
                ]
            );

            $this->end_controls_section();

    }

    protected function render() {
        $settings = $this->get_settings_for_display(); 
        $lines = $this->get_settings_for_display('lines'); 

        ?>
        <div class="master-vertical-lines">
            <?php foreach ($lines as $item) {
                $cls = 'elementor-repeater-item-' . $item['_id'];
                ?>
                <div class="line <?php echo esc_attr($cls); ?>"></div> 
            <?php } ?>
        </div>
        <?php
    }
}

