<?php

namespace MasterlayerAddons\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Plugin;
use Elementor\Repeater;
use Elementor\Icons_Manager;
use Elementor\Scheme_Color;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Modules\DynamicTags\Module as TagsModule;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

class MAE_Line_Dot_Animation_Widget extends Widget_Base{

    public function __construct($data = [], $args = null) {
        parent::__construct($data, $args);
    }

    // The get_name() method is a simple one, you just need to return a widget name that will be used in the code.
    public function get_name() {
        return 'mae-line-dot-animation';
    }
    
    public function get_script_depends() {
        return [ 'simplex-noise', 'gsap' ];
    }

    // The get_title() method, which again, is a very simple one, you need to return the widget title that will be displayed as the widget label.
    public function get_title() {
        return __( 'MAE - Grid Pattern', 'masterlayer' );
    }

    // The get_icon() method, is an optional but recommended method, it lets you set the widget icon. you can use any of the eicon or font-awesome icons, simply return the class name as a string.
    public function get_icon() {
        return 'eicon-apps';
    }

    // The get_categories method, lets you set the category of the widget, return the category name as a string.
    public function get_categories() {
        return [ 'masterlayer-addons' ];
    }

	protected function register_controls() {
      
			// Content Accordion 
			$this->start_controls_section(
				'section__content',
				[
					'label' => __( 'Grid Pattern', 'masterlayer' ),
				]
			);
			
			$this->add_control(
                'width',
                [
                    'label' => __( 'Width', 'masterlayer' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 200
                    ],
                    'selectors' => [ 
                        '{{WRAPPER}} .master-line-dot-animation' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                    'render_type' => 'template'
                ]
            );
            
            $this->add_control(
                'height',
                [
                    'label' => __( 'Height', 'masterlayer' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 200
                    ],
                    'selectors' => [ 
                        '{{WRAPPER}} .master-line-dot-animation' => 'height: {{SIZE}}{{UNIT}};',
                    ],
                    'render_type' => 'template'
                ]
            );
            
            $this->add_control(
                'res',
                [
                    'label' => __( 'Spacing', 'masterlayer' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 10
                    ],
                    'render_type' => 'template'
                ]
            );
            
            $this->add_control(
	            'dot_heading',
	            [   
	                'label' => __( 'Items', 'masterlayer' ),
	                'type' => Controls_Manager::HEADING,
	                'separator' => 'after'
	            ]
	        );
	        
	        $this->add_control(
                'item_width',
                [
                    'label' => __( 'Width', 'masterlayer' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'selectors' => [ 
                        '{{WRAPPER}} .master-line-dot-animation .dot' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                    'render_type' => 'template'
                ]
            );
            
            $this->add_control(
                'item_height',
                [
                    'label' => __( 'Height', 'masterlayer' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'selectors' => [ 
                        '{{WRAPPER}} .master-line-dot-animation .dot' => 'height: {{SIZE}}{{UNIT}};',
                    ],
                    'render_type' => 'template'
                ]
            );
            
            $this->add_control(
				'item_color',
				[
					'label' => __( 'Color', 'masterlayer' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .master-line-dot-animation .dot' => 'background-color: {{VALUE}};',
					]
				]
			);
			
			$this->add_control(
	            'item_rounded',
	            [
	                'label' => __('Rounded', 'masterlayer'),
	                'type' => Controls_Manager::DIMENSIONS,
	                'size_units' => ['px', '%'],
	                'default' => [
	                    'unit' => 'px',
	                ],
	                'selectors' => [
	                    '{{WRAPPER}} .master-line-dot-animation .dot' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; overflow:hidden;',
	                ],
	            ]
	        );
			
			$this->end_controls_section();
			
		$this->start_controls_section( 'setting_carousel_section',
            [
                'label' => __( 'Settings', 'masterlayer' ),
                'tab' => Controls_Manager::TAB_SETTINGS,
            ]
        );
        
        $this->add_control(
            'noise',
            [
                'label' => __( 'Noise', 'masterlayer' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'default' => ['size' => 5],
                'render_type' => 'template'
            ]
        );
        
        $this->add_control(
            'scale',
            [
                'label'        => __( 'Scale', 'masterlayer' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'On', 'masterlayer' ),
                'label_off'    => __( 'Off', 'masterlayer' ),
                'return_value' => 'true',
                'default'      => 'false',
            ]
        );
        
        $this->add_control(
            'rotate',
            [
                'label'        => __( 'Rotate', 'masterlayer' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'On', 'masterlayer' ),
                'label_off'    => __( 'Off', 'masterlayer' ),
                'return_value' => 'true',
                'default'      => 'true',
            ]
        );
        
        $this->add_control(
            'translate',
            [
                'label'        => __( 'Translate', 'masterlayer' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'On', 'masterlayer' ),
                'label_off'    => __( 'Off', 'masterlayer' ),
                'return_value' => 'true',
                'default'      => 'false',
            ]
        );
        
        $this->add_control(
            'opacity',
            [
                'label'        => __( 'Opacity', 'masterlayer' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => __( 'On', 'masterlayer' ),
                'label_off'    => __( 'Off', 'masterlayer' ),
                'return_value' => 'true',
                'default'      => 'false',
            ]
        );
            
        $this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		$width = 200;
		$height = 200;
		$res = 10;
		if ( $settings['width']['size'] ) $width = $settings['width']['size'];
		if ( $settings['height']['size'] ) $height = $settings['height']['size'];
		if ( $settings['res']['size'] ) $res = $settings['res']['size'];
		$cols = round($width / $res);
		$rows = round($height / $res);
		$number = $cols * $rows; 
		
		$config = array();
		$config['width'] = $width;
		$config['height'] = $height;
		$config['res'] = $res;
		$settings['noise']['size'] && ($config['noise'] = $settings['noise']['size']);
		$config['scale'] = $settings['scale'] == 'true' ? true : false;
		$config['rotate'] = $settings['rotate'] == 'true' ? true : false;
		$config['translate'] = $settings['translate'] == 'true' ? true : false;
		$config['opacity'] = $settings['opacity'] == 'true' ? true : false;
		
		$data = 'data-config=\'' . json_encode( $config ) . '\'';
		?>

		<div class="master-line-dot-animation" <?php echo $data; ?>>
		    <?php for ($i = 0; $i < $number; $i++) {
		        echo '<span class="dot"></span>';
		    } ?>
	    </div>

	    <?php
	}
}

