<?php
/**
 * Shop setting for Customizer
 *
 * @package tombuild
 * @version 3.8.9
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Main Shop
$this->sections['tombuild_shop_general'] = array(
	'title' => esc_html__( 'Main Shop', 'tombuild' ),
	'panel' => 'tombuild_shop',
	'settings' => array(
		array(
			'id' => 'shop_layout_position',
			'default' => 'no-sidebar',
			'control' => array(
				'label' => esc_html__( 'Shop Layout Position', 'tombuild' ),
				'type' => 'select',
				'choices' => array(
					'sidebar-right' => esc_html__( 'Right Sidebar', 'tombuild' ),
					'sidebar-left'  => esc_html__( 'Left Sidebar', 'tombuild' ),
					'no-sidebar'    => esc_html__( 'No Sidebar', 'tombuild' ),
				),
				'desc' => esc_html__( 'Specify layout for main shop page.', 'tombuild' ),
				'active_callback' => 'tombuild_cac_has_woo',
			),
		),
		array(
			'id' => 'shop_featured_title',
			'default' => esc_html__( 'Our Shop', 'tombuild' ),
			'control' => array(
				'label' => esc_html__( 'Shop: Featured Title', 'tombuild' ),
				'type' => 'tombuild_textarea',
				'active_callback' => 'tombuild_cac_has_woo',
			),
		),
		array(
			'id' => 'shop_featured_title_background_img',
			'control' => array(
				'type' => 'image',
				'label' => esc_html__( 'Shop: Featured Title Background', 'tombuild' ),
				'active_callback' => 'tombuild_cac_has_woo',
			),
		),
		array(
			'id' => 'shop_products_per_page',
			'default' => 6,
			'control' => array(
				'label' => esc_html__( 'Products Per Page', 'tombuild' ),
				'type' => 'number',
				'active_callback' => 'tombuild_cac_has_woo',
			),
		),
		array(
			'id' => 'shop_columns',
			'default' => '3',
			'control' => array(
				'label' => esc_html__( 'Shop Columns', 'tombuild' ),
				'type' => 'select',
				'choices' => array(
					'2' => '2',
					'3' => '3',
					'4' => '4',
				),
				'active_callback' => 'tombuild_cac_has_woo',
			),
		),
		array(
			'id' => 'shop_item_bottom_margin',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Item Bottom Margin', 'tombuild' ),
				'description' => esc_html__( 'Example: 30px.', 'tombuild' ),
				'active_callback' => 'tombuild_cac_has_woo',
			),
			'inline_css' => array(
				'target' => '.products li',
				'alter' => 'margin-top',
			),
		),
	),
);

// Single Shop
$this->sections['tombuild_single_shop_general'] = array(
	'title' => esc_html__( 'Single Shop', 'tombuild' ),
	'panel' => 'tombuild_shop',
	'settings' => array(
		array(
			'id' => 'shop_single_layout_position',
			'default' => 'no-sidebar',
			'control' => array(
				'label' => esc_html__( 'Shop Single Layout Position', 'tombuild' ),
				'type' => 'select',
				'choices' => array(
					'sidebar-right' => esc_html__( 'Right Sidebar', 'tombuild' ),
					'sidebar-left'  => esc_html__( 'Left Sidebar', 'tombuild' ),
					'no-sidebar'    => esc_html__( 'No Sidebar', 'tombuild' ),
				),
				'desc' => esc_html__( 'Specify layout on the shop single page.', 'tombuild' ),
				'active_callback' => 'tombuild_cac_has_woo',
			),
		),
		array(
			'id' => 'shop_single_featured_title',
			'default' => esc_html__( 'Our Shop', 'tombuild' ),
			'control' => array(
				'label' => esc_html__( 'Shop Single: Featured Title', 'tombuild' ),
				'type' => 'text',
				'active_callback' => 'tombuild_cac_has_woo',
			),
		),
		array(
			'id' => 'shop_single_featured_title_background_img',
			'control' => array(
				'type' => 'image',
				'label' => esc_html__( 'Shop Single: Featured Title Background', 'tombuild' ),
				'active_callback' => 'tombuild_cac_has_woo',
			),
		),
		array(
			'id' => 'shop_realted_columns',
			'default' => '3',
			'control' => array(
				'label' => esc_html__( 'Related Product Columns', 'tombuild' ),
				'type' => 'select',
				'choices' => array(
					'0' => '0',
					'2' => '2',
					'3' => '3',
					'4' => '4',
				),
				'active_callback' => 'tombuild_cac_has_woo',
			),
		),
	),
);