<?php
/**
 * Services setting for Customizer
 *
 * @package tombuild
 * @version 3.8.9
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Service General
$this->sections['tombuild_services_general'] = array(
	'title' => esc_html__( 'General', 'tombuild' ),
	'panel' => 'tombuild_services',
	'settings' => array(
		array(
			'id' => 'tombuild_service_single_featured_title',
			'control' => array(
				'type' => 'tombuild-heading',
				'label' => esc_html__( 'Feature Title', 'tombuild' ),
			),
		),
		array(
			'id' => 'service_single_featured_title',
			'default' =>  '',
			'control' => array(
				'label' => esc_html__( 'Title', 'tombuild' ),
				'type' => 'text',
				'description' => esc_html__( 'If empty, it will be blog title by default.', 'tombuild' ),
			),
		),
		array(
			'id' => 'service_single_featured_title_background_img',
			'control' => array(
				'type' => 'image',
				'label' => esc_html__( 'Single Service: Featured Title Background', 'tombuild' ),
			),
		)
	),
);