<?php
/**
 * Layout setting for Customizer
 *
 * @package tombuild
 * @version 3.8.9
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Layout Style
$this->sections['tombuild_layout_style'] = array(
	'title' => esc_html__( 'Layout Site', 'tombuild' ),
	'panel' => 'tombuild_layout',
	'settings' => array(
		array(
			'id' => 'site_layout_style',
			'default' => 'full-width',
			'control' => array(
				'label' => esc_html__( 'Layout Style', 'tombuild' ),
				'type' => 'select',
				'choices' => array(
					'full-width' => esc_html__( 'Full Width','tombuild' ),
					'boxed' => esc_html__( 'Boxed','tombuild' )
				),
			),
		),
		array(
			'id' => 'site_layout_boxed_shadow',
			'control' => array(
				'label' => esc_html__( 'Box Shadow', 'tombuild' ),
				'type' => 'checkbox',
				'active_callback' => 'tombuild_cac_has_boxed_layout',
			),
		),
		array(
			'id' => 'site_layout_wrapper_margin',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Wrapper Margin', 'tombuild' ),
				'desc' => esc_html__( 'Top Right Bottom Left. Default: 30px 0px 30px 0px.', 'tombuild' ),
				'active_callback' => 'tombuild_cac_has_boxed_layout',
			),
			'inline_css' => array(
				'target' => '.site-layout-boxed #wrapper',
				'alter' => 'padding',
			),
		),
		array(
			'id' => 'wrapper_background_color',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Outer Background Color', 'tombuild' ),
				'type' => 'color',
				'active_callback' => 'tombuild_cac_has_boxed_layout',
			),
			'inline_css' => array(
				'target' => '.site-layout-boxed #wrapper',
				'alter' => 'background-color',
			),
		),
		array(
			'id' => 'wrapper_background_img',
			'control' => array(
				'label' => esc_html__( 'Outer Background Image', 'tombuild' ),
				'type' => 'image',
				'active_callback' => 'tombuild_cac_has_boxed_layout',
			),
		),
		array(
			'id' => 'wrapper_background_img_style',
			'default' => '',
			'control' => array(
				'label' => esc_html__( 'Outer Background Image Style', 'tombuild' ),
				'type'  => 'image',
				'type'  => 'select',
				'choices' => array(
					''             => esc_html__( 'Default', 'tombuild' ),
					'cover'        => esc_html__( 'Cover', 'tombuild' ),
					'center-top'        => esc_html__( 'Center Top', 'tombuild' ),
					'fixed-top'    => esc_html__( 'Fixed Top', 'tombuild' ),
					'fixed'        => esc_html__( 'Fixed Center', 'tombuild' ),
					'fixed-bottom' => esc_html__( 'Fixed Bottom', 'tombuild' ),
					'repeat'       => esc_html__( 'Repeat', 'tombuild' ),
					'repeat-x'     => esc_html__( 'Repeat-x', 'tombuild' ),
					'repeat-y'     => esc_html__( 'Repeat-y', 'tombuild' ),
				),
				'active_callback' => 'tombuild_cac_has_boxed_layout',
			),
		),
	),
);

// Layout Position
$this->sections['tombuild_layout_position'] = array(
	'title' => esc_html__( 'Layout Position', 'tombuild' ),
	'panel' => 'tombuild_layout',
	'settings' => array(
		array(
			'id' => 'site_layout_position',
			'default' => 'sidebar-right',
			'control' => array(
				'label' => esc_html__( 'Site Layout Position', 'tombuild' ),
				'type' => 'select',
				'choices' => array(
					'sidebar-right' => esc_html__( 'Right Sidebar', 'tombuild' ),
					'sidebar-left'  => esc_html__( 'Left Sidebar', 'tombuild' ),
					'no-sidebar'    => esc_html__( 'No Sidebar', 'tombuild' ),
				),
				'desc' => esc_html__( 'Specify layout for all pages on website. (e.g. pages, blog posts, single post, archives, etc ). Single page can override this setting in Page Settings elementor when edit.', 'tombuild' )
			),
		),
		array(
			'id' => 'custom_page_layout_position',
			'default' => 'no-sidebar',
			'control' => array(
				'label' => esc_html__( 'Custom Page Layout Position', 'tombuild' ),
				'type' => 'select',
				'choices' => array(
					'sidebar-right' => esc_html__( 'Right Sidebar', 'tombuild' ),
					'sidebar-left'  => esc_html__( 'Left Sidebar', 'tombuild' ),
					'no-sidebar'    => esc_html__( 'No Sidebar', 'tombuild' ),
				),
				'desc' => esc_html__( 'Specify layout for all custom pages.', 'tombuild' )
			),
		),
		array(
			'id' => 'single_post_layout_position',
			'default' => 'sidebar-right',
			'control' => array(
				'label' => esc_html__( 'Single Post Layout Position', 'tombuild' ),
				'type' => 'select',
				'choices' => array(
					'sidebar-right' => esc_html__( 'Right Sidebar', 'tombuild' ),
					'sidebar-left'  => esc_html__( 'Left Sidebar', 'tombuild' ),
					'no-sidebar'    => esc_html__( 'No Sidebar', 'tombuild' ),
				),
				'desc' => esc_html__( 'Specify layout for all single post pages.', 'tombuild' )
			),
		),
		array(
			'id' => 'single_project_layout_position',
			'default' => 'no-sidebar',
			'control' => array(
				'label' => esc_html__( 'Single Project Layout Position', 'tombuild' ),
				'type' => 'select',
				'choices' => array(
					'sidebar-right' => esc_html__( 'Right Sidebar', 'tombuild' ),
					'sidebar-left'  => esc_html__( 'Left Sidebar', 'tombuild' ),
					'no-sidebar'    => esc_html__( 'No Sidebar', 'tombuild' ),
				),
				'desc' => esc_html__( 'Specify layout for all single project pages.', 'tombuild' ),
				'active_callback' => 'tombuild_cac_has_single_project',
			),
		),
		array(
			'id' => 'single_service_layout_position',
			'default' => 'no-sidebar',
			'control' => array(
				'label' => esc_html__( 'Single Service Layout Position', 'tombuild' ),
				'type' => 'select',
				'choices' => array(
					'sidebar-right' => esc_html__( 'Right Sidebar', 'tombuild' ),
					'sidebar-left'  => esc_html__( 'Left Sidebar', 'tombuild' ),
					'no-sidebar'    => esc_html__( 'No Sidebar', 'tombuild' ),
				),
				'desc' => esc_html__( 'Specify layout for all single service pages.', 'tombuild' ),
				'active_callback' => 'tombuild_cac_has_single_service',
			),
		),
		array(
			'id' => 'give_forms_layout_position',
			'default' => 'sidebar-right',
			'control' => array(
				'label' => esc_html__( 'Give Forms Layout Position', 'tombuild' ),
				'type' => 'select',
				'choices' => array(
					'sidebar-right' => esc_html__( 'Right Sidebar', 'tombuild' ),
					'sidebar-left'  => esc_html__( 'Left Sidebar', 'tombuild' ),
					'no-sidebar'    => esc_html__( 'No Sidebar', 'tombuild' ),
				),
				'desc' => esc_html__( 'Specify layout for all Give Forms.', 'tombuild' ),
				'active_callback' => 'tombuild_cac_has_give_forms',
			),
		),
	),
);

// Layout Widths
$this->sections['tombuild_layout_widths'] = array(
	'title' => esc_html__( 'Layout Widths', 'tombuild' ),
	'panel' => 'tombuild_layout',
	'settings' => array(
		array(
			'id' => 'site_desktop_container_width',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Container', 'tombuild' ),
				'type' => 'text',
				'desc' => esc_html__( 'Default: 1170px', 'tombuild' ),
			),
			'inline_css' => array(
				'target' => array( 
					'.site-layout-full-width .tombuild-container',
					'.site-layout-boxed #page'
				),
				'alter' => 'width',
			),
		),
		array(
			'id' => 'left_container_width',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Content', 'tombuild' ),
				'type' => 'text',
				'desc' => esc_html__( 'Example: 66%', 'tombuild' ),
			),
			'inline_css' => array(
				'target' => '#site-content',
				'alter' => 'width',
			),
		),
		array(
			'id' => 'sidebar_width',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Sidebar', 'tombuild' ),
				'type' => 'text',
				'desc' => esc_html__( 'Example: 28%', 'tombuild' ),
			),
			'inline_css' => array(
				'target' => '#sidebar',
				'alter' => 'width',
			),
		),
	),
);