<?php
/**
 * General setting for Customizer
 *
 * @package tombuild
 * @version 3.8.9
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Accent Colors
$this->sections['tombuild_Accent_Colors'] = array(
	'title' => esc_html__( 'Accent Colors', 'tombuild' ),
	'panel' => 'tombuild_general',
	'settings' => array(
		array(
			'id' => 'accent_color',
			'default' => '#2F3CA6',
			'control' => array(
				'label' => esc_html__( 'Accent Color', 'tombuild' ),
				'type' => 'color',
				'active_callback' => 'tombuild_cac_no_elementor_accent_color'
			),
		),
	)
);

// Cursor
$this->sections['tombuild_cursor'] = array(
	'title' => esc_html__( 'Custom Cursor', 'tombuild' ),
	'panel' => 'tombuild_general',
	'settings' => array(
		array(
			'id' => 'cursor',
			'default' => false,
			'control' => array(
				'label' => esc_html__( 'Enable', 'tombuild' ),
				'type' => 'checkbox',
			),
		),
		// cursor 1
		array(
			'id' => 'tombuild_cursor1_heading',
			'control' => array(
				'type' => 'tombuild-heading',
				'label' => esc_html__( 'Custom 1', 'tombuild' ),
				'active_callback' => 'tombuild_cac_has_cursor'
			),
		),
		array(
			'id' => 'tombuild_cursor1_target',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Target', 'tombuild' ),
				'active_callback' => 'tombuild_cac_has_cursor'
			),
		),
		array(
			'id' => 'tombuild_cursor1_text',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Text', 'tombuild' ),
				'active_callback' => 'tombuild_cac_has_cursor'
			),
		),
		array(
			'id' => 'tombuild_cursor1_classes',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Classes', 'tombuild' ),
				'active_callback' => 'tombuild_cac_has_cursor'
			),
		),
		// cursor 2
		array(
			'id' => 'tombuild_cursor2_heading',
			'control' => array(
				'type' => 'tombuild-heading',
				'label' => esc_html__( 'Custom 2', 'tombuild' ),
				'active_callback' => 'tombuild_cac_has_cursor_1'
			),
		),
		array(
			'id' => 'tombuild_cursor2_target',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Target', 'tombuild' ),
				'active_callback' => 'tombuild_cac_has_cursor_1'
			),
		),
		array(
			'id' => 'tombuild_cursor2_text',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Text', 'tombuild' ),
				'active_callback' => 'tombuild_cac_has_cursor_1'
			),
		),
		array(
			'id' => 'tombuild_cursor2_classes',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Classes', 'tombuild' ),
				'active_callback' => 'tombuild_cac_has_cursor_1'
			),
		),
		// cursor 3
		array(
			'id' => 'tombuild_cursor3_heading',
			'control' => array(
				'type' => 'tombuild-heading',
				'label' => esc_html__( 'Custom 3', 'tombuild' ),
				'active_callback' => 'tombuild_cac_has_cursor_1'
			),
		),
		array(
			'id' => 'tombuild_cursor3_target',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Target', 'tombuild' ),
				'active_callback' => 'tombuild_cac_has_cursor_2'
			),
		),
		array(
			'id' => 'tombuild_cursor3_text',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Text', 'tombuild' ),
				'active_callback' => 'tombuild_cac_has_cursor_2'
			),
		),
		array(
			'id' => 'tombuild_cursor3_classes',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Classes', 'tombuild' ),
				'active_callback' => 'tombuild_cac_has_cursor_2'
			),
		),
		// cursor 4
		array(
			'id' => 'tombuild_cursor4_heading',
			'control' => array(
				'type' => 'tombuild-heading',
				'label' => esc_html__( 'Custom 4', 'tombuild' ),
				'active_callback' => 'tombuild_cac_has_cursor_3'
			),
		),
		array(
			'id' => 'tombuild_cursor4_target',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Target', 'tombuild' ),
				'active_callback' => 'tombuild_cac_has_cursor_3'
			),
		),
		array(
			'id' => 'tombuild_cursor4_text',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Text', 'tombuild' ),
				'active_callback' => 'tombuild_cac_has_cursor_3'
			),
		),
		array(
			'id' => 'tombuild_cursor4_classes',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Classes', 'tombuild' ),
				'active_callback' => 'tombuild_cac_has_cursor_3'
			),
		),
		// cursor 5
		array(
			'id' => 'tombuild_cursor5_heading',
			'control' => array(
				'type' => 'tombuild-heading',
				'label' => esc_html__( 'Custom 5', 'tombuild' ),
				'active_callback' => 'tombuild_cac_has_cursor_4'
			),
		),
		array(
			'id' => 'tombuild_cursor5_target',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Target', 'tombuild' ),
				'active_callback' => 'tombuild_cac_has_cursor_4'
			),
		),
		array(
			'id' => 'tombuild_cursor5_text',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Text', 'tombuild' ),
				'active_callback' => 'tombuild_cac_has_cursor_4'
			),
		),
		array(
			'id' => 'tombuild_cursor5_classes',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Classes', 'tombuild' ),
				'active_callback' => 'tombuild_cac_has_cursor_4'
			),
		),
	)
);

// PreLoader
$this->sections['tombuild_preloader'] = array(
	'title' => esc_html__( 'PreLoader', 'tombuild' ),
	'panel' => 'tombuild_general',
	'settings' => array(
		array(
			'id' => 'preloader',
			'default' => 'animsition',
			'control' => array(
				'label' => esc_html__( 'Preloader Option', 'tombuild' ),
				'type' => 'select',
				'choices' => array(
					'' => esc_html__( 'Disable','tombuild' ),
					'animsition' => esc_html__( 'Enable','tombuild' ),
				),
			),
		),
		array(
			'id' => 'preloader_style',
			'default' => 'default',
			'control' => array(
				'label' => esc_html__( 'Style', 'tombuild' ),
				'type' => 'select',
				'choices' => array(
					'default' => esc_html__( 'Default','tombuild' ),
					'image' => esc_html__( 'Image','tombuild' ),
				),
			),
		),
		array(
			'id' => 'preload_color_1',
			'default' => '#EE0D08',
			'control' => array(
				'label' => esc_html__( 'Color 1', 'tombuild' ),
				'type' => 'color',
				'active_callback' => 'tombuild_cac_preloader_default'
			),
			'inline_css' => array(
				'target' => '.animsition-loading',
				'alter' => 'border-top-color',
			),
		),
		array(
			'id' => 'preload_color_2',
			'default' => '#092357',
			'control' => array(
				'label' => esc_html__( 'Color 2', 'tombuild' ),
				'type' => 'color',
				'active_callback' => 'tombuild_cac_preloader_default'
			),
			'inline_css' => array(
				'target' => '.animsition-loading:before',
				'alter' => 'border-top-color',
			),
		),
		array(
			'id' => 'preloader_image',
			'default' => '',
			'control' => array(
				'label' => esc_html__( 'Preloader Image', 'tombuild' ),
				'active_callback' => 'tombuild_cac_preloader_image',
				'type' => 'image',
			),
		),
		array(
			'id' => 'tombuild_loader_class',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Animation Class', 'tombuild' ),
				'active_callback' => 'tombuild_cac_preloader_image'
			),
		),
	)
);

// Header Site
$header_style = array( '1' => esc_html__( 'Basic', 'tombuild' ) );
$header_special = array( '1' => esc_html__( 'Default', 'tombuild' ) );
$header_fixed = array( '1' => esc_html__( 'None', 'tombuild' ));
$args = array(  
    'post_type' => 'header',
    'post_status' => 'publish',
    'posts_per_page' => -1,
    'orderby' => 'title',
    'order' => 'ASC'
);

$loop = new WP_Query( $args ); 
while ( $loop->have_posts() ) : $loop->the_post(); 
	$header_style[get_the_id()] = get_the_title();
	$header_special[get_the_id()] = get_the_title();
	$header_fixed[get_the_id()] = get_the_title();
endwhile;
wp_reset_postdata();

$this->sections['tombuild_header_site'] = array(
	'title' => esc_html__( 'Header', 'tombuild' ),
	'panel' => 'tombuild_general',
	'settings' => array(
		array(
			'id' => 'header_site_style',
			'default' => '1',
			'control' => array(
				'label' => esc_html__( 'Header Style', 'tombuild' ),
				'type' => 'select',
				'choices' => $header_style,
				'desc' => esc_html__( 'Header Style for all pages on website. (e.g. pages, blog posts, single post, archives, etc ). Single page can override this setting in Page Settings Elementor when edit.', 'tombuild' )
			),
		),
		array(
			'id' => 'header_fixed',
			'default' => '1',
			'control' => array(
				'label' => esc_html__( 'Header Fixed', 'tombuild' ),
				'type' => 'select',
				'choices' => $header_fixed,
				'active_callback' => 'tombuild_cac_header_elementor_builder'
			),
		),
		array(
			'id' => 'header_float',
			'default' => false,
			'control' => array(
				'label' => esc_html__( 'Header Float?', 'tombuild' ),
				'type' => 'checkbox',
			),
		),
		array(
			'id' => 'tombuild_header_heading',
			'control' => array(
				'type' => 'tombuild-heading',
				'label' => esc_html__( 'Header for special page', 'tombuild' ),
				'active_callback' => 'tombuild_cac_header_elementor_builder'
			),
		),
		array(
			'id' => 'header_blog',
			'default' => '1',
			'control' => array(
				'label' => esc_html__( 'Header Blog', 'tombuild' ),
				'type' => 'select',
				'choices' => $header_special,
				'active_callback' => 'tombuild_cac_header_elementor_builder'
			),
		),
		array(
			'id' => 'header_blog_single',
			'default' => '1',
			'control' => array(
				'label' => esc_html__( 'Header Blog Single', 'tombuild' ),
				'type' => 'select',
				'choices' => $header_special,
				'active_callback' => 'tombuild_cac_header_elementor_builder'
			),
		),
		array(
			'id' => 'header_shop',
			'default' => '1',
			'control' => array(
				'label' => esc_html__( 'Header Shop', 'tombuild' ),
				'type' => 'select',
				'choices' => $header_special,
				'active_callback' => 'tombuild_cac_header_elementor_builder'
			),
		),
		array(
			'id' => 'header_product_single',
			'default' => '1',
			'control' => array(
				'label' => esc_html__( 'Header Product Single', 'tombuild' ),
				'type' => 'select',
				'choices' => $header_special,
				'active_callback' => 'tombuild_cac_header_elementor_builder'
			),
		),
		array(
			'id' => 'header_project_single',
			'default' => '1',
			'control' => array(
				'label' => esc_html__( 'Header Project Single', 'tombuild' ),
				'type' => 'select',
				'choices' => $header_special,
				'active_callback' => 'tombuild_cac_header_elementor_builder'
			),
		),
		array(
			'id' => 'header_service_single',
			'default' => '1',
			'control' => array(
				'label' => esc_html__( 'Header Service Single', 'tombuild' ),
				'type' => 'select',
				'choices' => $header_special,
				'active_callback' => 'tombuild_cac_header_elementor_builder'
			),
		),
	),
);

// Footer
$footer_style = array( '1' => esc_html__( 'Basic', 'tombuild' ) );
$footer_special = array( '1' => esc_html__( 'Default', 'tombuild' ) );
$args = array(  
    'post_type' => 'footer',
    'post_status' => 'publish',
    'posts_per_page' => -1,
    'orderby' => 'title',
    'order' => 'ASC'
);

$loop = new WP_Query( $args ); 
while ( $loop->have_posts() ) : $loop->the_post(); 
	$footer_style[get_the_id()] = get_the_title();
	$footer_special[get_the_id()] = get_the_title();
endwhile;
wp_reset_postdata();

$this->sections['tombuild_footer_site'] = array(
	'title' => esc_html__( 'Footer', 'tombuild' ),
	'panel' => 'tombuild_general',
	'settings' => array(
		array(
			'id' => 'footer_site_style',
			'default' => '1',
			'control' => array(
				'label' => esc_html__( 'Footer Style', 'tombuild' ),
				'type' => 'select',
				'choices' => $footer_style,
				'desc' => esc_html__( 'Footer Style for all pages on website. (e.g. pages, blog posts, single post, archives, etc ). Single page can override this setting in Page Settings Elementor when edit.', 'tombuild' )
			),
		),
		array(
			'id' => 'tombuild_footer_heading',
			'control' => array(
				'type' => 'tombuild-heading',
				'label' => esc_html__( 'Footer for special page', 'tombuild' ),
				'active_callback' => 'tombuild_cac_footer_elementor_builder'
			),
		),
		array(
			'id' => 'footer_blog',
			'default' => '1',
			'control' => array(
				'label' => esc_html__( 'Footer Blog', 'tombuild' ),
				'type' => 'select',
				'choices' => $footer_special,
				'active_callback' => 'tombuild_cac_footer_elementor_builder'
			),
		),
		array(
			'id' => 'footer_blog_single',
			'default' => '1',
			'control' => array(
				'label' => esc_html__( 'Footer Blog Single', 'tombuild' ),
				'type' => 'select',
				'choices' => $footer_special,
				'active_callback' => 'tombuild_cac_footer_elementor_builder'
			),
		),
		array(
			'id' => 'footer_shop',
			'default' => '1',
			'control' => array(
				'label' => esc_html__( 'Footer Shop', 'tombuild' ),
				'type' => 'select',
				'choices' => $footer_special,
				'active_callback' => 'tombuild_cac_footer_elementor_builder'
			),
		),
		array(
			'id' => 'footer_product_single',
			'default' => '1',
			'control' => array(
				'label' => esc_html__( 'Footer Product Single', 'tombuild' ),
				'type' => 'select',
				'choices' => $footer_special,
				'active_callback' => 'tombuild_cac_footer_elementor_builder'
			),
		),
		array(
			'id' => 'footer_project_single',
			'default' => '1',
			'control' => array(
				'label' => esc_html__( 'Footer Project Single', 'tombuild' ),
				'type' => 'select',
				'choices' => $footer_special,
				'active_callback' => 'tombuild_cac_footer_elementor_builder'
			),
		),
		array(
			'id' => 'footer_service_single',
			'default' => '1',
			'control' => array(
				'label' => esc_html__( 'Footer Service Single', 'tombuild' ),
				'type' => 'select',
				'choices' => $footer_special,
				'active_callback' => 'tombuild_cac_footer_elementor_builder'
			),
		),
	),
);

// Scroll to top
$this->sections['tombuild_scroll_top'] = array(
	'title' => esc_html__( 'Scroll Top Button', 'tombuild' ),
	'panel' => 'tombuild_general',
	'settings' => array(
		array(
			'id' => 'scroll_top',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Enable', 'tombuild' ),
				'type' => 'checkbox',
			),
		),
	),
);

// Forms
$this->sections['tombuild_general_forms'] = array(
	'title' => esc_html__( 'Forms', 'tombuild' ),
	'panel' => 'tombuild_general',
	'settings' => array(
		array(
			'id' => 'input_border_rounded',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Border Rounded', 'tombuild' ),
			),
			'inline_css' => array(
				'target' => array(
					'textarea,input[type="text"],input[type="password"],input[type="datetime"],input[type="datetime-local"],input[type="date"],input[type="month"],input[type="time"],input[type="week"],input[type="number"],input[type="email"],input[type="url"],input[type="search"],input[type="tel"],input[type="color"]',
				),
				'alter' => 'border-radius',
			),
		),
		array(
			'id' => 'input_background_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Background', 'tombuild' ),
			),
			'inline_css' => array(
				'target' => array(
					'textarea,input[type="text"],input[type="password"],input[type="datetime"],input[type="datetime-local"],input[type="date"],input[type="month"],input[type="time"],input[type="week"],input[type="number"],input[type="email"],input[type="url"],input[type="search"],input[type="tel"],input[type="color"]',
				),
				'alter' => 'background-color',
			),
		),
		array(
			'id' => 'input_border_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Border Color', 'tombuild' ),
			),
			'inline_css' => array(
				'target' => array(
					'textarea,input[type="text"],input[type="password"],input[type="datetime"],input[type="datetime-local"],input[type="date"],input[type="month"],input[type="time"],input[type="week"],input[type="number"],input[type="email"],input[type="url"],input[type="search"],input[type="tel"],input[type="color"]',
				),
				'alter' => 'border-color',
			),
		),
		array(
			'id' => 'input_border_width',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Border Width', 'tombuild' ),
				'description' => esc_html__( 'Enter a value in pixels. Example: 1px', 'tombuild' ),
			),
			'inline_css' => array(
				'target' => array(
					'textarea,input[type="text"],input[type="password"],input[type="datetime"],input[type="datetime-local"],input[type="date"],input[type="month"],input[type="time"],input[type="week"],input[type="number"],input[type="email"],input[type="url"],input[type="search"],input[type="tel"],input[type="color"]',
				),
				'alter' => 'border-width',
			),
		),
		array(
			'id' => 'input_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Color', 'tombuild' ),
			),
			'inline_css' => array(
				'target' => array(
					'textarea,input[type="text"],input[type="password"],input[type="datetime"],input[type="datetime-local"],input[type="date"],input[type="month"],input[type="time"],input[type="week"],input[type="number"],input[type="email"],input[type="url"],input[type="search"],input[type="tel"],input[type="color"]',
				),
				'alter' => 'color',
			),
		),
	),
);

// Responsive
$this->sections['tombuild_responsive'] = array(
	'title' => esc_html__( 'Responsive', 'tombuild' ),
	'panel' => 'tombuild_general',
	'settings' => array(
		// Mobile Logo
		array(
			'id' => 'heading_mobile_logo',
			'control' => array(
				'type' => 'tombuild-heading',
				'label' => esc_html__( 'Mobile Logo', 'tombuild' ),
				'active_callback' => 'tombuild_cac_header_basic'
			),
		),
		array(
			'id' => 'mobile_logo_width',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Mobile Logo: Width', 'tombuild' ),
				'description' => esc_html__( 'Example: 150px', 'tombuild' ),
				'active_callback' => 'tombuild_cac_header_basic'
			),
			'inline_css' => array(
				'media_query' => '(max-width: 991px)',
				'target' => '#site-logo',
				'alter' => 'max-width',
			),
		),
		array(
			'id' => 'mobile_logo_margin',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Mobile Logo: Margin', 'tombuild' ),
				'description' => esc_html__( 'Example: 20px 0px 20px 0px', 'tombuild' ),
				'active_callback' => 'tombuild_cac_header_basic'
			),
			'inline_css' => array(
				'media_query' => '(max-width: 991px)',
				'target' => '#site-logo-inner',
				'alter' => 'margin',
			),
		),
		// Mobile Menu
		array(
			'id' => 'heading_mobile_menu',
			'control' => array(
				'type' => 'tombuild-heading',
				'label' => esc_html__( 'Mobile Menu', 'tombuild' ),
				'active_callback' => 'tombuild_cac_header_basic'
			),
		),
		array(
			'id' => 'mobile_menu_item_height',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Item Height', 'tombuild' ),
				'description' => esc_html__( 'Example: 40px', 'tombuild' ),
				'active_callback' => 'tombuild_cac_header_basic'
			),
			'inline_css' => array(
				'target' => array(
					'#main-nav-mobi ul > li > a',
					'#main-nav-mobi .menu-item-has-children .arrow'
				),
				'alter' => 'line-height'
			),
		),
		array(
			'id' => 'mobile_menu_logo',
			'default' => '',
			'control' => array(
				'label' => esc_html__( 'Mobile Menu Logo', 'tombuild' ),
				'active_callback' => 'tombuild_cac_header_basic',
				'type' => 'image',
			),
		),
		array(
			'id' => 'mobile_menu_logo_width',
			'control' => array(
				'label' => esc_html__( 'Mobile Menu Logo: Width', 'tombuild' ),
				'type' => 'text',
				'active_callback' => 'tombuild_cac_header_basic'
			),
		),
		// Featured Title
		array(
			'id' => 'heading_featured_title',
			'control' => array(
				'type' => 'tombuild-heading',
				'label' => esc_html__( 'Mobile Featured Title', 'tombuild' ),
			),
		),
		array(
			'id' => 'mobile_featured_title_padding',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Padding', 'tombuild' ),
				'description' => esc_html__( 'Top Right Bottom Left.', 'tombuild' ),
				'active_callback' => 'tombuild_cac_has_featured_title',
			),
			'inline_css' => array(
				'media_query' => '(max-width: 991px)',
				'target' => '#featured-title .inner-wrap, #featured-title.centered .inner-wrap, #featured-title.creative .inner-wrap',
				'alter' => 'padding',
			),
		),
	)
);

// 404 Page
$this->sections['tombuild_404_page'] = array(
	'title' => esc_html__( '404 Page', 'tombuild' ),
	'panel' => 'tombuild_general',
	'settings' => array(
		array(
			'id' => '404_image',
			'default' => '',
			'control' => array(
				'label' => esc_html__( '404 Image', 'tombuild' ),
				'type' => 'image',
			),
		),
		array(
			'id' => '404_image_max_width',
			'control' => array(
				'label' => esc_html__( '404 Image: Width', 'tombuild' ),
				'type' => 'text',
			),
		),
	)
);
