<?php
/**
 * Featured Title setting for Customizer
 *
 * @package tombuild
 * @version 3.8.9
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Featured Title General
$this->sections['tombuild_featuredtitle_general'] = array(
	'title' => esc_html__( 'General', 'tombuild' ),
	'panel' => 'tombuild_featuredtitle',
	'settings' => array(
		array(
			'id' => 'featured_title',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Enable', 'tombuild' ),
				'type' => 'checkbox',
			),
		),
		array(
			'id' => 'featured_title_style',
			'default' => 'simple',
			'control' => array(
				'label'  => esc_html__( 'Style', 'tombuild' ),
				'type' => 'select',
				'choices' => array(
					'simple' => esc_html__( 'Simple', 'tombuild' ),
					'centered' => esc_html__( 'Centered', 'tombuild' ),
					'modern' => esc_html__( 'Modern', 'tombuild' ),
				),
				'active_callback' => 'tombuild_cac_has_featured_title',
			),
		),
		array(
			'id' => 'featured_title_padding',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Padding', 'tombuild' ),
				'description' => esc_html__( 'Example: 250px 0px 150px 0px', 'tombuild' ),
				'active_callback' => 'tombuild_cac_has_featured_title',
			),
			'inline_css' => array(
				'media_query' => '(min-width: 992px)',
				'target' => '#featured-title .inner-wrap',
				'alter' => 'padding',
			),
		),
		array(
			'id' => 'featured_title_background',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Background', 'tombuild' ),
				'active_callback' => 'tombuild_cac_has_featured_title',
			),
			'inline_css' => array(
				'target' => '#featured-title',
				'alter' => 'background-color',
			),
		),
		array(
			'id' => 'featured_title_background_img',
			'control' => array(
				'type' => 'image',
				'label' => esc_html__( 'Background Image', 'tombuild' ),
				'active_callback' => 'tombuild_cac_has_featured_title',
			),
		),
		array(
			'id' => 'featured_title_background_img_style',
			'default' => 'repeat',
			'control' => array(
				'label' => esc_html__( 'Background Image Style', 'tombuild' ),
				'type'  => 'image',
				'type'  => 'select',
				'choices' => array(
					''             => esc_html__( 'Default', 'tombuild' ),
					'cover'        => esc_html__( 'Cover', 'tombuild' ),
					'center-top'        => esc_html__( 'Center Top', 'tombuild' ),
					'fixed-top'    => esc_html__( 'Fixed Top', 'tombuild' ),
					'fixed'        => esc_html__( 'Fixed Center', 'tombuild' ),
					'fixed-bottom' => esc_html__( 'Fixed Bottom', 'tombuild' ),
					'repeat'       => esc_html__( 'Repeat', 'tombuild' ),
					'repeat-x'     => esc_html__( 'Repeat-x', 'tombuild' ),
					'repeat-y'     => esc_html__( 'Repeat-y', 'tombuild' ),
				),
				'active_callback' => 'tombuild_cac_has_featured_title',
			),
		),
	),
);

// Featured Title Headings
$this->sections['tombuild_featuredtitle_heading'] = array(
	'title' => esc_html__( 'Headings', 'tombuild' ),
	'panel' => 'tombuild_featuredtitle',
	'settings' => array(
		array(
			'id' => 'featured_title_heading',
			'default' => false,
			'control' => array(
				'label' => esc_html__( 'Enable', 'tombuild' ),
				'type' => 'checkbox',
				'active_callback' => 'tombuild_cac_has_featured_title',
			),
		),
		array(
			'id' => 'featured_title_heading_bottom_margin',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Heading Bottom Margin', 'tombuild' ),
				'active_callback' => 'tombuild_cac_has_featured_title_center',
				'description' => esc_html__( 'Example: 30px.', 'tombuild' ),
			),
			'inline_css' => array(
				'target' => '#featured-title.centered .title-group',
				'alter' => 'margin-bottom',
			),
		),
		array(
			'id' => 'featured_title_heading_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Title Color', 'tombuild' ),
				'active_callback' => 'tombuild_cac_has_featured_title_heading',
			),
			'inline_css' => array(
				'target' => '#featured-title .main-title',
				'alter' => 'color',
			),
		),
	),
);

// Featured Title Breadcrumbs
$this->sections['tombuild_featuredtitle_breadcrumbs'] = array(
	'title' => esc_html__( 'Breadcrumbs', 'tombuild' ),
	'panel' => 'tombuild_featuredtitle',
	'settings' => array(
		array(
			'id' => 'featured_title_breadcrumbs',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Enable', 'tombuild' ),
				'type' => 'checkbox',
				'active_callback' => 'tombuild_cac_has_featured_title',
			),
		),
		array(
			'id' => 'featured_title_breadcrumbs_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Text Color', 'tombuild' ),
				'active_callback' => 'tombuild_cac_has_featured_title_breadcrumbs',
			),
			'inline_css' => array(
				'target' => array(
					'#featured-title #breadcrumbs',
				),
				'alter' => 'color',
			),
		),
		array(
			'id' => 'featured_title_breadcrumbs_link_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Link Color', 'tombuild' ),
				'active_callback' => 'tombuild_cac_has_featured_title_breadcrumbs',
			),
			'inline_css' => array(
				'target' => '#featured-title #breadcrumbs a',
				'alter' => 'color',
			),
		),
		array(
			'id' => 'featured_title_breadcrumbs_link_hover_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Link Color: Hover', 'tombuild' ),
				'active_callback' => 'tombuild_cac_has_featured_title_breadcrumbs',
			),
			'inline_css' => array(
				'target' => '#featured-title #breadcrumbs a:hover',
				'alter' => 'color',
			),
		),
		array(
			'id' => 'portfolio_page',
			'control' => array(
				'label'  => esc_html__( 'Projects', 'tombuild' ),
				'type' => 'select',
				'choices' => tombuild_get_pages(),
				'active_callback' => 'tombuild_cac_has_single_project',
			),
		),
	),
);