<?php
/**
 * Bottom Bar setting for Customizer
 *
 * @package tombuild
 * @version 3.8.9
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Bottom Bar General
$this->sections['tombuild_bottombar_general'] = array(
	'title' => esc_html__( 'General', 'tombuild' ),
	'panel' => 'tombuild_bottombar',
	'settings' => array(
		array(
			'id' => 'bottom_bar',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Enable', 'tombuild' ),
				'type' => 'checkbox',
				'active_callback' => 'tombuild_cac_footer_basic'
			),
		),
		array(
			'id' => 'bottom_copyright',
			'transport' => 'postMessage',
			'default' => '&copy; Copyrights, 2023 Company.com',
			'control' => array(
				'label' => esc_html__( 'Copyright', 'tombuild' ),
				'type' => 'tombuild_textarea',
				'active_callback' => 'tombuild_cac_has_bottombar',
			),
		),
		array(
			'id' => 'bottom_padding',
			'transport' => 'postMessage',
			'control' =>  array(
				'type' => 'text',
				'label' => esc_html__( 'Padding', 'tombuild' ),
				'description' => esc_html__( 'Top Right Bottom Left.', 'tombuild' ),
				'active_callback'=> 'tombuild_cac_has_bottombar',
			),
			'inline_css' => array(
				'target' => '#bottom .bottom-bar-inner-wrap',
				'alter' => 'padding',
			),
		),
		array(
			'id' => 'bottom_background',
			'transport' => 'postMessage',
			'control' =>  array(
				'type' => 'color',
				'label' => esc_html__( 'Background', 'tombuild' ),
				'active_callback'=> 'tombuild_cac_has_bottombar',
			),
			'inline_css' => array(
				'target' => '#bottom',
				'alter' => 'background',
			),
		),
		array(
			'id' => 'bottom_background_img',
			'control' => array(
				'type' => 'image',
				'label' => esc_html__( 'Background Image', 'tombuild' ),
				'active_callback' => 'tombuild_cac_has_bottombar',
			),
		),
		array(
			'id' => 'bottom_background_img_style',
			'default' => 'repeat',
			'control' => array(
				'label' => esc_html__( 'Background Image Style', 'tombuild' ),
				'type'  => 'image',
				'type'  => 'select',
				'choices' => array(
					''             => esc_html__( 'Default', 'tombuild' ),
					'cover'        => esc_html__( 'Cover', 'tombuild' ),
					'center-top'        => esc_html__( 'Center Top', 'tombuild' ),
					'fixed-top'    => esc_html__( 'Fixed Top', 'tombuild' ),
					'fixed'        => esc_html__( 'Fixed Center', 'tombuild' ),
					'fixed-bottom' => esc_html__( 'Fixed Bottom', 'tombuild' ),
					'repeat'       => esc_html__( 'Repeat', 'tombuild' ),
					'repeat-x'     => esc_html__( 'Repeat-x', 'tombuild' ),
					'repeat-y'     => esc_html__( 'Repeat-y', 'tombuild' ),
				),
				'active_callback' => 'tombuild_cac_has_bottombar',
			),
		),
		array(
			'id' => 'bottom_color',
			'transport' => 'postMessage',
			'control' =>  array(
				'type' => 'color',
				'label' => esc_html__( 'Color', 'tombuild' ),
				'active_callback'=> 'tombuild_cac_has_bottombar',
			),
			'inline_css' => array(
				'target' => '#bottom',
				'alter' => 'color',
			),
		),
		array(
			'id' => 'line_color',
			'transport' => 'postMessage',
			'control' =>  array(
				'type' => 'color',
				'label' => esc_html__( 'Line Color', 'tombuild' ),
				'active_callback'=> 'tombuild_cac_has_bottombar',
			),
			'inline_css' => array(
				'target' => '#bottom:before',
				'alter' => 'background-color',
			),
		),
	),
);

