<?php
$section = 'single_trip';
// Single trip
\Togo\Kirki::add_section('single_trip', array(
    'title'    => esc_html__('Single Trip', 'togo-framework'),
    'panel'    => $panel,
    'priority' => $priority++,
));

\Togo\Kirki::add_field('theme', [
    'type'     => 'notice',
    'settings' => 'single_trip_customize',
    'label'    => esc_html__('Review', 'togo-framework'),
    'section'  => $section,
    'priority' => $priority++,
]);

\Togo\Kirki::add_field('theme', array(
    'type'        => 'radio-buttonset',
    'settings'    => 'enable_approve_review',
    'label'       => esc_html__('Review approval', 'togo-framework'),
    'description' => esc_html__('Enable review approval when user submit review', 'togo-framework'),
    'section'     => $section,
    'priority'    => $priority++,
    'default'     => 'no',
    'choices'     => array(
        'no' => esc_html__('No', 'togo-framework'),
        'yes' => esc_html__('Yes', 'togo-framework'),
    ),
));

\Togo\Kirki::add_field('theme', array(
    'type'     => 'number',
    'settings' => 'single_trip_max_star',
    'label'    => esc_html__('Max Star', 'togo-framework'),
    'section'  => $section,
    'priority' => $priority++,
    'default'  => '5',
    'choices'  => [
        'min'  => 1,
        'max'  => 15,
        'step' => 1,
    ],
));

\Togo\Kirki::add_field('theme', array(
    'type'         => 'repeater',
    'settings'     => 'single_trip_reviews',
    'section'      => $section,
    'priority'     => $priority++,
    'button_label' => esc_html__('Add New', 'togo-framework'),
    'row_label'    => array(
        'type'  => 'field',
        'field' => 'text',
    ),
    'default'      => array(
        array(
            'text' => esc_attr__('Guide', 'togo-framework'),
        ),
        array(
            'text' => esc_attr__('Service', 'togo-framework'),
        ),
        array(
            'text' => esc_attr__('Transportation', 'togo-framework'),
        ),
        array(
            'text' => esc_attr__('Organization', 'togo-framework'),
        ),
    ),
    'fields'       => array(
        'text'       => array(
            'type'        => 'text',
            'label'       => esc_attr__('Text', 'togo-framework'),
            'default'     => '',
        ),
    ),
));

\Togo\Kirki::add_field('theme', array(
    'type'         => 'repeater',
    'label'        => esc_attr__('Customer Information Fields', 'togo-framework'),
    'settings'     => 'single_trip_customer_fields',
    'section'      => $section,
    'priority'     => $priority++,
    'button_label' => esc_html__('Add New', 'togo-framework'),
    'description' => esc_html__('Add fields for customer information when user book a trip', 'togo-framework'),
    'row_label'    => array(
        'type'  => 'field',
        'field' => 'label',
    ),
    'default'      => array(
        array(
            'label' => esc_attr__('Full Name', 'togo-framework'),
            'name' => 'full_name',
            'type' => 'text',
            'required' => 'yes',
            'placeholder' => esc_attr__('Enter your full name here', 'togo-framework'),
        ),
        array(
            'label' => esc_attr__('Age', 'togo-framework'),
            'name' => 'age',
            'type' => 'number',
            'required' => 'yes',
            'placeholder' => esc_attr__('Enter your age here', 'togo-framework'),
        ),
        array(
            'label' => esc_attr__('Passport/ID Number', 'togo-framework'),
            'name' => 'passport_id',
            'type' => 'text',
            'required' => 'yes',
            'placeholder' => esc_attr__('Enter your passport/ID number here', 'togo-framework'),
        ),
        array(
            'label' => esc_attr__('Verification Document', 'togo-framework'),
            'name' => 'verification_document',
            'type' => 'file',
            'required' => 'yes',
            'placeholder' => esc_attr__('Upload your verification document here', 'togo-framework'),
        ),
    ),
    'fields'       => array(
        'label'       => array(
            'type'        => 'text',
            'label'       => esc_attr__('Label', 'togo-framework'),
            'default'     => '',
        ),
        'name'       => array(
            'type'        => 'text',
            'label'       => esc_attr__('Field Name', 'togo-framework'),
            'default'     => 'field_' . uniqid(),
            'description' => esc_html__('Should only add the first time do not update to avoid errors', 'togo-framework'),

        ),
        'type'       => array(
            'type'        => 'select',
            'label'       => esc_attr__('Field Type', 'togo-framework'),
            'default'     => 'text',
            'choices'     => array(
                'text' => esc_attr__('Text', 'togo-framework'),
                'number' => esc_attr__('Number', 'togo-framework'),
                'textarea' => esc_attr__('Textarea', 'togo-framework'),
                'file' => esc_attr__('File', 'togo-framework'),
            ),
        ),
        'required'       => array(
            'type'        => 'radio',
            'label'       => esc_attr__('Required', 'togo-framework'),
            'description' => esc_attr__('Enable review approval when user submit review', 'togo-framework'),
            'default'     => 'no',
            'choices'     => array(
                'no' => esc_attr__('No', 'togo-framework'),
                'yes' => esc_attr__('Yes', 'togo-framework'),
            ),
        ),
        'placeholder'       => array(
            'type'        => 'text',
            'label'       => esc_attr__('Placeholder', 'togo-framework'),
            'default'     => '',
        ),
    ),
));