( function( api ) {
	'use strict';

	api.bind( 'ready', function() {
		
		/* Show / hide default headline options */
		
		api( 'boldthemes_theme_theme_options[default_headline_height]', function( setting ) {
			var linkSettingValueToControlActiveState;
			linkSettingValueToControlActiveState = function( control ) {

				var visibility = function() {
					switch ( setting.get() ) {
						case 'none':
							control.container.addClass( 'customize-control-disabled' );
							break;
						default:
							control.container.removeClass( 'customize-control-disabled' );
							break;
					}
				};
				// Set initial active state.
				visibility();
				// Update activate state whenever the setting is changed.
				setting.bind( visibility );
			};
			// Call linkSettingValueToControlActiveState on the border controls when they exist.
			api.control( 'default_headline_parallax', linkSettingValueToControlActiveState );
			api.control( 'default_headline_overlay', linkSettingValueToControlActiveState );
			api.control( 'default_headline_size', linkSettingValueToControlActiveState );
			api.control( 'default_headline_h_tag', linkSettingValueToControlActiveState );
			api.control( 'default_headline_width', linkSettingValueToControlActiveState );
			api.control( 'separator_default_headline_color_scheme', linkSettingValueToControlActiveState );
			api.control( 'default_headline_color_scheme', linkSettingValueToControlActiveState );
			api.control( 'default_headline_background_color', linkSettingValueToControlActiveState );
			api.control( 'default_headline_color', linkSettingValueToControlActiveState );
			api.control( 'page_single_show_superheadline', linkSettingValueToControlActiveState );
			api.control( 'page_single_show_subheadline', linkSettingValueToControlActiveState );
			api.control( 'page_single_share', linkSettingValueToControlActiveState );
			api.control( 'page_single_share_size', linkSettingValueToControlActiveState );
			api.control( 'page_single_share_style', linkSettingValueToControlActiveState );
			api.control( 'page_single_share_shape', linkSettingValueToControlActiveState );
			api.control( 'page_single_share_color_scheme', linkSettingValueToControlActiveState );
		});
		
		/* Show / hide preloader options */
		
		api( 'boldthemes_theme_theme_options[enable_preloader]', function( setting ) {
			var linkSettingValueToControlActiveState;
			linkSettingValueToControlActiveState = function( control ) {

				var visibility = function() {
					console.log( setting.get() );
					switch ( setting.get() ) {
						case false:
						case '0':
							control.container.addClass( 'customize-control-disabled' );
							break;
						default:
							control.container.removeClass( 'customize-control-disabled' );
							break;
					}
				};
				// Set initial active state.
				visibility();
				// Update activate state whenever the setting is changed.
				setting.bind( visibility );
			};
			// Call linkSettingValueToControlActiveState on the border controls when they exist.
			api.control( 'preloader_color_scheme', linkSettingValueToControlActiveState );
			api.control( 'preloader_background_color', linkSettingValueToControlActiveState );
			api.control( 'preloader_color', linkSettingValueToControlActiveState );
			api.control( 'preloader_transition', linkSettingValueToControlActiveState );
			api.control( 'preloader_animation', linkSettingValueToControlActiveState );
			api.control( 'preloader_logo', linkSettingValueToControlActiveState );
			api.control( 'preloader_text', linkSettingValueToControlActiveState );
		});
		
		/* Show / hide sticky options */
		
		api( 'boldthemes_theme_theme_options[enable_sticky]', function( setting ) {
			var linkSettingValueToControlActiveState;
			linkSettingValueToControlActiveState = function( control ) {

				var visibility = function() {
					console.log( setting.get() );
					switch ( setting.get() ) {
						case false:
						case '0':
							control.container.addClass( 'customize-control-disabled' );
							break;
						default:
							control.container.removeClass( 'customize-control-disabled' );
							break;
					}
				};
				// Set initial active state.
				visibility();
				// Update activate state whenever the setting is changed.
				setting.bind( visibility );
			};
			// Call linkSettingValueToControlActiveState on the border controls when they exist.
			api.control( 'sticky_style', linkSettingValueToControlActiveState );
			api.control( 'sticky_header_scroll_breakpoint', linkSettingValueToControlActiveState );
			api.control( 'sticky_logo', linkSettingValueToControlActiveState );
			api.control( 'sticky_header_width', linkSettingValueToControlActiveState );
			api.control( 'sticky_logo_height', linkSettingValueToControlActiveState );
			api.control( 'boldthemes_theme_separator_sticky_colors', linkSettingValueToControlActiveState );
			api.control( 'sticky_site_branding_bar_color_scheme', linkSettingValueToControlActiveState );
			api.control( 'sticky_site_branding_bar_background_color', linkSettingValueToControlActiveState );
			api.control( 'sticky_site_branding_bar_color', linkSettingValueToControlActiveState );
			api.control( 'sticky_menu_bar_color_scheme', linkSettingValueToControlActiveState );
			api.control( 'sticky_menu_bar_background_color', linkSettingValueToControlActiveState );
			api.control( 'sticky_menu_bar_color', linkSettingValueToControlActiveState );
			api.control( 'sticky_site_branding_bar_color', linkSettingValueToControlActiveState );
		});
		
		/* Show / hide sidebar options */
		
		/*api( 'boldthemes_theme_theme_options[sticky_header_scroll_breakpoint]', function( setting ) {
			var linkSettingValueToControlActiveState;
			linkSettingValueToControlActiveState = function( control ) {

				var visibility = function() {
					switch ( setting.get() ) {
						case '0':
							control.container.addClass( 'customize-control-disabled' );
							break;
						default:
							control.container.removeClass( 'customize-control-disabled' );
							break;
					}
				};
				// Set initial active state.
				visibility();
				// Update activate state whenever the setting is changed.
				setting.bind( visibility );
			};
			// Call linkSettingValueToControlActiveState on the border controls when they exist.
			api.control( 'sticky_logo', linkSettingValueToControlActiveState );
			api.control( 'sticky_header_width', linkSettingValueToControlActiveState );
			api.control( 'sticky_logo_height', linkSettingValueToControlActiveState );
			api.control( 'boldthemes_theme_separator_sticky_colors', linkSettingValueToControlActiveState );
			api.control( 'sticky_site_branding_bar_color_scheme', linkSettingValueToControlActiveState );
			api.control( 'sticky_site_branding_bar_background_color', linkSettingValueToControlActiveState );
			api.control( 'sticky_site_branding_bar_color', linkSettingValueToControlActiveState );
			api.control( 'sticky_menu_bar_color_scheme', linkSettingValueToControlActiveState );
			api.control( 'sticky_menu_bar_background_color', linkSettingValueToControlActiveState );
			api.control( 'sticky_menu_bar_color', linkSettingValueToControlActiveState );
		});*/
		
		/* Show / hide 404 options */
		
		api( 'boldthemes_theme_theme_options[error_404_page_slug]', function( setting ) {
			var linkSettingValueToControlActiveState;
			linkSettingValueToControlActiveState = function( control ) {

				var visibility = function() {
					switch ( setting.get() ) {
						case '':
							control.container.removeClass( 'customize-control-disabled' );
							break;
						default:
							control.container.addClass( 'customize-control-disabled' );
							break;
					}
				};
				// Set initial active state.
				visibility();
				// Update activate state whenever the setting is changed.
				setting.bind( visibility );
			};
			// Call linkSettingValueToControlActiveState on the border controls when they exist.
			api.control( 'error_404_background_image', linkSettingValueToControlActiveState );
			api.control( 'error_404_color', linkSettingValueToControlActiveState );
			api.control( 'error_404_background_color', linkSettingValueToControlActiveState );
			api.control( 'error_404_color_scheme', linkSettingValueToControlActiveState );
		});

	});

}( wp.customize ) );