<?php

class bt_bb_working_hours extends BT_BB_Element {

	function handle_shortcode( $atts, $content ) {
		extract( shortcode_atts( apply_filters( 'bt_bb_extract_atts', array(
			'wh_content'      	=> '',
			'button_style'		=> '',
			'button_shape'		=> '',
			'color_scheme' 		=> '',
			'target' 			=> ''
		) ), $atts, $this->shortcode ) );
		
		$class = array( $this->shortcode );
		
		if ( $el_class != '' ) {
			$class[] = $el_class;
		}

		$id_attr = '';
		if ( $el_id != '' ) {
			$id_attr = ' ' . 'id="' . esc_attr( $el_id ) . '"';
		}

		$color_scheme_id = NULL;
		if ( is_numeric ( $color_scheme ) ) {
			$color_scheme_id = $color_scheme;
		} else if ( $color_scheme != '' ) {
			$color_scheme_id = bt_bb_get_color_scheme_id( $color_scheme );
		}
		$color_scheme_colors = bt_bb_get_color_scheme_colors_by_id( $color_scheme_id - 1 );
		if ( $color_scheme_colors ) $el_style .= '; --button-primary-color:' . $color_scheme_colors[0] . '; --button-secondary-color:' . $color_scheme_colors[1] . ';';
		if ( $color_scheme != '' ) $class[] = $this->prefix . 'color_scheme_' .  $color_scheme_id;

		if ( $button_style != '' ) {
			$class[] = $this->prefix . 'button_style' . '_' . $button_style;
		}

		if ( $button_shape != '' ) {
			$class[] = $this->prefix . 'button_shape' . '_' . $button_shape;
		}

		$style_attr = '';
		if ( $el_style != '' ) {
			$style_attr = ' ' . 'style="' . esc_attr( $el_style ) . '"';
		}
		
		$class = apply_filters( $this->shortcode . '_class', $class, $atts );
		$class_attr = implode( ' ', $class );

		if ( $el_class != '' ) {
			$class_attr = $class_attr . ' ' . $el_class;
		}
		
		$output_inner = '';
		$has_link = '';
		$items_arr = preg_split( '/$\R?^/m', $wh_content );
		
		foreach ( $items_arr as $item ) {
			$output_inner .= '<div class="' . esc_attr( $this->shortcode ) . '_inner_row"><div class="' . esc_attr( $this->shortcode ) . '_inner_wrapper">';
			$item_arr = explode( ';', $item );
			$output_inner .= '<span class="' . esc_attr( $this->shortcode ) . '_inner_title">' . $item_arr[0] . '</span>';
			unset( $item_arr[0] );
			$link = array_pop($item_arr);
		
			foreach ( $item_arr as $inner_item ) {
				$output_inner .= '<span class="' . esc_attr( $this->shortcode ) . '_inner_content">' . $inner_item . '</span>';
			}

			if ( $link != '' && !ctype_space( $link ) ) {
				$link_arr = explode( ',', $link );
				$target_attr = ' target="_self" ';
				
				if ( $target != '' ) {
					$target_attr = ' ' . 'target="' . esc_attr( $target ) . '"';
				}

				$output_inner .= '<div class="' . esc_attr( $this->shortcode ) . '_inner_link">';
				$output_inner .=  '<a href="' . esc_attr( $link_arr[1] ) . '" title="' . esc_attr( $link_arr[0] ) . '" target="' . esc_attr( $target ) . '">' . $link_arr[0] . '</a>';
				$output_inner .= '</div>';
				$has_link = ' ' . $this->shortcode . '_has_link';
			}
			$output_inner .= '</div></div>';
		}

		$output = '<div class="btWorkingHours ' . $has_link . ' ' . esc_attr( $class_attr ) . '" ' . $style_attr . '>';
			$output .= '<div class="btWorkingHoursInner">';
				$output .= $output_inner;
			$output .= '</div>';
		$output .= '</div>';
		
		$output = apply_filters( 'bt_bb_general_output', $output, $atts );
		$output = apply_filters( $this->shortcode . '_output', $output, $atts );

		return $output;

	}

	function map_shortcode() {

		$color_scheme_arr = bt_bb_get_color_scheme_param_array();

		bt_bb_map( $this->shortcode, array( 'name' => esc_html__( 'Working Hours', 'vivo' ), 'description' => esc_html__( 'Working hours element', 'vivo' ), 'icon' => $this->prefix_backend . 'icon' . '_' . $this->shortcode, 'highlight' => true,
			'params' => array(
				array( 'param_name' => 'wh_content', 'type' => 'textarea', 'heading' => esc_html__( 'Working Hours', 'vivo' ) , 'description' => esc_html__( 'Insert value;value;URL title,URL separated by new line (leave ; at the end to remove Button link) - e.g. Mon;8AM-9PM;Contact Us,contact', 'vivo' ) 
				),
				array( 'param_name' => 'color_scheme', 'type' => 'dropdown', 'heading' => esc_html__( 'Color scheme', 'vivo' ), 'value' => $color_scheme_arr, 'preview' => true ),
				array( 'param_name' => 'button_style', 'type' => 'dropdown', 'heading' => esc_html__( 'Button style', 'vivo' ), 
					'value' => array(
						esc_html__( 'Filled', 'vivo' ) 			=> '',
						esc_html__( 'Filled gradient', 'vivo' ) 	=> 'filled_gradient'
					) 
				),
				array( 'param_name' => 'button_shape', 'type' => 'dropdown', 'heading' => esc_html__( 'Button shape', 'vivo' ), 
					'value' => array(
						esc_html__( 'Inherit', 'vivo' ) 					=> '',
						esc_html__( 'Square', 'vivo' ) 					=> 'square',
						esc_html__( 'Soft Rounded', 'vivo' ) 			=> 'soft-rounded',
						esc_html__( 'Hard Rounded', 'vivo' ) 			=> 'hard-rounded'
					)
				),
				array( 'param_name' => 'target', 'type' => 'dropdown', 'heading' => esc_html__( 'URL Target', 'vivo' ),
					'value' => array(
						esc_html__( 'Self (open in same tab)', 'vivo' ) 	=> '_self',
						esc_html__( 'Blank (open in new tab)', 'vivo' ) 	=> '_blank',
					)
				),
			)
		) );
	}
}