<?php

class bt_bb_timetable extends BT_BB_Element {

	function handle_shortcode( $atts, $content ) {
		extract( shortcode_atts( apply_filters( 'bt_bb_extract_atts', array(
		'columns'				=> '',
		'events'				=> '',
		'category'				=> '',
		'disable_event_url' 	=> '',
		'text_align'			=> '',
		'text_align_vertical'	=> '',
		'show_title'			=> '',
		'show_time'				=> '',
		'show_subtitle'			=> '',
		'show_description'		=> '',
		'show_event_head'		=> '',
		'show_additional_button'	=> '',
		'additional_button_label'	=> '',
		) ), $atts, $this->shortcode ) );

		$class = array( $this->shortcode );
		
		
		if ( file_exists( plugin_dir_url( '' ) . 'mp-timetable/mp-timetable.php' ) ) {
			require_once( 'mp-timetable.php' );
		}
		

		if ( $el_class != '' ) {
			$class[] = $el_class;
		}

		$id_attr = '';
		if ( $el_id != '' ) {
			$id_attr = ' ' . 'id="' . esc_attr( $el_id ) . '"';
		}

		$style_attr = '';
		if ( $el_style != '' ) {
			$style_attr = ' ' . 'style="' . esc_attr( $el_style ) . '"';
		}
		
		
		$class = apply_filters( $this->shortcode . '_class', $class, $atts );
		
		
		// Events (check if some event doesn't have time)
		$events_num_input = count(explode(", ", $events));
		$show_shortcode = 1;
		
		if ( ! function_exists( 'get_all_events()' ) ) {
			
			if (class_exists('mp_timetable\classes\models\Events')) {
			
				$e = new mp_timetable\classes\models\Events;
				
				$event = $e->get_all_events();
				
				$events_data_all = array();
				
				foreach ($event as $key => $data) {
					$events_data_all = $e->get( 'events' )->get_events_data( array( 'column' => 'event_id', 'id' => $data->ID ) );
				}
				
				$events_num_get = count($events_data_all);
				
				if ($events_num_input > $events_num_get) {
					$show_shortcode = 0;
				}
			}
		}
		
		
		if ($show_shortcode != 0) {

			$category2 = "";
		
			$columns2 = preg_replace('/\s+/', '', $columns);
			$events2 = preg_replace('/\s+/', '', $events);
			$category2 = preg_replace('/\s+/', '', $category);
			
			
			$shortcode_txt = '[mp-timetable col="' . rtrim($columns2,',') . '" events="' . rtrim($events2,',') . '"';
			if ($category2 != "") {
				$shortcode_txt .= ' event_categ="' . rtrim($category2,',') . '"';
			}
			
			if ($show_title != "") {
				$shortcode_txt .= ' title="' . esc_attr( $show_title ) . '"';
			}
			
			if ($show_time != "") {
				$shortcode_txt .= ' time="' . esc_attr( $show_time ) . '"';
			}
			
			if ($show_subtitle != "") {
				$shortcode_txt .= ' sub-title="' . esc_attr( $show_subtitle ) . '"';
			}
			
			if ($show_description != "") {
				$shortcode_txt .= ' description="' . esc_attr( $show_description ) . '"';
			}
			
			if ($show_event_head != "") {
				$shortcode_txt .= ' user="' . esc_attr( $show_event_head ) . '"';
			}
			
			$shortcode_txt .= ' row_height="60" font_size="" increment="1" view="none" label="All Events" hide_label="1" hide_hrs="0" hide_empty_rows="1" group="0" disable_event_url="' . esc_attr( $disable_event_url ) . '" text_align="' . esc_attr( $text_align ) . '" text_align_vertical="' . esc_attr( $text_align_vertical ) . '" id="" custom_class="" responsive="1" aa="1"]';
			
			if ( $show_additional_button != "" ) {
				$this->bt_bb_timetable_additional_button_label	= $additional_button_label;
				$this->bt_bb_timetable_disable_event_url		= $disable_event_url;
				add_filter( 'bt_bb_mpt_custom_content_item', array( $this, 'bt_bb_mpt_custom_content_item_callback' ), 10, 1 );

				if (class_exists('mp_timetable\plugin_core\classes\Hooks')) {
					// remove existing action hook for responsive layout function in mp-timetable plugin
					remove_action( 'mptt_shortcode_template_content', 'mptt_shortcode_template_content_responsive_table', 30 );
					// add new action hook for responsive layout function in file: /assets/php/before_framework.php;  with filter
					add_action( 'mptt_shortcode_template_content', 'bt_bb_mptt_shortcode_responsive_content_callback', 30 );
					add_filter( 'bt_bb_mpt_custom_content_event', array( $this, 'bt_bb_mpt_custom_content_event_callback' ), 10, 1 );
				}
			}
			
			$shortcode = do_shortcode( $shortcode_txt );			
			
			$output = $shortcode;
		}
		else {
			$output = '<div><p>Timetable error - there\'s one event without time definied. Please go to Dashboard - Timetable and check if all the events have the time properly set.</p></div>';
		}

		$output = '<div' . ( $id_attr ) . ' class="' . implode( ' ', $class ) . '"' . ( $style_attr ) . '>' . ( $output ) . '</div>';
		
		
		$output = apply_filters( 'bt_bb_general_output', $output, $atts );
		$output = apply_filters( $this->shortcode . '_output', $output, $atts );


		return $output;
	}

	/*
	* Filter hook for template /mp-timetable/shortcodes/event-container.php ( table template )
	* Original template file: /plugins/mp-timetable/templates/shortcodes/event-container.php
	*/
	function bt_bb_mpt_custom_content_item_callback( $item ) {		
		$label				= $this->bt_bb_timetable_additional_button_label != '' ? $this->bt_bb_timetable_additional_button_label : esc_html__( 'Book Now', 'vivo' );
		$disable_event_url	= $this->bt_bb_timetable_disable_event_url;
		
		$disable_url = (bool) $item[ 'post' ]->timetable_disable_url || (bool) $disable_event_url;
		if ( !$disable_url ) { 
			$link	= $item[ 'post' ]->timetable_custom_url != "" ? esc_url( $item[ 'post' ]->timetable_custom_url ) : get_permalink( $item[ 'event_id' ] );
			
			echo '<a class="mptt-shortcode-additional-custom-link" title="' . esc_attr( $label ) . '" href="' . esc_url(  $link ) . '" class="event-title">' . esc_html( $label ) . '</a>';
			
		}
	}

	/*
	* Filter hook for function: bt_bb_mptt_shortcode_responsive_content_callback() ( responsive function template )
	* Function file: /assets/php/before_framework.php
	*/
	function bt_bb_mpt_custom_content_event_callback( $event ) {
		$label				= $this->bt_bb_timetable_additional_button_label != '' ? $this->bt_bb_timetable_additional_button_label : esc_html__( 'Book Now', 'vivo' );
		$disable_event_url	= $this->bt_bb_timetable_disable_event_url;

		$disable_url = (bool) $event->post->timetable_disable_url || (bool) $disable_event_url;
		if ( ! $disable_url ) { 
			$link	= $event->post->timetable_custom_url != "" ? esc_url( $event->post->timetable_custom_url ) : get_permalink( $event->event_id );
			
			echo '<div class="mptt-custom-button-wrapper"><a class="mptt-shortcode-additional-custom-link" title="' . esc_attr( $label ) . '" href="' . esc_url( $link ) . '" class="event-title">' . esc_html( $label ) . '</a></div>';
			
		}
	}
	

	function map_shortcode() {
		
		$columns_for_show = array();
		$events_for_show = array();
		$category_for_show = array();
		
		// Columns
		if ( ! function_exists( 'get_all_column' ) ) {
			
			if(class_exists('mp_timetable\classes\models\Column')){
			
				$c = new mp_timetable\classes\models\Column;
				
				$columns = $c->get_all_column();
				
				$colums_data = array();
				$columns_array = array();
				
				foreach ($columns as $key => $data) {
					$colums_data['ID'] = $data->ID;
					$colums_data['post_title'] = $data->post_title;
					
					$columns_array[] = $colums_data;
				}
				
				foreach ($columns_array as $key => $data) {
					$columns_for_show[ $data['post_title'] ] = $data[ 'ID' ] . ",";
				}
			}
		}
		
		
		// Events and Categories
		if ( ! function_exists( 'get_all_events()' ) ) {
			
			if (class_exists('mp_timetable\classes\models\Events')) {
			
				$e = new mp_timetable\classes\models\Events;
				
				$events = $e->get_all_events();
				
				$events_data = array();
				$events_array = array();
				
				foreach ($events as $key => $data) {
					$events_data['ID'] = $data->ID;
					$events_data['post_title'] = $data->post_title;
					
					$events_array[] = $events_data;
				}
				
				$events_for_show = array();
				$i = 1;
				foreach ($events_array as $key => $data) {
					$events_for_show[ $i . " " . $data[ 'post_title' ] ] = $data[ 'ID' ] . ",";
					$i++;
				}
				
				
				// Category
				
				if ( ! function_exists( 'get_terms()' ) ) {
					$category = get_terms( 'mp-event_category', 'orderby=count&hide_empty=0' );
					
					$category_data = array();
					$category_array = array();
				
					foreach ($category as $key => $data) {
						$category_data['term_id'] = $data->term_id;
						$category_data['name'] = $data->name;
						
						$category_array[] = $category_data;
					}
				
					$category_for_show = array();
					$i = 1;
					foreach ($category_array as $key => $data) {
						$category_for_show[ $i . " " . $data[ 'name' ] ] = $data[ 'term_id' ] . ",";
						$i++;
					}
				}
			}
		}
		
		
		bt_bb_map( $this->shortcode, array( 'name' => esc_html__( 'Timetable', 'vivo' ), 'description' => esc_html__( 'Shows the timetable content from the Timetable plugin.', 'vivo' ), 'icon' => 'bt_bb_icon_bt_bb_timetable',
			'params' => array(
				array( 'param_name' => 'columns', 'type' => 'checkbox_group', 'heading' => esc_html__( 'Choose columns', 'vivo' ), 'preview' => true,
				'value' => $columns_for_show ),
				array( 'param_name' => 'events', 'type' => 'checkbox_group', 'heading' => esc_html__( 'Choose events', 'vivo' ), 'preview' => true,
				'value' => $events_for_show ),
				array( 'param_name' => 'category', 'type' => 'checkbox_group', 'heading' => esc_html__( 'Choose category', 'vivo' ), 'preview' => true,
				'value' => $category_for_show ),
				array( 'param_name' => 'disable_event_url', 'type' => 'checkbox', 'value' => array( esc_html__( 'Yes', 'vivo' ) => 'disable_event_url' ), 'heading' => esc_html__( 'Disable event url', 'vivo' ), 'preview' => true
				),
				array( 'param_name' => 'text_align', 'type' => 'dropdown', 'heading' => esc_html__( 'Text align', 'vivo' ),
					'value' => array(
						esc_html__( 'Center', 'vivo' ) 		=> 'center',
						esc_html__( 'Left', 'vivo' ) 		=> 'left',
						esc_html__( 'Right', 'vivo' ) 		=> 'right'
					)
				),
				array( 'param_name' => 'text_align_vertical', 'type' => 'dropdown', 'heading' => esc_html__( 'Text align vertical', 'vivo' ),
					'value' => array(
						esc_html__( 'Default', 'vivo' ) 		=> 'default',
						esc_html__( 'Top', 'vivo' ) 			=> 'top',
						esc_html__( 'Middle', 'vivo' ) 		=> 'middle',
						esc_html__( 'Bottom', 'vivo' ) 		=> 'bottom'
					)
				),
				array( 'param_name' => 'show_title', 'type' => 'checkbox', 'value' => array( esc_html__( 'Yes', 'vivo' ) => 'show_title' ), 'heading' => esc_html__( 'Show title', 'vivo' ), 'preview' => true
				),
				array( 'param_name' => 'show_time', 'type' => 'checkbox', 'value' => array( esc_html__( 'Yes', 'vivo' ) => 'show_time' ), 'heading' => esc_html__( 'Show time', 'vivo' ), 'preview' => true
				),
				array( 'param_name' => 'show_subtitle', 'type' => 'checkbox', 'value' => array( esc_html__( 'Yes', 'vivo' ) => 'show_subtitle' ), 'heading' => esc_html__( 'Show subtitle', 'vivo' ), 'preview' => true
				),
				array( 'param_name' => 'show_description', 'type' => 'checkbox', 'value' => array( esc_html__( 'Yes', 'vivo' ) => 'show_description' ), 'heading' => esc_html__( 'Show description', 'vivo' ), 'preview' => true
				),
				array( 'param_name' => 'show_event_head', 'type' => 'checkbox', 'value' => array( esc_html__( 'Yes', 'vivo' ) => 'show_event_head' ), 'heading' => esc_html__( 'Show event head', 'vivo' ), 'preview' => true
				),
				array( 'param_name' => 'show_additional_button', 'type' => 'checkbox', 'value' => array( esc_html__( 'Yes', 'vivo' ) => 'show_additional_button' ), 'heading' => esc_html__( 'Show additional button', 'vivo' ), 'preview' => true
				),
				array( 'param_name' => 'additional_button_label', 'type' => 'textfield', 'heading' => esc_html__( 'Additional button label', 'vivo' ) ),
			)
		) );
	}
}