<?php

class bt_bb_service extends BT_BB_Element {

	function handle_shortcode( $atts, $content ) {
		extract( shortcode_atts( apply_filters( 'bt_bb_extract_atts_' . $this->shortcode, array(
			'icon'         => '',
			'supertitle'   => '',
			'title'        => '',
			'text'         => '',
			'url'          => '',
			'target'       => '',
			'color_scheme' => '',
			'style'        => '',
			'size'         => '',
			'shape'        => '',
			'align'        => '',
			'title_weight' => ''
		) ), $atts, $this->shortcode ) );

		$class = array( $this->shortcode );
		$data_override_class = array();

		if ( $el_class != '' ) {
			$class[] = $el_class;
		}

		$id_attr = '';
		if ( $el_id != '' ) {
			$id_attr = ' ' . 'id="' . esc_attr( $el_id ) . '"';
		}
		
		$color_scheme_id = NULL;
		if ( is_numeric ( $color_scheme ) ) {
			$color_scheme_id = $color_scheme;
		} else if ( $color_scheme != '' ) {
			$color_scheme_id = bt_bb_get_color_scheme_id( $color_scheme );
		}
		$color_scheme_colors = bt_bb_get_color_scheme_colors_by_id( $color_scheme_id - 1 );
		if ( $color_scheme_colors ) $el_style .= '; --primary-color:' . $color_scheme_colors[0] . '; --secondary-color:' . $color_scheme_colors[1] . ';';
		if ( $color_scheme != '' ) $class[] = $this->prefix . 'color_scheme_' .  $color_scheme_id;

		$style_attr = '';
		$el_style = apply_filters( $this->shortcode . '_style', $el_style, $atts );
		if ( $el_style != '' ) {
			$style_attr = ' ' . 'style="' . esc_attr( $el_style ) . '"';
		}		

		if ( $style != '' ) {
			$class[] = $this->prefix . 'style' . '_' . $style;
		}

		$this->responsive_data_override_class(
			$class, $data_override_class,
			array(
				'prefix' => $this->prefix,
				'param' => 'size',
				'value' => $size
			)
		);

		if ( $shape != '' ) {
			$class[] = $this->prefix . 'shape' . '_' . $shape;
		}

		if ( $title_weight != '' ) {
			$class[] = $this->prefix . 'title_weight' . '_' . $title_weight;
		}

		if ( $supertitle == '' ) {
			$class[] = 'btNoSupertitle';
		}

		if ( $text == '' ) {
			$class[] = 'bt-no-text';
		}

		if ( $title == '' ) {
			$class[] = 'btNoTitle';
		}
		
		if ( $target != '' ) {
			$class[] = $this->prefix . 'target' . $target;
		}
		
		if ( $target == '_lightbox' ) {
			$class[] = 'bt_bb_use_lightbox';
			$target = '_blank';
		}

		$this->responsive_data_override_class(
			$class, $data_override_class,
			array(
				'prefix' => $this->prefix,
				'param' => 'align',
				'value' => $align
			)
		);
		
		$link = bt_bb_get_url( $url );

		$icon_title = wp_strip_all_tags($title);
		
		$icon = bt_bb_icon::get_html( $icon, '', $link, $icon_title, $target );

		if ( $link != '' ) {
			if ( $title != '' ) $title = '<a href="' . esc_url( $link ) . '" target="' . esc_attr( $target ) . '">' . $title . '</a>';
		}
		
		foreach ( $this->extra_responsive_data_override_param as $p ) {
			if ( ! is_array( $atts ) || ! array_key_exists( $p, $atts ) ) continue;
			$this->responsive_data_override_class(
				$class, $data_override_class,
				apply_filters( $this->shortcode . '_responsive_data_override', array(
					'prefix' => $this->prefix,
					'param' => $p,
					'value' => $atts[ $p ],
				) )
			);
		}

		$class = apply_filters( $this->shortcode . '_class', $class, $atts );

		$output = $icon;

		$output .= '<div class="' . esc_attr( $this->shortcode ) . '_content">';
			if ( $supertitle != '' ) $output .= '<div class="' . esc_attr( $this->shortcode ) . '_content_supertitle">' . $supertitle . '</div>';
			if ( $title != '' ) $output .= '<div class="' . esc_attr( $this->shortcode ) . '_content_title">' . $title . '</div>';
			if ( $text != '' ) $output .= '<div class="' . esc_attr( $this->shortcode ) . '_content_text">' . nl2br( $text ) . '</div>';
		$output .= '</div>';

		$output = '<div' . $id_attr . ' class="' . esc_attr( implode( ' ', $class ) ) . '"' . $style_attr . ' data-bt-override-class="' . htmlspecialchars( json_encode( $data_override_class, JSON_FORCE_OBJECT ), ENT_QUOTES, 'UTF-8' ) . '">' . $output . '</div>';
		
		$output = apply_filters( 'bt_bb_general_output', $output, $atts );
		$output = apply_filters( $this->shortcode . '_output', $output, $atts );

		return $output;

	}

	function map_shortcode() {

		$color_scheme_arr = bt_bb_get_color_scheme_param_array();

		bt_bb_map( $this->shortcode, array( 'name' => esc_html__( 'Service', 'vivo' ), 'description' => esc_html__( 'Icon with text', 'vivo' ), 'icon' => $this->prefix_backend . 'icon' . '_' . $this->shortcode,
			'params' => array(
				array( 'param_name' => 'icon', 'type' => 'iconpicker', 'heading' => esc_html__( 'Icon', 'vivo' ), 'preview' => true ),
				array( 'param_name' => 'supertitle', 'type' => 'textfield', 'heading' => esc_html__( 'Supertitle', 'vivo' ) ),
				array( 'param_name' => 'title', 'type' => 'textfield', 'heading' => esc_html__( 'Title', 'vivo' ), 'preview' => true ),
				array( 'param_name' => 'text', 'type' => 'textarea', 'heading' => esc_html__( 'Text', 'vivo' ) ),
				array( 'param_name' => 'align', 'type' => 'dropdown', 'heading' => esc_html__( 'Icon position', 'vivo' ), 'responsive_override' => true,
					'value' => array(
						esc_html__( 'Inherit', 'vivo' ) 		=> 'inherit',
						esc_html__( 'Left', 'vivo' ) 		=> 'left',
						esc_html__( 'Center', 'vivo' ) 		=> 'center',
						esc_html__( 'Right', 'vivo' ) 		=> 'right'
					)
				),
				array( 'param_name' => 'url', 'type' => 'link', 'heading' => esc_html__( 'URL', 'vivo' ), 'group' => esc_html__( 'URL', 'vivo' ), 'description' => esc_html__( 'Enter full or local URL (e.g. https://www.bold-themes.com or /pages/about-us) or post slug (e.g. about-us) or search for existing content.', 'vivo' ) ),
				array( 'param_name' => 'target', 'type' => 'dropdown', 'heading' => esc_html__( 'Target', 'vivo' ), 'group' => esc_html__( 'URL', 'vivo' ),
					'value' => array(
						esc_html__( 'Self (open in same tab)', 'vivo' ) 			=> '_self',
						esc_html__( 'Blank (open in new tab)', 'vivo' ) 			=> '_blank',
						esc_html__( 'Lightbox (open in new layer)', 'vivo' ) 	=> '_lightbox',
					)
				),
				array( 'param_name' => 'size', 'type' => 'dropdown', 'heading' => esc_html__( 'Icon size', 'vivo' ), 'responsive_override' => true, 'preview' => true, 'group' => esc_html__( 'Design', 'vivo' ),
					'value' => array(
						esc_html__( 'Extra small', 'vivo' ) 		=> 'xsmall',
						esc_html__( 'Small', 'vivo' ) 			=> 'small',
						esc_html__( 'Normal', 'vivo' ) 			=> 'normal',
						esc_html__( 'Large', 'vivo' ) 			=> 'large',
						esc_html__( 'Extra large', 'vivo' ) 		=> 'xlarge'
					)
				),
				array( 'param_name' => 'color_scheme', 'type' => 'dropdown', 'heading' => esc_html__( 'Color scheme', 'vivo' ), 'description' => esc_html__( 'Define color schemes in Bold Builder settings or define accent and alternate colors in theme customizer (if avaliable)', 'vivo' ), 'value' => $color_scheme_arr, 'preview' => true, 'group' => esc_html__( 'Design', 'vivo' ) ),
				array( 'param_name' => 'style', 'type' => 'dropdown', 'heading' => esc_html__( 'Icon style', 'vivo' ), 'preview' => true, 'group' => esc_html__( 'Design', 'vivo' ),
					'value' => array(
						esc_html__( 'Outline', 'vivo' ) 			=> 'outline',
						esc_html__( 'Filled', 'vivo' ) 			=> 'filled',
						esc_html__( 'Borderless', 'vivo' ) 		=> 'borderless'
					)
				),
				array( 'param_name' => 'shape', 'type' => 'dropdown', 'heading' => esc_html__( 'Icon shape', 'vivo' ), 'group' => esc_html__( 'Design', 'vivo' ),
					'value' => array(
						esc_html__( 'Circle', 'vivo' ) 			=> 'circle',
						esc_html__( 'Square', 'vivo' ) 			=> 'square',
						esc_html__( 'Rounded Square', 'vivo' ) 	=> 'round'
					)
				),
				array( 'param_name' => 'title_weight', 'type' => 'dropdown', 'group' => esc_html__( 'Design', 'vivo' ), 'heading' => esc_html__( 'Title font weight', 'vivo' ), 
					'value' => array(
						esc_html__( 'Default', 'vivo' ) 		=> '',
						esc_html__( 'Normal', 'vivo' ) 		=> 'normal',
						esc_html__( 'Bold', 'vivo' ) 		=> 'bold',
						esc_html__( 'Bolder', 'vivo' ) 		=> 'bolder',
						esc_html__( 'Lighter', 'vivo' ) 		=> 'lighter',
						esc_html__( 'Light', 'vivo' ) 		=> 'light',
						esc_html__( 'Thin', 'vivo' ) 		=> 'thin',
						esc_html__( '100', 'vivo' ) 			=> '100',
						esc_html__( '200', 'vivo' ) 			=> '200',
						esc_html__( '300', 'vivo' ) 			=> '300',
						esc_html__( '400', 'vivo' ) 			=> '400',
						esc_html__( '500', 'vivo' ) 			=> '500',
						esc_html__( '600', 'vivo' ) 			=> '600',
						esc_html__( '700', 'vivo' ) 			=> '700',
						esc_html__( '800', 'vivo' ) 			=> '800',
						esc_html__( '900', 'vivo' ) 			=> '900'
					)
				),
			)
		) );
	}
}