<?php

class bt_bb_search extends BT_BB_Element {

	function handle_shortcode( $atts, $content ) {
		extract( shortcode_atts( apply_filters( 'bt_bb_extract_atts', array(
			'button_style'					=> '',
			'color_scheme'					=> '',		
			'button_font_weight'			=> '',		
			'icon'							=> '',		
			'input_style'					=> '',		
			'placeholder_style'				=> '',		
			'placeholder_text'				=> '',		
		) ), $atts, $this->shortcode ) );
		
		$class = array( $this->shortcode );
		$data_override_class = array();

		$placeholder_text = html_entity_decode( $placeholder_text, ENT_QUOTES, 'UTF-8' );

		if ( $el_class != '' ) {
			$class[] = $el_class;
		}

		$id_attr = '';
		if ( $el_id != '' ) {
			$id_attr = ' ' . 'id="' . esc_attr( $el_id ) . '"';
		}

		if ( $button_style != '' ) {
			$class[] = $this->prefix . 'button_style' . '_' . $button_style;
		}

		$color_scheme_id = NULL;
		if ( is_numeric ( $color_scheme ) ) {
			$color_scheme_id = $color_scheme;
		} else if ( $color_scheme != '' && function_exists( 'bt_bb_get_color_scheme_id' ) ) {
			$color_scheme_id = bt_bb_get_color_scheme_id( $color_scheme );
		}

		$color_scheme_colors = function_exists( 'bt_bb_get_color_scheme_colors_by_id' ) ? bt_bb_get_color_scheme_colors_by_id( $color_scheme_id - 1 ) : array();		
		if ( $color_scheme_colors ) $el_style .= '; --primary-color:' . $color_scheme_colors[0] . '; --secondary-color:' . $color_scheme_colors[1] . ';';
		if ( $color_scheme != '' ) $class[] = $this->prefix . 'color_scheme_' .  $color_scheme_id;
		
		if ( $button_font_weight != '' ) {
			$class[] = $this->prefix . 'button_font_weight' . '_' . $button_font_weight;
		}

		if ( $input_style != '' ) {
			$class[] = $this->prefix . 'input_style' . '_' . $input_style;
		}

		if ( $placeholder_style != '' ) {
			switch ( $placeholder_style ) {
				case 'full':
					$class[] = 'bt_bb_placeholder_style_full';
					break;
				case 'semitransparent':
					$class[] = 'bt_bb_placeholder_style_semitransparent';
					break;
			}
		}

		$output_icon = '';
		if ( $icon != '' && class_exists( 'bt_bb_icon' ) ) {
			if ( method_exists( 'bt_bb_icon', 'get_html' ) ){
				$output_icon = bt_bb_icon::get_html( $icon, '', '', '' );
			}
		}

		$class = apply_filters( $this->shortcode . '_class', $class, $atts );

		$style_attr = '';
		if ( $el_style != '' ) {
			$style_attr = ' ' . 'style="' . esc_attr( $el_style ) . '"';
		}

		$output = '';
		$output .= '<form role="search" method="get" class="search-form" action="' . esc_url( home_url( '/' ) ) . '">';
			$output .= '<label for="s">';
				$output .= '<span class="screen-reader-text">' . esc_attr( $placeholder_text ) . '</span>';
				$output .= '<input type="search" class="search-field" placeholder="' . esc_attr( $placeholder_text ) . '" value="' . get_search_query() . '" name="s" id="s" />';
			$output .= '</label>';
			$output .= '<button type="submit" class="search-submit">'. $output_icon . esc_attr_x( 'Search', 'Search form BB element', 'vivo' ) . '</button>';
		$output .= '</form>';
		$output = '<div' . $id_attr . ' class="' . implode( ' ', $class ) . '"' . $style_attr . '>' . $output . '</div>';

		$output = apply_filters( 'bt_bb_general_output', $output, $atts );
		$output = apply_filters( $this->shortcode . '_output', $output, $atts );

		return $output;

	}


	function map_shortcode() {
		
		$color_scheme_arr = bt_bb_get_color_scheme_param_array();

		bt_bb_map( $this->shortcode, array( 'name' => esc_html__( 'Search', 'vivo' ), 'description' => esc_html__( 'Element with a search input and button, for 404 or similar page.', 'vivo' ), 'icon' => $this->prefix_backend . 'icon' . '_' . $this->shortcode,
			'params' => array(	
					array( 'param_name' => 'button_style', 'type' => 'dropdown', 'heading' => esc_html__( 'Button style', 'vivo' ), 
						'value' => array(
							esc_html__( 'Filled', 'vivo' ) 			=> '',
							esc_html__( 'Filled gradient', 'vivo' ) 	=> 'filled_gradient',
							esc_html__( 'Outline', 'vivo' ) 			=> 'outline',
							esc_html__( 'Clean', 'vivo' ) 			=> 'clean'
						)
					),
					array( 'param_name' => 'color_scheme', 'preview' => true, 'type' => 'dropdown', 'heading' => esc_html__( 'Button color scheme', 'vivo' ), 'value' => $color_scheme_arr ),
					array( 'param_name' => 'button_font_weight', 'type' => 'dropdown', 'heading' => esc_html__( 'Button font weight', 'vivo' ), 
						'value' => array(
							esc_html__( 'Default', 'vivo' ) 		=> '',
							esc_html__( 'Normal', 'vivo' ) 		=> 'normal',
							esc_html__( 'Bold', 'vivo' ) 		=> 'bold',
							esc_html__( 'Bolder', 'vivo' ) 		=> 'bolder',
							esc_html__( 'Lighter', 'vivo' ) 		=> 'lighter',
							esc_html__( 'Light', 'vivo' ) 		=> '300',
							esc_html__( 'Thin', 'vivo' ) 		=> '100',
							esc_html__( '100', 'vivo' ) 			=> '100',
							esc_html__( '200', 'vivo' ) 			=> '200',
							esc_html__( '300', 'vivo' ) 			=> '300',
							esc_html__( '400', 'vivo' ) 			=> '400',
							esc_html__( '500', 'vivo' ) 			=> '500',
							esc_html__( '600', 'vivo' ) 			=> '600',
							esc_html__( '700', 'vivo' ) 			=> '700',
							esc_html__( '800', 'vivo' ) 			=> '800',
							esc_html__( '900', 'vivo' ) 			=> '900'
						)
					),
					array( 'param_name' => 'icon', 'type' => 'iconpicker', 'heading' => esc_html__( 'Button icon', 'vivo' ), 'preview' => true ),
					array( 'param_name' => 'input_style', 'type' => 'dropdown', 'heading' => esc_html__( 'Input style', 'vivo' ), 
						'value' => array(
							esc_html__( 'Filled (gray background)', 'vivo' ) 	=> '',
							esc_html__( 'Filled (light background)', 'vivo' ) 	=> 'light',
							esc_html__( 'Outline/underline', 'vivo' ) 			=> 'outline'
						)
					),
					array( 'param_name' => 'placeholder_style', 'type' => 'dropdown', 'heading' => esc_html__( 'Placeholder style', 'vivo' ), 
						'value' => array(
							esc_html__( 'Semi transparent', 'vivo' ) 			=> 'semitransparent',
							esc_html__( 'Full visibility', 'vivo' ) 				=> 'full',
						)
					),
					array( 'param_name' => 'placeholder_text', 'type' => 'textfield', 'preview' => true, 'heading' => esc_html__( 'Placeholder text', 'vivo' )),
				)
			)
		);
	}
}