<?php
class bt_bb_quote extends BT_BB_Element {

	function handle_shortcode( $atts, $content ) {
		extract( shortcode_atts( apply_filters( 'bt_bb_extract_atts_' . $this->shortcode, array(
			'text'						=> '',
			'image'						=> '',
			'name'						=> '',
			'details'					=> '',

			'top_border'				=> '',
			'bottom_border'				=> '',
			
			'text_size'					=> 'normal',
			'text_style'				=> '',
			'quote_font_weight'			=> '',
			'quote_font'				=> '',
			'quote_font_subset'   		=> '',

			'quote_icon_color'			=> '',
			'quote_icon_size'			=> 'normal',
			'quote_icon_font_weight' 	=> '',
			'quote_icon_font'			=> '',
			'quote_icon_font_subset'   	=> ''
					
		) ), $atts, $this->shortcode ) );

		$text = html_entity_decode( $text, ENT_QUOTES, 'UTF-8' );

		$class = array( $this->shortcode );
		
		if ( $quote_font != '' && $quote_font != 'inherit' ) {
			require_once( WP_PLUGIN_DIR   .  '/bold-page-builder/content_elements_misc/misc.php' );
			bt_bb_enqueue_google_font( $quote_font, $quote_font_subset );
		}

		if ( $quote_icon_font != '' && $quote_icon_font != 'inherit' ) {
			require_once( WP_PLUGIN_DIR   .  '/bold-page-builder/content_elements_misc/misc.php' );
			bt_bb_enqueue_google_font( $quote_icon_font, $quote_icon_font_subset );
		}
		
		if ( $el_class != '' ) {
			$class[] = $el_class;
		}
		
		$id_attr = '';
		if ( $el_id != '' ) {
			$id_attr = ' ' . 'id="' . esc_attr( $el_id ) . '"';
		}

		$text_font_style = "";
		if ( $quote_font != '' && $quote_font != 'inherit' ) {
			$text_font_style = ' style="font-family:\'' . urldecode( $quote_font ) . '\';"';
		}

		$icon_font_style = "";
		if ( $quote_icon_font != '' && $quote_icon_font != 'inherit' ) {
			$icon_font_style = ' style="font-family:\'' . urldecode( $quote_icon_font ) . '\';"';
		}
				
		if ( $text_size != '' ) {
			$class[] = $this->prefix . 'text_size_' . $text_size;
		}

		if ( $text_style != '' ) {
			$class[] = $this->prefix . 'text_style_' . $text_style;
		}

		if ( $quote_font_weight != '' ) {
			$class[] = $this->prefix . 'font_weight_' . $quote_font_weight ;
		}

		if ( $quote_icon_size != '' ) {
			$class[] = $this->prefix . 'icon_size_' . $quote_icon_size;
		}

		if ( $quote_icon_color != '' ) {
			$class[] = $this->prefix . 'icon_color_' . $quote_icon_color;
		}

		if ( $quote_icon_font_weight != '' ) {
			$class[] = $this->prefix . 'icon_font_weight_' . $quote_icon_font_weight ;
		}

		if ( $top_border != '' ) {
			$class[] = $this->prefix . 'top_border_' . $top_border;
		}

		if ( $bottom_border != '' ) {
			$class[] = $this->prefix . 'bottom_border_' . $bottom_border;
		}

		if ( $image == '' ) {
			$class[] = 'btNoImage';
		}
		
		$class = apply_filters( $this->shortcode . '_class', $class, $atts );
		$class_attr = implode( ' ', $class );


		if ( $el_class != '' ) {
			$class_attr = $class_attr . ' ' . $el_class;
		}

		$style_attr = '';
		if ( $el_style != '' ) {
			$style_attr = ' ' . 'style="' . esc_attr( $el_style ) . '"';
		}
		
		$output = '<div' . $id_attr . ' class="' . esc_attr( $class_attr ) . '"' . $style_attr . '>';

			// ICON
			$output .= '<div class="' . esc_attr( $this->shortcode . '_icon' ) . '" ' . $icon_font_style . '><span></span></div>';
			
			// TEXT
			if ( $text != '' ) $output .= '<div class="' . esc_attr( $this->shortcode . '_text' ) . '" ' . $text_font_style . '><span>' . $text . '</span></div>';

			// AUTHOR
			if ( ( $image != '' ) || ( $name != '' ) || ( $details != '' ) ) {
				$output .= '<div class="' . esc_attr( $this->shortcode ) . '_author">';

					// IMAGE
					if ( $image != '' ) $output .=  '<div class="' . esc_attr( $this->shortcode . '_image' ) . '">' . do_shortcode( '[bt_bb_image image="' . esc_attr( $image ) . '" size="thumbnail" shape="hard-rounded" ignore_fe_editor="true"]' ) . '</div>';

					// NAME & DETAILS
					if ( ( $name != '' ) || ( $details != '' ) ) {
						$output .= '<div class="' . esc_attr( $this->shortcode . '_content' ) . '">';
							if ( $name != '' ) $output .= '<div class="' . esc_attr( $this->shortcode . '_name' ) . '">' . $name . '</div>';
							if ( $details != '' ) $output .= '<div class="' . esc_attr( $this->shortcode . '_details' ) . '">' . $details . '</div>';
						$output .= '</div>';
					}
				
				$output .= '</div>';
			}

		$output .= '</div>';
		
		$output = apply_filters( 'bt_bb_general_output', $output, $atts );
		$output = apply_filters( $this->shortcode . '_output', $output, $atts );
		
		return $output;
		
	}
	
	function map_shortcode() {
		
		require_once( WP_PLUGIN_DIR   .  '/bold-page-builder/content_elements_misc/fonts1.php' );
		
		require_once( WP_PLUGIN_DIR   .  '/bold-page-builder/content_elements_misc/misc.php' );
		$color_scheme_arr = bt_bb_get_color_scheme_param_array();
		
		bt_bb_map( $this->shortcode, array( 'name' => esc_html__( 'Quote', 'vivo' ), 'description' => esc_html__( 'Quote', 'vivo' ), 'icon' => $this->prefix_backend . 'icon' . '_' . $this->shortcode,
			'params' => array( 
				array( 'param_name' => 'text', 'type' => 'textarea', 'heading' => esc_html__( 'Text', 'vivo' ), 'description' => esc_html__( 'Quote text', 'vivo' ) ),
				array( 'param_name' => 'image', 'type' => 'attach_image', 'heading' => esc_html__( 'Image', 'vivo' ), 'preview' => true ),
				array( 'param_name' => 'name', 'type' => 'textfield', 'heading' => esc_html__( 'Name', 'vivo' ) ),
				array( 'param_name' => 'details', 'type' => 'textfield', 'heading' => esc_html__( 'Details', 'vivo' ) ),
				
				
				array( 'param_name' => 'text_size', 'type' => 'dropdown', 'heading' => esc_html__( 'Text size', 'vivo' ), 'group' => esc_html__( 'Text', 'vivo' ), 
					'value' => array(
						esc_html__( 'Small', 'vivo' ) 				=> 'small',
						esc_html__( 'Normal', 'vivo' ) 				=> 'normal',
						esc_html__( 'Large', 'vivo' ) 				=> 'large'
					)
				),
				array( 'param_name' => 'text_style', 'type' => 'dropdown', 'heading' => esc_html__( 'Text style', 'vivo' ), 'group' => esc_html__( 'Text', 'vivo' ), 
					'value' => array(
						esc_html__( 'None', 'vivo' ) 				=> '',
						esc_html__( 'Italic', 'vivo' ) 				=> 'italic'
					)
				),
				array( 'param_name' => 'quote_font', 'type' => 'dropdown', 'heading' => esc_html__( 'Text font', 'vivo' ), 'group' => esc_html__( 'Text', 'vivo' ), 'preview' => true,
					'value' => array( esc_html__( 'Inherit', 'vivo' ) => 'inherit' ) + BT_BB_Root::$font_arr
				),
				array( 'param_name' => 'quote_font_subset', 'type' => 'textfield', 'heading' => esc_html__( 'Google Font subset', 'vivo' ), 'group' => esc_html__( 'Text', 'vivo' ), 'value' => 'latin,latin-ext', 'description' => esc_html__( 'E.g. latin,latin-ext,cyrillic,cyrillic-ext', 'vivo' ) ),
				array( 'param_name' => 'quote_font_weight', 'type' => 'dropdown', 'heading' => esc_html__( 'Text font weight', 'vivo' ), 'group' => esc_html__( 'Text', 'vivo' ),
					'value' => array(
						esc_html__( 'Default', 'vivo' ) 		=> '',
						esc_html__( 'Normal', 'vivo' ) 		=> 'normal',
						esc_html__( 'Bold', 'vivo' ) 		=> 'bold',
						esc_html__( 'Bolder', 'vivo' ) 		=> 'bolder',
						esc_html__( 'Lighter', 'vivo' ) 		=> 'lighter',
						esc_html__( 'Light', 'vivo' ) 		=> 'light',
						esc_html__( 'Thin', 'vivo' ) 		=> 'thin',
						esc_html__( '100', 'vivo' ) 			=> '100',
						esc_html__( '200', 'vivo' ) 			=> '200',
						esc_html__( '300', 'vivo' ) 			=> '300',
						esc_html__( '400', 'vivo' ) 			=> '400',
						esc_html__( '500', 'vivo' ) 			=> '500',
						esc_html__( '600', 'vivo' ) 			=> '600',
						esc_html__( '700', 'vivo' ) 			=> '700',
						esc_html__( '800', 'vivo' ) 			=> '800',
						esc_html__( '900', 'vivo' ) 			=> '900'
					)
				),


				array( 'param_name' => 'quote_icon_size', 'type' => 'dropdown', 'heading' => esc_html__( 'Icon size', 'vivo' ), 'group' => esc_html__( 'Icon', 'vivo' ),
					'value' => array(
						esc_html__( 'Small', 'vivo' ) 				=> 'small',
						esc_html__( 'Normal', 'vivo' ) 				=> 'normal',
						esc_html__( 'Medium', 'vivo' ) 				=> 'medium',
						esc_html__( 'Large', 'vivo' ) 				=> 'large',
						esc_html__( 'Huge', 'vivo' ) 				=> 'huge'
					)
				),
				array( 'param_name' => 'quote_icon_color', 'type' => 'dropdown', 'heading' => esc_html__( 'Icon color', 'vivo' ), 'group' => esc_html__( 'Icon', 'vivo' ),
					'value' => array(
						esc_html__( 'Accent color', 'vivo' ) 	=> '',
						esc_html__( 'Alternate color', 'vivo' ) 	=> 'alternate',
						esc_html__( 'Light color', 'vivo' ) 		=> 'light',
						esc_html__( 'Dark color', 'vivo' ) 		=> 'dark'
				) ),
				array( 'param_name' => 'quote_icon_font', 'type' => 'dropdown', 'heading' => esc_html__( 'Icon font', 'vivo' ), 'group' => esc_html__( 'Icon', 'vivo' ), 'preview' => true,
					'value' => array( esc_html__( 'Inherit', 'vivo' ) => 'inherit' ) + BT_BB_Root::$font_arr
				),
				array( 'param_name' => 'quote_icon_font_subset', 'type' => 'textfield', 'heading' => esc_html__( 'Google Font subset', 'vivo' ), 'group' => esc_html__( 'Icon', 'vivo' ), 'value' => 'latin,latin-ext', 'description' => esc_html__( 'E.g. latin,latin-ext,cyrillic,cyrillic-ext', 'vivo' ) ),
				array( 'param_name' => 'quote_icon_font_weight', 'type' => 'dropdown', 'heading' => esc_html__( 'Icon font weight', 'vivo' ), 'group' => esc_html__( 'Icon', 'vivo' ),
					'value' => array(
						esc_html__( 'Default', 'vivo' ) 		=> '',
						esc_html__( 'Normal', 'vivo' ) 		=> 'normal',
						esc_html__( 'Bold', 'vivo' ) 		=> 'bold',
						esc_html__( 'Bolder', 'vivo' ) 		=> 'bolder',
						esc_html__( 'Lighter', 'vivo' ) 		=> 'lighter',
						esc_html__( 'Light', 'vivo' ) 		=> 'light',
						esc_html__( 'Thin', 'vivo' ) 		=> 'thin',
						esc_html__( '100', 'vivo' ) 			=> '100',
						esc_html__( '200', 'vivo' ) 			=> '200',
						esc_html__( '300', 'vivo' ) 			=> '300',
						esc_html__( '400', 'vivo' ) 			=> '400',
						esc_html__( '500', 'vivo' ) 			=> '500',
						esc_html__( '600', 'vivo' ) 			=> '600',
						esc_html__( '700', 'vivo' ) 			=> '700',
						esc_html__( '800', 'vivo' ) 			=> '800',
						esc_html__( '900', 'vivo' ) 			=> '900'
					)
				),

				array( 'param_name' => 'top_border', 'type' => 'dropdown', 'heading' => esc_html__( 'Show top border', 'vivo' ), 'group' => esc_html__( 'Design', 'vivo' ),
					'value' => array(
						esc_html__( 'Yes', 'vivo' ) 				=> '',
						esc_html__( 'No', 'vivo' ) 				=> 'hide'
					)
				),
				array( 'param_name' => 'bottom_border', 'type' => 'dropdown', 'heading' => esc_html__( 'Show bottom border', 'vivo' ), 'group' => esc_html__( 'Design', 'vivo' ),
					'value' => array(
						esc_html__( 'Yes', 'vivo' ) 				=> '',
						esc_html__( 'No', 'vivo' ) 				=> 'hide'
					)
				),
			)
		) );
	}
}
