<?php
class bt_bb_progress_bar_advanced extends BT_BB_Element {

	function handle_shortcode( $atts, $content ) {
		extract( shortcode_atts( apply_filters( 'bt_bb_extract_atts', array(
			'type'        		=> '',
			'percentage'        => '',
			'duration'        	=> '',
			'easing'        	=> '',
			'progress_text'     => '',
			'text'        		=> '',			
			'icon'				=> '',
			'url'				=> '',
			'target'			=> '',
			'size'        		=> '',
			'thickness'			=> '',
			'trail_thickness'	=> '',
			'color_from' 		=> '',
			'color_to' 			=> '',
			'text_color' 		=> '',
			'trail_color'       => '',
			'fill_color'		=> '',
			'transparent'       => ''
		) ), $atts, $this->shortcode ) );

		$pb_id = rand(1000, 100000);

		$content_elements_path = get_parent_theme_file_uri( 'bold-page-builder/content_elements/bt_bb_progress_bar_advanced/' );
		$content_elements_misc_path_js = get_parent_theme_file_uri( 'bold-page-builder/content_elements_misc/js/' );

		wp_enqueue_script( 
			'bt_bb_progressbar_advanced_js',
			$content_elements_path . 'bb_progressbar_advanced.js',
			array( 'jquery' ),
			'',
			true
		);

		wp_enqueue_script( 
			'bt_bb_progressbar_advanced',
			$content_elements_misc_path_js . 'bt_bb_progress_bar_advanced.js',
			array( 'jquery' ),
			'',
			true
		);
				
		$class = array( $this->shortcode );
        
		$class[] = 'animate-adv_progressbar';
		
		if ( $el_class != '' ) {
			$class[] = $el_class;
		}

		if ( $transparent != '' ) {
			$class[] = $this->prefix . 'trail_transparent';
		}

		$id_attr = '';
		if ( $el_id != '' ) {
			$id_attr = ' ' . 'id="' . esc_attr( $el_id ) . '"';
		}

		$style_attr = '';
		if ( $el_style != '' ) {
			$style_attr = ' ' . 'style="' . esc_attr( $el_style ) . '"';
		}
		
		if ( $size != '' ) {
			$class[] = $this->prefix . 'size' . '_' . $size;
		}
		
		if ( $percentage == '' ){
			$percentage = 100;
		}

		if ( $fill_color != '' ){
			if ( strpos( $fill_color, '#' ) !== false ) {
				$fill_color = $this->hex2rgba($fill_color, 0.5);
			}
		}
		
		$container				= 'container_' . $pb_id;
		$container_text			= $text;
		$container_percentage	= $percentage / 100;
		$container_duration		= ( $duration == '' ) ? '1400' : $duration;	
		$container_easing		= ( $easing == '') ? 'linear' : $easing;
		
		$container_text_color	= ( $text_color == '') ? '' : $text_color;		
		$container_color_from	= ( $color_from == '') ? '#eee' : $color_from;
		$container_color_to		= ( $color_to == '') ? '#000' : $color_to;		
		$container_trail_color	= ( $trail_color == '') ? '#eee' : $trail_color;
		$container_fill			= ( $fill_color) ? $fill_color : null;
		

		if ( $color_to == "" && $color_from != "") {
			$container_color_to = $container_color_from;
		}

		switch( $thickness ){
			case 'small':	$container_depth_from	= 1;	$container_depth_to		= 1;	$container_stroke_width = 1;	$container_trail_width	= 1;break;
			case 'normal':	$container_depth_from	= 3;	$container_depth_to		= 3;	$container_stroke_width = 3;	$container_trail_width	= 3;break;
			case 'medium':	$container_depth_from	= 4;	$container_depth_to		= 4;	$container_stroke_width = 4;	$container_trail_width	= 4;break;
			case 'large':	$container_depth_from	= 6;	$container_depth_to		= 6;	$container_stroke_width = 6;	$container_trail_width	= 6;break;
			case 'xlarge':	$container_depth_from	= 8;	$container_depth_to		= 8;	$container_stroke_width = 8;	$container_trail_width	= 8;break;
			default:break;
		}

		switch( $trail_thickness ){
			case 'small':	$container_trail_width	= 1;break;
			case 'normal':	$container_trail_width	= 3;break;
			case 'medium':	$container_trail_width	= 4;break;
			case 'large':	$container_trail_width	= 6;break;
			case 'xlarge':	$container_trail_width	= 8;break;
			default:break;
		}

		$link = '';

		if ( $url != '' && $url != '#' && substr( $url, 0, 4 ) != 'http' && substr( $url, 0, 5 ) != 'https' && substr( $url, 0, 6 ) != 'mailto' ) {
			$link = bt_bb_get_permalink_by_slug( $url );
		} else {
			$link = $url;
		}

		if ( $container_color_to == "" ) {
			$container_color_to = $container_color_from;
		}
		
		$content = do_shortcode( $content );
		$data = ' data-container="' . esc_attr( $container ) . '"';
		$data .= ' data-container-pbid="' . esc_attr( $pb_id ) . '"';
		$data .= ' data-container-type="' . esc_attr( $type ) . '"';
		$data .= ' data-container-percentage="' . esc_attr( $container_percentage ) . '"';
		$data .= ' data-container-text-color="' . esc_attr( $container_text_color ) . '"';
		$data .= ' data-container-stroke-width="' . esc_attr( $container_stroke_width ) . '"';
		$data .= ' data-container-trail-color="' . esc_attr( $container_trail_color ) . '"';
		$data .= ' data-container-trail-width="' . esc_attr( $container_trail_width ) . '"';
		$data .= ' data-container-easing="' . esc_attr( $container_easing ) . '"';
		$data .= ' data-container-color-from="' . esc_attr( $container_color_from ) . '"';
		$data .= ' data-container-depth-from="' . esc_attr( $container_depth_from ) . '"';
		$data .= ' data-container-color-to="' . esc_attr( $container_color_to ) . '"';
		$data .= ' data-container-depth-to="' . esc_attr( $container_depth_to ) . '"';
		$data .= ' data-container-fill="' . esc_attr( $container_fill ) . '"';
		$data .= ' data-container-duration="' . esc_attr( $container_duration ) . '"';
		$data .= ' data-container-text="' . esc_attr( $container_text ) . '"';

		$output = '';

		$class = apply_filters( $this->shortcode . '_class', $class, $atts );

		if ( $link != '' ) {
			$target_attr = 'target="_self"';
			if ( $target != '' ) {
				$target_attr = ' ' . 'target="' . ( $target ) . '"';
			}
			$output .= '<a href="' . esc_url( $link ) . '" ' . $target_attr . ' class="' . esc_attr( $this->shortcode . '_link' ) . '">';
		}

		// PROGRESS BAR
		$output .= '<div' . $id_attr . ' class="' . implode( ' ', $class ) . '"' . $style_attr . ' ' . $data . '>';	
			
			$output .= '<div id="' . esc_attr( 'container_' . $pb_id ) . '" class="container">';

				$output .= '<div id="' . esc_attr( 'container_inner_' . $pb_id ) . '" class="container_inner">';

					// ICON
					if ( $icon != '' ) {
						$icon_html = bt_bb_icon::get_html( $icon, '' );
						$output .= $icon_html;
					}

					// PROGRESS TEXT
					if ( $progress_text != '' ) {
						$output .= '<div class="' . esc_attr( $this->shortcode . '_bar_text' ) . '"><span>' . $progress_text . '</span></div>';
					}
				$output .= '</div>';

			$output .= '</div>';
			
			if ( $container_text != '' ) {
				$output .= '<p>' . wp_kses_post( $container_text ) . '</p>';
			}

		$output .= '</div>';

		if ( $link != '' ) {
			$output .= '</a>';
		}

		$output = apply_filters( 'bt_bb_general_output', $output, $atts );
		$output = apply_filters( $this->shortcode . '_output', $output, $atts );
			
		return $output;
	}

	static function get_icon_html( $icon, $text = '' ) {
		$icon_set	= substr( $icon, 0, -5 );
		$icon		= substr( $icon, -4 );
		return '<span data-ico-' . esc_attr( $icon_set ) . '="&#x' . esc_attr( $icon ) . ';" class="bt_bb_icon_holder">' . $text . '</span>';
	}

	/* Convert hexdec color string to rgb(a) string */ 
	static function hex2rgba($color, $opacity = false) {

		$default = 'rgb(0,0,0)';

		// Return default if no color provided
		if(empty($color))
		return $default; 

		// Sanitize $color if "#" is provided 
		if ($color[0] == '#' ) {
			$color = substr( $color, 1 );
		}

		// Check if color has 6 or 3 characters and get values
		if (strlen($color) == 6) {
			$hex = array( $color[0] . $color[1], $color[2] . $color[3], $color[4] . $color[5] );
		} elseif ( strlen( $color ) == 3 ) {
			$hex = array( $color[0] . $color[0], $color[1] . $color[1], $color[2] . $color[2] );
		} else {
			return $default;
		}

		// Convert hexadec to rgb
		$rgb =  array_map('hexdec', $hex);

		// Check if opacity is set(rgba or rgb)
		if ($opacity) {
			if (abs($opacity) > 1)
			$opacity = 1.0;
			$output = 'rgba('.implode(",",$rgb).','.$opacity.')';
		} else {
			$output = 'rgb('.implode(",",$rgb).')';
		}

		// Return rgb(a) color string
		return $output;
	}

	function map_shortcode() {
		
		require_once( WP_PLUGIN_DIR   . '/bold-page-builder/content_elements_misc/misc.php' );
		
		bt_bb_map( $this->shortcode, array( 'name' => esc_html__( 'Advanced Progress Bar', 'vivo' ), 'description' => esc_html__( 'Advanced Progress Bar', 'vivo' ), 'icon' => $this->prefix_backend . 'icon' . '_' . $this->shortcode,
			'params' => array(
				array( 'param_name' => 'type', 'type' => 'dropdown', 'heading' => esc_html__( 'Progress Bar Type', 'vivo' ), 'preview' => true,
					'value' => array(
						esc_html__( 'Semi circle', 'vivo' ) 	=> 'semi-circle',
						esc_html__( 'Circle', 'vivo' ) 		=> 'circle'
					)
				),
				array( 'param_name' => 'percentage', 'type' => 'textfield', 'heading' => esc_html__( 'Percentage', 'vivo' ), 'preview' => true ),
				array( 'param_name' => 'duration', 'type' => 'textfield', 'heading' => esc_html__( 'Animation duration', 'vivo' ), 'preview' => true ),
						array( 'param_name' => 'easing', 'type' => 'dropdown', 'heading' => esc_html__( 'Easing', 'vivo' ), 'preview' => true,
					'value' => array(
						esc_html__( 'Linear', 'vivo' ) 			=> 'linear',
						esc_html__( 'Ease In Out', 'vivo' ) 		=> 'easeInOut',
						esc_html__( 'Bounce', 'vivo' ) 			=> 'bounce'
					)
				),
				array( 'param_name' => 'progress_text', 'type' => 'textfield', 'heading' => esc_html__( 'Progress Text', 'vivo' ), 'preview' => true ),
				array( 'param_name' => 'text', 'type' => 'textfield', 'heading' => esc_html__( 'Text below the icon or percentage', 'vivo' ), 'preview' => true ),				
				array( 'param_name' => 'icon', 'type' => 'iconpicker', 'heading' => esc_html__( 'Icon', 'vivo' ), 'preview' => true ),
				
				array( 'param_name' => 'url', 'type' => 'link', 'heading' => esc_html__( 'URL', 'vivo' ), 'preview' => true, 'description' => esc_html__( 'Enter full or local URL (e.g. https://www.bold-themes.com or /pages/about-us), post slug (e.g. about-us), #lightbox to open current image in full size or search for existing content.', 'vivo' ), 'group' => esc_html__( 'URL', 'vivo' ) ),
				array( 'param_name' => 'target', 'type' => 'dropdown', 'group' => esc_html__( 'URL', 'vivo' ), 'heading' => esc_html__( 'Target', 'vivo' ),
					'value' => array(
						esc_html__( 'Self (open in same tab)', 'vivo' ) 	=> '_self',
						esc_html__( 'Blank (open in new tab)', 'vivo' ) 	=> '_blank',
					)
				),

				array( 'param_name' => 'size', 'type' => 'dropdown', 'heading' => esc_html__( 'Size', 'vivo' ), 'preview' => true, 'group' => esc_html__( 'Design', 'vivo' ),
					'value' => array(
						esc_html__( 'Small', 'vivo' ) 		=> 'small',
						esc_html__( 'Normal', 'vivo' ) 		=> 'normal',
						esc_html__( 'Medium', 'vivo' ) 		=> 'medium',
						esc_html__( 'Large', 'vivo' ) 		=> 'large',
						esc_html__( 'Extra large', 'vivo' ) 	=> 'xlarge'
					)
				),
				array( 'param_name' => 'thickness', 'type' => 'dropdown', 'heading' => esc_html__( 'Progress bar thickness', 'vivo' ), 'group' => esc_html__( 'Design', 'vivo' ),
					'value' => array(
						esc_html__( 'Small', 'vivo' ) 			=> 'small',
						esc_html__( 'Normal', 'vivo' ) 			=> 'normal',
						esc_html__( 'Medium', 'vivo' ) 			=> 'medium',
						esc_html__( 'Large', 'vivo' ) 			=> 'large',
						esc_html__( 'Extra large', 'vivo' ) 		=> 'xlarge'
					)
				),
				array( 'param_name' => 'trail_thickness', 'type' => 'dropdown', 'heading' => esc_html__( 'Progress bar trail thickness', 'vivo' ), 'group' => esc_html__( 'Design', 'vivo' ),
					'value' => array(
						esc_html__( 'Same as progress bar', 'vivo' ) => 'progressbar',
						esc_html__( 'Small', 'vivo' ) 				=> 'small',
						esc_html__( 'Normal', 'vivo' ) 				=> 'normal',
						esc_html__( 'Medium', 'vivo' ) 				=> 'medium',
						esc_html__( 'Large', 'vivo' ) 				=> 'large',
						esc_html__( 'Extra large', 'vivo' ) 			=> 'xlarge'
					)
				),
				array( 'param_name' => 'color_from', 'type' => 'colorpicker', 'heading' => esc_html__( 'Starting Progress Bar Background color', 'vivo' ), 'group' => esc_html__( 'Design', 'vivo' ) ),
				array( 'param_name' => 'color_to', 'type' => 'colorpicker', 'heading' => esc_html__( 'Ending Progress Bar Background color', 'vivo' ), 'group' => esc_html__( 'Design', 'vivo' ) ),
				array( 'param_name' => 'text_color', 'type' => 'colorpicker', 'heading' => esc_html__( 'Text color', 'vivo' ), 'group' => esc_html__( 'Design', 'vivo' ) ),
				array( 'param_name' => 'trail_color', 'type' => 'colorpicker', 'heading' => esc_html__( 'Color for lighter trail stroke underneath the actual progress path', 'vivo' ), 'group' => esc_html__( 'Design', 'vivo' ) ),
				array( 'param_name' => 'fill_color', 'type' => 'colorpicker', 'heading' => esc_html__( 'Fill color', 'vivo' ), 'group' => esc_html__( 'Design', 'vivo' ) ),
				array( 'param_name' => 'transparent', 'type' => 'checkbox', 'value' => array( esc_html__( 'Yes', 'vivo' ) => 'show_transparent_trail' ), 'heading' => esc_html__( 'Show trail as semi transparent', 'vivo' ), 'description' => esc_html__( 'Makes the progress bar trail semi transparent, at opacity od 10%.', 'vivo' ), 'preview' => true, 'group' => esc_html__( 'Design', 'vivo' ) )
			)
		) );
	}
}

