<?php 

class bt_bb_prices extends BT_BB_Element {

	function handle_shortcode( $atts, $content ) {
		extract( shortcode_atts( apply_filters( 'bt_bb_extract_atts', array(
			'wh_content'      => ''
		) ), $atts, $this->shortcode ) );
		
		$content_elements_misc_path_css	= get_parent_theme_file_uri( 'bold-page-builder/content_elements_misc/css/' );
		
		$class = array( $this->shortcode );
		
		if ( $el_class != '' ) {
			$class[] = $el_class;
		}

		$id_attr = '';
		if ( $el_id != '' ) {
			$id_attr = ' ' . 'id="' . esc_attr( $el_id ) . '"';
		}		

		$style_attr = '';
		if ( $el_style != '' ) {
			$style_attr = ' ' . 'style="' . esc_attr( $el_style ) . '"';
		}
		
		$class = apply_filters( $this->shortcode . '_class', $class, $atts );
		
		$output_inner = '';
		$items_arr = preg_split( '/$\R?^/m', $wh_content );
		
		foreach ( $items_arr as $item ) {
			$output_inner .= '<div class="' . esc_attr( $this->shortcode ) . '_inner_row">';
			$item_arr = explode( ';', $item );
			$output_inner .= '<span class="' . esc_attr( $this->shortcode ) . '_inner_title">' . $item_arr[0] . '</span>';
			unset( $item_arr[0] );
		
			foreach ( $item_arr as $inner_item ) {
				$output_inner .= '<span class="' . esc_attr( $this->shortcode ) . '_inner_price">' . $inner_item . '</span>';
			}

			$output_inner .= '</div>';
		}

		$output = '<div class="bt_bb_prices ' . $el_class . '" ' . $style_attr . '>';
			$output .= $output_inner;
		$output .= '</div>';
		
		$output = apply_filters( 'bt_bb_general_output', $output, $atts );
		$output = apply_filters( $this->shortcode . '_output', $output, $atts );

		return $output;

	}

	function map_shortcode() {

		bt_bb_map( $this->shortcode, array( 'name' => esc_html__( 'Prices', 'vivo' ), 'description' => esc_html__( 'Prices element', 'vivo' ), 'icon' => $this->prefix_backend . 'icon' . '_' . $this->shortcode, 'highlight' => true,
			'params' => array(
				array( 'param_name' => 'wh_content', 'type' => 'textarea', 'heading' => esc_html__( 'Prices', 'vivo' ) , 'description' => esc_html__( 'Insert title;price; separated by new line (leave ; at the end)', 'vivo' ) 
				)	
			)
		) );
	}
}