<?php

class bt_bb_post_slider extends BT_BB_Element {
	
	public $auto_play = '';
	
	function handle_shortcode( $atts, $content ) {
		extract( shortcode_atts( apply_filters( 'bt_bb_extract_atts_' . $this->shortcode, array(
			'post_type'					=> 'post',
			'number'					=> '',
			'category'					=> '',
			'height'    				=> '',
			'animation' 				=> '',
			'pause_on_hover'     		=> '',
			'slides_to_show' 			=> '',
			'gap' 						=> '',
			'auto_play' 				=> '',
			'size'						=> '',
			'image_position' 			=> '',
			'shadow' 					=> '',
			'negative_margin'			=> '',
			
			'navigation_position'		=> '',
			'arrows_size' 				=> '',
			'show_dots' 				=> '',
			'navigation_color_scheme'	=> '',
			'item_color_scheme'			=> '',			
			'shape'						=> '',
			'post_details_color'		=> '',
			'date_color_scheme'			=> '',
			'image_detail'				=> '',
			
			'button_color_scheme'		=> '',
			
			'show_date'					=> '',
			'show_category'				=> '',
			'show_author'				=> '',
			'show_comments'				=> '',
			'show_excerpt'				=> '',
			'read_more'					=> '',
			'target'					=> '',
			'title_lines'				=> '',
			'excerpt_lines'				=> '',
			'title_font_weight'			=> ''
			
		) ), $atts, $this->shortcode ) );

		wp_enqueue_script( 
			'bt_bb_post_slider',
			get_template_directory_uri() . '/bold-page-builder/content_elements/bt_bb_post_slider/bt_bb_post_slider.js',
			array( 'jquery' )
		);
		
		$class = array( $this->shortcode );
		$data_override_class = array();
		$slider_class = array( 'slick-slider' );
		
		if ( $el_class != '' ) {
			$class[] = $el_class;
		}
		
		$id_attr = '';
		if ( $el_id != '' ) {
			$id_attr = ' ' . 'id="' . esc_attr( $el_id ) . '"';
		}

		if ( $gap != '' ) {
			$class[] = $this->prefix . 'gap' . '_' . $gap;
		}
		
		if ( $arrows_size != '' ) {
			$class[] = $this->prefix . 'arrows_size' . '_' . $arrows_size;
		}

		if ( $shadow != '' ) {
			$class[] = $this->prefix . 'shadow' . '_' . $shadow;
		}
		
		if ( $show_dots != '' ) {
			$class[] = $this->prefix . 'show_dots' . '_' . $show_dots;
		}

		if ( $title_lines != '' ) {
			$class[] = $this->prefix . 'title_lines' . '_' . $title_lines;
		}

		if ( $excerpt_lines != '' ) {
			$class[] = $this->prefix . 'excerpt_lines' . '_' . $excerpt_lines;
		}

		if ( $navigation_position != '' ) {
			$class[] = $this->prefix . 'navigation_position' . '_' . $navigation_position;
		}

		if ( $post_details_color != '' ) {
			$class[] = $this->prefix . 'post_details_color' . '_' . $post_details_color;
		}

		if ( $image_detail != '' ) {
			$class[] = $this->prefix . 'image_detail' . '_' . $image_detail;
		}
		
		if ( $height != '' ) {
			$class[] = $this->prefix . 'height' . '_' . $height;
		}

		if ( $animation != '' ) {
			$class[] = $this->prefix . 'animation' . '_' . $animation;
		}

		if ( $title_font_weight != '' ) {
			$class[] = $this->prefix . 'title_font_weight' . '_' . $title_font_weight;
		}
		
		$this->responsive_data_override_class(
			$class, $data_override_class,
			array(
				'prefix' => $this->prefix,
				'param' => 'negative_margin',
				'value' => $negative_margin
			)
		);


		if ( $image_position != '' ) {
			$class[] = $this->prefix . 'image_position' . '_' . $image_position;
		}


		$item_color_scheme_id = NULL;
		if ( is_numeric ( $item_color_scheme ) ) {
			$item_color_scheme_id = $item_color_scheme;
		} else if ( $item_color_scheme != '' ) {
			$item_color_scheme_id = bt_bb_get_color_scheme_id( $item_color_scheme );
		}
		$item_color_scheme_colors = bt_bb_get_color_scheme_colors_by_id( $item_color_scheme_id - 1 );
		if ( $item_color_scheme_colors ) $el_style .= '; --post-slider-item-primary-color:' . $item_color_scheme_colors[0] . '; --post-slider-item-secondary-color:' . $item_color_scheme_colors[1] . ';';
		if ( $item_color_scheme != '' ) $class[] = $this->prefix . 'item_color_scheme_' .  $item_color_scheme_id;


		$navigation_color_scheme_id = NULL;
		if ( is_numeric ( $navigation_color_scheme ) ) {
			$navigation_color_scheme_id = $navigation_color_scheme;
		} else if ( $navigation_color_scheme != '' ) {
			$navigation_color_scheme_id = bt_bb_get_color_scheme_id( $navigation_color_scheme );
		}
		$navigation_color_scheme_colors = bt_bb_get_color_scheme_colors_by_id( $navigation_color_scheme_id - 1 );
		if ( $navigation_color_scheme_colors ) $el_style .= '; --post-slider-navigation-primary-color:' . $navigation_color_scheme_colors[0] . '; --post-slider-navigation-secondary-color:' . $navigation_color_scheme_colors[1] . ';';
		if ( $navigation_color_scheme != '' ) $class[] = $this->prefix . 'navigation_color_scheme_' .  $navigation_color_scheme_id;



		$button_color_scheme_id = NULL;
		if ( is_numeric ( $button_color_scheme ) ) {
			$button_color_scheme_id = $button_color_scheme;
		} else if ( $button_color_scheme != '' ) {
			$button_color_scheme_id = bt_bb_get_color_scheme_id( $button_color_scheme );
		}
		$button_color_scheme_colors = bt_bb_get_color_scheme_colors_by_id( $button_color_scheme_id - 1 );
		if ( $button_color_scheme_colors ) $el_style .= '; --post-slider-button-primary-color:' . $button_color_scheme_colors[0] . '; --post-slider-button-secondary-color:' . $button_color_scheme_colors[1] . ';';
		if ( $button_color_scheme != '' ) $class[] = $this->prefix . 'button_color_scheme_' .  $button_color_scheme_id;

		if ( $show_date != '' ) {
			$class[] = $this->prefix . 'show_date' . '_' . $show_date;
		}

		$date_color_scheme_id = NULL;
		if ( is_numeric ( $date_color_scheme ) ) {
			$date_color_scheme_id = $date_color_scheme;
		} else if ( $date_color_scheme != '' ) {
			$date_color_scheme_id = bt_bb_get_color_scheme_id( $date_color_scheme );
		}
		$date_color_scheme_colors = bt_bb_get_color_scheme_colors_by_id( $date_color_scheme_id - 1 );
		if ( $date_color_scheme_colors ) $el_style .= '; --post-slider-date-primary-color:' . $date_color_scheme_colors[0] . '; --post-slider-date-secondary-color:' . $date_color_scheme_colors[1] . ';';
		if ( $date_color_scheme != '' ) $class[] = $this->prefix . 'date_color_scheme_' .  $date_color_scheme_id;

		if ( $shape != '' ) {
			$class[] = $this->prefix . 'shape' . '_' . $shape;
		}

		$data_slick  = ' data-slick=\'{ "lazyLoad": "progressive", "cssEase": "ease-out", "speed": "600"';
		
		if ( $animation == 'fade' ) {
			$data_slick .= ', "fade": true';
			$slider_class[] = 'fade';
			$slides_to_show = 1;
		}
		
		if ( $arrows_size != 'no_arrows' ) {
			$data_slick  .= ', "prevArrow": "&lt;button type=\"button\" class=\"slick-prev\" aria-label=\"' . esc_html__( 'Previous', 'vivo' ) . '\" tabindex=\"0\" role=\"button\"&gt;&lt;/button&gt;", "nextArrow": "&lt;button type=\"button\" class=\"slick-next\" aria-label=\"' . esc_html__( 'Next', 'vivo' ) . '\" tabindex=\"0\" role=\"button\"&gt;&lt;/button&gt;"';
		} else {
			$data_slick .= ', "arrows": false';
		}
		
		if ( $height != 'keep-height' ) {
			$data_slick .= ', "adaptiveHeight": true';
		}
		
		if ( $show_dots != 'hide' ) {
			$data_slick .= ', "dots": true' ;
		}
		
		if ( $slides_to_show > 1 ) {
			$data_slick .= ',"slidesToShow": ' . intval( $slides_to_show );
			$class[] = $this->prefix . 'multiple_slides';
		}
		
		if ( $auto_play != '' ) {
			$data_slick .= ',"autoplay": true, "autoplaySpeed": ' . intval( $auto_play );
		}
		
		if ( $pause_on_hover == 'no' ) {
			$data_slick .= ',"pauseOnHover": false';
		}

		if ( is_rtl() ) {
			$data_slick .= ', "rtl": true' ;
		}
		
		if ( $slides_to_show > 1 ) {
			$data_slick .= ', "responsive": [';
			if ( $slides_to_show > 1 ) {
				$data_slick .= '{ "breakpoint": 480, "settings": { "slidesToShow": 1, "slidesToScroll": 1 } }';	
			}
			if ( $slides_to_show > 2 ) {
				$data_slick .= ',{ "breakpoint": 768, "settings": { "slidesToShow": 2, "slidesToScroll": 2 } }';	
			}
			if ( $slides_to_show > 3 ) {
				$data_slick .= ',{ "breakpoint": 920, "settings": { "slidesToShow": 3, "slidesToScroll": 3 } }';	
			}
			if ( $slides_to_show > 4 ) {
				$data_slick .= ',{ "breakpoint": 1024, "settings": { "slidesToShow": 3, "slidesToScroll": 3 } }';	
			}
			$data_slick .= ']';
		}
		$data_slick = $data_slick . '}\' ';
		
		$class = apply_filters( $this->shortcode . '_class', $class, $atts );

		$style_attr = '';
		if ( $el_style != '' ) {
			$style_attr = ' ' . 'style="' . esc_attr( $el_style ) . '"';
		}

		$show = array(
			'category' 		=> false,
			'date' 			=> false,
			'author' 		=> false,
			'comments' 		=> false,
			'excerpt' 		=> false, 
			'read_more' 	=> '',
			'target' 		=> '_self',
			'image' 		=> false,
			'size' 			=> 'large'
		);
		
		if ( $show_category == 'show_category' ) {
			$show['category'] = true;
		}
		if ( $show_excerpt == 'show_excerpt' ) {
			$show['excerpt'] = true;
		}
		if ( $show_date == 'on_top' ) {
			$show['date'] = true;
		}
		if ( $show_date == 'on_image' ) {
			$show['date'] = true;
		}
		if ( $show_comments == 'show_comments' ) {
			$show['comments'] = true;
		}
		if ( $show_author == 'show_author' ) {
			$show['author'] = true;
		}
		if ( $read_more != '' ) {
			$show['read_more'] = $read_more;
		}
		if ( $size != '' ) {
			$show['size'] = $size;
		}
		if ( $target != '' ) {
			$show['target'] = $target;
		}
		
		if ( $number > 1000 || $number == '' ) {
			$number = 1000;
		} else if ( $number < 1 ) {
			$number = 1;
		}

		
		$posts = bt_bb_get_posts( $number, 0, $category, $post_type );

		$output = $this->slider_content( $posts, $show );
		
		$output = '<div' . $id_attr . ' class="' . implode( ' ', $class ) . '"' . $style_attr . ' data-slides="' . esc_attr( $slides_to_show ) . '" data-bt-override-class="' . htmlspecialchars( json_encode( $data_override_class, JSON_FORCE_OBJECT ), ENT_QUOTES, 'UTF-8' ) . '"><div class="' . implode( ' ', $slider_class ) . '" ' . $data_slick .  '>' . $output . '</div></div>';
	
		$output = apply_filters( 'bt_bb_general_output', $output, $atts );
		$output = apply_filters( $this->shortcode . '_output', $output, $atts );
		
		return $output;
	}
	
	static function slider_content( $posts, $show ) {

		$date_design_format         = 'j M';
		$date_design_format_day     = 'j';
		$date_design_format_month   = 'M';

		$image_position = '';

		$output = '';
		$class	= array();
		
		$prefix_backend = 'bt_bb_';
		$shortcode = 'bt_bb_post_slider';

		foreach( $posts as $post_item ) {

			$post_thumbnail_id = get_post_thumbnail_id( $post_item['ID'] ); 
			$img = wp_get_attachment_image_src( $post_thumbnail_id, $show['size'] );
			$img_src = isset($img[0]) ? $img[0] : BoldThemes_Customize_Default::$data['post_image_default'];

			if ( $img_src ) {
				$style_attr = ' ';
				$hw = 0;
				if ( $img_src != '' ) {
					$hw = $img[2] / $img[1];
				}
			} else {
				$class[] = ' bt_bb_post_slider_item_inner_no_image';
				$style_attr = ' ';

				$post_thumbnail_id = attachment_url_to_postid( boldthemes_get_option( 'post_image_default' ) );
				if ( is_numeric( $post_thumbnail_id ) ) {
					$img = wp_get_attachment_image_src( $post_thumbnail_id, $show['size'] );
					$img_src = isset($img[0]) ? $img[0] : BoldThemes_Customize_Default::$data['post_image_default'];
				}
			}

			$alt = get_post_meta( $post_thumbnail_id, '_wp_attachment_image_alt', true );
			$alt = $alt != '' ? $alt : $post_item['title'];

		
			$output .= '<div class="' . esc_attr( $shortcode ) . '_item " ' . $style_attr . '><div class="' . esc_attr( $shortcode ) . '_item_inner">';

				// IMAGE
				if ( $post_thumbnail_id != '' ) {
					$output .= '<div class="' . esc_attr( $shortcode ) . '_item_image">';
						
						$output .= '<a href="' . esc_url_raw( $post_item['permalink'] ) . '" target="' . esc_attr( $show['target'] ) . '">';
							$output .= '<img src="' . esc_url_raw( $img_src ) . '" alt="' . esc_attr( $alt ) . '" title="' . esc_attr( $post_item['title'] ) . '">';
						$output .= '</a>';

					$output .= '</div>';
				}

				$output .= '<div class="' . esc_attr( $shortcode ) . '_item_content">';

					// DATE
					if ( $show['date'] ) {
						$output .= '<div class="' . esc_attr( $shortcode ) . '_item_date">';
							if ( $date_design_format_day != '' && $date_design_format_month != '' ) {
								$output .= '<span class="' . esc_attr( $shortcode ) . '_item_date_day">';
									$output .= get_the_date( $date_design_format_day, $post_item['ID'] );
								$output .= '</span>';

								$output .= '<span class="' . esc_attr( $shortcode ) . '_item_date_month">';
									$output .= get_the_date( $date_design_format_month, $post_item['ID'] );
								$output .= '</span>';
							} else {
								$output .= get_the_date( $date_design_format, $post_item['ID'] );
							}
						$output .= '</div>';
					}

					// TITLE
					$output .= '<h5 class="' . esc_attr( $shortcode ) . '_item_title">';
						$output .= '<a href="' . esc_url_raw( $post_item['permalink'] ) . '" target="' . esc_attr( $show['target'] ) . '">' . $post_item['title'] . '</a>';
					$output .= '</h5>';

					// EXCERPT
					if ( $show['excerpt'] ) {
						$output .= '<div class="' . esc_attr( $shortcode ) . '_item_excerpt">';
							$output .= $post_item['excerpt'];
						$output .= '</div>';
					}

					// META
					if ( $show['author']  || $show['comments'] || $show['category'] ) {
						$meta_output = '<div class="' . esc_attr( $shortcode ) . '_item_meta">';

							if ( $show['category'] ) {
								$meta_output .= '<div class="' . esc_attr( $shortcode ) . '_item_category">';
									$meta_output .= $post_item['category_list'];
								$meta_output .= '</div>';
							}

							if ( $show['author'] ) {
								$meta_output .= '<span class="' . esc_attr( $shortcode ) . '_item_author">';
									$meta_output .= esc_html__( 'by', 'vivo' ) . ' ' . $post_item['author'];
								$meta_output .= '</span>';
							}

							if ( $show['comments'] && $post_item['comments'] != '' ) {
								$meta_output .= '<span class="' . esc_attr( $shortcode ) . '_item_comments">';
									$meta_output .= $post_item['comments'];
								$meta_output .= '</span>';
							}

						$meta_output .= '</div>';
						$output .= $meta_output;
					}

					// READ MORE
					if ( $show['read_more'] ) {
						$output .= '<div class="bt_bb_post_slider_item_read_more bt_bb_button bt_bb_width_inline bt_bb_shape_inherit bt_bb_style_line bt_bb_size_small btWithLink">';
							$output .='<a href="' . esc_url_raw( $post_item['permalink'] ) . '" target="' . esc_attr( $show['target'] ) . '" class="bt_bb_link"><span class="bt_bb_button_text"> ' . esc_attr( $show['read_more'] ) . ' </span></a>';
						$output .= '</div>';
					}
						
					$output .= '</div>';
			$output .= '</div></div>';

		}
		
		return $output;
	}
	
	function map_shortcode() {

		$color_scheme_arr = bt_bb_get_color_scheme_param_array();
		
		bt_bb_map( $this->shortcode, array( 'name' => esc_html__( 'Post Slider', 'vivo' ), 'description' => esc_html__( 'Slider with posts', 'vivo' ), 'icon' => $this->prefix_backend . 'icon' . '_' . $this->shortcode,
			'params' => array(
				array( 'param_name' => 'post_type', 'type' => 'dropdown', 'preview' => true, 'heading' => esc_html__( 'Post Type', 'vivo' ),
					'value' => array(
						esc_html__( 'Post', 'vivo' ) => 'post',
						esc_html__( 'Portfolio', 'vivo' ) => 'portfolio'
					)
				),
				array( 'param_name' => 'number', 'type' => 'textfield', 'heading' => esc_html__( 'Number of posts', 'vivo' ), 'description' => esc_html__( 'Enter number of posts or leave empty to show all (up to 1000)', 'vivo' ) ),
				array( 'param_name' => 'category', 'type' => 'textfield', 'heading' => esc_html__( 'Filter posts by category', 'vivo' ), 'description' => esc_html__( 'Enter category slugs separated by "," or leave empty to show all', 'vivo' ), 'preview' => true ),
				array( 'param_name' => 'size', 'type' => 'dropdown', 'heading' => esc_html__( 'Image size', 'vivo' ),
					'value' => bt_bb_get_image_sizes()
				),
				array( 'param_name' => 'image_position', 'type' => 'dropdown', 'heading' => esc_html__( 'Image position', 'vivo' ),  
					'value' => array(
						esc_html__( 'On top', 'vivo' ) 				=> '',
						esc_html__( 'Background', 'vivo' ) 			=> 'background'
					)
				),
				array( 'param_name' => 'negative_margin', 'type' => 'dropdown', 'heading' => esc_html__( 'Negative margin', 'vivo' ), 'responsive_override' => true, 
					'value' => array(
						esc_html__( 'None', 'vivo' ) 			=> 'none',
						esc_html__( 'Small', 'vivo' ) 			=> 'small',
						esc_html__( 'Normal', 'vivo' ) 			=> 'normal',
						esc_html__( 'Large', 'vivo' ) 			=> 'large'
					)
				),
				
				


				array( 'param_name' => 'slides_to_show', 'type' => 'textfield', 'default' => 1, 'group' => esc_html__( 'Slider', 'vivo' ), 'heading' => esc_html__( 'Number of slides to show', 'vivo' ), 'description' => esc_html__( 'Enter number of posts to be visible in the slider, e.g. 3', 'vivo' ) ),
				array( 'param_name' => 'height', 'type' => 'dropdown', 'preview' => true, 'heading' => esc_html__( 'Slider height', 'vivo' ),  'group' => esc_html__( 'Slider', 'vivo' ),
					'value' => array(
						esc_html__( 'Auto', 'vivo' ) 			=> 'auto',
						esc_html__( 'Keep height', 'vivo' )		=> 'keep-height',
						esc_html__( 'Half screen', 'vivo' )		=> 'half_screen',
						esc_html__( 'Full screen', 'vivo' )		=> 'full_screen'
					)
				),
				array( 'param_name' => 'animation', 'type' => 'dropdown', 'heading' => esc_html__( 'Slider animation', 'vivo' ), 'group' => esc_html__( 'Slider', 'vivo' ), 'description' => esc_html__( 'If fade is selected, number of slides to show will be 1', 'vivo' ),
					'value' => array(
						esc_html__( 'Default', 'vivo' )		=> 'slide',
						esc_html__( 'Fade', 'vivo' )			=> 'fade'
					)
				),
				array( 'param_name' => 'pause_on_hover', 'default' => 'yes', 'type' => 'dropdown', 'heading' => esc_html__( 'Pause slideshow on hover', 'vivo' ), 'group' => esc_html__( 'Slider', 'vivo' ),
					'value' => array(
						esc_html__( 'Yes', 'vivo' )		=> 'yes',
						esc_html__( 'No', 'vivo' )		=> 'no'
					)
				),
				
				array( 'param_name' => 'gap', 'type' => 'dropdown', 'heading' => esc_html__( 'Slider items gap', 'vivo' ), 'group' => esc_html__( 'Slider', 'vivo' ),
					'value' => array(
						esc_html__( 'No gap', 'vivo' )		=> 'no_gap',
						esc_html__( 'Small', 'vivo' )		=> 'small',
						esc_html__( 'Normal', 'vivo' )		=> 'normal',
						esc_html__( 'Large', 'vivo' )		=> 'large'
					)
				),
				array( 'param_name' => 'auto_play', 'type' => 'textfield', 'heading' => esc_html__( 'Slider autoplay interval (ms)', 'vivo' ), 'group' => esc_html__( 'Slider', 'vivo' ), 'description' => esc_html__( 'e.g. 2000', 'vivo' ) ),
				array( 'param_name' => 'navigation_position', 'type' => 'dropdown', 'heading' => esc_html__( 'Arrows position', 'vivo' ), 'group' => esc_html__( 'Slider', 'vivo' ),
					'value' => array(
						esc_html__( 'On side', 'vivo' ) 				=> '',
						esc_html__( 'Outside slider', 'vivo' ) 		=> 'outside'
					)
				),
				array( 'param_name' => 'arrows_size', 'type' => 'dropdown', 'default' => 'normal', 'group' => esc_html__( 'Slider', 'vivo' ), 'heading' => esc_html__( 'Arrows size', 'vivo' ),
					'value' => array(
						esc_html__( 'No arrows', 'vivo' ) 	=> 'no_arrows',
						esc_html__( 'Small', 'vivo' ) 		=> 'small',
						esc_html__( 'Normal', 'vivo' ) 		=> 'normal',
						esc_html__( 'Large', 'vivo' ) 		=> 'large'
					)
				),
				array( 'param_name' => 'show_dots', 'type' => 'dropdown', 'heading' => esc_html__( 'Lines position', 'vivo' ), 'group' => esc_html__( 'Slider', 'vivo' ),
					'value' => array(
						esc_html__( 'Lines on middle bottom (arrows on side)', 'vivo' ) 		=> 'bottom',
						esc_html__( 'Lines below bottom (arrows on side)', 'vivo' ) 			=> 'below',
						esc_html__( 'Lines on bottom left (arows on right)', 'vivo' ) 		=> 'left',
						esc_html__( 'Lines on bottom right (arrows on left)', 'vivo' ) 		=> 'right',
						esc_html__( 'Lines on top left (arows on right)', 'vivo' ) 			=> 'top_left',
						esc_html__( 'Lines on top right (arrows on left)', 'vivo' ) 			=> 'top_right',
						esc_html__( 'Lines on top right (arrows on side)', 'vivo' ) 			=> 'top_right_side',
						esc_html__( 'Lines on top left (arrows on side)', 'vivo' ) 			=> 'top_left_side',
						esc_html__( 'Hide Lines', 'vivo' ) 									=> 'hide'
					)
				),
				array( 'param_name' => 'navigation_color_scheme', 'type' => 'dropdown', 'heading' => esc_html__( 'Arrows & Lines color scheme', 'vivo' ), 'value' => $color_scheme_arr, 'description' => esc_html__( 'Choose navigation colors - Define color schemes in Bold Builder settings or define accent and alternate colors in theme customizer (if avaliable)', 'vivo' ), 'preview' => true, 'group' => esc_html__( 'Slider', 'vivo' ) ),


				
				
				

				array( 'param_name' => 'shape', 'type' => 'dropdown', 'heading' => esc_html__( 'Slider item shape', 'vivo' ), 'group' => esc_html__( 'Design', 'vivo' ),
					'value' => array(
						esc_html__( 'Square', 'vivo' ) 				=> 'square',
						esc_html__( 'Soft Rounded', 'vivo' ) 		=> 'soft_rounded',
						esc_html__( 'Medium Rounded', 'vivo' ) 		=> 'medium_rounded',
						esc_html__( 'Hard Rounded', 'vivo' ) 		=> 'hard_rounded'
					)
				),
				array( 'param_name' => 'item_color_scheme', 'type' => 'dropdown', 'heading' => esc_html__( 'Slider item color scheme', 'vivo' ), 'value' => $color_scheme_arr, 'description' => esc_html__( 'Choose item colors - Define color schemes in Bold Builder settings or define accent and alternate colors in theme customizer (if avaliable)', 'vivo' ), 'preview' => true, 'group' => esc_html__( 'Design', 'vivo' ) ),
				array( 'param_name' => 'date_color_scheme', 'type' => 'dropdown', 'heading' => esc_html__( 'Date color scheme', 'vivo' ), 'value' => $color_scheme_arr, 'description' => esc_html__( 'Choose date colors - Define color schemes in Bold Builder settings or define accent and alternate colors in theme customizer (if avaliable)', 'vivo' ), 'group' => esc_html__( 'Design', 'vivo' ) ),
				array( 'param_name' => 'shadow', 'type' => 'dropdown', 'heading' => esc_html__( 'Show shadow', 'vivo' ), 'group' => esc_html__( 'Design', 'vivo' ), 
					'value' => array(
						esc_html__( 'No', 'vivo' )		=> '',
						esc_html__( 'Yes', 'vivo' )		=> 'yes'
					)
				),
				array( 'param_name' => 'post_details_color', 'type' => 'dropdown', 'group' => esc_html__( 'Design', 'vivo' ), 'heading' => esc_html__( 'Post details colors', 'vivo' ), 'description' => esc_html__( 'Choose colors for post details - author name, comments, categories etc.', 'vivo' ),
					'value' => array(
						esc_html__( 'Inherit', 'vivo' ) 			=> '',
						esc_html__( 'Dark', 'vivo' )				=> 'dark',
						esc_html__( 'Light', 'vivo' )			=> 'light',
						esc_html__( 'Accent', 'vivo' )			=> 'accent',
						esc_html__( 'Alternate', 'vivo' )		=> 'alternate'
					)
				),
				array( 'param_name' => 'image_detail', 'type' => 'dropdown', 'heading' => esc_html__( 'Image detail', 'vivo' ), 'group' => esc_html__( 'Design', 'vivo' ), 
					'value' => array(
						esc_html__( 'No', 'vivo' ) 					=> '',
						esc_html__( 'Light blue detail', 'vivo' ) 	=> 'light_blue',
						esc_html__( 'Light gray detail', 'vivo' ) 	=> 'light_gray',
						esc_html__( 'Rounded bottom', 'vivo' ) 		=> 'rounded'
					)
				),
				array( 'param_name' => 'button_color_scheme', 'type' => 'dropdown', 'heading' => esc_html__( 'Read more color scheme', 'vivo' ), 'value' => $color_scheme_arr, 'description' => esc_html__( 'Choose button colors - Define color schemes in Bold Builder settings or define accent and alternate colors in theme customizer (if avaliable)', 'vivo' ), 'group' => esc_html__( 'Design', 'vivo' ) ),

				

				array( 'param_name' => 'show_date', 'type' => 'dropdown', 'heading' => esc_html__( 'Show date', 'vivo' ), 'group' => esc_html__( 'Post', 'vivo' ),
					'value' => array(
						esc_html__( 'Hide', 'vivo' ) 					=> '',
						esc_html__( 'Show on top', 'vivo' ) 				=> 'on_top',
						esc_html__( 'Show on image', 'vivo' ) 			=> 'on_image'
					)
				),
				array( 'param_name' => 'show_category', 'type' => 'checkbox', 'value' => array( esc_html__( 'Yes', 'vivo' ) => 'show_category' ), 'heading' => esc_html__( 'Show category', 'vivo' ), 'group' => esc_html__( 'Post', 'vivo' )
				),
				array( 'param_name' => 'show_author', 'type' => 'checkbox', 'value' => array( esc_html__( 'Yes', 'vivo' ) => 'show_author' ), 'heading' => esc_html__( 'Show author', 'vivo' ), 'group' => esc_html__( 'Post', 'vivo' )
				),
				array( 'param_name' => 'show_comments', 'type' => 'checkbox', 'value' => array( esc_html__( 'Yes', 'vivo' ) => 'show_comments' ), 'heading' => esc_html__( 'Show number of comments', 'vivo' ), 'group' => esc_html__( 'Post', 'vivo' )
				),
				array( 'param_name' => 'show_excerpt', 'type' => 'checkbox', 'value' => array( esc_html__( 'Yes', 'vivo' ) => 'show_excerpt' ), 'heading' => esc_html__( 'Show excerpt', 'vivo' ), 'group' => esc_html__( 'Post', 'vivo' )
				),
				array( 'param_name' => 'read_more', 'type' => 'textfield', 'heading' => esc_html__( 'Read more text', 'vivo' ), 'group' => esc_html__( 'Post', 'vivo' ) 
				),
				array( 'param_name' => 'target', 'type' => 'dropdown', 'heading' => esc_html__( 'Target', 'vivo' ), 'group' => esc_html__( 'Post', 'vivo' ),
					'value' => array(
						esc_html__('Self (open in same tab)', 'vivo' )		=> '_self',
						esc_html__('Blank (open in new tab)', 'vivo' )		=> '_blank',
					)
				),
				array( 'param_name' => 'title_lines', 'default' => '', 'type' => 'dropdown', 'heading' => esc_html__( 'Title lines', 'vivo' ), 'description' => esc_html__( 'Limit and show 1, 2, 3 or 4 lines of post title', 'vivo' ), 'group' => esc_html__( 'Post', 'vivo' ),
					'value' => array(
						esc_html__( 'All', 'vivo' )		=> '',
						esc_html__( '4', 'vivo' )		=> '4',
						esc_html__( '3', 'vivo' )		=> '3',
						esc_html__( '2', 'vivo' )		=> '2',
						esc_html__( '1', 'vivo' )		=> '1'
					)
				),
				array( 'param_name' => 'title_font_weight', 'type' => 'dropdown', 'heading' => esc_html__( 'Title font weight', 'vivo' ), 'group' => esc_html__( 'Post', 'vivo' ),
					'value' => array(
						esc_html__( 'Default', 'vivo' ) 		=> '',
						esc_html__( 'Normal', 'vivo' ) 		=> 'normal',
						esc_html__( 'Bold', 'vivo' ) 		=> 'bold',
						esc_html__( 'Bolder', 'vivo' ) 		=> 'bolder',
						esc_html__( 'Lighter', 'vivo' ) 		=> 'lighter',
						esc_html__( 'Light', 'vivo' ) 		=> 'light',
						esc_html__( 'Thin', 'vivo' ) 		=> 'thin',
						esc_html__( '100', 'vivo' ) 			=> '100',
						esc_html__( '200', 'vivo' ) 			=> '200',
						esc_html__( '300', 'vivo' ) 			=> '300',
						esc_html__( '400', 'vivo' ) 			=> '400',
						esc_html__( '500', 'vivo' ) 			=> '500',
						esc_html__( '600', 'vivo' ) 			=> '600',
						esc_html__( '700', 'vivo' ) 			=> '700',
						esc_html__( '800', 'vivo' ) 			=> '800',
						esc_html__( '900', 'vivo' ) 			=> '900'
					)
				),
				array( 'param_name' => 'excerpt_lines', 'default' => '', 'type' => 'dropdown', 'heading' => esc_html__( 'Excerpt lines', 'vivo' ), 'description' => esc_html__( 'Limit and show 1, 2, 3 or 4 lines of post excerpt text', 'vivo' ), 'group' => esc_html__( 'Post', 'vivo' ),
					'value' => array(
						esc_html__( '4', 'vivo' )		=> '',
						esc_html__( '3', 'vivo' )		=> '3',
						esc_html__( '2', 'vivo' )		=> '2',
						esc_html__( '1', 'vivo' )		=> '1'
					)
				),
			)
		) );
	}
}