<?php

class bt_bb_latest_posts extends BT_BB_Element {

	function handle_shortcode( $atts, $content ) {
		extract( shortcode_atts( apply_filters( 'bt_bb_extract_atts_' . $this->shortcode, array(
			'rows'            	=> '',
			'columns'         	=> '',
			'gap'             	=> '',
			'category'        	=> '',
			'target'          	=> '',
			'image_shape'     	=> '',
			'show_category'   	=> '',
			'show_date'       	=> '',
			'show_author'     	=> '',
			'show_comments'   	=> '',
			'show_excerpt'    	=> '',
			'lazy_load'  		=> 'no',
			'show_image'  		=> '',
			'title_lines'		=> '',
			'excerpt_lines'		=> ''
		) ), $atts, $this->shortcode ) );
		
		$class = array( $this->shortcode );
		
		if ( $el_class != '' ) {
			$class[] = $el_class;
		}	
		
		$id_attr = '';
		if ( $el_id != '' ) {
			$id_attr = ' ' . 'id="' . esc_attr( $el_id ) . '"';
		}

		$style_attr = '';
		$el_style = apply_filters( $this->shortcode . '_style', $el_style, $atts );
		if ( $el_style != '' ) {
			$style_attr = ' ' . 'style="' . esc_attr( $el_style ) . '"';
		}
		
		if ( $columns != '' ) {
			$class[] = $this->prefix . 'columns' . '_' . $columns;
		}

		if ( $gap != '' ) {
			$class[] = $this->prefix . 'gap' . '_' . $gap;
		}

		if ( $title_lines != '' ) {
			$class[] = $this->prefix . 'title_lines' . '_' . $title_lines;
		}

		if ( $excerpt_lines != '' ) {
			$class[] = $this->prefix . 'excerpt_lines' . '_' . $excerpt_lines;
		}
		
		if ( $image_shape != '' ) {
			$class[] = $this->prefix . 'image_shape' . '_' . $image_shape;
		}

		do_action( $this->shortcode . '_before_extra_responsive_param' );
		foreach ( $this->extra_responsive_data_override_param as $p ) {
			if ( ! is_array( $atts ) || ! array_key_exists( $p, $atts ) ) continue;
			$this->responsive_data_override_class(
				$class, $data_override_class,
				apply_filters( $this->shortcode . '_responsive_data_override', array(
					'prefix' => $this->prefix,
					'param' => $p,
					'value' => $atts[ $p ],
				) )
			);
		}
		
		$class = apply_filters( $this->shortcode . '_class', $class, $atts );
		
		$number = $rows * $columns;
		
		$posts = bt_bb_get_posts( $number, 0, $category );
		
		$output = '';

		foreach( $posts as $post_item ) {

			$output .= '<div class="' . esc_attr( $this->shortcode ) . '_item">';
				$post_thumbnail_id = get_post_thumbnail_id( $post_item['ID'] );

				if ( $post_thumbnail_id != '' ) {
					$img = wp_get_attachment_image_src( $post_thumbnail_id, $size = 'medium' );
					$img_src = BT_BB_Root::$path . 'img/blank.gif';
					$data_img = '';
					if ( $lazy_load == 'yes' ) {
						$img_class = 'btLazyLoadImage';
						if ( $img ) {
							$data_img = ' data-image_src="' . esc_attr( $img[0] ) . '"';
						}
					} else {
						if ( $img ) {
							$img_src = $img[0];
						}
						$img_class = '';
					}
					
					if ( $show_image == '' ) {
						$output .= '<div class="' . esc_attr( $this->shortcode ) . '_item_image"><a href="' . esc_url_raw( $post_item['permalink'] ) . '" target="' . esc_attr( $target ) . '"><img src="' . esc_url_raw( $img_src ) . '" alt="' . esc_attr( $post_item['title'] ) . '" title="' . esc_attr( $post_item['title'] ) . '" class="' . esc_attr( $img_class ) . '" ' . $data_img .  '"></a></div>';
					}
				}

				$output .= '<div class="' . esc_attr( $this->shortcode ) . '_item_content">';

					$output .= '<h5 class="' . esc_attr( $this->shortcode ) . '_item_title">';
						$output .= '<a href="' . esc_url_raw( $post_item['permalink'] ) . '" target="' . esc_attr( $target ) . '">' . $post_item['title'] . '</a>';
					$output .= '</h5>';

					if ( $show_date == 'show_date' || $show_author == 'show_author' || $show_author == 'show_comments' || $show_category == 'show_category' ) {
				
						$meta_output = '<div class="' . esc_attr( $this->shortcode ) . '_item_meta">';

							if ( $show_date == 'show_date' ) {
								$meta_output .= '<span class="' . esc_attr( $this->shortcode ) . '_item_date">';
									$meta_output .= get_the_date( '', $post_item['ID'] );
								$meta_output .= '</span>';
							}

							if ( $show_author == 'show_author' ) {
								$meta_output .= '<span class="' . esc_attr( $this->shortcode ) . '_item_author">';
									$meta_output .= esc_html__( 'by', 'vivo' ) . ' ' . $post_item['author'];
								$meta_output .= '</span>';
							}

							if ( $show_comments == 'show_comments' && $post_item['comments'] != '' ) {
								$meta_output .= '<span class="' . esc_attr( $this->shortcode ) . '_item_comments">';
									$meta_output .= $post_item['comments'];
								$meta_output .= '</span>';
							}

							if ( $show_category == 'show_category' && $post_item['comments'] != '' ) {
								$meta_output .= '<div class="' . esc_attr( $this->shortcode ) . '_item_category">';
									$meta_output .= $post_item['category_list'];
								$meta_output .= '</div>';
							}
				
						$meta_output .= '</div>';
		
						$output .= $meta_output;
		
					}

					if ( $show_excerpt == 'show_excerpt' ) {
						$output .= '<div class="' . esc_attr( $this->shortcode ) . '_item_excerpt">';
							$output .= $post_item['excerpt'];
						$output .= '</div>';
					}
				$output .= '</div>';
				
			$output .= '</div>';
		}

		$output = '<div' . $id_attr . ' class="' . esc_attr( implode( ' ', $class ) ) . '"' . $style_attr . '>' . $output . '</div>';
		
		$output = apply_filters( 'bt_bb_general_output', $output, $atts );
		$output = apply_filters( $this->shortcode . '_output', $output, $atts );

		return $output;

	}

	function map_shortcode() {

		bt_bb_map( $this->shortcode, array( 'name' => esc_html__( 'Latest Posts', 'vivo' ), 'description' => esc_html__( 'List of latest posts', 'vivo' ), 'icon' => $this->prefix_backend . 'icon' . '_' . $this->shortcode,
			'params' => array(
				array( 'param_name' => 'rows', 'type' => 'textfield', 'value' => '1', 'heading' => esc_html__( 'Rows', 'vivo' ), 'preview' => true ),
				array( 'param_name' => 'columns', 'type' => 'dropdown', 'value' => '3', 'heading' => esc_html__( 'Columns', 'vivo' ), 'preview' => true,
					'value' => array(
						esc_html__( '1', 'vivo' ) => '1',
						esc_html__( '2', 'vivo' ) => '2',
						esc_html__( '3', 'vivo' ) => '3',
						esc_html__( '4', 'vivo' ) => '4',
						esc_html__( '6', 'vivo' ) => '6'
					)
				),
				array( 'param_name' => 'gap', 'type' => 'dropdown', 'heading' => esc_html__( 'Gap', 'vivo' ), 'preview' => true,
					'value' => array(
						esc_html__( 'Normal', 'vivo' ) 	=> 'normal',
						esc_html__( 'No gap', 'vivo' ) 	=> 'no_gap',
						esc_html__( 'Small', 'vivo' ) 	=> 'small',
						esc_html__( 'Large', 'vivo' ) 	=> 'large'
					)
				),				
				array( 'param_name' => 'category', 'type' => 'textfield', 'heading' => esc_html__( 'Category', 'vivo' ), 'description' => esc_html__( 'Enter category slug or leave empty to show all', 'vivo' ), 'preview' => true ),
				array( 'param_name' => 'target', 'type' => 'dropdown', 'heading' => esc_html__( 'Target', 'vivo' ),
					'value' => array(
						esc_html__( 'Self (open in same tab)', 'vivo' ) => '_self',
						esc_html__( 'Blank (open in new tab)', 'vivo' ) => '_blank',
					)
				),
				array( 'param_name' => 'image_shape', 'type' => 'dropdown', 'heading' => esc_html__( 'Image shape', 'vivo' ),
					'value' => array(
						esc_html__( 'Square', 'vivo' ) 	=> 'square',
						esc_html__( 'Rounded', 'vivo' ) 	=> 'rounded',
						esc_html__( 'Round', 'vivo' ) 	=> 'round'
					)
				),
				array( 'param_name' => 'show_category', 'type' => 'checkbox', 'value' => array( esc_html__( 'Yes', 'vivo' ) => 'show_category' ), 'heading' => esc_html__( 'Show category', 'vivo' ), 'preview' => true
				),
				array( 'param_name' => 'show_date', 'type' => 'checkbox', 'value' => array( esc_html__( 'Yes', 'vivo' ) => 'show_date' ), 'heading' => esc_html__( 'Show date', 'vivo' ), 'preview' => true
				),
				array( 'param_name' => 'show_author', 'type' => 'checkbox', 'value' => array( esc_html__( 'Yes', 'vivo' ) => 'show_author' ), 'heading' => esc_html__( 'Show author', 'vivo' ), 'preview' => true
				),
				array( 'param_name' => 'show_comments', 'type' => 'checkbox', 'value' => array( esc_html__( 'Yes', 'vivo' ) => 'show_comments' ), 'heading' => esc_html__( 'Show number of comments', 'vivo' ), 'preview' => true
				),
				array( 'param_name' => 'show_excerpt', 'type' => 'checkbox', 'value' => array( esc_html__( 'Yes', 'vivo' ) => 'show_excerpt' ), 'heading' => esc_html__( 'Show excerpt', 'vivo' ), 'preview' => true
				),
				array( 'param_name' => 'lazy_load', 'type' => 'dropdown', 'default' => 'yes', 'heading' => esc_html__( 'Lazy load images', 'vivo' ),
					'value' => array(
						esc_html__( 'No', 'vivo' ) 		=> 'no',
						esc_html__( 'Yes', 'vivo' ) 		=> 'yes'
					)
				),
				array( 'param_name' => 'show_image', 'type' => 'dropdown', 'preview' => true, 'heading' => esc_html__( 'Show image', 'vivo' ),
					'value' => array(
						esc_html__( 'Yes', 'vivo' ) 				=> '',
						esc_html__( 'No', 'vivo' ) 				=> 'no'
					)
				),
				array( 'param_name' => 'title_lines', 'default' => '', 'type' => 'dropdown', 'heading' => esc_html__( 'Title lines', 'vivo' ), 'description' => esc_html__( 'Limit and show 1, 2, 3 or 4 lines of post title', 'vivo' ), 
					'value' => array(
						esc_html__( 'All', 'vivo' )		=> '',
						esc_html__( '4', 'vivo' )		=> '4',
						esc_html__( '3', 'vivo' )		=> '3',
						esc_html__( '2', 'vivo' )		=> '2',
						esc_html__( '1', 'vivo' )		=> '1'
					)
				),
				array( 'param_name' => 'excerpt_lines', 'default' => '', 'type' => 'dropdown', 'heading' => esc_html__( 'Excerpt lines', 'vivo' ), 'description' => esc_html__( 'Limit and show 1, 2, 3 or 4 lines of post excerpt text', 'vivo' ), 
					'value' => array(
						esc_html__( '4', 'vivo' )		=> '',
						esc_html__( '3', 'vivo' )		=> '3',
						esc_html__( '2', 'vivo' )		=> '2',
						esc_html__( '1', 'vivo' )		=> '1'
					)
				),
			)
		) );
	} 
}