<?php

class bt_bb_image extends BT_BB_Element {

	function handle_shortcode( $atts, $content ) {
		extract( shortcode_atts( apply_filters( 'bt_bb_extract_atts_' . $this->shortcode, array(
			'image'  							=> '',
			'size'   							=> '',
			'shape'  							=> '',
			'lazy_load'  						=> 'no',
			'image_height'  					=> '',
			'align'  							=> '',
			'caption'    						=> '',
			'url'    							=> '',
			'target' 							=> '',
			'hover_style'  						=> '',
			'content_display'  					=> '',
			'content_background_color' 			=> '',
			'content_background_opacity'	    => '',
			'content_align'						=> '',
			'content_padding'					=> '',
			'negative_top_margin'				=> '',
			'negative_left_margin'				=> '',
			'negative_right_margin'				=> '',
			'negative_bottom_margin'			=> ''

		) ), $atts, $this->shortcode ) );
		
		require_once( dirname(__FILE__) . '/../../../../../plugins/bold-page-builder/content_elements_misc/misc.php' );
		
		$class = array( $this->shortcode );
		$data_override_class = array();
		
		$url = trim( $url );
		
		if ( $el_class != '' ) {
			$class[] = $el_class;
		}
		
		if ( $hover_style == 'scroll' ) {
			$el_id = 'bt_bb_random_id_' . rand();
		}

		if ( $image_height != '' ) {
			$el_style .= 'height:' . $image_height . '; overflow: hidden;';
		}

		$style_attr = '';		
		$el_style = apply_filters( $this->shortcode . '_style', $el_style, $atts );
		if ( $el_style != '' ) {
			$style_attr = ' ' . 'style="' . esc_attr( $el_style ) . '"';
		}	
		
		$id_attr = '';
		if ( $el_id != '' ) {
			$id_attr = ' ' . 'id="' . esc_attr( $el_id ) . '"';
		}
		
		if ( $shape != '' ) {
			$class[] = $this->prefix . 'shape' . '_' . $shape;
		}
		
		if ( $url != '#lightbox' ) {
			$link = bt_bb_get_url( $url );	
		} else {
			$link = $url;
			$target = '_lightbox';
		}
		
		if ( $target != '' ) {
			$class[] = $this->prefix . 'target' . $target;
		}
		
		if ( $target == '_lightbox' ) {
			$class[] = 'bt_bb_use_lightbox';
			$target = '_blank';
			if ( $url == '' ) {
				$link = '#lightbox';
			}
		}
		
		$this->responsive_data_override_class(
			$class, $data_override_class,
			array(
				'prefix' => $this->prefix,
				'param' => 'align',
				'value' => $align
			)
		);
		
		if ( $content_padding != '' ) {
			$class[] = $this->prefix . 'content_padding' . '_' . $content_padding;
		}

		if ( $hover_style != '' ) {
			$class[] = $this->prefix . 'hover_style' . '_' . $hover_style;
		}
		
		if ( $content_display != '' ) {
			$class[] = $this->prefix . 'content_display' . '_' . $content_display;
		}

		if ( $content_align != '' ) {
			$class[] = $this->prefix . 'content_align' . '_' . $content_align;
		}

		$this->responsive_data_override_class(
			$class, $data_override_class,
			array(
				'prefix' => $this->prefix,
				'param' => 'negative_top_margin',
				'value' => $negative_top_margin
			)
		);

		$this->responsive_data_override_class(
			$class, $data_override_class,
			array(
				'prefix' => $this->prefix,
				'param' => 'negative_left_margin',
				'value' => $negative_left_margin
			)
		);

		$this->responsive_data_override_class(
			$class, $data_override_class,
			array(
				'prefix' => $this->prefix,
				'param' => 'negative_right_margin',
				'value' => $negative_right_margin
			)
		);

		$this->responsive_data_override_class(
			$class, $data_override_class,
			array(
				'prefix' => $this->prefix,
				'param' => 'negative_bottom_margin',
				'value' => $negative_bottom_margin
			)
		);

		$alt = $caption;
		$title = $caption;
		$full_image = $image;
		$image_ = $image;
			
		if ( $image != '' && is_numeric( $image ) ) {
			$post_image = get_post( $image );
			if ( $post_image == '' ) return;
			
			if ( $alt == '' ) {
				$alt = get_post_meta( $post_image->ID, '_wp_attachment_image_alt', true );
			}
			if ( $alt == '' ) {
				$alt = $post_image->post_excerpt;
			}
			if ( $title == '' ) {
				$title = $post_image->post_title;
			}
			
			$image_ = wp_get_attachment_image_src( $image, $size );
			if ( $image_ ) {
				$image_ = $image_[0];
			}
			if ( $alt == '' ) {
				$alt = $image_;
			}
			
			if ( $size == 'full' ) {
				$full_image = $image_;
			} else {
				$full_image = wp_get_attachment_image_src( $image, 'full' );
				if ( $full_image ) {
					$full_image = $full_image[0];
				} else {
					$full_image = '';
				}				
			}
		}
		
		$content = do_shortcode( $content );
		
		if ( $content != '' ) {
			$class[] = $this->prefix . 'content_exists';
		}
		
		$output = '';

		if ( $image != '' ) {
			if ( is_numeric( $image ) ) {
				$attr_arr = array();
				$attr_arr['data-full_image_src'] = esc_url_raw( $full_image );
				$attr_arr['alt'] = esc_attr( $alt );
				if ( $title != '' ) {
					$attr_arr['title'] = esc_attr( $title );
				}
				if ( $lazy_load != 'yes' ) {
					$attr_arr['loading'] = false;
				}
				$output .= wp_get_attachment_image( $image, $size, false, $attr_arr );
			} else {
				$title_attr = '';
				$alt_attr = '';
				if ( $title != '' ) {
					$title_attr = ' ' . 'title="' . esc_attr( $title ) . '"';
				}
				if ( $alt != '' ) {
					$alt_attr = ' ' . 'alt="' . esc_attr( $alt ) . '"';
				}
				if ( $lazy_load == 'yes' ) {
					$output .= '<img src="' . esc_url_raw( $image ) . '"' . $title_attr . $alt_attr . ' loading="lazy">';
				} else {
					$output .= '<img src="' . esc_url_raw( $image ) . '"' . $title_attr . $alt_attr . '>';
				}
			}
		}
		
		if ( ! empty( $link ) ) {
			if ( $title != '' ) {
				$output = '<a href="' . esc_url( $link ) . '"  target="' . esc_attr( $target ) . '" title="' . esc_attr( $title ) . '">' . $output . '</a>';
			} else {
				$output = '<a href="' . esc_url( $link ) . '"  target="' . esc_attr( $target ) . '">' . $output . '</a>';
			}
		} else {
			$output = '<span>' . $output . '</span>';
		}

		do_action( $this->shortcode . '_before_extra_responsive_param' );
		foreach ( $this->extra_responsive_data_override_param as $p ) {
			if ( ! is_array( $atts ) || ! array_key_exists( $p, $atts ) ) continue;
			$this->responsive_data_override_class(
				$class, $data_override_class,
				apply_filters( $this->shortcode . '_responsive_data_override', array(
					'prefix' => $this->prefix,
					'param' => $p,
					'value' => $atts[ $p ],
				) )
			);
		}
		
		$class = apply_filters( $this->shortcode . '_class', $class, $atts );
		
		$output = '<div' . $id_attr . ' class="' . esc_attr( implode( ' ', $class ) ) . '"' . $style_attr . ' data-bt-override-class="' . htmlspecialchars( json_encode( $data_override_class, JSON_FORCE_OBJECT ), ENT_QUOTES, 'UTF-8' ) . '">' . $output ;
		if ( $content != '' ) {
			$content_background_style = '';
			if ( $content_background_color != '' ) {
				if ( strpos( $content_background_color, '#' ) !== false ) {
					$content_background_color = bt_bb_image::hex2rgb( $content_background_color );
					if ( $content_background_opacity == '' ) {
						$content_background_opacity = 1;
					}
					$content_background_style .= ' style="background-color: rgba(' . $content_background_color[0] . ', ' . $content_background_color[1] . ', ' . $content_background_color[2] . ', ' . $content_background_opacity . ');"';
				} else {
					$content_background_style .= 'style="background-color:' . $content_background_color . ';"';
				}
			}
			$output .= '<div class="bt_bb_image_content" ' . $content_background_style . '><div class="bt_bb_image_content_flex"><div class="bt_bb_image_content_inner">' . $content . '</div></div></div>';
		}
		$output .= '</div>';
		
		$output = apply_filters( 'bt_bb_general_output', $output, $atts );
		$output = apply_filters( $this->shortcode . '_output', $output, $atts );
		
		return $output;

	}

	function map_shortcode() {
		bt_bb_map( $this->shortcode, array( 'name' => esc_html__( 'Image', 'vivo' ), 'description' => esc_html__( 'Single image', 'vivo' ), 'container' => 'vertical', 'accept' => array( 'bt_bb_button' => true, 'bt_bb_icon' => true, 'bt_bb_text' => true, 'bt_bb_headline' => true, 'bt_bb_separator' => true, 'bt_bb_quote' => true ), 'icon' => $this->prefix_backend . 'icon' . '_' . $this->shortcode,
			'params' => array(
				array( 'param_name' => 'image', 'type' => 'attach_image', 'heading' => esc_html__( 'Image', 'vivo' ), 'preview' => true ),
				array( 'param_name' => 'size', 'type' => 'dropdown', 'heading' => esc_html__( 'Size', 'vivo' ), 'preview' => true,
					'value' => bt_bb_get_image_sizes()
				),
				array( 'param_name' => 'image_height', 'type' => 'textfield', 'heading' => esc_html__( 'Image height', 'vivo' )),
				array( 'param_name' => 'shape', 'type' => 'dropdown', 'heading' => esc_html__( 'Shape', 'vivo' ),
					'value' => array(
						esc_html__( 'Square', 'vivo' ) 					=> 'square',
						esc_html__( 'Soft Rounded', 'vivo' ) 			=> 'soft-rounded',
						esc_html__( 'Medium Rounded', 'vivo' ) 			=> 'medium-rounded',
						esc_html__( 'Hard Rounded', 'vivo' ) 			=> 'hard-rounded',
						esc_html__( 'With wavy detail', 'vivo' ) 		=> 'detail',
						esc_html__( 'With light gray detail', 'vivo' ) 	=> 'gray_detail',
						esc_html__( 'Rounded left edge', 'vivo' ) 		=> 'rounded-edge',
						esc_html__( 'Rounded (all edges)', 'vivo' ) 		=> 'rounded'
					)
				),
				array( 'param_name' => 'lazy_load', 'type' => 'dropdown', 'default' => 'yes', 'heading' => esc_html__( 'Lazy load this image', 'vivo' ),
					'value' => array(
						esc_html__( 'No', 'vivo' ) 		=> 'no',
						esc_html__( 'Yes', 'vivo' ) 		=> 'yes'
					)
				),
				array( 'param_name' => 'align', 'type' => 'dropdown', 'heading' => esc_html__( 'Alignment', 'vivo' ), 'responsive_override' => true,
					'value' => array(
						esc_html__( 'Inherit', 'vivo' ) 		=> 'inherit',
						esc_html__( 'Left', 'vivo' ) 		=> 'left',
						esc_html__( 'Center', 'vivo' ) 		=> 'center',
						esc_html__( 'Right', 'vivo' ) 		=> 'right'
					)
				),
				array( 'param_name' => 'caption', 'type' => 'textfield', 'heading' => esc_html__( 'Caption', 'vivo' ) ),
				array( 'param_name' => 'url', 'type' => 'link', 'heading' => esc_html__( 'URL', 'vivo' ), 'description' => esc_html__( 'Enter full or local URL (e.g. https://www.bold-themes.com or /pages/about-us), post slug (e.g. about-us)', 'vivo' ), 'group' => esc_html__( 'URL', 'vivo' ) ),
				array( 'param_name' => 'target', 'type' => 'dropdown', 'heading' => esc_html__( 'Target', 'vivo' ), 'description' => esc_html__( 'To open current image in full size select lightbox and leave url empty.', 'vivo' ), 'group' => esc_html__( 'URL', 'vivo' ),
					'value' => array(
						esc_html__( 'Self (open in same tab)', 'vivo' ) 			=> '_self',
						esc_html__( 'Blank (open in new tab)', 'vivo' ) 			=> '_blank',
						esc_html__( 'Lightbox (open in new layer)', 'vivo' ) 	=> '_lightbox'
					)
				),
				array( 'param_name' => 'hover_style', 'type' => 'dropdown', 'heading' => esc_html__( 'Mouse hover style', 'vivo' ), 'group' => esc_html__( 'URL', 'vivo' ),
					'value' => array(
						esc_html__( 'Simple', 'vivo' ) 					=> 'simple',
						esc_html__( 'Flip', 'vivo' ) 					=> 'flip',
						esc_html__( 'Zoom in', 'vivo' ) 					=> 'zoom-in',
						esc_html__( 'To grayscale', 'vivo' ) 			=> 'to-grayscale',
						esc_html__( 'From grayscale', 'vivo' ) 			=> 'from-grayscale',
						esc_html__( 'Zoom in to grayscale', 'vivo' ) 	=> 'zoom-in-to-grayscale',
						esc_html__( 'Zoom in from grayscale', 'vivo' ) 	=> 'zoom-in-from-grayscale',
						esc_html__( 'Scroll', 'vivo' ) 					=> 'scroll'
					)
				),
				array( 'param_name' => 'content_display', 'type' => 'dropdown', 'heading' => esc_html__( 'Show content', 'vivo' ), 'description' => esc_html__( 'Add selected elements and show them over the image', 'vivo' ), 'group' => esc_html__( 'Content', 'vivo' ),
					'value' => array(
						esc_html__( 'Always', 'vivo' ) 			=> 'always',
						esc_html__( 'Show on hover', 'vivo' ) 	=> 'show-on-hover',
						esc_html__( 'Hide on hover', 'vivo' ) 	=> 'hide-on-hover'
					)
				),
				array( 'param_name' => 'content_background_color', 'type' => 'colorpicker', 'heading' => esc_html__( 'Content background color', 'vivo' ), 'group' => esc_html__( 'Content', 'vivo' ) ),
				array( 'param_name' => 'content_background_opacity', 'type' => 'textfield', 'heading' => esc_html__( 'Content background opacity (deprecated)', 'vivo' ), 'group' => esc_html__( 'Content', 'vivo' ) ),
				array( 'param_name' => 'content_align', 'type' => 'dropdown', 'heading' => esc_html__( 'Content alignment', 'vivo' ), 'group' => esc_html__( 'Content', 'vivo' ),
					'value' => array(
						esc_html__( 'Middle', 'vivo' ) 	=> 'middle',
						esc_html__( 'Top', 'vivo' ) 		=> 'top',						
						esc_html__( 'Bottom', 'vivo' ) 	=> 'bottom'
					)
				),
				array( 'param_name' => 'content_padding', 'type' => 'dropdown', 'group' => esc_html__( 'Content', 'vivo' ), 'heading' => esc_html__( 'Content padding', 'vivo' ),
					'value' => array(
						esc_html__( 'Default', 'vivo' ) 		=> '',
						esc_html__( '0px', 'vivo' ) 			=> '0px',
						esc_html__( '5px', 'vivo' ) 			=> '5px',
						esc_html__( '10px', 'vivo' ) 		=> '10px',
						esc_html__( '15px', 'vivo' ) 		=> '15px',
						esc_html__( '20px', 'vivo' ) 		=> '20px',
						esc_html__( '25px', 'vivo' ) 		=> '25px',
						esc_html__( '30px', 'vivo' ) 		=> '30px',
						esc_html__( '35px', 'vivo' ) 		=> '35px',
						esc_html__( '40px', 'vivo' ) 		=> '40px',
						esc_html__( '45px', 'vivo' ) 		=> '45px',
						esc_html__( '50px', 'vivo' ) 		=> '50px'
					)
				),

				array( 'param_name' => 'negative_top_margin', 'type' => 'dropdown', 'default' => '', 'group' => esc_html__( 'Margin', 'vivo' ), 'heading' => esc_html__( 'Negative top margin', 'vivo' ), 'responsive_override' => true,
					'value' => array(
						esc_html__( 'None', 'vivo' ) 		=> 'none',
						esc_html__( 'Extra small', 'vivo' ) 	=> 'extra_small',
						esc_html__( 'Small', 'vivo' ) 		=> 'small',
						esc_html__( 'Normal', 'vivo' ) 		=> 'normal',
						esc_html__( 'Medium', 'vivo' )		=> 'medium',
						esc_html__( 'Large', 'vivo' ) 		=> 'large',
						esc_html__( 'Extra large', 'vivo' ) 	=> 'extra_large',
						esc_html__( '5px', 'vivo' ) 			=> '5px',
						esc_html__( '10px', 'vivo' ) 		=> '10px',
						esc_html__( '15px', 'vivo' ) 		=> '15px',
						esc_html__( '20px', 'vivo' ) 		=> '20px',
						esc_html__( '25px', 'vivo' ) 		=> '25px',
						esc_html__( '30px', 'vivo' ) 		=> '30px',
						esc_html__( '35px', 'vivo' ) 		=> '35px',
						esc_html__( '40px', 'vivo' ) 		=> '40px',
						esc_html__( '45px', 'vivo' ) 		=> '45px',
						esc_html__( '50px', 'vivo' ) 		=> '50px'
					)
				),
				array( 'param_name' => 'negative_bottom_margin', 'type' => 'dropdown', 'default' => '', 'group' => esc_html__( 'Margin', 'vivo' ), 'heading' => esc_html__( 'Negative bottom margin', 'vivo' ), 'responsive_override' => true,
					'value' => array(
						esc_html__( 'None', 'vivo' ) 		=> 'none',
						esc_html__( 'Extra small', 'vivo' ) 	=> 'extra_small',
						esc_html__( 'Small', 'vivo' ) 		=> 'small',
						esc_html__( 'Normal', 'vivo' ) 		=> 'normal',
						esc_html__( 'Medium', 'vivo' )		=> 'medium',
						esc_html__( 'Large', 'vivo' ) 		=> 'large',
						esc_html__( 'Extra large', 'vivo' ) 	=> 'extra_large',
						esc_html__( '5px', 'vivo' ) 			=> '5px',
						esc_html__( '10px', 'vivo' ) 		=> '10px',
						esc_html__( '15px', 'vivo' ) 		=> '15px',
						esc_html__( '20px', 'vivo' ) 		=> '20px',
						esc_html__( '25px', 'vivo' ) 		=> '25px',
						esc_html__( '30px', 'vivo' ) 		=> '30px',
						esc_html__( '35px', 'vivo' ) 		=> '35px',
						esc_html__( '40px', 'vivo' ) 		=> '40px',
						esc_html__( '45px', 'vivo' ) 		=> '45px',
						esc_html__( '50px', 'vivo' ) 		=> '50px'
					)
				),
				array( 'param_name' => 'negative_right_margin', 'type' => 'dropdown', 'default' => '', 'group' => esc_html__( 'Margin', 'vivo' ), 'heading' => esc_html__( 'Negative right margin', 'vivo' ), 'responsive_override' => true,
					'value' => array(
						esc_html__( 'None', 'vivo' ) 		=> 'none',
						esc_html__( 'Extra small', 'vivo' ) 	=> 'extra_small',
						esc_html__( 'Small', 'vivo' ) 		=> 'small',
						esc_html__( 'Normal', 'vivo' ) 		=> 'normal',
						esc_html__( 'Medium', 'vivo' )		=> 'medium',
						esc_html__( 'Large', 'vivo' ) 		=> 'large',
						esc_html__( 'Extra large', 'vivo' ) 	=> 'extra_large',
						esc_html__( '5px', 'vivo' ) 			=> '5px',
						esc_html__( '10px', 'vivo' ) 		=> '10px',
						esc_html__( '15px', 'vivo' ) 		=> '15px',
						esc_html__( '20px', 'vivo' ) 		=> '20px',
						esc_html__( '25px', 'vivo' ) 		=> '25px',
						esc_html__( '30px', 'vivo' ) 		=> '30px',
						esc_html__( '35px', 'vivo' ) 		=> '35px',
						esc_html__( '40px', 'vivo' ) 		=> '40px',
						esc_html__( '45px', 'vivo' ) 		=> '45px',
						esc_html__( '50px', 'vivo' ) 		=> '50px'
					)
				),
				array( 'param_name' => 'negative_left_margin', 'type' => 'dropdown', 'default' => '', 'group' => esc_html__( 'Margin', 'vivo' ), 'heading' => esc_html__( 'Negative left margin', 'vivo' ), 'responsive_override' => true,
					'value' => array(
						esc_html__( 'None', 'vivo' ) 		=> 'none',
						esc_html__( 'Extra small', 'vivo' ) 	=> 'extra_small',
						esc_html__( 'Small', 'vivo' ) 		=> 'small',
						esc_html__( 'Normal', 'vivo' ) 		=> 'normal',
						esc_html__( 'Medium', 'vivo' )		=> 'medium',
						esc_html__( 'Large', 'vivo' ) 		=> 'large',
						esc_html__( 'Extra large', 'vivo' ) 	=> 'extra_large',
						esc_html__( '5px', 'vivo' ) 			=> '5px',
						esc_html__( '10px', 'vivo' ) 		=> '10px',
						esc_html__( '15px', 'vivo' ) 		=> '15px',
						esc_html__( '20px', 'vivo' ) 		=> '20px',
						esc_html__( '25px', 'vivo' ) 		=> '25px',
						esc_html__( '30px', 'vivo' ) 		=> '30px',
						esc_html__( '35px', 'vivo' ) 		=> '35px',
						esc_html__( '40px', 'vivo' ) 		=> '40px',
						esc_html__( '45px', 'vivo' ) 		=> '45px',
						esc_html__( '50px', 'vivo' ) 		=> '50px'
					)
				),

			)
		) );
	}
	static function hex2rgb( $hex ) {
		$hex = str_replace( '#', '', $hex );
		if ( strlen( $hex ) == 3 ) {
			$r = hexdec( substr( $hex, 0, 1 ) . substr( $hex, 0, 1 ) );
			$g = hexdec( substr( $hex, 1, 1 ) . substr( $hex, 1, 1 ) );
			$b = hexdec( substr( $hex, 2, 1 ) . substr( $hex, 2, 1 ) );
		} else {
			$r = hexdec( substr( $hex, 0, 2 ) );
			$g = hexdec( substr( $hex, 2, 2 ) );
			$b = hexdec( substr( $hex, 4, 2 ) );
		}
		$rgb = array( $r, $g, $b );
		return $rgb;
	}
}