<?php

class bt_bb_dropdown extends BT_BB_Element {

	function handle_shortcode( $atts, $content ) {
		extract( shortcode_atts( apply_filters( 'bt_bb_extract_atts_' . $this->shortcode, array(
			'title'   				=> '',
			'field_color_scheme' 	=> '',
			'button_style' 			=> '',
			'button_color_scheme' 	=> '',	
			'button_text' 			=> '',
		) ), $atts, $this->shortcode ) );

		wp_enqueue_script( 
			'bt_bb_dropdown',
			get_template_directory_uri() . '/bold-page-builder/content_elements/bt_bb_dropdown/bt_bb_dropdown.js',
			array( 'jquery' ),
			'',
			true
		);
		
		$blank_image_src = BT_BB_Root::$path . 'img/blank.gif';

		$class = array( $this->shortcode );
		$button_class = array('bt_bb_button bt_bb_size_small bt_bb_align_inherit');
		
		if ( $el_class != '' ) {
			$class[] = $el_class;
		}

		$id_attr = '';
		if ( $el_id != '' ) {
			$id_attr = ' ' . 'id="' . esc_attr( $el_id ) . '"';
		}

		if ( $field_color_scheme != '' ) {
			$class[] = $this->prefix . 'field_color_scheme' . '_' . $field_color_scheme;
		}

		if ( $button_style != '' ) {
			$class[] = $this->prefix . 'button_style' . '_' . $button_style;
			$button_class[] = $this->prefix . 'style' . '_' . $button_style;
		}

		$button_color_scheme_id = NULL;
		if ( is_numeric ( $button_color_scheme ) ) {
			$button_color_scheme_id = $button_color_scheme;
		} else if ( $button_color_scheme != '' && function_exists( 'bt_bb_get_color_scheme_id' ) ) {
			$button_color_scheme_id = bt_bb_get_color_scheme_id( $button_color_scheme );
		}

		$button_color_scheme_colors = function_exists( 'bt_bb_get_color_scheme_colors_by_id' ) ? bt_bb_get_color_scheme_colors_by_id( $button_color_scheme_id - 1 ) : array();		
		if ( $button_color_scheme_colors ) $el_style .= '; --primary-color:' . $button_color_scheme_colors[0] . '; --secondary-color:' . $button_color_scheme_colors[1] . ';';
		if ( $button_color_scheme != '' ) $class[] = $this->prefix . 'color_scheme_' .  $button_color_scheme_id;

		$class = apply_filters( $this->shortcode . '_class', $class, $atts );
		$class_attr			= implode( ' ', $class );
		$button_class_attr	= implode( ' ', $button_class );
		
		if ( $el_class != '' ) {
			$class_attr = $class_attr . ' ' . $el_class;
		}
	
		$style_attr = '';
		if ( $el_style != '' ) {
			$style_attr = ' ' . 'style="' . esc_attr( $el_style ) . '"';
		}

		$content = do_shortcode( $content );

		$output = '<div' . $id_attr . ' class="' . esc_attr( $class_attr ) . '" ' . $style_attr . '  data-button-text="' . esc_attr( $button_text ) . '">';
					
			// IMAGE
			$output .= '<div class="' . esc_attr( $this->shortcode . '_image' ) . '">';
				$output .= '<div class="bt_bb_image bt_bb_shape_hard-rounded bt_bb_image_dropdown" data-bt-override-class="{}"><span><img class="bt_bb_image_dropdown_inner" width="100" height="100" src="' . esc_attr( $blank_image_src ) . '" alt="' . esc_attr( $this->shortcode . '_title' ) . '"></span></div>';
			$output .= '</div>';

			$output .= '<div class="' . esc_attr( $this->shortcode . '_list' ) . '">';

				// TITLE
				if ( $title != '' ) $output .= '<div class="' . esc_attr( $this->shortcode . '_title' ) .'"><span>' . $title . ''  . '</span></div>';


				// SELECT
				$output .= '<div class="' . esc_attr( $this->shortcode . '_select' ) . '">';
					$output .= '<select class="btDropdownSelect"  id="btDropdownSelect">';
						$output .= $content;
					$output .= '</select>';
				$output .= '</div>';
			$output .= '</div>';


			// BUTTON
			$output .= '<div class="' . esc_attr( $this->shortcode . '_button' ) . '">';
				$output .= '<div class="' . esc_attr( $button_class_attr ) . '" data-bt-override-class="{}">
								<a href="" target="_self" class="bt_bb_link bt_bb_button_dropdown_inner"><span class="bt_bb_button_text"></span></a>
							</div>';
			$output .= '</div>';

		$output .= '</div>';
		
		$output = apply_filters( 'bt_bb_general_output', $output, $atts );
		$output = apply_filters( $this->shortcode . '_output', $output, $atts );
			
		return $output;

	}


	function map_shortcode() {

		$color_scheme_arr = bt_bb_get_color_scheme_param_array();

		bt_bb_map( $this->shortcode, array( 'name' => esc_html__( 'Dropdown', 'vivo' ), 'description' => esc_html__( 'Dropdown with image, text and button', 'vivo' ), 'container' => 'vertical', 'accept' => array( 'bt_bb_dropdown_inner' => true ), 'icon' => $this->prefix_backend . 'icon' . '_' . $this->shortcode, 'highlight' => true,
			'params' => array(
				array( 'param_name' => 'title', 'type' => 'textfield', 'preview' => true, 'heading' => esc_html__( 'Title', 'vivo' ) ),
				array( 'param_name' => 'field_color_scheme', 'preview' => true, 'type' => 'dropdown', 'heading' => esc_html__( 'Field color scheme', 'vivo' ), 
					'value' => array(
						esc_html__( 'Inherit', 'vivo' ) 		=> '',
						esc_html__( 'Light', 'vivo' ) 	=> 'light',
						esc_html__( 'Dark', 'vivo' ) 	=> 'dark'
					)
				),
				array( 'param_name' => 'button_style', 'type' => 'dropdown', 'heading' => esc_html__( 'Button style', 'vivo' ), 
					'value' => array(
						esc_html__( 'Filled', 'vivo' ) 			=> '',
						esc_html__( 'Filled gradient', 'vivo' ) 	=> 'filled_gradient',
						esc_html__( 'Outline', 'vivo' ) 			=> 'outline',
						esc_html__( 'Clean', 'vivo' ) 			=> 'clean'
					)
				),
				array( 'param_name' => 'button_color_scheme', 'preview' => true, 'type' => 'dropdown', 'heading' => esc_html__( 'Button color scheme', 'vivo' ), 'value' => $color_scheme_arr ),
				array( 'param_name' => 'button_text', 'type' => 'textfield','preview' => true, 'heading' => esc_html__( 'Button text', 'vivo' ) )
			))
		);
	}
}